// @flow
/* eslint-disable */

// This file is auto-generated by client/protocol/Makefile.
import * as gregor1 from './flow-types-gregor'

import engine, {EngineChannel} from '../../engine'
import {RPCError} from '../../util/errors'
import {putOnChannelMap, createChannelMap, closeChannelMap} from '../../util/saga'
import {Buffer} from 'buffer'

import type {ChannelConfig, ChannelMap} from './saga'
import type {Exact} from './more'
export type int = number
export type int64 = number
export type uint = number
export type uint64 = number
export type long = number
export type double = number
export type bytes = Buffer
export type WaitingHandlerType = (waiting: boolean) => void

const engineRpcOutgoing = (method: string, params: any, callbackOverride: any, incomingCallMapOverride: any) => engine()._rpcOutgoing(method, params, callbackOverride, incomingCallMapOverride)

type requestCommon = {
  waitingHandler?: WaitingHandlerType,
  incomingCallMap?: incomingCallMapType,
}

type requestErrorCallback = {
  callback?: ?(err: ?RPCError) => void
}

type RPCErrorHandler = (err: RPCError) => void

type CommonResponseHandler = {
  error: RPCErrorHandler,
  result: (...rest: Array<void>) => void,
}

function _channelMapRpcHelper(channelConfig: ChannelConfig<*>, partialRpcCall: (incomingCallMap: any, callback: Function) => void): ChannelMap<*> {
  const channelMap = createChannelMap(channelConfig)
  const incomingCallMap = Object.keys(channelMap).reduce((acc, k) => {
    acc[k] = (params, response) => {
      putOnChannelMap(channelMap, k, {params, response})
    }
    return acc
  }, {})
  const callback = (error, params) => {
    channelMap['finished'] && putOnChannelMap(channelMap, 'finished', {error, params})
    closeChannelMap(channelMap)
  }
  partialRpcCall(incomingCallMap, callback)
  return channelMap
}


export const AppStateAppState = {
  foreground: 0,
  background: 1,
  inactive: 2,
  backgroundactive: 3,
}

export const BackendCommonBlockType = {
  data: 0,
  md: 1,
  git: 2,
}

export const CommonClientType = {
  none: 0,
  cli: 1,
  guiMain: 2,
  kbfs: 3,
  guiHelper: 4,
}

export const CommonDeviceType = {
  desktop: 0,
  mobile: 1,
}

export const CommonFullNamePackageVersion = {
  v0: 0,
}

export const CommonLogLevel = {
  none: 0,
  debug: 1,
  info: 2,
  notice: 3,
  warn: 4,
  error: 5,
  critical: 6,
  fatal: 7,
}

export const CommonMerkleTreeID = {
  master: 0,
  kbfsPublic: 1,
  kbfsPrivate: 2,
  kbfsPrivateteam: 3,
}

export const CommonSeqType = {
  public: 1,
  private: 2,
  semiprivate: 3,
}

export const CommonTLFVisibility = {
  any: 0,
  public: 1,
  private: 2,
}

export const CommonTeamType = {
  none: 0,
  legacy: 1,
  modern: 2,
}

export const CommonUserOrTeamResult = {
  user: 1,
  team: 2,
}

export const ConfigForkType = {
  none: 0,
  auto: 1,
  watchdog: 2,
  launchd: 3,
}

export const ConstantsStatusCode = {
  scok: 0,
  scinputerror: 100,
  scloginrequired: 201,
  scbadsession: 202,
  scbadloginusernotfound: 203,
  scbadloginpassword: 204,
  scnotfound: 205,
  scthrottlecontrol: 210,
  scdeleted: 216,
  scgeneric: 218,
  scalreadyloggedin: 235,
  scexists: 230,
  sccanceled: 237,
  scinputcanceled: 239,
  screloginrequired: 274,
  scresolutionfailed: 275,
  scprofilenotpublic: 276,
  scidentifyfailed: 277,
  sctrackingbroke: 278,
  scwrongcryptoformat: 279,
  scdecryptionerror: 280,
  scinvalidaddress: 281,
  scnosession: 283,
  scaccountreset: 290,
  scidentifiesfailed: 295,
  scbademail: 472,
  scbadsignupusernametaken: 701,
  scbadinvitationcode: 707,
  scmissingresult: 801,
  sckeynotfound: 901,
  sckeycorrupted: 905,
  sckeyinuse: 907,
  sckeybadgen: 913,
  sckeynosecret: 914,
  sckeybaduids: 915,
  sckeynoactive: 916,
  sckeynosig: 917,
  sckeybadsig: 918,
  sckeybadeldest: 919,
  sckeynoeldest: 920,
  sckeyduplicateupdate: 921,
  scsibkeyalreadyexists: 922,
  scdecryptionkeynotfound: 924,
  sckeynopgpencryption: 927,
  sckeynonaclencryption: 928,
  sckeysyncedpgpnotfound: 929,
  sckeynomatchinggpg: 930,
  sckeyrevoked: 931,
  scbadtracksession: 1301,
  scdevicebadname: 1404,
  scdevicenameinuse: 1408,
  scdevicenotfound: 1409,
  scdevicemismatch: 1410,
  scdevicerequired: 1411,
  scdeviceprevprovisioned: 1413,
  scdevicenoprovision: 1414,
  scdeviceprovisionviadevice: 1415,
  screvokecurrentdevice: 1416,
  screvokelastdevice: 1417,
  scdeviceprovisionoffline: 1418,
  scstreamexists: 1501,
  scstreamnotfound: 1502,
  scstreamwrongkind: 1503,
  scstreameof: 1504,
  scgenericapierror: 1600,
  scapinetworkerror: 1601,
  sctimeout: 1602,
  scprooferror: 1701,
  scidentificationexpired: 1702,
  scselfnotfound: 1703,
  scbadkexphrase: 1704,
  scnouidelegation: 1705,
  scnoui: 1706,
  scgpgunavailable: 1707,
  scinvalidversionerror: 1800,
  scoldversionerror: 1801,
  scinvalidlocationerror: 1802,
  scservicestatuserror: 1803,
  scinstallerror: 1804,
  scloadkexterror: 1810,
  scloadkextpermerror: 1811,
  scgitinternal: 2300,
  scgitrepoalreadyexists: 2301,
  scgitinvalidreponame: 2302,
  scgitcannotdelete: 2303,
  scloginstatetimeout: 2400,
  scchatinternal: 2500,
  scchatratelimit: 2501,
  scchatconvexists: 2502,
  scchatunknowntlfid: 2503,
  scchatnotinconv: 2504,
  scchatbadmsg: 2505,
  scchatbroadcast: 2506,
  scchatalreadysuperseded: 2507,
  scchatalreadydeleted: 2508,
  scchattlffinalized: 2509,
  scchatcollision: 2510,
  scidentifysummaryerror: 2511,
  scneedselfrekey: 2512,
  scneedotherrekey: 2513,
  scchatmessagecollision: 2514,
  scchatduplicatemessage: 2515,
  scchatclienterror: 2516,
  scchatnotinteam: 2517,
  scchatstalepreviousstate: 2518,
  scteamselfnotowner: 2607,
  scteamnotfound: 2614,
  scteamexists: 2619,
  scteamreaderror: 2623,
  scteamtarduplicate: 2663,
  scteamtarnotfound: 2664,
  scteammemberexists: 2665,
  scteamnotreleased: 2666,
  scteampermanentlyleft: 2667,
  scteamneedrootid: 2668,
  scteamhaslivechildren: 2669,
  scteamdeleteerror: 2670,
  scteambadrootteam: 2671,
  scteamnameconflictswithuser: 2672,
  scteamdeletenouppointer: 2673,
  scteamneedowner: 2674,
  scteamnoownerallowed: 2675,
  scteamimplicitnononsbs: 2676,
  scteamimplicitbadhash: 2677,
  scteamimplicitbadname: 2678,
  scteamimplicitclash: 2679,
  scteamimplicitduplicate: 2680,
  scteamimplicitbadop: 2681,
  scteamimplicitbadrole: 2682,
  scteamimplicitnotfound: 2683,
  scteambadadminseqnotype: 2684,
  scteamimplicitbadadd: 2685,
  scteamimplicitbadremove: 2686,
  scteamkeymasknotfound: 2697,
}

export const CtlDbType = {
  main: 0,
  chat: 1,
}

export const CtlExitCode = {
  ok: 0,
  notok: 2,
  restart: 4,
}

export const FavoriteFolderType = {
  unknown: 0,
  private: 1,
  public: 2,
  team: 3,
}

export const GitGitLocalMetadataVersion = {
  v1: 1,
}

export const GregorUIPushReason = {
  none: 0,
  reconnected: 1,
  newData: 2,
}

export const IdentifyCommonIdentifyReasonType = {
  none: 0,
  id: 1,
  track: 2,
  encrypt: 3,
  decrypt: 4,
  verify: 5,
  resource: 6,
  background: 7,
}

export const IdentifyCommonTrackDiffType = {
  none: 0,
  error: 1,
  clash: 2,
  revoked: 3,
  upgraded: 4,
  new: 5,
  remoteFail: 6,
  remoteWorking: 7,
  remoteChanged: 8,
  newEldest: 9,
  noneViaTemporary: 10,
}

export const IdentifyCommonTrackStatus = {
  newOk: 1,
  newZeroProofs: 2,
  newFailProofs: 3,
  updateBrokenFailedProofs: 4,
  updateNewProofs: 5,
  updateOk: 6,
  updateBrokenRevoked: 7,
}

export const IdentifyUiCheckResultFreshness = {
  fresh: 0,
  aged: 1,
  rancid: 2,
}

export const IdentifyUiDismissReasonType = {
  none: 0,
  handledElsewhere: 1,
}

export const InstallInstallAction = {
  unknown: 0,
  none: 1,
  upgrade: 2,
  reinstall: 3,
  install: 4,
}

export const InstallInstallStatus = {
  unknown: 0,
  error: 1,
  notInstalled: 2,
  installed: 4,
}

export const KbfsCommonFSErrorType = {
  accessDenied: 0,
  userNotFound: 1,
  revokedDataDetected: 2,
  notLoggedIn: 3,
  timeout: 4,
  rekeyNeeded: 5,
  badFolder: 6,
  notImplemented: 7,
  oldVersion: 8,
  overQuota: 9,
  noSigChain: 10,
  tooManyFolders: 11,
  exdevNotSupported: 12,
  diskLimitReached: 13,
  diskCacheErrorLogSend: 14,
}

export const KbfsCommonFSNotificationType = {
  encrypting: 0,
  decrypting: 1,
  signing: 2,
  verifying: 3,
  rekeying: 4,
  connection: 5,
  mdReadSuccess: 6,
  fileCreated: 7,
  fileModified: 8,
  fileDeleted: 9,
  fileRenamed: 10,
  initialized: 11,
}

export const KbfsCommonFSStatusCode = {
  start: 0,
  finish: 1,
  error: 2,
}

export const PassphraseCommonPassphraseType = {
  none: 0,
  paperKey: 1,
  passPhrase: 2,
  verifyPassPhrase: 3,
}

export const PgpSignMode = {
  attached: 0,
  detached: 1,
  clear: 2,
}

export const ProcessFileType = {
  unknown: 0,
  directory: 1,
  file: 2,
}

export const ProveCommonProofState = {
  none: 0,
  ok: 1,
  tempFailure: 2,
  permFailure: 3,
  looking: 4,
  superseded: 5,
  posted: 6,
  revoked: 7,
  deleted: 8,
  unknownType: 9,
  sigHintMissing: 10,
  unchecked: 11,
}

export const ProveCommonProofStatus = {
  none: 0,
  ok: 1,
  local: 2,
  found: 3,
  baseError: 100,
  hostUnreachable: 101,
  permissionDenied: 103,
  failedParse: 106,
  dnsError: 107,
  authFailed: 108,
  http429: 129,
  http500: 150,
  timeout: 160,
  internalError: 170,
  unchecked: 171,
  missingPvl: 172,
  baseHardError: 200,
  notFound: 201,
  contentFailure: 202,
  badUsername: 203,
  badRemoteId: 204,
  textNotFound: 205,
  badArgs: 206,
  contentMissing: 207,
  titleNotFound: 208,
  serviceError: 209,
  torSkipped: 210,
  torIncompatible: 211,
  http300: 230,
  http400: 240,
  httpOther: 260,
  emptyJson: 270,
  deleted: 301,
  serviceDead: 302,
  badSignature: 303,
  badApiUrl: 304,
  unknownType: 305,
  noHint: 306,
  badHintText: 307,
  invalidPvl: 308,
}

export const ProveCommonProofType = {
  none: 0,
  keybase: 1,
  twitter: 2,
  github: 3,
  reddit: 4,
  coinbase: 5,
  hackernews: 6,
  facebook: 8,
  genericWebSite: 1000,
  dns: 1001,
  pgp: 1002,
  rooter: 100001,
}

export const ProveUiPromptOverwriteType = {
  social: 0,
  site: 1,
}

export const ProvisionUiChooseType = {
  existingDevice: 0,
  newDevice: 1,
}

export const ProvisionUiGPGMethod = {
  gpgNone: 0,
  gpgImport: 1,
  gpgSign: 2,
}

export const ProvisionUiProvisionMethod = {
  device: 0,
  paperKey: 1,
  passphrase: 2,
  gpgImport: 3,
  gpgSign: 4,
}

export const ReachabilityReachable = {
  unknown: 0,
  yes: 1,
  no: 2,
}

export const RekeyOutcome = {
  none: 0,
  fixed: 1,
  ignored: 2,
}

export const RekeyUIRekeyEventType = {
  none: 0,
  notLoggedIn: 1,
  apiError: 2,
  noProblems: 3,
  loadMeError: 4,
  currentDeviceCanRekey: 5,
  deviceLoadError: 6,
  harass: 7,
  noGregorMessages: 8,
}

export const SaltpackUiSaltpackSenderType = {
  notTracked: 0,
  unknown: 1,
  anonymous: 2,
  trackingBroke: 3,
  trackingOk: 4,
  self: 5,
  revoked: 6,
  expired: 7,
}

export const SimpleFSAsyncOps = {
  list: 0,
  listRecursive: 1,
  read: 2,
  write: 3,
  copy: 4,
  move: 5,
  remove: 6,
}

export const SimpleFSDirentType = {
  file: 0,
  dir: 1,
  sym: 2,
  exec: 3,
}

export const SimpleFSOpenFlags = {
  read: 0,
  replace: 1,
  existing: 2,
  write: 4,
  append: 8,
  directory: 16,
}

export const SimpleFSPathType = {
  local: 0,
  kbfs: 1,
}

export const TeamsTeamApplication = {
  kbfs: 1,
  chat: 2,
  saltpack: 3,
  gitMetadata: 4,
}

export const TeamsTeamInviteCategory = {
  none: 0,
  unknown: 1,
  keybase: 2,
  email: 3,
  sbs: 4,
}

export const TeamsTeamRole = {
  none: 0,
  reader: 1,
  writer: 2,
  admin: 3,
  owner: 4,
}

export const TlfKeysTLFIdentifyBehavior = {
  defaultKbfs: 0,
  chatCli: 1,
  chatGui: 2,
  chatGuiStrict: 3,
  kbfsRekey: 4,
  kbfsQr: 5,
  chatSkip: 6,
}

export const UPKKeyType = {
  none: 0,
  nacl: 1,
  pgp: 2,
}

export const UPKUPAKVersion = {
  v1: 1,
  v2: 2,
}

export const UPKUPK2MinorVersion = {
  v0: 0,
  v1: 1,
  v2: 2,
  v3: 3,
  v4: 4,
  v5: 5,
}

export const UiPromptDefault = {
  none: 0,
  yes: 1,
  no: 2,
}

export function BTCRegisterBTCRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: BTCRegisterBTCRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.BTC.registerBTC', request)
}

export function BTCRegisterBTCRpcPromise (request: (requestCommon & requestErrorCallback & {param: BTCRegisterBTCRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.BTC.registerBTC', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function KBFSGitCreateRepoRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: KBFSGitCreateRepoResult) => void} & {param: KBFSGitCreateRepoRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.KBFSGit.createRepo', request)
}

export function KBFSGitCreateRepoRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: KBFSGitCreateRepoResult) => void} & {param: KBFSGitCreateRepoRpcParam})): Promise<KBFSGitCreateRepoResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.KBFSGit.createRepo', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function KBFSGitDeleteRepoRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: KBFSGitDeleteRepoRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.KBFSGit.deleteRepo', request)
}

export function KBFSGitDeleteRepoRpcPromise (request: (requestCommon & requestErrorCallback & {param: KBFSGitDeleteRepoRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.KBFSGit.deleteRepo', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function Kex2Provisionee2DidCounterSign2RpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: Kex2Provisionee2DidCounterSign2RpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.Kex2Provisionee2.didCounterSign2', request)
}

export function Kex2Provisionee2DidCounterSign2RpcPromise (request: (requestCommon & requestErrorCallback & {param: Kex2Provisionee2DidCounterSign2RpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.Kex2Provisionee2.didCounterSign2', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function Kex2Provisionee2Hello2RpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: Kex2Provisionee2Hello2Result) => void} & {param: Kex2Provisionee2Hello2RpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.Kex2Provisionee2.hello2', request)
}

export function Kex2Provisionee2Hello2RpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: Kex2Provisionee2Hello2Result) => void} & {param: Kex2Provisionee2Hello2RpcParam})): Promise<Kex2Provisionee2Hello2Result> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.Kex2Provisionee2.hello2', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function Kex2ProvisioneeDidCounterSignRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: Kex2ProvisioneeDidCounterSignRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.Kex2Provisionee.didCounterSign', request)
}

export function Kex2ProvisioneeDidCounterSignRpcPromise (request: (requestCommon & requestErrorCallback & {param: Kex2ProvisioneeDidCounterSignRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.Kex2Provisionee.didCounterSign', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function Kex2ProvisioneeHelloRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: Kex2ProvisioneeHelloResult) => void} & {param: Kex2ProvisioneeHelloRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.Kex2Provisionee.hello', request)
}

export function Kex2ProvisioneeHelloRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: Kex2ProvisioneeHelloResult) => void} & {param: Kex2ProvisioneeHelloRpcParam})): Promise<Kex2ProvisioneeHelloResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.Kex2Provisionee.hello', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function Kex2ProvisionerKexStartRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.Kex2Provisioner.kexStart', request)
}

export function Kex2ProvisionerKexStartRpcPromise (request: ?(requestCommon & requestErrorCallback)): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.Kex2Provisioner.kexStart', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function NotifyFSRequestFSEditListRequestRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: NotifyFSRequestFSEditListRequestRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.NotifyFSRequest.FSEditListRequest', request)
}

export function NotifyFSRequestFSEditListRequestRpcPromise (request: (requestCommon & requestErrorCallback & {param: NotifyFSRequestFSEditListRequestRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.NotifyFSRequest.FSEditListRequest', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function NotifyFSRequestFSSyncStatusRequestRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: NotifyFSRequestFSSyncStatusRequestRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.NotifyFSRequest.FSSyncStatusRequest', request)
}

export function NotifyFSRequestFSSyncStatusRequestRpcPromise (request: (requestCommon & requestErrorCallback & {param: NotifyFSRequestFSSyncStatusRequestRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.NotifyFSRequest.FSSyncStatusRequest', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function ScanProofsScanProofsRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: ScanProofsScanProofsRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.ScanProofs.scanProofs', request)
}

export function ScanProofsScanProofsRpcPromise (request: (requestCommon & requestErrorCallback & {param: ScanProofsScanProofsRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.ScanProofs.scanProofs', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function SecretKeysGetSecretKeysRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: SecretKeysGetSecretKeysResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.SecretKeys.getSecretKeys', request)
}

export function SecretKeysGetSecretKeysRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: SecretKeysGetSecretKeysResult) => void})): Promise<SecretKeysGetSecretKeysResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.SecretKeys.getSecretKeys', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function SimpleFSSimpleFSCancelRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: SimpleFSSimpleFSCancelRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.SimpleFS.simpleFSCancel', request)
}

export function SimpleFSSimpleFSCancelRpcPromise (request: (requestCommon & requestErrorCallback & {param: SimpleFSSimpleFSCancelRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.SimpleFS.simpleFSCancel', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function SimpleFSSimpleFSCheckRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: SimpleFSSimpleFSCheckResult) => void} & {param: SimpleFSSimpleFSCheckRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.SimpleFS.simpleFSCheck', request)
}

export function SimpleFSSimpleFSCheckRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: SimpleFSSimpleFSCheckResult) => void} & {param: SimpleFSSimpleFSCheckRpcParam})): Promise<SimpleFSSimpleFSCheckResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.SimpleFS.simpleFSCheck', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function SimpleFSSimpleFSCloseRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: SimpleFSSimpleFSCloseRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.SimpleFS.simpleFSClose', request)
}

export function SimpleFSSimpleFSCloseRpcPromise (request: (requestCommon & requestErrorCallback & {param: SimpleFSSimpleFSCloseRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.SimpleFS.simpleFSClose', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function SimpleFSSimpleFSCopyRecursiveRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: SimpleFSSimpleFSCopyRecursiveRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.SimpleFS.simpleFSCopyRecursive', request)
}

export function SimpleFSSimpleFSCopyRecursiveRpcPromise (request: (requestCommon & requestErrorCallback & {param: SimpleFSSimpleFSCopyRecursiveRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.SimpleFS.simpleFSCopyRecursive', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function SimpleFSSimpleFSCopyRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: SimpleFSSimpleFSCopyRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.SimpleFS.simpleFSCopy', request)
}

export function SimpleFSSimpleFSCopyRpcPromise (request: (requestCommon & requestErrorCallback & {param: SimpleFSSimpleFSCopyRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.SimpleFS.simpleFSCopy', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function SimpleFSSimpleFSGetOpsRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: SimpleFSSimpleFSGetOpsResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.SimpleFS.simpleFSGetOps', request)
}

export function SimpleFSSimpleFSGetOpsRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: SimpleFSSimpleFSGetOpsResult) => void})): Promise<SimpleFSSimpleFSGetOpsResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.SimpleFS.simpleFSGetOps', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function SimpleFSSimpleFSListRecursiveRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: SimpleFSSimpleFSListRecursiveRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.SimpleFS.simpleFSListRecursive', request)
}

export function SimpleFSSimpleFSListRecursiveRpcPromise (request: (requestCommon & requestErrorCallback & {param: SimpleFSSimpleFSListRecursiveRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.SimpleFS.simpleFSListRecursive', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function SimpleFSSimpleFSListRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: SimpleFSSimpleFSListRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.SimpleFS.simpleFSList', request)
}

export function SimpleFSSimpleFSListRpcPromise (request: (requestCommon & requestErrorCallback & {param: SimpleFSSimpleFSListRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.SimpleFS.simpleFSList', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function SimpleFSSimpleFSMakeOpidRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: SimpleFSSimpleFSMakeOpidResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.SimpleFS.simpleFSMakeOpid', request)
}

export function SimpleFSSimpleFSMakeOpidRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: SimpleFSSimpleFSMakeOpidResult) => void})): Promise<SimpleFSSimpleFSMakeOpidResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.SimpleFS.simpleFSMakeOpid', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function SimpleFSSimpleFSMoveRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: SimpleFSSimpleFSMoveRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.SimpleFS.simpleFSMove', request)
}

export function SimpleFSSimpleFSMoveRpcPromise (request: (requestCommon & requestErrorCallback & {param: SimpleFSSimpleFSMoveRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.SimpleFS.simpleFSMove', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function SimpleFSSimpleFSOpenRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: SimpleFSSimpleFSOpenRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.SimpleFS.simpleFSOpen', request)
}

export function SimpleFSSimpleFSOpenRpcPromise (request: (requestCommon & requestErrorCallback & {param: SimpleFSSimpleFSOpenRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.SimpleFS.simpleFSOpen', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function SimpleFSSimpleFSReadListRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: SimpleFSSimpleFSReadListResult) => void} & {param: SimpleFSSimpleFSReadListRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.SimpleFS.simpleFSReadList', request)
}

export function SimpleFSSimpleFSReadListRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: SimpleFSSimpleFSReadListResult) => void} & {param: SimpleFSSimpleFSReadListRpcParam})): Promise<SimpleFSSimpleFSReadListResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.SimpleFS.simpleFSReadList', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function SimpleFSSimpleFSReadRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: SimpleFSSimpleFSReadResult) => void} & {param: SimpleFSSimpleFSReadRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.SimpleFS.simpleFSRead', request)
}

export function SimpleFSSimpleFSReadRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: SimpleFSSimpleFSReadResult) => void} & {param: SimpleFSSimpleFSReadRpcParam})): Promise<SimpleFSSimpleFSReadResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.SimpleFS.simpleFSRead', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function SimpleFSSimpleFSRemoveRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: SimpleFSSimpleFSRemoveRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.SimpleFS.simpleFSRemove', request)
}

export function SimpleFSSimpleFSRemoveRpcPromise (request: (requestCommon & requestErrorCallback & {param: SimpleFSSimpleFSRemoveRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.SimpleFS.simpleFSRemove', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function SimpleFSSimpleFSRenameRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: SimpleFSSimpleFSRenameRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.SimpleFS.simpleFSRename', request)
}

export function SimpleFSSimpleFSRenameRpcPromise (request: (requestCommon & requestErrorCallback & {param: SimpleFSSimpleFSRenameRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.SimpleFS.simpleFSRename', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function SimpleFSSimpleFSSetStatRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: SimpleFSSimpleFSSetStatRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.SimpleFS.simpleFSSetStat', request)
}

export function SimpleFSSimpleFSSetStatRpcPromise (request: (requestCommon & requestErrorCallback & {param: SimpleFSSimpleFSSetStatRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.SimpleFS.simpleFSSetStat', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function SimpleFSSimpleFSStatRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: SimpleFSSimpleFSStatResult) => void} & {param: SimpleFSSimpleFSStatRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.SimpleFS.simpleFSStat', request)
}

export function SimpleFSSimpleFSStatRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: SimpleFSSimpleFSStatResult) => void} & {param: SimpleFSSimpleFSStatRpcParam})): Promise<SimpleFSSimpleFSStatResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.SimpleFS.simpleFSStat', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function SimpleFSSimpleFSWaitRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: SimpleFSSimpleFSWaitRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.SimpleFS.simpleFSWait', request)
}

export function SimpleFSSimpleFSWaitRpcPromise (request: (requestCommon & requestErrorCallback & {param: SimpleFSSimpleFSWaitRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.SimpleFS.simpleFSWait', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function SimpleFSSimpleFSWriteRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: SimpleFSSimpleFSWriteRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.SimpleFS.simpleFSWrite', request)
}

export function SimpleFSSimpleFSWriteRpcPromise (request: (requestCommon & requestErrorCallback & {param: SimpleFSSimpleFSWriteRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.SimpleFS.simpleFSWrite', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function accountEmailChangeRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: accountEmailChangeRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.account.emailChange', request)
}

export function accountEmailChangeRpcPromise (request: (requestCommon & requestErrorCallback & {param: accountEmailChangeRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.account.emailChange', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function accountHasServerKeysRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: accountHasServerKeysResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.account.hasServerKeys', request)
}

export function accountHasServerKeysRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: accountHasServerKeysResult) => void})): Promise<accountHasServerKeysResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.account.hasServerKeys', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function accountPassphraseChangeRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: accountPassphraseChangeRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.account.passphraseChange', request)
}

export function accountPassphraseChangeRpcPromise (request: (requestCommon & requestErrorCallback & {param: accountPassphraseChangeRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.account.passphraseChange', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function accountPassphrasePromptRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: accountPassphrasePromptResult) => void} & {param: accountPassphrasePromptRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.account.passphrasePrompt', request)
}

export function accountPassphrasePromptRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: accountPassphrasePromptResult) => void} & {param: accountPassphrasePromptRpcParam})): Promise<accountPassphrasePromptResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.account.passphrasePrompt', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function accountResetAccountRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.account.resetAccount', request)
}

export function accountResetAccountRpcPromise (request: ?(requestCommon & requestErrorCallback)): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.account.resetAccount', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function apiserverDeleteRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: apiserverDeleteResult) => void} & {param: apiserverDeleteRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.apiserver.Delete', request)
}

export function apiserverDeleteRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: apiserverDeleteResult) => void} & {param: apiserverDeleteRpcParam})): Promise<apiserverDeleteResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.apiserver.Delete', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function apiserverGetRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: apiserverGetResult) => void} & {param: apiserverGetRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.apiserver.Get', request)
}

export function apiserverGetRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: apiserverGetResult) => void} & {param: apiserverGetRpcParam})): Promise<apiserverGetResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.apiserver.Get', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function apiserverGetWithSessionRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: apiserverGetWithSessionResult) => void} & {param: apiserverGetWithSessionRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.apiserver.GetWithSession', request)
}

export function apiserverGetWithSessionRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: apiserverGetWithSessionResult) => void} & {param: apiserverGetWithSessionRpcParam})): Promise<apiserverGetWithSessionResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.apiserver.GetWithSession', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function apiserverPostJSONRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: apiserverPostJSONResult) => void} & {param: apiserverPostJSONRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.apiserver.PostJSON', request)
}

export function apiserverPostJSONRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: apiserverPostJSONResult) => void} & {param: apiserverPostJSONRpcParam})): Promise<apiserverPostJSONResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.apiserver.PostJSON', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function apiserverPostRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: apiserverPostResult) => void} & {param: apiserverPostRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.apiserver.Post', request)
}

export function apiserverPostRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: apiserverPostResult) => void} & {param: apiserverPostRpcParam})): Promise<apiserverPostResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.apiserver.Post', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function appStateUpdateAppStateRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: appStateUpdateAppStateRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.appState.updateAppState', request)
}

export function appStateUpdateAppStateRpcPromise (request: (requestCommon & requestErrorCallback & {param: appStateUpdateAppStateRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.appState.updateAppState', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function badgerGetBadgeStateRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: badgerGetBadgeStateResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.badger.getBadgeState', request)
}

export function badgerGetBadgeStateRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: badgerGetBadgeStateResult) => void})): Promise<badgerGetBadgeStateResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.badger.getBadgeState', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function blockAddReferenceRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: blockAddReferenceRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.block.addReference', request)
}

export function blockAddReferenceRpcPromise (request: (requestCommon & requestErrorCallback & {param: blockAddReferenceRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.block.addReference', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function blockArchiveReferenceRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: blockArchiveReferenceResult) => void} & {param: blockArchiveReferenceRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.block.archiveReference', request)
}

export function blockArchiveReferenceRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: blockArchiveReferenceResult) => void} & {param: blockArchiveReferenceRpcParam})): Promise<blockArchiveReferenceResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.block.archiveReference', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function blockArchiveReferenceWithCountRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: blockArchiveReferenceWithCountResult) => void} & {param: blockArchiveReferenceWithCountRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.block.archiveReferenceWithCount', request)
}

export function blockArchiveReferenceWithCountRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: blockArchiveReferenceWithCountResult) => void} & {param: blockArchiveReferenceWithCountRpcParam})): Promise<blockArchiveReferenceWithCountResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.block.archiveReferenceWithCount', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function blockAuthenticateSessionRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: blockAuthenticateSessionRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.block.authenticateSession', request)
}

export function blockAuthenticateSessionRpcPromise (request: (requestCommon & requestErrorCallback & {param: blockAuthenticateSessionRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.block.authenticateSession', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function blockBlockPingRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: blockBlockPingResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.block.blockPing', request)
}

export function blockBlockPingRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: blockBlockPingResult) => void})): Promise<blockBlockPingResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.block.blockPing', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function blockDelReferenceRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: blockDelReferenceRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.block.delReference', request)
}

export function blockDelReferenceRpcPromise (request: (requestCommon & requestErrorCallback & {param: blockDelReferenceRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.block.delReference', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function blockDelReferenceWithCountRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: blockDelReferenceWithCountResult) => void} & {param: blockDelReferenceWithCountRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.block.delReferenceWithCount', request)
}

export function blockDelReferenceWithCountRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: blockDelReferenceWithCountResult) => void} & {param: blockDelReferenceWithCountRpcParam})): Promise<blockDelReferenceWithCountResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.block.delReferenceWithCount', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function blockGetBlockRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: blockGetBlockResult) => void} & {param: blockGetBlockRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.block.getBlock', request)
}

export function blockGetBlockRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: blockGetBlockResult) => void} & {param: blockGetBlockRpcParam})): Promise<blockGetBlockResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.block.getBlock', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function blockGetSessionChallengeRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: blockGetSessionChallengeResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.block.getSessionChallenge', request)
}

export function blockGetSessionChallengeRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: blockGetSessionChallengeResult) => void})): Promise<blockGetSessionChallengeResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.block.getSessionChallenge', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function blockGetTeamQuotaInfoRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: blockGetTeamQuotaInfoResult) => void} & {param: blockGetTeamQuotaInfoRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.block.getTeamQuotaInfo', request)
}

export function blockGetTeamQuotaInfoRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: blockGetTeamQuotaInfoResult) => void} & {param: blockGetTeamQuotaInfoRpcParam})): Promise<blockGetTeamQuotaInfoResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.block.getTeamQuotaInfo', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function blockGetUserQuotaInfoRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: blockGetUserQuotaInfoResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.block.getUserQuotaInfo', request)
}

export function blockGetUserQuotaInfoRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: blockGetUserQuotaInfoResult) => void})): Promise<blockGetUserQuotaInfoResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.block.getUserQuotaInfo', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function blockPutBlockAgainRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: blockPutBlockAgainRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.block.putBlockAgain', request)
}

export function blockPutBlockAgainRpcPromise (request: (requestCommon & requestErrorCallback & {param: blockPutBlockAgainRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.block.putBlockAgain', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function blockPutBlockRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: blockPutBlockRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.block.putBlock', request)
}

export function blockPutBlockRpcPromise (request: (requestCommon & requestErrorCallback & {param: blockPutBlockRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.block.putBlock', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function configCheckAPIServerOutOfDateWarningRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: configCheckAPIServerOutOfDateWarningResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.config.checkAPIServerOutOfDateWarning', request)
}

export function configCheckAPIServerOutOfDateWarningRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: configCheckAPIServerOutOfDateWarningResult) => void})): Promise<configCheckAPIServerOutOfDateWarningResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.config.checkAPIServerOutOfDateWarning', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function configClearValueRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: configClearValueRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.config.clearValue', request)
}

export function configClearValueRpcPromise (request: (requestCommon & requestErrorCallback & {param: configClearValueRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.config.clearValue', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function configGetBootstrapStatusRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: configGetBootstrapStatusResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.config.getBootstrapStatus', request)
}

export function configGetBootstrapStatusRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: configGetBootstrapStatusResult) => void})): Promise<configGetBootstrapStatusResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.config.getBootstrapStatus', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function configGetConfigRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: configGetConfigResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.config.getConfig', request)
}

export function configGetConfigRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: configGetConfigResult) => void})): Promise<configGetConfigResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.config.getConfig', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function configGetCurrentStatusRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: configGetCurrentStatusResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.config.getCurrentStatus', request)
}

export function configGetCurrentStatusRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: configGetCurrentStatusResult) => void})): Promise<configGetCurrentStatusResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.config.getCurrentStatus', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function configGetExtendedStatusRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: configGetExtendedStatusResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.config.getExtendedStatus', request)
}

export function configGetExtendedStatusRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: configGetExtendedStatusResult) => void})): Promise<configGetExtendedStatusResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.config.getExtendedStatus', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function configGetValueRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: configGetValueResult) => void} & {param: configGetValueRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.config.getValue', request)
}

export function configGetValueRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: configGetValueResult) => void} & {param: configGetValueRpcParam})): Promise<configGetValueResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.config.getValue', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function configHelloIAmRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: configHelloIAmRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.config.helloIAm', request)
}

export function configHelloIAmRpcPromise (request: (requestCommon & requestErrorCallback & {param: configHelloIAmRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.config.helloIAm', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function configSetPathRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: configSetPathRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.config.setPath', request)
}

export function configSetPathRpcPromise (request: (requestCommon & requestErrorCallback & {param: configSetPathRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.config.setPath', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function configSetUserConfigRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: configSetUserConfigRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.config.setUserConfig', request)
}

export function configSetUserConfigRpcPromise (request: (requestCommon & requestErrorCallback & {param: configSetUserConfigRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.config.setUserConfig', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function configSetValueRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: configSetValueRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.config.setValue', request)
}

export function configSetValueRpcPromise (request: (requestCommon & requestErrorCallback & {param: configSetValueRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.config.setValue', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function configWaitForClientRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: configWaitForClientResult) => void} & {param: configWaitForClientRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.config.waitForClient', request)
}

export function configWaitForClientRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: configWaitForClientResult) => void} & {param: configWaitForClientRpcParam})): Promise<configWaitForClientResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.config.waitForClient', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function cryptoSignED25519ForKBFSRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: cryptoSignED25519ForKBFSResult) => void} & {param: cryptoSignED25519ForKBFSRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.crypto.signED25519ForKBFS', request)
}

export function cryptoSignED25519ForKBFSRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: cryptoSignED25519ForKBFSResult) => void} & {param: cryptoSignED25519ForKBFSRpcParam})): Promise<cryptoSignED25519ForKBFSResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.crypto.signED25519ForKBFS', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function cryptoSignED25519RpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: cryptoSignED25519Result) => void} & {param: cryptoSignED25519RpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.crypto.signED25519', request)
}

export function cryptoSignED25519RpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: cryptoSignED25519Result) => void} & {param: cryptoSignED25519RpcParam})): Promise<cryptoSignED25519Result> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.crypto.signED25519', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function cryptoSignToStringRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: cryptoSignToStringResult) => void} & {param: cryptoSignToStringRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.crypto.signToString', request)
}

export function cryptoSignToStringRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: cryptoSignToStringResult) => void} & {param: cryptoSignToStringRpcParam})): Promise<cryptoSignToStringResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.crypto.signToString', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function cryptoUnboxBytes32AnyRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: cryptoUnboxBytes32AnyResult) => void} & {param: cryptoUnboxBytes32AnyRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.crypto.unboxBytes32Any', request)
}

export function cryptoUnboxBytes32AnyRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: cryptoUnboxBytes32AnyResult) => void} & {param: cryptoUnboxBytes32AnyRpcParam})): Promise<cryptoUnboxBytes32AnyResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.crypto.unboxBytes32Any', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function cryptoUnboxBytes32RpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: cryptoUnboxBytes32Result) => void} & {param: cryptoUnboxBytes32RpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.crypto.unboxBytes32', request)
}

export function cryptoUnboxBytes32RpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: cryptoUnboxBytes32Result) => void} & {param: cryptoUnboxBytes32RpcParam})): Promise<cryptoUnboxBytes32Result> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.crypto.unboxBytes32', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function cryptocurrencyRegisterAddressRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: cryptocurrencyRegisterAddressResult) => void} & {param: cryptocurrencyRegisterAddressRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.cryptocurrency.registerAddress', request)
}

export function cryptocurrencyRegisterAddressRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: cryptocurrencyRegisterAddressResult) => void} & {param: cryptocurrencyRegisterAddressRpcParam})): Promise<cryptocurrencyRegisterAddressResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.cryptocurrency.registerAddress', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function ctlAppExitRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.ctl.appExit', request)
}

export function ctlAppExitRpcPromise (request: ?(requestCommon & requestErrorCallback)): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.ctl.appExit', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function ctlDbDeleteRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: ctlDbDeleteRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.ctl.dbDelete', request)
}

export function ctlDbDeleteRpcPromise (request: (requestCommon & requestErrorCallback & {param: ctlDbDeleteRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.ctl.dbDelete', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function ctlDbGetRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: ctlDbGetResult) => void} & {param: ctlDbGetRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.ctl.dbGet', request)
}

export function ctlDbGetRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: ctlDbGetResult) => void} & {param: ctlDbGetRpcParam})): Promise<ctlDbGetResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.ctl.dbGet', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function ctlDbNukeRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.ctl.dbNuke', request)
}

export function ctlDbNukeRpcPromise (request: ?(requestCommon & requestErrorCallback)): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.ctl.dbNuke', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function ctlDbPutRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: ctlDbPutRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.ctl.dbPut', request)
}

export function ctlDbPutRpcPromise (request: (requestCommon & requestErrorCallback & {param: ctlDbPutRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.ctl.dbPut', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function ctlLogRotateRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.ctl.logRotate', request)
}

export function ctlLogRotateRpcPromise (request: ?(requestCommon & requestErrorCallback)): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.ctl.logRotate', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function ctlReloadRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.ctl.reload', request)
}

export function ctlReloadRpcPromise (request: ?(requestCommon & requestErrorCallback)): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.ctl.reload', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function ctlStopRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: ctlStopRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.ctl.stop', request)
}

export function ctlStopRpcPromise (request: (requestCommon & requestErrorCallback & {param: ctlStopRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.ctl.stop', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function debuggingFirstStepRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: debuggingFirstStepResult) => void} & {param: debuggingFirstStepRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.debugging.firstStep', request)
}

export function debuggingFirstStepRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: debuggingFirstStepResult) => void} & {param: debuggingFirstStepRpcParam})): Promise<debuggingFirstStepResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.debugging.firstStep', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function debuggingIncrementRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: debuggingIncrementResult) => void} & {param: debuggingIncrementRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.debugging.increment', request)
}

export function debuggingIncrementRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: debuggingIncrementResult) => void} & {param: debuggingIncrementRpcParam})): Promise<debuggingIncrementResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.debugging.increment', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function debuggingSecondStepRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: debuggingSecondStepResult) => void} & {param: debuggingSecondStepRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.debugging.secondStep', request)
}

export function debuggingSecondStepRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: debuggingSecondStepResult) => void} & {param: debuggingSecondStepRpcParam})): Promise<debuggingSecondStepResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.debugging.secondStep', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function delegateUiCtlRegisterGregorFirehoseRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.delegateUiCtl.registerGregorFirehose', request)
}

export function delegateUiCtlRegisterGregorFirehoseRpcPromise (request: ?(requestCommon & requestErrorCallback)): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.delegateUiCtl.registerGregorFirehose', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function delegateUiCtlRegisterIdentifyUIRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.delegateUiCtl.registerIdentifyUI', request)
}

export function delegateUiCtlRegisterIdentifyUIRpcPromise (request: ?(requestCommon & requestErrorCallback)): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.delegateUiCtl.registerIdentifyUI', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function delegateUiCtlRegisterRekeyUIRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.delegateUiCtl.registerRekeyUI', request)
}

export function delegateUiCtlRegisterRekeyUIRpcPromise (request: ?(requestCommon & requestErrorCallback)): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.delegateUiCtl.registerRekeyUI', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function delegateUiCtlRegisterSecretUIRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.delegateUiCtl.registerSecretUI', request)
}

export function delegateUiCtlRegisterSecretUIRpcPromise (request: ?(requestCommon & requestErrorCallback)): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.delegateUiCtl.registerSecretUI', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function delegateUiCtlRegisterUpdateUIRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.delegateUiCtl.registerUpdateUI', request)
}

export function delegateUiCtlRegisterUpdateUIRpcPromise (request: ?(requestCommon & requestErrorCallback)): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.delegateUiCtl.registerUpdateUI', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function deviceCheckDeviceNameForUserRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: deviceCheckDeviceNameForUserRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.device.checkDeviceNameForUser', request)
}

export function deviceCheckDeviceNameForUserRpcPromise (request: (requestCommon & requestErrorCallback & {param: deviceCheckDeviceNameForUserRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.device.checkDeviceNameForUser', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function deviceCheckDeviceNameFormatRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: deviceCheckDeviceNameFormatResult) => void} & {param: deviceCheckDeviceNameFormatRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.device.checkDeviceNameFormat', request)
}

export function deviceCheckDeviceNameFormatRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: deviceCheckDeviceNameFormatResult) => void} & {param: deviceCheckDeviceNameFormatRpcParam})): Promise<deviceCheckDeviceNameFormatResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.device.checkDeviceNameFormat', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function deviceDeviceAddRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.device.deviceAdd', request)
}

export function deviceDeviceAddRpcPromise (request: ?(requestCommon & requestErrorCallback)): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.device.deviceAdd', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function deviceDeviceHistoryListRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: deviceDeviceHistoryListResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.device.deviceHistoryList', request)
}

export function deviceDeviceHistoryListRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: deviceDeviceHistoryListResult) => void})): Promise<deviceDeviceHistoryListResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.device.deviceHistoryList', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function deviceDeviceListRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: deviceDeviceListResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.device.deviceList', request)
}

export function deviceDeviceListRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: deviceDeviceListResult) => void})): Promise<deviceDeviceListResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.device.deviceList', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function favoriteFavoriteAddRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: favoriteFavoriteAddRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.favorite.favoriteAdd', request)
}

export function favoriteFavoriteAddRpcPromise (request: (requestCommon & requestErrorCallback & {param: favoriteFavoriteAddRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.favorite.favoriteAdd', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function favoriteFavoriteIgnoreRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: favoriteFavoriteIgnoreRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.favorite.favoriteIgnore', request)
}

export function favoriteFavoriteIgnoreRpcPromise (request: (requestCommon & requestErrorCallback & {param: favoriteFavoriteIgnoreRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.favorite.favoriteIgnore', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function favoriteGetFavoritesRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: favoriteGetFavoritesResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.favorite.getFavorites', request)
}

export function favoriteGetFavoritesRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: favoriteGetFavoritesResult) => void})): Promise<favoriteGetFavoritesResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.favorite.getFavorites', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function fsListRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: fsListResult) => void} & {param: fsListRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.fs.List', request)
}

export function fsListRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: fsListResult) => void} & {param: fsListRpcParam})): Promise<fsListResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.fs.List', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function gitCreatePersonalRepoRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: gitCreatePersonalRepoResult) => void} & {param: gitCreatePersonalRepoRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.git.createPersonalRepo', request)
}

export function gitCreatePersonalRepoRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: gitCreatePersonalRepoResult) => void} & {param: gitCreatePersonalRepoRpcParam})): Promise<gitCreatePersonalRepoResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.git.createPersonalRepo', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function gitCreateTeamRepoRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: gitCreateTeamRepoResult) => void} & {param: gitCreateTeamRepoRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.git.createTeamRepo', request)
}

export function gitCreateTeamRepoRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: gitCreateTeamRepoResult) => void} & {param: gitCreateTeamRepoRpcParam})): Promise<gitCreateTeamRepoResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.git.createTeamRepo', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function gitDeletePersonalRepoRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: gitDeletePersonalRepoRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.git.deletePersonalRepo', request)
}

export function gitDeletePersonalRepoRpcPromise (request: (requestCommon & requestErrorCallback & {param: gitDeletePersonalRepoRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.git.deletePersonalRepo', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function gitDeleteTeamRepoRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: gitDeleteTeamRepoRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.git.deleteTeamRepo', request)
}

export function gitDeleteTeamRepoRpcPromise (request: (requestCommon & requestErrorCallback & {param: gitDeleteTeamRepoRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.git.deleteTeamRepo', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function gitGetAllGitMetadataRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: gitGetAllGitMetadataResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.git.getAllGitMetadata', request)
}

export function gitGetAllGitMetadataRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: gitGetAllGitMetadataResult) => void})): Promise<gitGetAllGitMetadataResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.git.getAllGitMetadata', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function gitGetGitMetadataRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: gitGetGitMetadataResult) => void} & {param: gitGetGitMetadataRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.git.getGitMetadata', request)
}

export function gitGetGitMetadataRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: gitGetGitMetadataResult) => void} & {param: gitGetGitMetadataRpcParam})): Promise<gitGetGitMetadataResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.git.getGitMetadata', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function gitPutGitMetadataRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: gitPutGitMetadataRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.git.putGitMetadata', request)
}

export function gitPutGitMetadataRpcPromise (request: (requestCommon & requestErrorCallback & {param: gitPutGitMetadataRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.git.putGitMetadata', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function gregorDismissCategoryRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: gregorDismissCategoryRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.gregor.dismissCategory', request)
}

export function gregorDismissCategoryRpcPromise (request: (requestCommon & requestErrorCallback & {param: gregorDismissCategoryRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.gregor.dismissCategory', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function gregorGetStateRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: gregorGetStateResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.gregor.getState', request)
}

export function gregorGetStateRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: gregorGetStateResult) => void})): Promise<gregorGetStateResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.gregor.getState', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function gregorInjectItemRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: gregorInjectItemResult) => void} & {param: gregorInjectItemRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.gregor.injectItem', request)
}

export function gregorInjectItemRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: gregorInjectItemResult) => void} & {param: gregorInjectItemRpcParam})): Promise<gregorInjectItemResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.gregor.injectItem', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function identifyIdentify2RpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: identifyIdentify2Result) => void} & {param: identifyIdentify2RpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.identify.identify2', request)
}

export function identifyIdentify2RpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: identifyIdentify2Result) => void} & {param: identifyIdentify2RpcParam})): Promise<identifyIdentify2Result> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.identify.identify2', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function identifyIdentifyLiteRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: identifyIdentifyLiteResult) => void} & {param: identifyIdentifyLiteRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.identify.identifyLite', request)
}

export function identifyIdentifyLiteRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: identifyIdentifyLiteResult) => void} & {param: identifyIdentifyLiteRpcParam})): Promise<identifyIdentifyLiteResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.identify.identifyLite', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function identifyResolve3RpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: identifyResolve3Result) => void} & {param: identifyResolve3RpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.identify.Resolve3', request)
}

export function identifyResolve3RpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: identifyResolve3Result) => void} & {param: identifyResolve3RpcParam})): Promise<identifyResolve3Result> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.identify.Resolve3', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function identifyResolveIdentifyImplicitTeamRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: identifyResolveIdentifyImplicitTeamResult) => void} & {param: identifyResolveIdentifyImplicitTeamRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.identify.resolveIdentifyImplicitTeam', request)
}

export function identifyResolveIdentifyImplicitTeamRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: identifyResolveIdentifyImplicitTeamResult) => void} & {param: identifyResolveIdentifyImplicitTeamRpcParam})): Promise<identifyResolveIdentifyImplicitTeamResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.identify.resolveIdentifyImplicitTeam', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function installFuseStatusRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: installFuseStatusResult) => void} & {param: installFuseStatusRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.install.fuseStatus', request)
}

export function installFuseStatusRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: installFuseStatusResult) => void} & {param: installFuseStatusRpcParam})): Promise<installFuseStatusResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.install.fuseStatus', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function installInstallCommandLinePrivilegedRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: installInstallCommandLinePrivilegedResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.install.installCommandLinePrivileged', request)
}

export function installInstallCommandLinePrivilegedRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: installInstallCommandLinePrivilegedResult) => void})): Promise<installInstallCommandLinePrivilegedResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.install.installCommandLinePrivileged', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function installInstallFuseRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: installInstallFuseResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.install.installFuse', request)
}

export function installInstallFuseRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: installInstallFuseResult) => void})): Promise<installInstallFuseResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.install.installFuse', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function installInstallKBFSRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: installInstallKBFSResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.install.installKBFS', request)
}

export function installInstallKBFSRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: installInstallKBFSResult) => void})): Promise<installInstallKBFSResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.install.installKBFS', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function installUninstallKBFSRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: installUninstallKBFSResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.install.uninstallKBFS', request)
}

export function installUninstallKBFSRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: installUninstallKBFSResult) => void})): Promise<installUninstallKBFSResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.install.uninstallKBFS', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function kbfsFSEditListRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: kbfsFSEditListRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.kbfs.FSEditList', request)
}

export function kbfsFSEditListRpcPromise (request: (requestCommon & requestErrorCallback & {param: kbfsFSEditListRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.kbfs.FSEditList', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function kbfsFSEventRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: kbfsFSEventRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.kbfs.FSEvent', request)
}

export function kbfsFSEventRpcPromise (request: (requestCommon & requestErrorCallback & {param: kbfsFSEventRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.kbfs.FSEvent', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function kbfsFSSyncEventRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: kbfsFSSyncEventRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.kbfs.FSSyncEvent', request)
}

export function kbfsFSSyncEventRpcPromise (request: (requestCommon & requestErrorCallback & {param: kbfsFSSyncEventRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.kbfs.FSSyncEvent', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function kbfsFSSyncStatusRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: kbfsFSSyncStatusRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.kbfs.FSSyncStatus', request)
}

export function kbfsFSSyncStatusRpcPromise (request: (requestCommon & requestErrorCallback & {param: kbfsFSSyncStatusRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.kbfs.FSSyncStatus', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function kbfsMountGetAllAvailableMountDirsRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: kbfsMountGetAllAvailableMountDirsResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.kbfsMount.GetAllAvailableMountDirs', request)
}

export function kbfsMountGetAllAvailableMountDirsRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: kbfsMountGetAllAvailableMountDirsResult) => void})): Promise<kbfsMountGetAllAvailableMountDirsResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.kbfsMount.GetAllAvailableMountDirs', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function kbfsMountGetCurrentMountDirRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: kbfsMountGetCurrentMountDirResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.kbfsMount.GetCurrentMountDir', request)
}

export function kbfsMountGetCurrentMountDirRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: kbfsMountGetCurrentMountDirResult) => void})): Promise<kbfsMountGetCurrentMountDirResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.kbfsMount.GetCurrentMountDir', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function kbfsMountSetCurrentMountDirRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: kbfsMountSetCurrentMountDirRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.kbfsMount.SetCurrentMountDir', request)
}

export function kbfsMountSetCurrentMountDirRpcPromise (request: (requestCommon & requestErrorCallback & {param: kbfsMountSetCurrentMountDirRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.kbfsMount.SetCurrentMountDir', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function logRegisterLoggerRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: logRegisterLoggerRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.log.registerLogger', request)
}

export function logRegisterLoggerRpcPromise (request: (requestCommon & requestErrorCallback & {param: logRegisterLoggerRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.log.registerLogger', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function loginAccountDeleteRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.login.accountDelete', request)
}

export function loginAccountDeleteRpcPromise (request: ?(requestCommon & requestErrorCallback)): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.login.accountDelete', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function loginClearStoredSecretRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: loginClearStoredSecretRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.login.clearStoredSecret', request)
}

export function loginClearStoredSecretRpcPromise (request: (requestCommon & requestErrorCallback & {param: loginClearStoredSecretRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.login.clearStoredSecret', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function loginDeprovisionRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: loginDeprovisionRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.login.deprovision', request)
}

export function loginDeprovisionRpcPromise (request: (requestCommon & requestErrorCallback & {param: loginDeprovisionRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.login.deprovision', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function loginGetConfiguredAccountsRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: loginGetConfiguredAccountsResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.login.getConfiguredAccounts', request)
}

export function loginGetConfiguredAccountsRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: loginGetConfiguredAccountsResult) => void})): Promise<loginGetConfiguredAccountsResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.login.getConfiguredAccounts', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function loginLoginProvisionedDeviceRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: loginLoginProvisionedDeviceRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.login.loginProvisionedDevice', request)
}

export function loginLoginProvisionedDeviceRpcPromise (request: (requestCommon & requestErrorCallback & {param: loginLoginProvisionedDeviceRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.login.loginProvisionedDevice', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function loginLoginRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: loginLoginRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.login.login', request)
}

export function loginLoginRpcPromise (request: (requestCommon & requestErrorCallback & {param: loginLoginRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.login.login', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function loginLoginWithPaperKeyRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.login.loginWithPaperKey', request)
}

export function loginLoginWithPaperKeyRpcPromise (request: ?(requestCommon & requestErrorCallback)): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.login.loginWithPaperKey', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function loginLogoutRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.login.logout', request)
}

export function loginLogoutRpcPromise (request: ?(requestCommon & requestErrorCallback)): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.login.logout', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function loginPaperKeyRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.login.paperKey', request)
}

export function loginPaperKeyRpcPromise (request: ?(requestCommon & requestErrorCallback)): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.login.paperKey', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function loginPaperKeySubmitRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: loginPaperKeySubmitRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.login.paperKeySubmit', request)
}

export function loginPaperKeySubmitRpcPromise (request: (requestCommon & requestErrorCallback & {param: loginPaperKeySubmitRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.login.paperKeySubmit', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function loginPgpProvisionRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: loginPgpProvisionRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.login.pgpProvision', request)
}

export function loginPgpProvisionRpcPromise (request: (requestCommon & requestErrorCallback & {param: loginPgpProvisionRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.login.pgpProvision', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function loginRecoverAccountFromEmailAddressRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: loginRecoverAccountFromEmailAddressRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.login.recoverAccountFromEmailAddress', request)
}

export function loginRecoverAccountFromEmailAddressRpcPromise (request: (requestCommon & requestErrorCallback & {param: loginRecoverAccountFromEmailAddressRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.login.recoverAccountFromEmailAddress', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function loginUnlockRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.login.unlock', request)
}

export function loginUnlockRpcPromise (request: ?(requestCommon & requestErrorCallback)): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.login.unlock', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function loginUnlockWithPassphraseRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: loginUnlockWithPassphraseRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.login.unlockWithPassphrase', request)
}

export function loginUnlockWithPassphraseRpcPromise (request: (requestCommon & requestErrorCallback & {param: loginUnlockWithPassphraseRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.login.unlockWithPassphrase', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function merkleGetCurrentMerkleRootRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: merkleGetCurrentMerkleRootResult) => void} & {param: merkleGetCurrentMerkleRootRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.merkle.getCurrentMerkleRoot', request)
}

export function merkleGetCurrentMerkleRootRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: merkleGetCurrentMerkleRootResult) => void} & {param: merkleGetCurrentMerkleRootRpcParam})): Promise<merkleGetCurrentMerkleRootResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.merkle.getCurrentMerkleRoot', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function metadataAuthenticateRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: metadataAuthenticateResult) => void} & {param: metadataAuthenticateRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.metadata.authenticate', request)
}

export function metadataAuthenticateRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: metadataAuthenticateResult) => void} & {param: metadataAuthenticateRpcParam})): Promise<metadataAuthenticateResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.metadata.authenticate', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function metadataDeleteKeyRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: metadataDeleteKeyRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.metadata.deleteKey', request)
}

export function metadataDeleteKeyRpcPromise (request: (requestCommon & requestErrorCallback & {param: metadataDeleteKeyRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.metadata.deleteKey', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function metadataGetChallengeRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: metadataGetChallengeResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.metadata.getChallenge', request)
}

export function metadataGetChallengeRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: metadataGetChallengeResult) => void})): Promise<metadataGetChallengeResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.metadata.getChallenge', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function metadataGetFolderHandleRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: metadataGetFolderHandleResult) => void} & {param: metadataGetFolderHandleRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.metadata.getFolderHandle', request)
}

export function metadataGetFolderHandleRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: metadataGetFolderHandleResult) => void} & {param: metadataGetFolderHandleRpcParam})): Promise<metadataGetFolderHandleResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.metadata.getFolderHandle', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function metadataGetFoldersForRekeyRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: metadataGetFoldersForRekeyRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.metadata.getFoldersForRekey', request)
}

export function metadataGetFoldersForRekeyRpcPromise (request: (requestCommon & requestErrorCallback & {param: metadataGetFoldersForRekeyRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.metadata.getFoldersForRekey', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function metadataGetKeyBundlesRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: metadataGetKeyBundlesResult) => void} & {param: metadataGetKeyBundlesRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.metadata.getKeyBundles', request)
}

export function metadataGetKeyBundlesRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: metadataGetKeyBundlesResult) => void} & {param: metadataGetKeyBundlesRpcParam})): Promise<metadataGetKeyBundlesResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.metadata.getKeyBundles', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function metadataGetKeyRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: metadataGetKeyResult) => void} & {param: metadataGetKeyRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.metadata.getKey', request)
}

export function metadataGetKeyRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: metadataGetKeyResult) => void} & {param: metadataGetKeyRpcParam})): Promise<metadataGetKeyResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.metadata.getKey', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function metadataGetLatestFolderHandleRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: metadataGetLatestFolderHandleResult) => void} & {param: metadataGetLatestFolderHandleRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.metadata.getLatestFolderHandle', request)
}

export function metadataGetLatestFolderHandleRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: metadataGetLatestFolderHandleResult) => void} & {param: metadataGetLatestFolderHandleRpcParam})): Promise<metadataGetLatestFolderHandleResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.metadata.getLatestFolderHandle', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function metadataGetMerkleNodeRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: metadataGetMerkleNodeResult) => void} & {param: metadataGetMerkleNodeRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.metadata.getMerkleNode', request)
}

export function metadataGetMerkleNodeRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: metadataGetMerkleNodeResult) => void} & {param: metadataGetMerkleNodeRpcParam})): Promise<metadataGetMerkleNodeResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.metadata.getMerkleNode', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function metadataGetMerkleRootLatestRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: metadataGetMerkleRootLatestResult) => void} & {param: metadataGetMerkleRootLatestRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.metadata.getMerkleRootLatest', request)
}

export function metadataGetMerkleRootLatestRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: metadataGetMerkleRootLatestResult) => void} & {param: metadataGetMerkleRootLatestRpcParam})): Promise<metadataGetMerkleRootLatestResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.metadata.getMerkleRootLatest', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function metadataGetMerkleRootRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: metadataGetMerkleRootResult) => void} & {param: metadataGetMerkleRootRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.metadata.getMerkleRoot', request)
}

export function metadataGetMerkleRootRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: metadataGetMerkleRootResult) => void} & {param: metadataGetMerkleRootRpcParam})): Promise<metadataGetMerkleRootResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.metadata.getMerkleRoot', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function metadataGetMerkleRootSinceRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: metadataGetMerkleRootSinceResult) => void} & {param: metadataGetMerkleRootSinceRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.metadata.getMerkleRootSince', request)
}

export function metadataGetMerkleRootSinceRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: metadataGetMerkleRootSinceResult) => void} & {param: metadataGetMerkleRootSinceRpcParam})): Promise<metadataGetMerkleRootSinceResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.metadata.getMerkleRootSince', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function metadataGetMetadataRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: metadataGetMetadataResult) => void} & {param: metadataGetMetadataRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.metadata.getMetadata', request)
}

export function metadataGetMetadataRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: metadataGetMetadataResult) => void} & {param: metadataGetMetadataRpcParam})): Promise<metadataGetMetadataResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.metadata.getMetadata', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function metadataLockRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: metadataLockRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.metadata.lock', request)
}

export function metadataLockRpcPromise (request: (requestCommon & requestErrorCallback & {param: metadataLockRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.metadata.lock', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function metadataPing2RpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: metadataPing2Result) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.metadata.ping2', request)
}

export function metadataPing2RpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: metadataPing2Result) => void})): Promise<metadataPing2Result> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.metadata.ping2', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function metadataPingRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.metadata.ping', request)
}

export function metadataPingRpcPromise (request: ?(requestCommon & requestErrorCallback)): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.metadata.ping', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function metadataPruneBranchRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: metadataPruneBranchRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.metadata.pruneBranch', request)
}

export function metadataPruneBranchRpcPromise (request: (requestCommon & requestErrorCallback & {param: metadataPruneBranchRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.metadata.pruneBranch', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function metadataPutKeysRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: metadataPutKeysRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.metadata.putKeys', request)
}

export function metadataPutKeysRpcPromise (request: (requestCommon & requestErrorCallback & {param: metadataPutKeysRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.metadata.putKeys', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function metadataPutMetadataRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: metadataPutMetadataRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.metadata.putMetadata', request)
}

export function metadataPutMetadataRpcPromise (request: (requestCommon & requestErrorCallback & {param: metadataPutMetadataRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.metadata.putMetadata', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function metadataRegisterForUpdatesRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: metadataRegisterForUpdatesRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.metadata.registerForUpdates', request)
}

export function metadataRegisterForUpdatesRpcPromise (request: (requestCommon & requestErrorCallback & {param: metadataRegisterForUpdatesRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.metadata.registerForUpdates', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function metadataReleaseLockRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: metadataReleaseLockRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.metadata.releaseLock', request)
}

export function metadataReleaseLockRpcPromise (request: (requestCommon & requestErrorCallback & {param: metadataReleaseLockRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.metadata.releaseLock', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function metadataTruncateLockRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: metadataTruncateLockResult) => void} & {param: metadataTruncateLockRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.metadata.truncateLock', request)
}

export function metadataTruncateLockRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: metadataTruncateLockResult) => void} & {param: metadataTruncateLockRpcParam})): Promise<metadataTruncateLockResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.metadata.truncateLock', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function metadataTruncateUnlockRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: metadataTruncateUnlockResult) => void} & {param: metadataTruncateUnlockRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.metadata.truncateUnlock', request)
}

export function metadataTruncateUnlockRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: metadataTruncateUnlockResult) => void} & {param: metadataTruncateUnlockRpcParam})): Promise<metadataTruncateUnlockResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.metadata.truncateUnlock', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function metadataUpdateFolderNeedsRekeyRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: metadataUpdateFolderNeedsRekeyRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.metadataUpdate.folderNeedsRekey', request)
}

export function metadataUpdateFolderNeedsRekeyRpcPromise (request: (requestCommon & requestErrorCallback & {param: metadataUpdateFolderNeedsRekeyRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.metadataUpdate.folderNeedsRekey', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function metadataUpdateFoldersNeedRekeyRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: metadataUpdateFoldersNeedRekeyRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.metadataUpdate.foldersNeedRekey', request)
}

export function metadataUpdateFoldersNeedRekeyRpcPromise (request: (requestCommon & requestErrorCallback & {param: metadataUpdateFoldersNeedRekeyRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.metadataUpdate.foldersNeedRekey', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function metadataUpdateMetadataUpdateRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: metadataUpdateMetadataUpdateRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.metadataUpdate.metadataUpdate', request)
}

export function metadataUpdateMetadataUpdateRpcPromise (request: (requestCommon & requestErrorCallback & {param: metadataUpdateMetadataUpdateRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.metadataUpdate.metadataUpdate', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function notifyCtlSetNotificationsRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: notifyCtlSetNotificationsRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.notifyCtl.setNotifications', request)
}

export function notifyCtlSetNotificationsRpcPromise (request: (requestCommon & requestErrorCallback & {param: notifyCtlSetNotificationsRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.notifyCtl.setNotifications', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function paperprovisionPaperProvisionRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: paperprovisionPaperProvisionRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.paperprovision.paperProvision', request)
}

export function paperprovisionPaperProvisionRpcPromise (request: (requestCommon & requestErrorCallback & {param: paperprovisionPaperProvisionRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.paperprovision.paperProvision', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function pgpPgpDecryptRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: pgpPgpDecryptResult) => void} & {param: pgpPgpDecryptRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.pgp.pgpDecrypt', request)
}

export function pgpPgpDecryptRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: pgpPgpDecryptResult) => void} & {param: pgpPgpDecryptRpcParam})): Promise<pgpPgpDecryptResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.pgp.pgpDecrypt', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function pgpPgpDeletePrimaryRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.pgp.pgpDeletePrimary', request)
}

export function pgpPgpDeletePrimaryRpcPromise (request: ?(requestCommon & requestErrorCallback)): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.pgp.pgpDeletePrimary', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function pgpPgpEncryptRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: pgpPgpEncryptRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.pgp.pgpEncrypt', request)
}

export function pgpPgpEncryptRpcPromise (request: (requestCommon & requestErrorCallback & {param: pgpPgpEncryptRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.pgp.pgpEncrypt', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function pgpPgpExportByFingerprintRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: pgpPgpExportByFingerprintResult) => void} & {param: pgpPgpExportByFingerprintRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.pgp.pgpExportByFingerprint', request)
}

export function pgpPgpExportByFingerprintRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: pgpPgpExportByFingerprintResult) => void} & {param: pgpPgpExportByFingerprintRpcParam})): Promise<pgpPgpExportByFingerprintResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.pgp.pgpExportByFingerprint', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function pgpPgpExportByKIDRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: pgpPgpExportByKIDResult) => void} & {param: pgpPgpExportByKIDRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.pgp.pgpExportByKID', request)
}

export function pgpPgpExportByKIDRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: pgpPgpExportByKIDResult) => void} & {param: pgpPgpExportByKIDRpcParam})): Promise<pgpPgpExportByKIDResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.pgp.pgpExportByKID', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function pgpPgpExportRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: pgpPgpExportResult) => void} & {param: pgpPgpExportRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.pgp.pgpExport', request)
}

export function pgpPgpExportRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: pgpPgpExportResult) => void} & {param: pgpPgpExportRpcParam})): Promise<pgpPgpExportResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.pgp.pgpExport', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function pgpPgpImportRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: pgpPgpImportRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.pgp.pgpImport', request)
}

export function pgpPgpImportRpcPromise (request: (requestCommon & requestErrorCallback & {param: pgpPgpImportRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.pgp.pgpImport', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function pgpPgpKeyGenDefaultRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: pgpPgpKeyGenDefaultRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.pgp.pgpKeyGenDefault', request)
}

export function pgpPgpKeyGenDefaultRpcPromise (request: (requestCommon & requestErrorCallback & {param: pgpPgpKeyGenDefaultRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.pgp.pgpKeyGenDefault', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function pgpPgpKeyGenRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: pgpPgpKeyGenRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.pgp.pgpKeyGen', request)
}

export function pgpPgpKeyGenRpcPromise (request: (requestCommon & requestErrorCallback & {param: pgpPgpKeyGenRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.pgp.pgpKeyGen', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function pgpPgpPullRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: pgpPgpPullRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.pgp.pgpPull', request)
}

export function pgpPgpPullRpcPromise (request: (requestCommon & requestErrorCallback & {param: pgpPgpPullRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.pgp.pgpPull', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function pgpPgpPurgeRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: pgpPgpPurgeResult) => void} & {param: pgpPgpPurgeRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.pgp.pgpPurge', request)
}

export function pgpPgpPurgeRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: pgpPgpPurgeResult) => void} & {param: pgpPgpPurgeRpcParam})): Promise<pgpPgpPurgeResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.pgp.pgpPurge', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function pgpPgpSelectRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: pgpPgpSelectRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.pgp.pgpSelect', request)
}

export function pgpPgpSelectRpcPromise (request: (requestCommon & requestErrorCallback & {param: pgpPgpSelectRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.pgp.pgpSelect', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function pgpPgpSignRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: pgpPgpSignRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.pgp.pgpSign', request)
}

export function pgpPgpSignRpcPromise (request: (requestCommon & requestErrorCallback & {param: pgpPgpSignRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.pgp.pgpSign', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function pgpPgpStorageDismissRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.pgp.pgpStorageDismiss', request)
}

export function pgpPgpStorageDismissRpcPromise (request: ?(requestCommon & requestErrorCallback)): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.pgp.pgpStorageDismiss', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function pgpPgpUpdateRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: pgpPgpUpdateRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.pgp.pgpUpdate', request)
}

export function pgpPgpUpdateRpcPromise (request: (requestCommon & requestErrorCallback & {param: pgpPgpUpdateRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.pgp.pgpUpdate', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function pgpPgpVerifyRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: pgpPgpVerifyResult) => void} & {param: pgpPgpVerifyRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.pgp.pgpVerify', request)
}

export function pgpPgpVerifyRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: pgpPgpVerifyResult) => void} & {param: pgpPgpVerifyRpcParam})): Promise<pgpPgpVerifyResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.pgp.pgpVerify', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function proveCheckProofRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: proveCheckProofResult) => void} & {param: proveCheckProofRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.prove.checkProof', request)
}

export function proveCheckProofRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: proveCheckProofResult) => void} & {param: proveCheckProofRpcParam})): Promise<proveCheckProofResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.prove.checkProof', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function proveStartProofRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: proveStartProofResult) => void} & {param: proveStartProofRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.prove.startProof', request)
}

export function proveStartProofRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: proveStartProofResult) => void} & {param: proveStartProofRpcParam})): Promise<proveStartProofResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.prove.startProof', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function quotaVerifySessionRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: quotaVerifySessionResult) => void} & {param: quotaVerifySessionRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.quota.verifySession', request)
}

export function quotaVerifySessionRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: quotaVerifySessionResult) => void} & {param: quotaVerifySessionRpcParam})): Promise<quotaVerifySessionResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.quota.verifySession', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function reachabilityCheckReachabilityRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: reachabilityCheckReachabilityResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.reachability.checkReachability', request)
}

export function reachabilityCheckReachabilityRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: reachabilityCheckReachabilityResult) => void})): Promise<reachabilityCheckReachabilityResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.reachability.checkReachability', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function reachabilityReachabilityChangedRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: reachabilityReachabilityChangedRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.reachability.reachabilityChanged', request)
}

export function reachabilityReachabilityChangedRpcPromise (request: (requestCommon & requestErrorCallback & {param: reachabilityReachabilityChangedRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.reachability.reachabilityChanged', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function reachabilityStartReachabilityRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: reachabilityStartReachabilityResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.reachability.startReachability', request)
}

export function reachabilityStartReachabilityRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: reachabilityStartReachabilityResult) => void})): Promise<reachabilityStartReachabilityResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.reachability.startReachability', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function rekeyDebugShowRekeyStatusRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.rekey.debugShowRekeyStatus', request)
}

export function rekeyDebugShowRekeyStatusRpcPromise (request: ?(requestCommon & requestErrorCallback)): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.rekey.debugShowRekeyStatus', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function rekeyGetPendingRekeyStatusRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: rekeyGetPendingRekeyStatusResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.rekey.getPendingRekeyStatus', request)
}

export function rekeyGetPendingRekeyStatusRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: rekeyGetPendingRekeyStatusResult) => void})): Promise<rekeyGetPendingRekeyStatusResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.rekey.getPendingRekeyStatus', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function rekeyGetRevokeWarningRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: rekeyGetRevokeWarningResult) => void} & {param: rekeyGetRevokeWarningRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.rekey.getRevokeWarning', request)
}

export function rekeyGetRevokeWarningRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: rekeyGetRevokeWarningResult) => void} & {param: rekeyGetRevokeWarningRpcParam})): Promise<rekeyGetRevokeWarningResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.rekey.getRevokeWarning', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function rekeyRekeyStatusFinishRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: rekeyRekeyStatusFinishResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.rekey.rekeyStatusFinish', request)
}

export function rekeyRekeyStatusFinishRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: rekeyRekeyStatusFinishResult) => void})): Promise<rekeyRekeyStatusFinishResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.rekey.rekeyStatusFinish', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function rekeyRekeySyncRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: rekeyRekeySyncRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.rekey.rekeySync', request)
}

export function rekeyRekeySyncRpcPromise (request: (requestCommon & requestErrorCallback & {param: rekeyRekeySyncRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.rekey.rekeySync', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function rekeyShowPendingRekeyStatusRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.rekey.showPendingRekeyStatus', request)
}

export function rekeyShowPendingRekeyStatusRpcPromise (request: ?(requestCommon & requestErrorCallback)): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.rekey.showPendingRekeyStatus', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function revokeRevokeDeviceRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: revokeRevokeDeviceRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.revoke.revokeDevice', request)
}

export function revokeRevokeDeviceRpcPromise (request: (requestCommon & requestErrorCallback & {param: revokeRevokeDeviceRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.revoke.revokeDevice', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function revokeRevokeKeyRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: revokeRevokeKeyRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.revoke.revokeKey', request)
}

export function revokeRevokeKeyRpcPromise (request: (requestCommon & requestErrorCallback & {param: revokeRevokeKeyRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.revoke.revokeKey', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function revokeRevokeSigsRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: revokeRevokeSigsRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.revoke.revokeSigs', request)
}

export function revokeRevokeSigsRpcPromise (request: (requestCommon & requestErrorCallback & {param: revokeRevokeSigsRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.revoke.revokeSigs', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function saltpackSaltpackDecryptRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: saltpackSaltpackDecryptResult) => void} & {param: saltpackSaltpackDecryptRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.saltpack.saltpackDecrypt', request)
}

export function saltpackSaltpackDecryptRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: saltpackSaltpackDecryptResult) => void} & {param: saltpackSaltpackDecryptRpcParam})): Promise<saltpackSaltpackDecryptResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.saltpack.saltpackDecrypt', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function saltpackSaltpackEncryptRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: saltpackSaltpackEncryptRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.saltpack.saltpackEncrypt', request)
}

export function saltpackSaltpackEncryptRpcPromise (request: (requestCommon & requestErrorCallback & {param: saltpackSaltpackEncryptRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.saltpack.saltpackEncrypt', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function saltpackSaltpackSignRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: saltpackSaltpackSignRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.saltpack.saltpackSign', request)
}

export function saltpackSaltpackSignRpcPromise (request: (requestCommon & requestErrorCallback & {param: saltpackSaltpackSignRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.saltpack.saltpackSign', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function saltpackSaltpackVerifyRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: saltpackSaltpackVerifyRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.saltpack.saltpackVerify', request)
}

export function saltpackSaltpackVerifyRpcPromise (request: (requestCommon & requestErrorCallback & {param: saltpackSaltpackVerifyRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.saltpack.saltpackVerify', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function sessionCurrentSessionRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: sessionCurrentSessionResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.session.currentSession', request)
}

export function sessionCurrentSessionRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: sessionCurrentSessionResult) => void})): Promise<sessionCurrentSessionResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.session.currentSession', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function sessionSessionPingRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.session.sessionPing', request)
}

export function sessionSessionPingRpcPromise (request: ?(requestCommon & requestErrorCallback)): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.session.sessionPing', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function signupCheckInvitationCodeRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: signupCheckInvitationCodeRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.signup.checkInvitationCode', request)
}

export function signupCheckInvitationCodeRpcPromise (request: (requestCommon & requestErrorCallback & {param: signupCheckInvitationCodeRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.signup.checkInvitationCode', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function signupCheckUsernameAvailableRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: signupCheckUsernameAvailableRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.signup.checkUsernameAvailable', request)
}

export function signupCheckUsernameAvailableRpcPromise (request: (requestCommon & requestErrorCallback & {param: signupCheckUsernameAvailableRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.signup.checkUsernameAvailable', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function signupGetInvitationCodeRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: signupGetInvitationCodeResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.signup.getInvitationCode', request)
}

export function signupGetInvitationCodeRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: signupGetInvitationCodeResult) => void})): Promise<signupGetInvitationCodeResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.signup.getInvitationCode', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function signupInviteRequestRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: signupInviteRequestRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.signup.inviteRequest', request)
}

export function signupInviteRequestRpcPromise (request: (requestCommon & requestErrorCallback & {param: signupInviteRequestRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.signup.inviteRequest', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function signupSignupRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: signupSignupResult) => void} & {param: signupSignupRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.signup.signup', request)
}

export function signupSignupRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: signupSignupResult) => void} & {param: signupSignupRpcParam})): Promise<signupSignupResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.signup.signup', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function sigsSigListJSONRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: sigsSigListJSONResult) => void} & {param: sigsSigListJSONRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.sigs.sigListJSON', request)
}

export function sigsSigListJSONRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: sigsSigListJSONResult) => void} & {param: sigsSigListJSONRpcParam})): Promise<sigsSigListJSONResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.sigs.sigListJSON', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function sigsSigListRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: sigsSigListResult) => void} & {param: sigsSigListRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.sigs.sigList', request)
}

export function sigsSigListRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: sigsSigListResult) => void} & {param: sigsSigListRpcParam})): Promise<sigsSigListResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.sigs.sigList', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function teamsGetTeamRootIDRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: teamsGetTeamRootIDResult) => void} & {param: teamsGetTeamRootIDRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.teams.getTeamRootID', request)
}

export function teamsGetTeamRootIDRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: teamsGetTeamRootIDResult) => void} & {param: teamsGetTeamRootIDRpcParam})): Promise<teamsGetTeamRootIDResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.teams.getTeamRootID', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function teamsLoadTeamPlusApplicationKeysRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: teamsLoadTeamPlusApplicationKeysResult) => void} & {param: teamsLoadTeamPlusApplicationKeysRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.teams.loadTeamPlusApplicationKeys', request)
}

export function teamsLoadTeamPlusApplicationKeysRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: teamsLoadTeamPlusApplicationKeysResult) => void} & {param: teamsLoadTeamPlusApplicationKeysRpcParam})): Promise<teamsLoadTeamPlusApplicationKeysResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.teams.loadTeamPlusApplicationKeys', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function teamsLookupImplicitTeamRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: teamsLookupImplicitTeamResult) => void} & {param: teamsLookupImplicitTeamRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.teams.lookupImplicitTeam', request)
}

export function teamsLookupImplicitTeamRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: teamsLookupImplicitTeamResult) => void} & {param: teamsLookupImplicitTeamRpcParam})): Promise<teamsLookupImplicitTeamResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.teams.lookupImplicitTeam', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function teamsLookupOrCreateImplicitTeamRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: teamsLookupOrCreateImplicitTeamResult) => void} & {param: teamsLookupOrCreateImplicitTeamRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.teams.lookupOrCreateImplicitTeam', request)
}

export function teamsLookupOrCreateImplicitTeamRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: teamsLookupOrCreateImplicitTeamResult) => void} & {param: teamsLookupOrCreateImplicitTeamRpcParam})): Promise<teamsLookupOrCreateImplicitTeamResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.teams.lookupOrCreateImplicitTeam', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function teamsTeamAcceptInviteOrRequestAccessRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: teamsTeamAcceptInviteOrRequestAccessRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.teams.teamAcceptInviteOrRequestAccess', request)
}

export function teamsTeamAcceptInviteOrRequestAccessRpcPromise (request: (requestCommon & requestErrorCallback & {param: teamsTeamAcceptInviteOrRequestAccessRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.teams.teamAcceptInviteOrRequestAccess', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function teamsTeamAcceptInviteRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: teamsTeamAcceptInviteRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.teams.teamAcceptInvite', request)
}

export function teamsTeamAcceptInviteRpcPromise (request: (requestCommon & requestErrorCallback & {param: teamsTeamAcceptInviteRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.teams.teamAcceptInvite', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function teamsTeamAddMemberRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: teamsTeamAddMemberResult) => void} & {param: teamsTeamAddMemberRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.teams.teamAddMember', request)
}

export function teamsTeamAddMemberRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: teamsTeamAddMemberResult) => void} & {param: teamsTeamAddMemberRpcParam})): Promise<teamsTeamAddMemberResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.teams.teamAddMember', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function teamsTeamChangeMembershipRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: teamsTeamChangeMembershipRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.teams.teamChangeMembership', request)
}

export function teamsTeamChangeMembershipRpcPromise (request: (requestCommon & requestErrorCallback & {param: teamsTeamChangeMembershipRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.teams.teamChangeMembership', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function teamsTeamCreateRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: teamsTeamCreateResult) => void} & {param: teamsTeamCreateRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.teams.teamCreate', request)
}

export function teamsTeamCreateRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: teamsTeamCreateResult) => void} & {param: teamsTeamCreateRpcParam})): Promise<teamsTeamCreateResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.teams.teamCreate', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function teamsTeamCreateWithSettingsRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: teamsTeamCreateWithSettingsResult) => void} & {param: teamsTeamCreateWithSettingsRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.teams.teamCreateWithSettings', request)
}

export function teamsTeamCreateWithSettingsRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: teamsTeamCreateWithSettingsResult) => void} & {param: teamsTeamCreateWithSettingsRpcParam})): Promise<teamsTeamCreateWithSettingsResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.teams.teamCreateWithSettings', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function teamsTeamDeleteRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: teamsTeamDeleteRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.teams.teamDelete', request)
}

export function teamsTeamDeleteRpcPromise (request: (requestCommon & requestErrorCallback & {param: teamsTeamDeleteRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.teams.teamDelete', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function teamsTeamEditMemberRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: teamsTeamEditMemberRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.teams.teamEditMember', request)
}

export function teamsTeamEditMemberRpcPromise (request: (requestCommon & requestErrorCallback & {param: teamsTeamEditMemberRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.teams.teamEditMember', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function teamsTeamGetRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: teamsTeamGetResult) => void} & {param: teamsTeamGetRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.teams.teamGet', request)
}

export function teamsTeamGetRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: teamsTeamGetResult) => void} & {param: teamsTeamGetRpcParam})): Promise<teamsTeamGetResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.teams.teamGet', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function teamsTeamIgnoreRequestRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: teamsTeamIgnoreRequestRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.teams.teamIgnoreRequest', request)
}

export function teamsTeamIgnoreRequestRpcPromise (request: (requestCommon & requestErrorCallback & {param: teamsTeamIgnoreRequestRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.teams.teamIgnoreRequest', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function teamsTeamLeaveRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: teamsTeamLeaveRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.teams.teamLeave', request)
}

export function teamsTeamLeaveRpcPromise (request: (requestCommon & requestErrorCallback & {param: teamsTeamLeaveRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.teams.teamLeave', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function teamsTeamListRequestsRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: teamsTeamListRequestsResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.teams.teamListRequests', request)
}

export function teamsTeamListRequestsRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: teamsTeamListRequestsResult) => void})): Promise<teamsTeamListRequestsResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.teams.teamListRequests', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function teamsTeamListRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: teamsTeamListResult) => void} & {param: teamsTeamListRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.teams.teamList', request)
}

export function teamsTeamListRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: teamsTeamListResult) => void} & {param: teamsTeamListRpcParam})): Promise<teamsTeamListResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.teams.teamList', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function teamsTeamListSubteamsRecursiveRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: teamsTeamListSubteamsRecursiveResult) => void} & {param: teamsTeamListSubteamsRecursiveRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.teams.teamListSubteamsRecursive', request)
}

export function teamsTeamListSubteamsRecursiveRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: teamsTeamListSubteamsRecursiveResult) => void} & {param: teamsTeamListSubteamsRecursiveRpcParam})): Promise<teamsTeamListSubteamsRecursiveResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.teams.teamListSubteamsRecursive', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function teamsTeamReAddMemberAfterResetRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: teamsTeamReAddMemberAfterResetRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.teams.teamReAddMemberAfterReset', request)
}

export function teamsTeamReAddMemberAfterResetRpcPromise (request: (requestCommon & requestErrorCallback & {param: teamsTeamReAddMemberAfterResetRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.teams.teamReAddMemberAfterReset', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function teamsTeamRemoveMemberRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: teamsTeamRemoveMemberRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.teams.teamRemoveMember', request)
}

export function teamsTeamRemoveMemberRpcPromise (request: (requestCommon & requestErrorCallback & {param: teamsTeamRemoveMemberRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.teams.teamRemoveMember', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function teamsTeamRenameRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: teamsTeamRenameRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.teams.teamRename', request)
}

export function teamsTeamRenameRpcPromise (request: (requestCommon & requestErrorCallback & {param: teamsTeamRenameRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.teams.teamRename', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function teamsTeamRequestAccessRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: teamsTeamRequestAccessRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.teams.teamRequestAccess', request)
}

export function teamsTeamRequestAccessRpcPromise (request: (requestCommon & requestErrorCallback & {param: teamsTeamRequestAccessRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.teams.teamRequestAccess', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function teamsTeamSetSettingsRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: teamsTeamSetSettingsRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.teams.teamSetSettings', request)
}

export function teamsTeamSetSettingsRpcPromise (request: (requestCommon & requestErrorCallback & {param: teamsTeamSetSettingsRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.teams.teamSetSettings', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function teamsTeamTreeRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: teamsTeamTreeResult) => void} & {param: teamsTeamTreeRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.teams.teamTree', request)
}

export function teamsTeamTreeRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: teamsTeamTreeResult) => void} & {param: teamsTeamTreeRpcParam})): Promise<teamsTeamTreeResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.teams.teamTree', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function testPanicRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: testPanicRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.test.panic', request)
}

export function testPanicRpcPromise (request: (requestCommon & requestErrorCallback & {param: testPanicRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.test.panic', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function testTestCallbackRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: testTestCallbackResult) => void} & {param: testTestCallbackRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.test.testCallback', request)
}

export function testTestCallbackRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: testTestCallbackResult) => void} & {param: testTestCallbackRpcParam})): Promise<testTestCallbackResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.test.testCallback', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function testTestRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: testTestResult) => void} & {param: testTestRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.test.test', request)
}

export function testTestRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: testTestResult) => void} & {param: testTestRpcParam})): Promise<testTestResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.test.test', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function tlfCompleteAndCanonicalizePrivateTlfNameRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: tlfCompleteAndCanonicalizePrivateTlfNameResult) => void} & {param: tlfCompleteAndCanonicalizePrivateTlfNameRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.tlf.completeAndCanonicalizePrivateTlfName', request)
}

export function tlfCompleteAndCanonicalizePrivateTlfNameRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: tlfCompleteAndCanonicalizePrivateTlfNameResult) => void} & {param: tlfCompleteAndCanonicalizePrivateTlfNameRpcParam})): Promise<tlfCompleteAndCanonicalizePrivateTlfNameResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.tlf.completeAndCanonicalizePrivateTlfName', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function tlfCryptKeysRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: tlfCryptKeysResult) => void} & {param: tlfCryptKeysRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.tlf.CryptKeys', request)
}

export function tlfCryptKeysRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: tlfCryptKeysResult) => void} & {param: tlfCryptKeysRpcParam})): Promise<tlfCryptKeysResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.tlf.CryptKeys', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function tlfKeysGetPublicCanonicalTLFNameAndIDRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: tlfKeysGetPublicCanonicalTLFNameAndIDResult) => void} & {param: tlfKeysGetPublicCanonicalTLFNameAndIDRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.tlfKeys.getPublicCanonicalTLFNameAndID', request)
}

export function tlfKeysGetPublicCanonicalTLFNameAndIDRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: tlfKeysGetPublicCanonicalTLFNameAndIDResult) => void} & {param: tlfKeysGetPublicCanonicalTLFNameAndIDRpcParam})): Promise<tlfKeysGetPublicCanonicalTLFNameAndIDResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.tlfKeys.getPublicCanonicalTLFNameAndID', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function tlfKeysGetTLFCryptKeysRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: tlfKeysGetTLFCryptKeysResult) => void} & {param: tlfKeysGetTLFCryptKeysRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.tlfKeys.getTLFCryptKeys', request)
}

export function tlfKeysGetTLFCryptKeysRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: tlfKeysGetTLFCryptKeysResult) => void} & {param: tlfKeysGetTLFCryptKeysRpcParam})): Promise<tlfKeysGetTLFCryptKeysResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.tlfKeys.getTLFCryptKeys', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function tlfPublicCanonicalTLFNameAndIDRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: tlfPublicCanonicalTLFNameAndIDResult) => void} & {param: tlfPublicCanonicalTLFNameAndIDRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.tlf.publicCanonicalTLFNameAndID', request)
}

export function tlfPublicCanonicalTLFNameAndIDRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: tlfPublicCanonicalTLFNameAndIDResult) => void} & {param: tlfPublicCanonicalTLFNameAndIDRpcParam})): Promise<tlfPublicCanonicalTLFNameAndIDResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.tlf.publicCanonicalTLFNameAndID', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function trackCheckTrackingRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.track.checkTracking', request)
}

export function trackCheckTrackingRpcPromise (request: ?(requestCommon & requestErrorCallback)): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.track.checkTracking', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function trackDismissWithTokenRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: trackDismissWithTokenRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.track.dismissWithToken', request)
}

export function trackDismissWithTokenRpcPromise (request: (requestCommon & requestErrorCallback & {param: trackDismissWithTokenRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.track.dismissWithToken', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function trackFakeTrackingChangedRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: trackFakeTrackingChangedRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.track.fakeTrackingChanged', request)
}

export function trackFakeTrackingChangedRpcPromise (request: (requestCommon & requestErrorCallback & {param: trackFakeTrackingChangedRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.track.fakeTrackingChanged', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function trackTrackRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: trackTrackResult) => void} & {param: trackTrackRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.track.track', request)
}

export function trackTrackRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: trackTrackResult) => void} & {param: trackTrackRpcParam})): Promise<trackTrackResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.track.track', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function trackTrackWithTokenRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: trackTrackWithTokenRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.track.trackWithToken', request)
}

export function trackTrackWithTokenRpcPromise (request: (requestCommon & requestErrorCallback & {param: trackTrackWithTokenRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.track.trackWithToken', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function trackUntrackRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: trackUntrackRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.track.untrack', request)
}

export function trackUntrackRpcPromise (request: (requestCommon & requestErrorCallback & {param: trackUntrackRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.track.untrack', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function userDeleteUserRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.user.deleteUser', request)
}

export function userDeleteUserRpcPromise (request: ?(requestCommon & requestErrorCallback)): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.user.deleteUser', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function userInterestingPeopleRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: userInterestingPeopleResult) => void} & {param: userInterestingPeopleRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.user.interestingPeople', request)
}

export function userInterestingPeopleRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: userInterestingPeopleResult) => void} & {param: userInterestingPeopleRpcParam})): Promise<userInterestingPeopleResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.user.interestingPeople', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function userListTrackers2RpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: userListTrackers2Result) => void} & {param: userListTrackers2RpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.user.listTrackers2', request)
}

export function userListTrackers2RpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: userListTrackers2Result) => void} & {param: userListTrackers2RpcParam})): Promise<userListTrackers2Result> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.user.listTrackers2', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function userListTrackersByNameRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: userListTrackersByNameResult) => void} & {param: userListTrackersByNameRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.user.listTrackersByName', request)
}

export function userListTrackersByNameRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: userListTrackersByNameResult) => void} & {param: userListTrackersByNameRpcParam})): Promise<userListTrackersByNameResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.user.listTrackersByName', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function userListTrackersRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: userListTrackersResult) => void} & {param: userListTrackersRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.user.listTrackers', request)
}

export function userListTrackersRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: userListTrackersResult) => void} & {param: userListTrackersRpcParam})): Promise<userListTrackersResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.user.listTrackers', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function userListTrackersSelfRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: userListTrackersSelfResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.user.listTrackersSelf', request)
}

export function userListTrackersSelfRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: userListTrackersSelfResult) => void})): Promise<userListTrackersSelfResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.user.listTrackersSelf', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function userListTrackingJSONRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: userListTrackingJSONResult) => void} & {param: userListTrackingJSONRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.user.listTrackingJSON', request)
}

export function userListTrackingJSONRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: userListTrackingJSONResult) => void} & {param: userListTrackingJSONRpcParam})): Promise<userListTrackingJSONResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.user.listTrackingJSON', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function userListTrackingRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: userListTrackingResult) => void} & {param: userListTrackingRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.user.listTracking', request)
}

export function userListTrackingRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: userListTrackingResult) => void} & {param: userListTrackingRpcParam})): Promise<userListTrackingResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.user.listTracking', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function userLoadAllPublicKeysUnverifiedRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: userLoadAllPublicKeysUnverifiedResult) => void} & {param: userLoadAllPublicKeysUnverifiedRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.user.loadAllPublicKeysUnverified', request)
}

export function userLoadAllPublicKeysUnverifiedRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: userLoadAllPublicKeysUnverifiedResult) => void} & {param: userLoadAllPublicKeysUnverifiedRpcParam})): Promise<userLoadAllPublicKeysUnverifiedResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.user.loadAllPublicKeysUnverified', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function userLoadMyPublicKeysRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: userLoadMyPublicKeysResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.user.loadMyPublicKeys', request)
}

export function userLoadMyPublicKeysRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: userLoadMyPublicKeysResult) => void})): Promise<userLoadMyPublicKeysResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.user.loadMyPublicKeys', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function userLoadMySettingsRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: userLoadMySettingsResult) => void}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.user.loadMySettings', request)
}

export function userLoadMySettingsRpcPromise (request: ?(requestCommon & {callback?: ?(err: ?any, response: userLoadMySettingsResult) => void})): Promise<userLoadMySettingsResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.user.loadMySettings', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function userLoadPublicKeysRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: userLoadPublicKeysResult) => void} & {param: userLoadPublicKeysRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.user.loadPublicKeys', request)
}

export function userLoadPublicKeysRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: userLoadPublicKeysResult) => void} & {param: userLoadPublicKeysRpcParam})): Promise<userLoadPublicKeysResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.user.loadPublicKeys', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function userLoadUncheckedUserSummariesRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: userLoadUncheckedUserSummariesResult) => void} & {param: userLoadUncheckedUserSummariesRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.user.loadUncheckedUserSummaries', request)
}

export function userLoadUncheckedUserSummariesRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: userLoadUncheckedUserSummariesResult) => void} & {param: userLoadUncheckedUserSummariesRpcParam})): Promise<userLoadUncheckedUserSummariesResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.user.loadUncheckedUserSummaries', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function userLoadUserByNameRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: userLoadUserByNameResult) => void} & {param: userLoadUserByNameRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.user.loadUserByName', request)
}

export function userLoadUserByNameRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: userLoadUserByNameResult) => void} & {param: userLoadUserByNameRpcParam})): Promise<userLoadUserByNameResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.user.loadUserByName', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function userLoadUserPlusKeysRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: userLoadUserPlusKeysResult) => void} & {param: userLoadUserPlusKeysRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.user.loadUserPlusKeys', request)
}

export function userLoadUserPlusKeysRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: userLoadUserPlusKeysResult) => void} & {param: userLoadUserPlusKeysRpcParam})): Promise<userLoadUserPlusKeysResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.user.loadUserPlusKeys', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function userLoadUserRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: userLoadUserResult) => void} & {param: userLoadUserRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.user.loadUser', request)
}

export function userLoadUserRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: userLoadUserResult) => void} & {param: userLoadUserRpcParam})): Promise<userLoadUserResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.user.loadUser', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function userProfileEditRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback & {param: userProfileEditRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.user.profileEdit', request)
}

export function userProfileEditRpcPromise (request: (requestCommon & requestErrorCallback & {param: userProfileEditRpcParam})): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.user.profileEdit', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function userResetUserRpcChannelMap (configKeys: Array<string>, request: requestCommon & requestErrorCallback): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.user.resetUser', request)
}

export function userResetUserRpcPromise (request: ?(requestCommon & requestErrorCallback)): Promise<void> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.user.resetUser', request, (error, result) => error ? reject(error) : resolve(result)))
}

export function userSearchRpcChannelMap (configKeys: Array<string>, request: requestCommon & {callback?: ?(err: ?any, response: userSearchResult) => void} & {param: userSearchRpcParam}): EngineChannel {
  return engine()._channelMapRpcHelper(configKeys, 'keybase.1.user.search', request)
}

export function userSearchRpcPromise (request: (requestCommon & {callback?: ?(err: ?any, response: userSearchResult) => void} & {param: userSearchRpcParam})): Promise<userSearchResult> {
  return new Promise((resolve, reject) => engineRpcOutgoing('keybase.1.user.search', request, (error, result) => error ? reject(error) : resolve(result)))
}

export type APIRes = {
  status: string,
  body: string,
  httpStatus: int,
  appStatus: string,
}

export type AnnotatedMemberInfo = {
  userID: UID,
  teamID: TeamID,
  username: string,
  fullName: string,
  fqName: string,
  isImplicitTeam: boolean,
  role: TeamRole,
  implicit?: ?ImplicitRole,
}

export type AnnotatedTeamInvite = {
  role: TeamRole,
  id: TeamInviteID,
  type: TeamInviteType,
  name: TeamInviteName,
  inviter: UserVersion,
  inviterUsername: string,
  teamName: string,
}

export type AnnotatedTeamList = {
  teams?: ?Array<AnnotatedMemberInfo>,
  annotatedActiveInvites: {[key: string]: AnnotatedTeamInvite},
}

export type AppState =
    0 // FOREGROUND_0
  | 1 // BACKGROUND_1
  | 2 // INACTIVE_2
  | 3 // BACKGROUNDACTIVE_3

export type AsyncOps =
    0 // LIST_0
  | 1 // LIST_RECURSIVE_1
  | 2 // READ_2
  | 3 // WRITE_3
  | 4 // COPY_4
  | 5 // MOVE_5
  | 6 // REMOVE_6

export type BTCRegisterBTCRpcParam = Exact<{
  address: string,
  force: boolean
}>

export type BadgeConversationInfo = {
  convID: ChatConversationID,
  badgeCounts: {[key: string]: int},
  unreadMessages: int,
}

export type BadgeState = {
  newTlfs: int,
  rekeysNeeded: int,
  newFollowers: int,
  inboxVers: int,
  conversations?: ?Array<BadgeConversationInfo>,
  newGitRepoGlobalUniqueIDs?: ?Array<string>,
}

export type BinaryKID = bytes

export type BlockIdCombo = {
  blockHash: string,
  chargedTo: UserOrTeamID,
  blockType: BlockType,
}

export type BlockPingResponse = {}

export type BlockRefNonce = any

export type BlockReference = {
  bid: BlockIdCombo,
  nonce: BlockRefNonce,
  chargedTo: UserOrTeamID,
}

export type BlockReferenceCount = {
  ref: BlockReference,
  liveCount: int,
}

export type BlockType =
    0 // DATA_0
  | 1 // MD_1
  | 2 // GIT_2

export type BootstrapStatus = {
  registered: boolean,
  loggedIn: boolean,
  uid: UID,
  username: string,
  deviceID: DeviceID,
  deviceName: string,
  following?: ?Array<string>,
  followers?: ?Array<string>,
}

export type BoxNonce = any

export type BoxPublicKey = any

export type Bytes32 = any

export type CanonicalTLFNameAndIDWithBreaks = {
  tlfID: TLFID,
  CanonicalName: CanonicalTlfName,
  breaks: TLFBreak,
}

export type CanonicalTlfName = string

export type ChallengeInfo = {
  now: long,
  challenge: string,
}

export type ChatConversationID = bytes

export type CheckProofStatus = {
  found: boolean,
  status: ProofStatus,
  proofText: string,
  state: ProofState,
}

export type CheckResult = {
  proofResult: ProofResult,
  time: Time,
  freshness: CheckResultFreshness,
}

export type CheckResultFreshness =
    0 // FRESH_0
  | 1 // AGED_1
  | 2 // RANCID_2

export type ChooseType =
    0 // EXISTING_DEVICE_0
  | 1 // NEW_DEVICE_1

export type CiphertextBundle = {
  kid: KID,
  ciphertext: EncryptedBytes32,
  nonce: BoxNonce,
  publicKey: BoxPublicKey,
}

export type ClientDetails = {
  pid: int,
  clientType: ClientType,
  argv?: ?Array<string>,
  desc: string,
  version: string,
}

export type ClientType =
    0 // NONE_0
  | 1 // CLI_1
  | 2 // GUI_MAIN_2
  | 3 // KBFS_3
  | 4 // GUI_HELPER_4

export type CompatibilityTeamID =
    { typ: 1, legacy: ?TLFID }
  | { typ: 2, modern: ?TeamID }

export type ComponentResult = {
  name: string,
  status: Status,
  exitCode: int,
}

export type Config = {
  serverURI: string,
  socketFile: string,
  label: string,
  runMode: string,
  gpgExists: boolean,
  gpgPath: string,
  version: string,
  path: string,
  configPath: string,
  versionShort: string,
  versionFull: string,
  isAutoForked: boolean,
  forkType: ForkType,
}

export type ConfigValue = {
  isNull: boolean,
  b?: ?boolean,
  i?: ?int,
  s?: ?string,
  o?: ?string,
}

export type ConfiguredAccount = {
  username: string,
  hasStoredSecret: boolean,
}

export type ConfirmResult = {
  identityConfirmed: boolean,
  remoteConfirmed: boolean,
  expiringLocal: boolean,
  autoConfirmed: boolean,
}

export type CopyArgs = {
  opID: OpID,
  src: Path,
  dest: Path,
}

export type CryptKey = {
  KeyGeneration: int,
  Key: Bytes32,
}

export type Cryptocurrency = {
  rowId: int,
  pkhash: bytes,
  address: string,
  sigID: SigID,
  type: string,
  family: string,
}

export type CsrfToken = string

export type DbKey = {
  dbType: DbType,
  objType: int,
  key: string,
}

export type DbType =
    0 // MAIN_0
  | 1 // CHAT_1

export type DbValue = bytes

export type Device = {
  type: string,
  name: string,
  deviceID: DeviceID,
  cTime: Time,
  mTime: Time,
  lastUsedTime: Time,
  encryptKey: KID,
  verifyKey: KID,
  status: int,
}

export type DeviceDetail = {
  device: Device,
  eldest: boolean,
  provisioner?: ?Device,
  provisionedAt?: ?Time,
  revokedAt?: ?Time,
  revokedBy: KID,
  revokedByDevice?: ?Device,
  currentDevice: boolean,
}

export type DeviceID = string

export type DeviceType =
    0 // DESKTOP_0
  | 1 // MOBILE_1

export type Dirent = {
  time: Time,
  size: int,
  name: string,
  direntType: DirentType,
}

export type DirentType =
    0 // FILE_0
  | 1 // DIR_1
  | 2 // SYM_2
  | 3 // EXEC_3

export type DismissReason = {
  type: DismissReasonType,
  reason: string,
  resource: string,
}

export type DismissReasonType =
    0 // NONE_0
  | 1 // HANDLED_ELSEWHERE_1

export type DowngradeReferenceRes = {
  completed?: ?Array<BlockReferenceCount>,
  failed: BlockReference,
}

export type DurationSec = double

export type ED25519PublicKey = any

export type ED25519Signature = any

export type ED25519SignatureInfo = {
  sig: ED25519Signature,
  publicKey: ED25519PublicKey,
}

export type Email = {
  email: string,
  isVerified: boolean,
}

export type EncryptedBytes32 = any

export type EncryptedGitMetadata = {
  v: int,
  e: bytes,
  n: BoxNonce,
  gen: PerTeamKeyGeneration,
}

export type ErrorNum = int

export type ExitCode =
    0 // OK_0
  | 2 // NOTOK_2
  | 4 // RESTART_4

export type ExtendedStatus = {
  standalone: boolean,
  passphraseStreamCached: boolean,
  tsecCached: boolean,
  deviceSigKeyCached: boolean,
  deviceEncKeyCached: boolean,
  paperSigKeyCached: boolean,
  paperEncKeyCached: boolean,
  storedSecret: boolean,
  secretPromptSkip: boolean,
  device?: ?Device,
  deviceErr?: ?LoadDeviceErr,
  logDir: string,
  session?: ?SessionStatus,
  defaultUsername: string,
  provisionedUsernames?: ?Array<string>,
  Clients?: ?Array<ClientDetails>,
  platformInfo: PlatformInfo,
  defaultDeviceID: DeviceID,
}

export type FSEditListRequest = {
  folder: Folder,
  requestID: int,
}

export type FSErrorType =
    0 // ACCESS_DENIED_0
  | 1 // USER_NOT_FOUND_1
  | 2 // REVOKED_DATA_DETECTED_2
  | 3 // NOT_LOGGED_IN_3
  | 4 // TIMEOUT_4
  | 5 // REKEY_NEEDED_5
  | 6 // BAD_FOLDER_6
  | 7 // NOT_IMPLEMENTED_7
  | 8 // OLD_VERSION_8
  | 9 // OVER_QUOTA_9
  | 10 // NO_SIG_CHAIN_10
  | 11 // TOO_MANY_FOLDERS_11
  | 12 // EXDEV_NOT_SUPPORTED_12
  | 13 // DISK_LIMIT_REACHED_13
  | 14 // DISK_CACHE_ERROR_LOG_SEND_14

export type FSNotification = {
  filename: string,
  status: string,
  statusCode: FSStatusCode,
  notificationType: FSNotificationType,
  errorType: FSErrorType,
  params: {[key: string]: string},
  writerUid: UID,
  localTime: Time,
  folderType: FolderType,
}

export type FSNotificationType =
    0 // ENCRYPTING_0
  | 1 // DECRYPTING_1
  | 2 // SIGNING_2
  | 3 // VERIFYING_3
  | 4 // REKEYING_4
  | 5 // CONNECTION_5
  | 6 // MD_READ_SUCCESS_6
  | 7 // FILE_CREATED_7
  | 8 // FILE_MODIFIED_8
  | 9 // FILE_DELETED_9
  | 10 // FILE_RENAMED_10
  | 11 // INITIALIZED_11

export type FSPathSyncStatus = {
  folderType: FolderType,
  path: string,
  syncingBytes: int64,
  syncingOps: int64,
  syncedBytes: int64,
}

export type FSStatusCode =
    0 // START_0
  | 1 // FINISH_1
  | 2 // ERROR_2

export type FSSyncStatus = {
  totalSyncingBytes: int64,
  totalSyncingOps: int64,
  pathStatuses?: ?Array<FSPathSyncStatus>,
}

export type FSSyncStatusRequest = {
  requestID: int,
}

export type FavoritesResult = {
  favoriteFolders?: ?Array<Folder>,
  ignoredFolders?: ?Array<Folder>,
  newFolders?: ?Array<Folder>,
}

export type Feature = {
  allow: boolean,
  defaultValue: boolean,
  readonly: boolean,
  label: string,
}

export type File = {
  path: string,
}

export type FileContent = {
  data: bytes,
  progress: Progress,
}

export type FileDescriptor = {
  name: string,
  type: FileType,
}

export type FileType =
    0 // UNKNOWN_0
  | 1 // DIRECTORY_1
  | 2 // FILE_2

export type FirstStepResult = {
  valPlusTwo: int,
}

export type Folder = {
  name: string,
  private: boolean,
  notificationsOn: boolean,
  created: boolean,
  folderType: FolderType,
}

export type FolderType =
    0 // UNKNOWN_0
  | 1 // PRIVATE_1
  | 2 // PUBLIC_2
  | 3 // TEAM_3

export type ForkType =
    0 // NONE_0
  | 1 // AUTO_1
  | 2 // WATCHDOG_2
  | 3 // LAUNCHD_3

export type FullName = string

export type FullNamePackage = {
  version: FullNamePackageVersion,
  fullName: FullName,
  cachedAt: Time,
}

export type FullNamePackageVersion =
    0 // V0_0

export type FuseMountInfo = {
  path: string,
  fstype: string,
  output: string,
}

export type FuseStatus = {
  version: string,
  bundleVersion: string,
  kextID: string,
  path: string,
  kextStarted: boolean,
  installStatus: InstallStatus,
  installAction: InstallAction,
  mountInfos?: ?Array<FuseMountInfo>,
  status: Status,
}

export type GPGKey = {
  algorithm: string,
  keyID: string,
  creation: string,
  expiration: string,
  identities?: ?Array<PGPIdentity>,
}

export type GPGMethod =
    0 // GPG_NONE_0
  | 1 // GPG_IMPORT_1
  | 2 // GPG_SIGN_2

export type GUIEntryArg = {
  windowTitle: string,
  prompt: string,
  username: string,
  submitLabel: string,
  cancelLabel: string,
  retryLabel: string,
  type: PassphraseType,
  features: GUIEntryFeatures,
}

export type GUIEntryFeatures = {
  showTyping: Feature,
}

export type GetBlockRes = {
  blockKey: string,
  buf: bytes,
}

export type GetCurrentStatusRes = {
  configured: boolean,
  registered: boolean,
  loggedIn: boolean,
  sessionIsValid: boolean,
  user?: ?User,
}

export type GetPassphraseRes = {
  passphrase: string,
  storeSecret: boolean,
}

export type GetTLFCryptKeysRes = {
  nameIDBreaks: CanonicalTLFNameAndIDWithBreaks,
  CryptKeys?: ?Array<CryptKey>,
}

export type GitLocalMetadata = {
  repoName: GitRepoName,
}

export type GitLocalMetadataV1 = {
  repoName: GitRepoName,
}

export type GitLocalMetadataVersion =
    1 // V1_1

export type GitLocalMetadataVersioned =
    { version: 1, v1: ?GitLocalMetadataV1 }

export type GitRepoName = string

export type GitRepoResult = {
  folder: Folder,
  repoID: RepoID,
  localMetadata: GitLocalMetadata,
  serverMetadata: GitServerMetadata,
  repoUrl: string,
  globalUniqueID: string,
  canDelete: boolean,
}

export type GitServerMetadata = {
  ctime: Time,
  mtime: Time,
  lastModifyingUsername: string,
  lastModifyingDeviceID: DeviceID,
  lastModifyingDeviceName: string,
}

export type HasServerKeysRes = {
  hasServerKeys: boolean,
}

export type HashMeta = bytes

export type Hello2Res = {
  encryptionKey: KID,
  sigPayload: HelloRes,
}

export type HelloRes = string

export type Identify2Res = {
  upk: UserPlusKeys,
  identifiedAt: Time,
  trackBreaks?: ?IdentifyTrackBreaks,
}

export type IdentifyKey = {
  pgpFingerprint: bytes,
  KID: KID,
  trackDiff?: ?TrackDiff,
  breaksTracking: boolean,
}

export type IdentifyLiteRes = {
  ul: UserOrTeamLite,
  trackBreaks?: ?IdentifyTrackBreaks,
}

export type IdentifyOutcome = {
  username: string,
  status?: ?Status,
  warnings?: ?Array<string>,
  trackUsed?: ?TrackSummary,
  trackStatus: TrackStatus,
  numTrackFailures: int,
  numTrackChanges: int,
  numProofFailures: int,
  numRevoked: int,
  numProofSuccesses: int,
  revoked?: ?Array<TrackDiff>,
  trackOptions: TrackOptions,
  forPGPPull: boolean,
  reason: IdentifyReason,
}

export type IdentifyProofBreak = {
  remoteProof: RemoteProof,
  lcr: LinkCheckResult,
}

export type IdentifyReason = {
  type: IdentifyReasonType,
  reason: string,
  resource: string,
}

export type IdentifyReasonType =
    0 // NONE_0
  | 1 // ID_1
  | 2 // TRACK_2
  | 3 // ENCRYPT_3
  | 4 // DECRYPT_4
  | 5 // VERIFY_5
  | 6 // RESOURCE_6
  | 7 // BACKGROUND_7

export type IdentifyRow = {
  rowId: int,
  proof: RemoteProof,
  trackDiff?: ?TrackDiff,
}

export type IdentifyTrackBreaks = {
  keys?: ?Array<IdentifyKey>,
  proofs?: ?Array<IdentifyProofBreak>,
}

export type Identity = {
  status?: ?Status,
  whenLastTracked: Time,
  proofs?: ?Array<IdentifyRow>,
  cryptocurrency?: ?Array<Cryptocurrency>,
  revoked?: ?Array<TrackDiff>,
  revokedDetails?: ?Array<RevokedProof>,
  breaksTracking: boolean,
}

export type ImplicitRole = {
  role: TeamRole,
  ancestor: TeamID,
}

export type ImplicitTeamConflictInfo = {
  generation: int,
  time: Time,
}

export type ImplicitTeamDisplayName = {
  isPublic: boolean,
  writers: ImplicitTeamUserSet,
  readers: ImplicitTeamUserSet,
  conflictInfo?: ?ImplicitTeamConflictInfo,
}

export type ImplicitTeamUserSet = {
  keybaseUsers?: ?Array<string>,
  unresolvedUsers?: ?Array<SocialAssertion>,
}

export type InstallAction =
    0 // UNKNOWN_0
  | 1 // NONE_1
  | 2 // UPGRADE_2
  | 3 // REINSTALL_3
  | 4 // INSTALL_4

export type InstallResult = {
  componentResults?: ?Array<ComponentResult>,
  status: Status,
  fatal: boolean,
}

export type InstallStatus =
    0 // UNKNOWN_0
  | 1 // ERROR_1
  | 2 // NOT_INSTALLED_2
  | 4 // INSTALLED_4

export type InterestingPerson = {
  uid: UID,
  username: string,
}

export type KBFSGitCreateRepoRpcParam = Exact<{
  folder: Folder,
  name: GitRepoName
}>

export type KBFSGitDeleteRepoRpcParam = Exact<{
  folder: Folder,
  name: GitRepoName
}>

export type KID = string

export type Kex2Provisionee2DidCounterSign2RpcParam = Exact<{
  sig: bytes,
  ppsEncrypted: string,
  pukBox?: ?PerUserKeyBox
}>

export type Kex2Provisionee2Hello2RpcParam = Exact<{
  uid: UID,
  token: SessionToken,
  csrf: CsrfToken,
  sigBody: string
}>

export type Kex2ProvisioneeDidCounterSignRpcParam = Exact<{
  sig: bytes
}>

export type Kex2ProvisioneeHelloRpcParam = Exact<{
  uid: UID,
  token: SessionToken,
  csrf: CsrfToken,
  pps: PassphraseStream,
  sigBody: string
}>

export type KeyBundle = {
  version: int,
  bundle: bytes,
}

export type KeyBundleResponse = {
  WriterBundle: KeyBundle,
  ReaderBundle: KeyBundle,
}

export type KeyHalf = {
  user: UID,
  deviceKID: KID,
  key: bytes,
}

export type KeyInfo = {
  fingerprint: string,
  key: string,
  desc: string,
}

export type KeyType =
    0 // NONE_0
  | 1 // NACL_1
  | 2 // PGP_2

export type KeybaseTime = {
  unix: Time,
  chain: Seqno,
}

export type LeaseID = string

export type LinkCheckResult = {
  proofId: int,
  proofResult: ProofResult,
  snoozedResult: ProofResult,
  torWarning: boolean,
  tmpTrackExpireTime: Time,
  cached?: ?CheckResult,
  diff?: ?TrackDiff,
  remoteDiff?: ?TrackDiff,
  hint?: ?SigHint,
  breaksTracking: boolean,
}

export type LinkID = string

export type ListArgs = {
  opID: OpID,
  path: Path,
}

export type ListResult = {
  files?: ?Array<File>,
}

export type LoadDeviceErr = {
  where: string,
  desc: string,
}

export type LoadTeamArg = {
  ID: TeamID,
  name: string,
  needAdmin: boolean,
  refreshers: TeamRefreshers,
  forceFullReload: boolean,
  forceRepoll: boolean,
  staleOK: boolean,
}

export type LockContext = {
  requireLockID: LockID,
  releaseAfterSuccess: boolean,
}

export type LockID = long

export type LogLevel =
    0 // NONE_0
  | 1 // DEBUG_1
  | 2 // INFO_2
  | 3 // NOTICE_3
  | 4 // WARN_4
  | 5 // ERROR_5
  | 6 // CRITICAL_6
  | 7 // FATAL_7

export type MDBlock = {
  version: int,
  timestamp: Time,
  block: bytes,
}

export type MDPriority = int

export type MaskB64 = bytes

export type MemberInfo = {
  userID: UID,
  teamID: TeamID,
  fqName: string,
  isImplicitTeam: boolean,
  role: TeamRole,
  implicit?: ?ImplicitRole,
}

export type MerkleRoot = {
  version: int,
  root: bytes,
}

export type MerkleRootAndTime = {
  root: MerkleRootV2,
  updateTime: Time,
  fetchTime: Time,
}

export type MerkleRootV2 = {
  seqno: Seqno,
  hashMeta: HashMeta,
}

export type MerkleTreeID =
    0 // MASTER_0
  | 1 // KBFS_PUBLIC_1
  | 2 // KBFS_PRIVATE_2
  | 3 // KBFS_PRIVATETEAM_3

export type MerkleTreeLocation = {
  leaf: UserOrTeamID,
  loc: SigChainLocation,
}

export type MetadataResponse = {
  folderID: string,
  mdBlocks?: ?Array<MDBlock>,
}

export type MoveArgs = {
  opID: OpID,
  src: Path,
  dest: Path,
}

export type NaclDHKeyPrivate = any

export type NaclDHKeyPublic = any

export type NaclSigningKeyPrivate = any

export type NaclSigningKeyPublic = any

export type NotificationChannels = {
  session: boolean,
  users: boolean,
  kbfs: boolean,
  tracking: boolean,
  favorites: boolean,
  paperkeys: boolean,
  keyfamily: boolean,
  service: boolean,
  app: boolean,
  chat: boolean,
  pgp: boolean,
  kbfsrequest: boolean,
  badges: boolean,
  reachability: boolean,
  team: boolean,
}

export type NotifyBadgesBadgeStateRpcParam = Exact<{
  badgeState: BadgeState
}>

export type NotifyFSFSActivityRpcParam = Exact<{
  notification: FSNotification
}>

export type NotifyFSFSEditListResponseRpcParam = Exact<{
  edits?: ?Array<FSNotification>,
  requestID: int
}>

export type NotifyFSFSSyncActivityRpcParam = Exact<{
  status: FSPathSyncStatus
}>

export type NotifyFSFSSyncStatusResponseRpcParam = Exact<{
  status: FSSyncStatus,
  requestID: int
}>

export type NotifyFSRequestFSEditListRequestRpcParam = Exact<{
  req: FSEditListRequest
}>

export type NotifyFSRequestFSSyncStatusRequestRpcParam = Exact<{
  req: FSSyncStatusRequest
}>

export type NotifyFavoritesFavoritesChangedRpcParam = Exact<{
  uid: UID
}>

export type NotifyKeyfamilyKeyfamilyChangedRpcParam = Exact<{
  uid: UID
}>

export type NotifyPaperKeyPaperKeyCachedRpcParam = Exact<{
  uid: UID,
  encKID: KID,
  sigKID: KID
}>

export type NotifySessionClientOutOfDateRpcParam = Exact<{
  upgradeTo: string,
  upgradeURI: string,
  upgradeMsg: string
}>

export type NotifySessionLoggedInRpcParam = Exact<{
  username: string
}>

export type NotifyTeamTeamChangedRpcParam = Exact<{
  teamID: TeamID,
  teamName: string,
  latestSeqno: Seqno,
  changes: TeamChangeSet
}>

export type NotifyTeamTeamDeletedRpcParam = Exact<{
  teamID: TeamID
}>

export type NotifyTrackingTrackingChangedRpcParam = Exact<{
  uid: UID,
  username: string,
  isTracking: boolean
}>

export type NotifyUsersUserChangedRpcParam = Exact<{
  uid: UID
}>

export type OpDescription =
    { asyncOp: 0, list: ?ListArgs }
  | { asyncOp: 1, listRecursive: ?ListArgs }
  | { asyncOp: 2, read: ?ReadArgs }
  | { asyncOp: 3, write: ?WriteArgs }
  | { asyncOp: 4, copy: ?CopyArgs }
  | { asyncOp: 5, move: ?MoveArgs }
  | { asyncOp: 6, remove: ?RemoveArgs }

export type OpID = any

export type OpenFlags =
    0 // READ_0
  | 1 // REPLACE_1
  | 2 // EXISTING_2
  | 4 // WRITE_4
  | 8 // APPEND_8
  | 16 // DIRECTORY_16

export type OutOfDateInfo = {
  upgradeTo: string,
  upgradeURI: string,
  customMessage: string,
  criticalClockSkew: long,
}

export type Outcome =
    0 // NONE_0
  | 1 // FIXED_1
  | 2 // IGNORED_2

export type PGPCreateUids = {
  useDefault: boolean,
  ids?: ?Array<PGPIdentity>,
}

export type PGPDecryptOptions = {
  assertSigned: boolean,
  signedBy: string,
}

export type PGPEncryptOptions = {
  recipients?: ?Array<string>,
  noSign: boolean,
  noSelf: boolean,
  binaryOut: boolean,
  keyQuery: string,
}

export type PGPFingerprint = any

export type PGPIdentity = {
  username: string,
  comment: string,
  email: string,
}

export type PGPPurgeRes = {
  filenames?: ?Array<string>,
}

export type PGPQuery = {
  secret: boolean,
  query: string,
  exactMatch: boolean,
}

export type PGPSigVerification = {
  isSigned: boolean,
  verified: boolean,
  signer: User,
  signKey: PublicKey,
}

export type PGPSignOptions = {
  keyQuery: string,
  mode: SignMode,
  binaryIn: boolean,
  binaryOut: boolean,
}

export type PGPVerifyOptions = {
  signedBy: string,
  signature: bytes,
}

export type PassphraseStream = {
  passphraseStream: bytes,
  generation: int,
}

export type PassphraseType =
    0 // NONE_0
  | 1 // PAPER_KEY_1
  | 2 // PASS_PHRASE_2
  | 3 // VERIFY_PASS_PHRASE_3

export type Path =
    { PathType: 0, local: ?string }
  | { PathType: 1, kbfs: ?string }

export type PathType =
    0 // LOCAL_0
  | 1 // KBFS_1

export type PerTeamKey = {
  gen: PerTeamKeyGeneration,
  seqno: Seqno,
  sigKID: KID,
  encKID: KID,
}

export type PerTeamKeyGeneration = int

export type PerTeamKeySeed = any

export type PerTeamKeySeedItem = {
  seed: PerTeamKeySeed,
  generation: PerTeamKeyGeneration,
  seqno: Seqno,
}

export type PerUserKey = {
  gen: int,
  seqno: Seqno,
  sigKID: KID,
  encKID: KID,
  signedByKID: KID,
}

export type PerUserKeyBox = {
  generation: PerUserKeyGeneration,
  box: string,
  receiverKID: KID,
}

export type PerUserKeyGeneration = int

export type PingResponse = {
  timestamp: Time,
}

export type PlatformInfo = {
  os: string,
  osVersion: string,
  arch: string,
  goVersion: string,
}

export type ProblemSet = {
  user: User,
  kid: KID,
  tlfs?: ?Array<ProblemTLF>,
}

export type ProblemSetDevices = {
  problemSet: ProblemSet,
  devices?: ?Array<Device>,
}

export type ProblemTLF = {
  tlf: TLF,
  score: int,
  solution_kids?: ?Array<KID>,
}

export type Process = {
  pid: string,
  command: string,
  fileDescriptors?: ?Array<FileDescriptor>,
}

export type Progress = int

export type PromptDefault =
    0 // NONE_0
  | 1 // YES_1
  | 2 // NO_2

export type PromptOverwriteType =
    0 // SOCIAL_0
  | 1 // SITE_1

export type ProofResult = {
  state: ProofState,
  status: ProofStatus,
  desc: string,
}

export type ProofState =
    0 // NONE_0
  | 1 // OK_1
  | 2 // TEMP_FAILURE_2
  | 3 // PERM_FAILURE_3
  | 4 // LOOKING_4
  | 5 // SUPERSEDED_5
  | 6 // POSTED_6
  | 7 // REVOKED_7
  | 8 // DELETED_8
  | 9 // UNKNOWN_TYPE_9
  | 10 // SIG_HINT_MISSING_10
  | 11 // UNCHECKED_11

export type ProofStatus =
    0 // NONE_0
  | 1 // OK_1
  | 2 // LOCAL_2
  | 3 // FOUND_3
  | 100 // BASE_ERROR_100
  | 101 // HOST_UNREACHABLE_101
  | 103 // PERMISSION_DENIED_103
  | 106 // FAILED_PARSE_106
  | 107 // DNS_ERROR_107
  | 108 // AUTH_FAILED_108
  | 129 // HTTP_429_129
  | 150 // HTTP_500_150
  | 160 // TIMEOUT_160
  | 170 // INTERNAL_ERROR_170
  | 171 // UNCHECKED_171
  | 172 // MISSING_PVL_172
  | 200 // BASE_HARD_ERROR_200
  | 201 // NOT_FOUND_201
  | 202 // CONTENT_FAILURE_202
  | 203 // BAD_USERNAME_203
  | 204 // BAD_REMOTE_ID_204
  | 205 // TEXT_NOT_FOUND_205
  | 206 // BAD_ARGS_206
  | 207 // CONTENT_MISSING_207
  | 208 // TITLE_NOT_FOUND_208
  | 209 // SERVICE_ERROR_209
  | 210 // TOR_SKIPPED_210
  | 211 // TOR_INCOMPATIBLE_211
  | 230 // HTTP_300_230
  | 240 // HTTP_400_240
  | 260 // HTTP_OTHER_260
  | 270 // EMPTY_JSON_270
  | 301 // DELETED_301
  | 302 // SERVICE_DEAD_302
  | 303 // BAD_SIGNATURE_303
  | 304 // BAD_API_URL_304
  | 305 // UNKNOWN_TYPE_305
  | 306 // NO_HINT_306
  | 307 // BAD_HINT_TEXT_307
  | 308 // INVALID_PVL_308

export type ProofType =
    0 // NONE_0
  | 1 // KEYBASE_1
  | 2 // TWITTER_2
  | 3 // GITHUB_3
  | 4 // REDDIT_4
  | 5 // COINBASE_5
  | 6 // HACKERNEWS_6
  | 8 // FACEBOOK_8
  | 1000 // GENERIC_WEB_SITE_1000
  | 1001 // DNS_1001
  | 1002 // PGP_1002
  | 100001 // ROOTER_100001

export type Proofs = {
  social?: ?Array<TrackProof>,
  web?: ?Array<WebProof>,
  publicKeys?: ?Array<PublicKey>,
}

export type ProvisionMethod =
    0 // DEVICE_0
  | 1 // PAPER_KEY_1
  | 2 // PASSPHRASE_2
  | 3 // GPG_IMPORT_3
  | 4 // GPG_SIGN_4

export type PublicKey = {
  KID: KID,
  PGPFingerprint: string,
  PGPIdentities?: ?Array<PGPIdentity>,
  isSibkey: boolean,
  isEldest: boolean,
  parentID: string,
  deviceID: DeviceID,
  deviceDescription: string,
  deviceType: string,
  cTime: Time,
  eTime: Time,
  isRevoked: boolean,
}

export type PublicKeyV2 =
    { keyType: 1, nacl: ?PublicKeyV2NaCl }
  | { keyType: 2, pgp: ?PublicKeyV2PGPSummary }
  | { keyType: any }

export type PublicKeyV2Base = {
  kid: KID,
  isSibkey: boolean,
  isEldest: boolean,
  cTime: Time,
  eTime: Time,
  provisioning: SignatureMetadata,
  revocation?: ?SignatureMetadata,
}

export type PublicKeyV2NaCl = {
  base: PublicKeyV2Base,
  parent?: ?KID,
  deviceID: DeviceID,
  deviceDescription: string,
  deviceType: string,
}

export type PublicKeyV2PGPSummary = {
  base: PublicKeyV2Base,
  fingerprint: PGPFingerprint,
  identities?: ?Array<PGPIdentity>,
}

export type PushReason =
    0 // NONE_0
  | 1 // RECONNECTED_1
  | 2 // NEW_DATA_2

export type Reachability = {
  reachable: Reachable,
}

export type Reachable =
    0 // UNKNOWN_0
  | 1 // YES_1
  | 2 // NO_2

export type ReadArgs = {
  opID: OpID,
  path: Path,
  offset: long,
  size: int,
}

export type ReaderKeyMask = {
  application: TeamApplication,
  generation: PerTeamKeyGeneration,
  mask: MaskB64,
}

export type RegisterAddressRes = {
  type: string,
  family: string,
}

export type RekeyEvent = {
  eventType: RekeyEventType,
  interruptType: int,
}

export type RekeyEventType =
    0 // NONE_0
  | 1 // NOT_LOGGED_IN_1
  | 2 // API_ERROR_2
  | 3 // NO_PROBLEMS_3
  | 4 // LOAD_ME_ERROR_4
  | 5 // CURRENT_DEVICE_CAN_REKEY_5
  | 6 // DEVICE_LOAD_ERROR_6
  | 7 // HARASS_7
  | 8 // NO_GREGOR_MESSAGES_8

export type RekeyRequest = {
  folderID: string,
  revision: long,
}

export type RemoteProof = {
  proofType: ProofType,
  key: string,
  value: string,
  displayMarkup: string,
  sigID: SigID,
  mTime: Time,
}

export type RemoteTrack = {
  username: string,
  uid: UID,
  linkID: LinkID,
}

export type RemoveArgs = {
  opID: OpID,
  path: Path,
}

export type RepoID = string

export type ResolveIdentifyImplicitTeamRes = {
  displayName: string,
  teamID: TeamID,
  writers?: ?Array<UserVersion>,
  trackBreaks: {[key: string]: IdentifyTrackBreaks},
}

export type RevokeWarning = {
  endangeredTLFs?: ?Array<TLF>,
}

export type RevokedKey = {
  key: PublicKey,
  time: KeybaseTime,
  by: KID,
}

export type RevokedProof = {
  proof: RemoteProof,
  diff: TrackDiff,
}

export type SaltpackDecryptOptions = {
  interactive: boolean,
  forceRemoteCheck: boolean,
  usePaperKey: boolean,
}

export type SaltpackEncryptOptions = {
  recipients?: ?Array<string>,
  anonymousSender: boolean,
  encryptionOnlyMode: boolean,
  noSelfEncrypt: boolean,
  binary: boolean,
  saltpackVersion: int,
}

export type SaltpackEncryptedMessageInfo = {
  devices?: ?Array<Device>,
  numAnonReceivers: int,
  receiverIsAnon: boolean,
  sender: SaltpackSender,
}

export type SaltpackSender = {
  uid: UID,
  username: string,
  senderType: SaltpackSenderType,
}

export type SaltpackSenderType =
    0 // NOT_TRACKED_0
  | 1 // UNKNOWN_1
  | 2 // ANONYMOUS_2
  | 3 // TRACKING_BROKE_3
  | 4 // TRACKING_OK_4
  | 5 // SELF_5
  | 6 // REVOKED_6
  | 7 // EXPIRED_7

export type SaltpackSignOptions = {
  detached: boolean,
  binary: boolean,
  saltpackVersion: int,
}

export type SaltpackVerifyOptions = {
  signedBy: string,
  signature: bytes,
}

export type ScanProofsScanProofsRpcParam = Exact<{
  infile: string,
  indices: string,
  sigid: string,
  ratelimit: int,
  cachefile: string,
  ignorefile: string
}>

export type SearchComponent = {
  key: string,
  value: string,
  score: double,
}

export type SearchResult = {
  uid: UID,
  username: string,
  components?: ?Array<SearchComponent>,
  score: double,
}

export type SecretEntryArg = {
  desc: string,
  prompt: string,
  err: string,
  cancel: string,
  ok: string,
  reason: string,
  showTyping: boolean,
}

export type SecretEntryRes = {
  text: string,
  canceled: boolean,
  storeSecret: boolean,
}

export type SecretKeys = {
  signing: NaclSigningKeyPrivate,
  encryption: NaclDHKeyPrivate,
}

export type SecretResponse = {
  secret: bytes,
  phrase: string,
}

export type SelectKeyRes = {
  keyID: string,
  doSecretPush: boolean,
}

export type SeqType =
    1 // PUBLIC_1
  | 2 // PRIVATE_2
  | 3 // SEMIPRIVATE_3

export type Seqno = int64

export type ServiceStatus = {
  version: string,
  label: string,
  pid: string,
  lastExitStatus: string,
  bundleVersion: string,
  installStatus: InstallStatus,
  installAction: InstallAction,
  status: Status,
}

export type ServicesStatus = {
  service?: ?Array<ServiceStatus>,
  kbfs?: ?Array<ServiceStatus>,
  updater?: ?Array<ServiceStatus>,
}

export type Session = {
  uid: UID,
  username: string,
  token: string,
  deviceSubkeyKid: KID,
  deviceSibkeyKid: KID,
}

export type SessionStatus = {
  SessionFor: string,
  Loaded: boolean,
  Cleared: boolean,
  SaltOnly: boolean,
  Expired: boolean,
}

export type SessionToken = string

export type Sig = {
  seqno: Seqno,
  sigID: SigID,
  sigIDDisplay: string,
  type: string,
  cTime: Time,
  revoked: boolean,
  active: boolean,
  key: string,
  body: string,
}

export type SigChainLocation = {
  seqno: Seqno,
  seqType: SeqType,
}

export type SigHint = {
  remoteId: string,
  humanUrl: string,
  apiUrl: string,
  checkText: string,
}

export type SigID = string

export type SigListArgs = {
  sessionID: int,
  username: string,
  allKeys: boolean,
  types?: ?SigTypes,
  filterx: string,
  verbose: boolean,
  revoked: boolean,
}

export type SigTypes = {
  track: boolean,
  proof: boolean,
  cryptocurrency: boolean,
  isSelf: boolean,
}

export type SignMode =
    0 // ATTACHED_0
  | 1 // DETACHED_1
  | 2 // CLEAR_2

export type SignatureMetadata = {
  signingKID: KID,
  prevMerkleRootSigned: MerkleRootV2,
  firstAppearedUnverified: Seqno,
  time: Time,
  sigChainLocation: SigChainLocation,
}

export type SignupRes = {
  passphraseOk: boolean,
  postOk: boolean,
  writeOk: boolean,
}

export type SimpleFSListResult = {
  entries?: ?Array<Dirent>,
  progress: Progress,
}

export type SimpleFSSimpleFSCancelRpcParam = Exact<{
  opID: OpID
}>

export type SimpleFSSimpleFSCheckRpcParam = Exact<{
  opID: OpID
}>

export type SimpleFSSimpleFSCloseRpcParam = Exact<{
  opID: OpID
}>

export type SimpleFSSimpleFSCopyRecursiveRpcParam = Exact<{
  opID: OpID,
  src: Path,
  dest: Path
}>

export type SimpleFSSimpleFSCopyRpcParam = Exact<{
  opID: OpID,
  src: Path,
  dest: Path
}>

export type SimpleFSSimpleFSListRecursiveRpcParam = Exact<{
  opID: OpID,
  path: Path
}>

export type SimpleFSSimpleFSListRpcParam = Exact<{
  opID: OpID,
  path: Path
}>

export type SimpleFSSimpleFSMoveRpcParam = Exact<{
  opID: OpID,
  src: Path,
  dest: Path
}>

export type SimpleFSSimpleFSOpenRpcParam = Exact<{
  opID: OpID,
  dest: Path,
  flags: OpenFlags
}>

export type SimpleFSSimpleFSReadListRpcParam = Exact<{
  opID: OpID
}>

export type SimpleFSSimpleFSReadRpcParam = Exact<{
  opID: OpID,
  offset: long,
  size: int
}>

export type SimpleFSSimpleFSRemoveRpcParam = Exact<{
  opID: OpID,
  path: Path
}>

export type SimpleFSSimpleFSRenameRpcParam = Exact<{
  src: Path,
  dest: Path
}>

export type SimpleFSSimpleFSSetStatRpcParam = Exact<{
  dest: Path,
  flag: DirentType
}>

export type SimpleFSSimpleFSStatRpcParam = Exact<{
  path: Path
}>

export type SimpleFSSimpleFSWaitRpcParam = Exact<{
  opID: OpID
}>

export type SimpleFSSimpleFSWriteRpcParam = Exact<{
  opID: OpID,
  offset: long,
  content: bytes
}>

export type SocialAssertion = {
  user: string,
  service: SocialAssertionService,
}

export type SocialAssertionService = string

export type StartProofResult = {
  sigID: SigID,
}

export type Status = {
  code: int,
  name: string,
  desc: string,
  fields?: ?Array<StringKVPair>,
}

export type StatusCode =
    0 // SCOk_0
  | 100 // SCInputError_100
  | 201 // SCLoginRequired_201
  | 202 // SCBadSession_202
  | 203 // SCBadLoginUserNotFound_203
  | 204 // SCBadLoginPassword_204
  | 205 // SCNotFound_205
  | 210 // SCThrottleControl_210
  | 216 // SCDeleted_216
  | 218 // SCGeneric_218
  | 235 // SCAlreadyLoggedIn_235
  | 230 // SCExists_230
  | 237 // SCCanceled_237
  | 239 // SCInputCanceled_239
  | 274 // SCReloginRequired_274
  | 275 // SCResolutionFailed_275
  | 276 // SCProfileNotPublic_276
  | 277 // SCIdentifyFailed_277
  | 278 // SCTrackingBroke_278
  | 279 // SCWrongCryptoFormat_279
  | 280 // SCDecryptionError_280
  | 281 // SCInvalidAddress_281
  | 283 // SCNoSession_283
  | 290 // SCAccountReset_290
  | 295 // SCIdentifiesFailed_295
  | 472 // SCBadEmail_472
  | 701 // SCBadSignupUsernameTaken_701
  | 707 // SCBadInvitationCode_707
  | 801 // SCMissingResult_801
  | 901 // SCKeyNotFound_901
  | 905 // SCKeyCorrupted_905
  | 907 // SCKeyInUse_907
  | 913 // SCKeyBadGen_913
  | 914 // SCKeyNoSecret_914
  | 915 // SCKeyBadUIDs_915
  | 916 // SCKeyNoActive_916
  | 917 // SCKeyNoSig_917
  | 918 // SCKeyBadSig_918
  | 919 // SCKeyBadEldest_919
  | 920 // SCKeyNoEldest_920
  | 921 // SCKeyDuplicateUpdate_921
  | 922 // SCSibkeyAlreadyExists_922
  | 924 // SCDecryptionKeyNotFound_924
  | 927 // SCKeyNoPGPEncryption_927
  | 928 // SCKeyNoNaClEncryption_928
  | 929 // SCKeySyncedPGPNotFound_929
  | 930 // SCKeyNoMatchingGPG_930
  | 931 // SCKeyRevoked_931
  | 1301 // SCBadTrackSession_1301
  | 1404 // SCDeviceBadName_1404
  | 1408 // SCDeviceNameInUse_1408
  | 1409 // SCDeviceNotFound_1409
  | 1410 // SCDeviceMismatch_1410
  | 1411 // SCDeviceRequired_1411
  | 1413 // SCDevicePrevProvisioned_1413
  | 1414 // SCDeviceNoProvision_1414
  | 1415 // SCDeviceProvisionViaDevice_1415
  | 1416 // SCRevokeCurrentDevice_1416
  | 1417 // SCRevokeLastDevice_1417
  | 1418 // SCDeviceProvisionOffline_1418
  | 1501 // SCStreamExists_1501
  | 1502 // SCStreamNotFound_1502
  | 1503 // SCStreamWrongKind_1503
  | 1504 // SCStreamEOF_1504
  | 1600 // SCGenericAPIError_1600
  | 1601 // SCAPINetworkError_1601
  | 1602 // SCTimeout_1602
  | 1701 // SCProofError_1701
  | 1702 // SCIdentificationExpired_1702
  | 1703 // SCSelfNotFound_1703
  | 1704 // SCBadKexPhrase_1704
  | 1705 // SCNoUIDelegation_1705
  | 1706 // SCNoUI_1706
  | 1707 // SCGPGUnavailable_1707
  | 1800 // SCInvalidVersionError_1800
  | 1801 // SCOldVersionError_1801
  | 1802 // SCInvalidLocationError_1802
  | 1803 // SCServiceStatusError_1803
  | 1804 // SCInstallError_1804
  | 1810 // SCLoadKextError_1810
  | 1811 // SCLoadKextPermError_1811
  | 2300 // SCGitInternal_2300
  | 2301 // SCGitRepoAlreadyExists_2301
  | 2302 // SCGitInvalidRepoName_2302
  | 2303 // SCGitCannotDelete_2303
  | 2400 // SCLoginStateTimeout_2400
  | 2500 // SCChatInternal_2500
  | 2501 // SCChatRateLimit_2501
  | 2502 // SCChatConvExists_2502
  | 2503 // SCChatUnknownTLFID_2503
  | 2504 // SCChatNotInConv_2504
  | 2505 // SCChatBadMsg_2505
  | 2506 // SCChatBroadcast_2506
  | 2507 // SCChatAlreadySuperseded_2507
  | 2508 // SCChatAlreadyDeleted_2508
  | 2509 // SCChatTLFFinalized_2509
  | 2510 // SCChatCollision_2510
  | 2511 // SCIdentifySummaryError_2511
  | 2512 // SCNeedSelfRekey_2512
  | 2513 // SCNeedOtherRekey_2513
  | 2514 // SCChatMessageCollision_2514
  | 2515 // SCChatDuplicateMessage_2515
  | 2516 // SCChatClientError_2516
  | 2517 // SCChatNotInTeam_2517
  | 2518 // SCChatStalePreviousState_2518
  | 2607 // SCTeamSelfNotOwner_2607
  | 2614 // SCTeamNotFound_2614
  | 2619 // SCTeamExists_2619
  | 2623 // SCTeamReadError_2623
  | 2663 // SCTeamTarDuplicate_2663
  | 2664 // SCTeamTarNotFound_2664
  | 2665 // SCTeamMemberExists_2665
  | 2666 // SCTeamNotReleased_2666
  | 2667 // SCTeamPermanentlyLeft_2667
  | 2668 // SCTeamNeedRootId_2668
  | 2669 // SCTeamHasLiveChildren_2669
  | 2670 // SCTeamDeleteError_2670
  | 2671 // SCTeamBadRootTeam_2671
  | 2672 // SCTeamNameConflictsWithUser_2672
  | 2673 // SCTeamDeleteNoUpPointer_2673
  | 2674 // SCTeamNeedOwner_2674
  | 2675 // SCTeamNoOwnerAllowed_2675
  | 2676 // SCTeamImplicitNoNonSbs_2676
  | 2677 // SCTeamImplicitBadHash_2677
  | 2678 // SCTeamImplicitBadName_2678
  | 2679 // SCTeamImplicitClash_2679
  | 2680 // SCTeamImplicitDuplicate_2680
  | 2681 // SCTeamImplicitBadOp_2681
  | 2682 // SCTeamImplicitBadRole_2682
  | 2683 // SCTeamImplicitNotFound_2683
  | 2684 // SCTeamBadAdminSeqnoType_2684
  | 2685 // SCTeamImplicitBadAdd_2685
  | 2686 // SCTeamImplicitBadRemove_2686
  | 2697 // SCTeamKeyMaskNotFound_2697

export type Stream = {
  fd: int,
}

export type StringKVPair = {
  key: string,
  value: string,
}

export type SubteamLogPoint = {
  name: TeamName,
  seqno: Seqno,
}

export type TLF = {
  id: TLFID,
  name: string,
  writers?: ?Array<string>,
  readers?: ?Array<string>,
  isPrivate: boolean,
}

export type TLFBreak = {
  breaks?: ?Array<TLFIdentifyFailure>,
}

export type TLFID = string

export type TLFIdentifyBehavior =
    0 // DEFAULT_KBFS_0
  | 1 // CHAT_CLI_1
  | 2 // CHAT_GUI_2
  | 3 // CHAT_GUI_STRICT_3
  | 4 // KBFS_REKEY_4
  | 5 // KBFS_QR_5
  | 6 // CHAT_SKIP_6

export type TLFIdentifyFailure = {
  user: User,
  breaks?: ?IdentifyTrackBreaks,
}

export type TLFQuery = {
  tlfName: string,
  identifyBehavior: TLFIdentifyBehavior,
}

export type TLFVisibility =
    0 // ANY_0
  | 1 // PUBLIC_1
  | 2 // PRIVATE_2

export type TeamAccessRequest = {
  uid: UID,
  eldestSeqno: Seqno,
}

export type TeamAddMemberResult = {
  invited: boolean,
  user?: ?User,
  emailSent: boolean,
  chatSent: boolean,
}

export type TeamApplication =
    1 // KBFS_1
  | 2 // CHAT_2
  | 3 // SALTPACK_3
  | 4 // GIT_METADATA_4

export type TeamApplicationKey = {
  application: TeamApplication,
  keyGeneration: PerTeamKeyGeneration,
  key: Bytes32,
}

export type TeamCLKRMsg = {
  teamID: TeamID,
  generation: PerTeamKeyGeneration,
  score: int,
}

export type TeamChangeReq = {
  owners?: ?Array<UserVersion>,
  admins?: ?Array<UserVersion>,
  writers?: ?Array<UserVersion>,
  readers?: ?Array<UserVersion>,
  none?: ?Array<UserVersion>,
  completedInvites: {[key: string]: UserVersionPercentForm},
}

export type TeamChangeRow = {
  id: TeamID,
  name: string,
  keyRotated: boolean,
  membershipChanged: boolean,
  latestSeqno: Seqno,
}

export type TeamChangeSet = {
  membershipChanged: boolean,
  keyRotated: boolean,
  renamed: boolean,
}

export type TeamCreateResult = {
  chatSent: boolean,
  creatorAdded: boolean,
}

export type TeamData = {
  secretless: boolean,
  name: TeamName,
  chain: TeamSigChainState,
  perTeamKeySeeds: {[key: string]: PerTeamKeySeedItem},
  readerKeyMasks: {[key: string]: {[key: string]: MaskB64}},
  cachedAt: Time,
}

export type TeamDetails = {
  members: TeamMembersDetails,
  keyGeneration: PerTeamKeyGeneration,
  annotatedActiveInvites: {[key: string]: AnnotatedTeamInvite},
}

export type TeamExitRow = {
  id: TeamID,
}

export type TeamID = string

export type TeamIDAndName = {
  id: TeamID,
  name: TeamName,
}

export type TeamIDWithVisibility = {
  teamID: TeamID,
  visibility: TLFVisibility,
}

export type TeamInvite = {
  role: TeamRole,
  id: TeamInviteID,
  type: TeamInviteType,
  name: TeamInviteName,
  inviter: UserVersion,
}

export type TeamInviteCategory =
    0 // NONE_0
  | 1 // UNKNOWN_1
  | 2 // KEYBASE_2
  | 3 // EMAIL_3
  | 4 // SBS_4

export type TeamInviteID = string

export type TeamInviteName = string

export type TeamInviteSocialNetwork = string

export type TeamInviteType =
    { c: 1, unknown: ?string }
  | { c: 4, sbs: ?TeamInviteSocialNetwork }
  | { c: any }

export type TeamInvitee = {
  inviteID: TeamInviteID,
  uid: UID,
  eldestSeqno: Seqno,
  role: TeamRole,
}

export type TeamJoinRequest = {
  name: string,
  username: string,
}

export type TeamList = {
  teams?: ?Array<MemberInfo>,
}

export type TeamMember = {
  uid: UID,
  role: TeamRole,
  eldestSeqno: Seqno,
}

export type TeamMemberDetails = {
  uv: UserVersion,
  username: string,
  active: boolean,
}

export type TeamMembers = {
  owners?: ?Array<UserVersion>,
  admins?: ?Array<UserVersion>,
  writers?: ?Array<UserVersion>,
  readers?: ?Array<UserVersion>,
}

export type TeamMembersDetails = {
  owners?: ?Array<TeamMemberDetails>,
  admins?: ?Array<TeamMemberDetails>,
  writers?: ?Array<TeamMemberDetails>,
  readers?: ?Array<TeamMemberDetails>,
}

export type TeamName = {
  parts?: ?Array<TeamNamePart>,
}

export type TeamNameLogPoint = {
  lastPart: TeamNamePart,
  seqno: Seqno,
}

export type TeamNamePart = string

export type TeamOpenReqMsg = {
  teamID: TeamID,
  tars?: ?Array<TeamAccessRequest>,
}

export type TeamPlusApplicationKeys = {
  id: TeamID,
  name: string,
  implicit: boolean,
  public: boolean,
  application: TeamApplication,
  writers?: ?Array<UserVersion>,
  onlyReaders?: ?Array<UserVersion>,
  applicationKeys?: ?Array<TeamApplicationKey>,
}

export type TeamRefreshers = {
  needKeyGeneration: PerTeamKeyGeneration,
  wantMembers?: ?Array<UserVersion>,
  wantMembersRole: TeamRole,
}

export type TeamRole =
    0 // NONE_0
  | 1 // READER_1
  | 2 // WRITER_2
  | 3 // ADMIN_3
  | 4 // OWNER_4

export type TeamSBSMsg = {
  teamID: TeamID,
  score: int,
  invitees?: ?Array<TeamInvitee>,
}

export type TeamSettings = {
  open: boolean,
  joinAs: TeamRole,
}

export type TeamSigChainState = {
  reader: UserVersion,
  id: TeamID,
  implicit: boolean,
  public: boolean,
  rootAncestor: TeamName,
  nameDepth: int,
  nameLog?: ?Array<TeamNameLogPoint>,
  lastSeqno: Seqno,
  lastLinkID: LinkID,
  parentID?: ?TeamID,
  userLog: {[key: string]: ?Array<UserLogPoint>},
  subteamLog: {[key: string]: ?Array<SubteamLogPoint>},
  perTeamKeys: {[key: string]: PerTeamKey},
  linkIDs: {[key: string]: LinkID},
  stubbedLinks: {[key: string]: boolean},
  activeInvites: {[key: string]: TeamInvite},
  open: boolean,
  openTeamJoinAs: TeamRole,
}

export type TeamTreeEntry = {
  name: TeamName,
  admin: boolean,
}

export type TeamTreeResult = {
  entries?: ?Array<TeamTreeEntry>,
}

export type TeamType =
    0 // NONE_0
  | 1 // LEGACY_1
  | 2 // MODERN_2

export type Test = {
  reply: string,
}

export type Text = {
  data: string,
  markup: boolean,
}

export type Time = long

export type TrackDiff = {
  type: TrackDiffType,
  displayMarkup: string,
}

export type TrackDiffType =
    0 // NONE_0
  | 1 // ERROR_1
  | 2 // CLASH_2
  | 3 // REVOKED_3
  | 4 // UPGRADED_4
  | 5 // NEW_5
  | 6 // REMOTE_FAIL_6
  | 7 // REMOTE_WORKING_7
  | 8 // REMOTE_CHANGED_8
  | 9 // NEW_ELDEST_9
  | 10 // NONE_VIA_TEMPORARY_10

export type TrackOptions = {
  localOnly: boolean,
  bypassConfirm: boolean,
  forceRetrack: boolean,
  expiringLocal: boolean,
  forPGPPull: boolean,
}

export type TrackProof = {
  proofType: string,
  proofName: string,
  idString: string,
}

export type TrackStatus =
    1 // NEW_OK_1
  | 2 // NEW_ZERO_PROOFS_2
  | 3 // NEW_FAIL_PROOFS_3
  | 4 // UPDATE_BROKEN_FAILED_PROOFS_4
  | 5 // UPDATE_NEW_PROOFS_5
  | 6 // UPDATE_OK_6
  | 7 // UPDATE_BROKEN_REVOKED_7

export type TrackSummary = {
  username: string,
  time: Time,
  isRemote: boolean,
}

export type TrackToken = string

export type Tracker = {
  tracker: UID,
  status: int,
  mTime: Time,
}

export type UID = string

export type UPAKVersion =
    1 // V1_1
  | 2 // V2_2

export type UPAKVersioned =
    { v: 1, v1: ?UserPlusAllKeys }
  | { v: 2, v2: ?UserPlusKeysV2AllIncarnations }

export type UPK2MinorVersion =
    0 // V0_0
  | 1 // V1_1
  | 2 // V2_2
  | 3 // V3_3
  | 4 // V4_4
  | 5 // V5_5

export type UnboxAnyRes = {
  kid: KID,
  plaintext: Bytes32,
  index: int,
}

export type UninstallResult = {
  componentResults?: ?Array<ComponentResult>,
  status: Status,
}

export type User = {
  uid: UID,
  username: string,
}

export type UserCard = {
  following: int,
  followers: int,
  uid: UID,
  fullName: string,
  location: string,
  bio: string,
  website: string,
  twitter: string,
  youFollowThem: boolean,
  theyFollowYou: boolean,
}

export type UserLogPoint = {
  role: TeamRole,
  sigMeta: SignatureMetadata,
}

export type UserOrTeamID = string

export type UserOrTeamLite = {
  id: UserOrTeamID,
  name: string,
}

export type UserOrTeamResult =
    1 // USER_1
  | 2 // TEAM_2

export type UserPlusAllKeys = {
  base: UserPlusKeys,
  pgpKeys?: ?Array<PublicKey>,
  remoteTracks?: ?Array<RemoteTrack>,
}

export type UserPlusKeys = {
  uid: UID,
  username: string,
  eldestSeqno: Seqno,
  status: StatusCode,
  deviceKeys?: ?Array<PublicKey>,
  revokedDeviceKeys?: ?Array<RevokedKey>,
  pgpKeyCount: int,
  uvv: UserVersionVector,
  deletedDeviceKeys?: ?Array<PublicKey>,
  perUserKeys?: ?Array<PerUserKey>,
}

export type UserPlusKeysV2 = {
  uid: UID,
  username: string,
  eldestSeqno: Seqno,
  status: StatusCode,
  perUserKeys?: ?Array<PerUserKey>,
  deviceKeys: {[key: string]: PublicKeyV2NaCl},
  pgpKeys: {[key: string]: PublicKeyV2PGPSummary},
  remoteTracks: {[key: string]: RemoteTrack},
}

export type UserPlusKeysV2AllIncarnations = {
  current: UserPlusKeysV2,
  pastIncarnations?: ?Array<UserPlusKeysV2>,
  uvv: UserVersionVector,
  seqnoLinkIDs: {[key: string]: LinkID},
  minorVersion: UPK2MinorVersion,
}

export type UserResolution = {
  assertion: SocialAssertion,
  userID: UID,
}

export type UserSettings = {
  emails?: ?Array<Email>,
}

export type UserSummary = {
  uid: UID,
  username: string,
  thumbnail: string,
  idVersion: int,
  fullName: string,
  bio: string,
  proofs: Proofs,
  sigIDDisplay: string,
  trackTime: Time,
}

export type UserSummary2 = {
  uid: UID,
  username: string,
  thumbnail: string,
  fullName: string,
  isFollower: boolean,
  isFollowee: boolean,
}

export type UserSummary2Set = {
  users?: ?Array<UserSummary2>,
  time: Time,
  version: int,
}

export type UserVersion = {
  uid: UID,
  eldestSeqno: Seqno,
}

export type UserVersionPercentForm = string

export type UserVersionVector = {
  id: long,
  sigHints: int,
  sigChain: long,
  cachedAt: Time,
}

export type VerifySessionRes = {
  uid: UID,
  sid: string,
  generated: int,
  lifetime: int,
}

export type WebProof = {
  hostname: string,
  protocols?: ?Array<string>,
}

export type WriteArgs = {
  opID: OpID,
  path: Path,
  offset: long,
}

export type accountEmailChangeRpcParam = Exact<{
  newEmail: string
}>

export type accountPassphraseChangeRpcParam = Exact<{
  oldPassphrase: string,
  passphrase: string,
  force: boolean
}>

export type accountPassphrasePromptRpcParam = Exact<{
  guiArg: GUIEntryArg
}>

export type apiserverDeleteRpcParam = Exact<{
  endpoint: string,
  args?: ?Array<StringKVPair>,
  httpStatus?: ?Array<int>,
  appStatusCode?: ?Array<int>
}>

export type apiserverGetRpcParam = Exact<{
  endpoint: string,
  args?: ?Array<StringKVPair>,
  httpStatus?: ?Array<int>,
  appStatusCode?: ?Array<int>
}>

export type apiserverGetWithSessionRpcParam = Exact<{
  endpoint: string,
  args?: ?Array<StringKVPair>,
  httpStatus?: ?Array<int>,
  appStatusCode?: ?Array<int>
}>

export type apiserverPostJSONRpcParam = Exact<{
  endpoint: string,
  args?: ?Array<StringKVPair>,
  JSONPayload?: ?Array<StringKVPair>,
  httpStatus?: ?Array<int>,
  appStatusCode?: ?Array<int>
}>

export type apiserverPostRpcParam = Exact<{
  endpoint: string,
  args?: ?Array<StringKVPair>,
  httpStatus?: ?Array<int>,
  appStatusCode?: ?Array<int>
}>

export type appStateUpdateAppStateRpcParam = Exact<{
  state: AppState
}>

export type blockAddReferenceRpcParam = Exact<{
  folder: string,
  ref: BlockReference
}>

export type blockArchiveReferenceRpcParam = Exact<{
  folder: string,
  refs?: ?Array<BlockReference>
}>

export type blockArchiveReferenceWithCountRpcParam = Exact<{
  folder: string,
  refs?: ?Array<BlockReference>
}>

export type blockAuthenticateSessionRpcParam = Exact<{
  signature: string
}>

export type blockDelReferenceRpcParam = Exact<{
  folder: string,
  ref: BlockReference
}>

export type blockDelReferenceWithCountRpcParam = Exact<{
  folder: string,
  refs?: ?Array<BlockReference>
}>

export type blockGetBlockRpcParam = Exact<{
  bid: BlockIdCombo,
  folder: string
}>

export type blockGetTeamQuotaInfoRpcParam = Exact<{
  tid: TeamID
}>

export type blockPutBlockAgainRpcParam = Exact<{
  folder: string,
  ref: BlockReference,
  blockKey: string,
  buf: bytes
}>

export type blockPutBlockRpcParam = Exact<{
  bid: BlockIdCombo,
  folder: string,
  blockKey: string,
  buf: bytes
}>

export type configClearValueRpcParam = Exact<{
  path: string
}>

export type configGetValueRpcParam = Exact<{
  path: string
}>

export type configHelloIAmRpcParam = Exact<{
  details: ClientDetails
}>

export type configSetPathRpcParam = Exact<{
  path: string
}>

export type configSetUserConfigRpcParam = Exact<{
  username: string,
  key: string,
  value: string
}>

export type configSetValueRpcParam = Exact<{
  path: string,
  value: ConfigValue
}>

export type configWaitForClientRpcParam = Exact<{
  clientType: ClientType,
  timeout: DurationSec
}>

export type cryptoSignED25519ForKBFSRpcParam = Exact<{
  msg: bytes,
  reason: string
}>

export type cryptoSignED25519RpcParam = Exact<{
  msg: bytes,
  reason: string
}>

export type cryptoSignToStringRpcParam = Exact<{
  msg: bytes,
  reason: string
}>

export type cryptoUnboxBytes32AnyRpcParam = Exact<{
  bundles?: ?Array<CiphertextBundle>,
  reason: string,
  promptPaper: boolean
}>

export type cryptoUnboxBytes32RpcParam = Exact<{
  encryptedBytes32: EncryptedBytes32,
  nonce: BoxNonce,
  peersPublicKey: BoxPublicKey,
  reason: string
}>

export type cryptocurrencyRegisterAddressRpcParam = Exact<{
  address: string,
  force: boolean,
  wantedFamily: string
}>

export type ctlDbDeleteRpcParam = Exact<{
  key: DbKey
}>

export type ctlDbGetRpcParam = Exact<{
  key: DbKey
}>

export type ctlDbPutRpcParam = Exact<{
  key: DbKey,
  value: DbValue
}>

export type ctlStopRpcParam = Exact<{
  exitCode: ExitCode
}>

export type debuggingFirstStepRpcParam = Exact<{
  val: int
}>

export type debuggingIncrementRpcParam = Exact<{
  val: int
}>

export type debuggingSecondStepRpcParam = Exact<{
  val: int
}>

export type deviceCheckDeviceNameForUserRpcParam = Exact<{
  username: string,
  devicename: string
}>

export type deviceCheckDeviceNameFormatRpcParam = Exact<{
  name: string
}>

export type favoriteFavoriteAddRpcParam = Exact<{
  folder: Folder
}>

export type favoriteFavoriteIgnoreRpcParam = Exact<{
  folder: Folder
}>

export type fsListRpcParam = Exact<{
  path: string
}>

export type gitCreatePersonalRepoRpcParam = Exact<{
  repoName: GitRepoName
}>

export type gitCreateTeamRepoRpcParam = Exact<{
  repoName: GitRepoName,
  teamName: TeamName,
  notifyTeam: boolean
}>

export type gitDeletePersonalRepoRpcParam = Exact<{
  repoName: GitRepoName
}>

export type gitDeleteTeamRepoRpcParam = Exact<{
  repoName: GitRepoName,
  teamName: TeamName,
  notifyTeam: boolean
}>

export type gitGetGitMetadataRpcParam = Exact<{
  folder: Folder
}>

export type gitPutGitMetadataRpcParam = Exact<{
  folder: Folder,
  repoID: RepoID,
  metadata: GitLocalMetadata,
  notifyTeam: boolean
}>

export type gpgUiSelectKeyAndPushOptionRpcParam = Exact<{
  keys?: ?Array<GPGKey>
}>

export type gpgUiSelectKeyRpcParam = Exact<{
  keys?: ?Array<GPGKey>
}>

export type gpgUiSignRpcParam = Exact<{
  msg: bytes,
  fingerprint: bytes
}>

export type gregorDismissCategoryRpcParam = Exact<{
  category: gregor1.Category
}>

export type gregorInjectItemRpcParam = Exact<{
  cat: string,
  body: string,
  dtime: gregor1.TimeOrOffset
}>

export type gregorUIPushOutOfBandMessagesRpcParam = Exact<{
  oobm?: ?Array<gregor1.OutOfBandMessage>
}>

export type gregorUIPushStateRpcParam = Exact<{
  state: gregor1.State,
  reason: PushReason
}>

export type identifyIdentify2RpcParam = Exact<{
  uid: UID,
  userAssertion: string,
  reason: IdentifyReason,
  useDelegateUI?: boolean,
  alwaysBlock?: boolean,
  noErrorOnTrackFailure?: boolean,
  forceRemoteCheck?: boolean,
  needProofSet?: boolean,
  allowEmptySelfID?: boolean,
  noSkipSelf?: boolean,
  canSuppressUI?: boolean,
  identifyBehavior?: TLFIdentifyBehavior,
  forceDisplay?: boolean
}>

export type identifyIdentifyLiteRpcParam = Exact<{
  id: UserOrTeamID,
  assertion: string,
  reason: IdentifyReason,
  useDelegateUI?: boolean,
  alwaysBlock?: boolean,
  noErrorOnTrackFailure?: boolean,
  forceRemoteCheck?: boolean,
  needProofSet?: boolean,
  allowEmptySelfID?: boolean,
  noSkipSelf?: boolean,
  canSuppressUI?: boolean,
  identifyBehavior?: TLFIdentifyBehavior,
  forceDisplay?: boolean
}>

export type identifyResolve3RpcParam = Exact<{
  assertion: string
}>

export type identifyResolveIdentifyImplicitTeamRpcParam = Exact<{
  assertions: string,
  suffix: string,
  isPublic: boolean,
  doIdentifies: boolean,
  create: boolean,
  reason: IdentifyReason,
  identifyBehavior: TLFIdentifyBehavior
}>

export type identifyUiConfirmRpcParam = Exact<{
  outcome: IdentifyOutcome
}>

export type identifyUiDismissRpcParam = Exact<{
  username: string,
  reason: DismissReason
}>

export type identifyUiDisplayCryptocurrencyRpcParam = Exact<{
  c: Cryptocurrency
}>

export type identifyUiDisplayKeyRpcParam = Exact<{
  key: IdentifyKey
}>

export type identifyUiDisplayTLFCreateWithInviteRpcParam = Exact<{
  folderName: string,
  isPrivate: boolean,
  assertion: string,
  socialAssertion: SocialAssertion,
  inviteLink: string,
  throttled: boolean
}>

export type identifyUiDisplayTrackStatementRpcParam = Exact<{
  stmt: string
}>

export type identifyUiDisplayUserCardRpcParam = Exact<{
  card: UserCard
}>

export type identifyUiFinishSocialProofCheckRpcParam = Exact<{
  rp: RemoteProof,
  lcr: LinkCheckResult
}>

export type identifyUiFinishWebProofCheckRpcParam = Exact<{
  rp: RemoteProof,
  lcr: LinkCheckResult
}>

export type identifyUiLaunchNetworkChecksRpcParam = Exact<{
  identity: Identity,
  user: User
}>

export type identifyUiReportLastTrackRpcParam = Exact<{
  track?: ?TrackSummary
}>

export type identifyUiReportTrackTokenRpcParam = Exact<{
  trackToken: TrackToken
}>

export type identifyUiStartRpcParam = Exact<{
  username: string,
  reason: IdentifyReason,
  forceDisplay?: boolean
}>

export type installFuseStatusRpcParam = Exact<{
  bundleVersion: string
}>

export type kbfsFSEditListRpcParam = Exact<{
  edits?: ?Array<FSNotification>,
  requestID: int
}>

export type kbfsFSEventRpcParam = Exact<{
  event: FSNotification
}>

export type kbfsFSSyncEventRpcParam = Exact<{
  event: FSPathSyncStatus
}>

export type kbfsFSSyncStatusRpcParam = Exact<{
  status: FSSyncStatus,
  requestID: int
}>

export type kbfsMountSetCurrentMountDirRpcParam = Exact<{
  dir: string
}>

export type logRegisterLoggerRpcParam = Exact<{
  name: string,
  level: LogLevel
}>

export type logUiLogRpcParam = Exact<{
  level: LogLevel,
  text: Text
}>

export type loginClearStoredSecretRpcParam = Exact<{
  username: string
}>

export type loginDeprovisionRpcParam = Exact<{
  username: string,
  doRevoke: boolean
}>

export type loginLoginProvisionedDeviceRpcParam = Exact<{
  username: string,
  noPassphrasePrompt: boolean
}>

export type loginLoginRpcParam = Exact<{
  deviceType: string,
  usernameOrEmail: string,
  clientType: ClientType
}>

export type loginPaperKeySubmitRpcParam = Exact<{
  paperPhrase: string
}>

export type loginPgpProvisionRpcParam = Exact<{
  username: string,
  passphrase: string,
  deviceName: string
}>

export type loginRecoverAccountFromEmailAddressRpcParam = Exact<{
  email: string
}>

export type loginUiDisplayPaperKeyPhraseRpcParam = Exact<{
  phrase: string
}>

export type loginUiDisplayPrimaryPaperKeyRpcParam = Exact<{
  phrase: string
}>

export type loginUiPromptRevokePaperKeysRpcParam = Exact<{
  device: Device,
  index: int
}>

export type loginUnlockWithPassphraseRpcParam = Exact<{
  passphrase: string
}>

export type merkleGetCurrentMerkleRootRpcParam = Exact<{
  freshnessMsec: int
}>

export type metadataAuthenticateRpcParam = Exact<{
  signature: string
}>

export type metadataDeleteKeyRpcParam = Exact<{
  uid: UID,
  deviceKID: KID,
  keyHalfID: bytes,
  logTags: {[key: string]: string}
}>

export type metadataGetFolderHandleRpcParam = Exact<{
  folderID: string,
  signature: string,
  challenge: string
}>

export type metadataGetFoldersForRekeyRpcParam = Exact<{
  deviceKID: KID
}>

export type metadataGetKeyBundlesRpcParam = Exact<{
  folderID: string,
  writerBundleID: string,
  readerBundleID: string
}>

export type metadataGetKeyRpcParam = Exact<{
  keyHalfID: bytes,
  deviceKID: string,
  logTags: {[key: string]: string}
}>

export type metadataGetLatestFolderHandleRpcParam = Exact<{
  folderID: string
}>

export type metadataGetMerkleNodeRpcParam = Exact<{
  hash: string
}>

export type metadataGetMerkleRootLatestRpcParam = Exact<{
  treeID: MerkleTreeID
}>

export type metadataGetMerkleRootRpcParam = Exact<{
  treeID: MerkleTreeID,
  seqNo: long
}>

export type metadataGetMerkleRootSinceRpcParam = Exact<{
  treeID: MerkleTreeID,
  when: Time
}>

export type metadataGetMetadataRpcParam = Exact<{
  folderID: string,
  folderHandle: bytes,
  branchID: string,
  unmerged: boolean,
  startRevision: long,
  stopRevision: long,
  logTags: {[key: string]: string},
  lockBeforeGet?: ?LockID
}>

export type metadataLockRpcParam = Exact<{
  folderID: string,
  lockID: LockID
}>

export type metadataPruneBranchRpcParam = Exact<{
  folderID: string,
  branchID: string,
  logTags: {[key: string]: string}
}>

export type metadataPutKeysRpcParam = Exact<{
  keyHalves?: ?Array<KeyHalf>,
  logTags: {[key: string]: string}
}>

export type metadataPutMetadataRpcParam = Exact<{
  mdBlock: MDBlock,
  readerKeyBundle: KeyBundle,
  writerKeyBundle: KeyBundle,
  logTags: {[key: string]: string},
  lockContext?: ?LockContext,
  priority: MDPriority
}>

export type metadataRegisterForUpdatesRpcParam = Exact<{
  folderID: string,
  currRevision: long,
  logTags: {[key: string]: string}
}>

export type metadataReleaseLockRpcParam = Exact<{
  folderID: string,
  lockID: LockID
}>

export type metadataTruncateLockRpcParam = Exact<{
  folderID: string
}>

export type metadataTruncateUnlockRpcParam = Exact<{
  folderID: string
}>

export type metadataUpdateFolderNeedsRekeyRpcParam = Exact<{
  folderID: string,
  revision: long
}>

export type metadataUpdateFoldersNeedRekeyRpcParam = Exact<{
  requests?: ?Array<RekeyRequest>
}>

export type metadataUpdateMetadataUpdateRpcParam = Exact<{
  folderID: string,
  revision: long
}>

export type notifyCtlSetNotificationsRpcParam = Exact<{
  channels: NotificationChannels
}>

export type paperprovisionPaperProvisionRpcParam = Exact<{
  username: string,
  deviceName: string,
  paperKey: string
}>

export type pgpPgpDecryptRpcParam = Exact<{
  source: Stream,
  sink: Stream,
  opts: PGPDecryptOptions
}>

export type pgpPgpEncryptRpcParam = Exact<{
  source: Stream,
  sink: Stream,
  opts: PGPEncryptOptions
}>

export type pgpPgpExportByFingerprintRpcParam = Exact<{
  options: PGPQuery,
  encrypted: boolean
}>

export type pgpPgpExportByKIDRpcParam = Exact<{
  options: PGPQuery,
  encrypted: boolean
}>

export type pgpPgpExportRpcParam = Exact<{
  options: PGPQuery,
  encrypted: boolean
}>

export type pgpPgpImportRpcParam = Exact<{
  key: bytes,
  pushSecret: boolean
}>

export type pgpPgpKeyGenDefaultRpcParam = Exact<{
  createUids: PGPCreateUids
}>

export type pgpPgpKeyGenRpcParam = Exact<{
  primaryBits: int,
  subkeyBits: int,
  createUids: PGPCreateUids,
  allowMulti: boolean,
  doExport: boolean,
  exportEncrypted: boolean,
  pushSecret: boolean
}>

export type pgpPgpPullRpcParam = Exact<{
  userAsserts?: ?Array<string>
}>

export type pgpPgpPurgeRpcParam = Exact<{
  doPurge: boolean
}>

export type pgpPgpSelectRpcParam = Exact<{
  fingerprintQuery: string,
  allowMulti: boolean,
  skipImport: boolean,
  onlyImport: boolean
}>

export type pgpPgpSignRpcParam = Exact<{
  source: Stream,
  sink: Stream,
  opts: PGPSignOptions
}>

export type pgpPgpUpdateRpcParam = Exact<{
  all: boolean,
  fingerprints?: ?Array<string>
}>

export type pgpPgpVerifyRpcParam = Exact<{
  source: Stream,
  opts: PGPVerifyOptions
}>

export type pgpUiKeyGeneratedRpcParam = Exact<{
  kid: KID,
  key: KeyInfo
}>

export type pgpUiOutputSignatureSuccessNonKeybaseRpcParam = Exact<{
  keyID: string,
  signedAt: Time
}>

export type pgpUiOutputSignatureSuccessRpcParam = Exact<{
  fingerprint: string,
  username: string,
  signedAt: Time
}>

export type proveCheckProofRpcParam = Exact<{
  sigID: SigID
}>

export type proveStartProofRpcParam = Exact<{
  service: string,
  username: string,
  force: boolean,
  promptPosted: boolean,
  auto: boolean
}>

export type proveUiDisplayRecheckWarningRpcParam = Exact<{
  text: Text
}>

export type proveUiOkToCheckRpcParam = Exact<{
  name: string,
  attempt: int
}>

export type proveUiOutputInstructionsRpcParam = Exact<{
  instructions: Text,
  proof: string
}>

export type proveUiOutputPrechecksRpcParam = Exact<{
  text: Text
}>

export type proveUiPreProofWarningRpcParam = Exact<{
  text: Text
}>

export type proveUiPromptOverwriteRpcParam = Exact<{
  account: string,
  typ: PromptOverwriteType
}>

export type proveUiPromptUsernameRpcParam = Exact<{
  prompt: string,
  prevError?: ?Status
}>

export type provisionUiChooseDeviceRpcParam = Exact<{
  devices?: ?Array<Device>,
  canSelectNoDevice: boolean
}>

export type provisionUiChooseDeviceTypeRpcParam = Exact<{
  kind: ChooseType
}>

export type provisionUiChooseGPGMethodRpcParam = Exact<{
  keys?: ?Array<GPGKey>
}>

export type provisionUiChooseProvisioningMethodRpcParam = Exact<{
  gpgOption: boolean
}>

export type provisionUiDisplayAndPromptSecretRpcParam = Exact<{
  secret: bytes,
  phrase: string,
  otherDeviceType: DeviceType,
  previousErr: string
}>

export type provisionUiPromptNewDeviceNameRpcParam = Exact<{
  existingDevices?: ?Array<string>,
  errorMessage: string
}>

export type provisionUiProvisioneeSuccessRpcParam = Exact<{
  username: string,
  deviceName: string
}>

export type provisionUiProvisionerSuccessRpcParam = Exact<{
  deviceName: string,
  deviceType: string
}>

export type provisionUiSwitchToGPGSignOKRpcParam = Exact<{
  key: GPGKey,
  importError: string
}>

export type quotaVerifySessionRpcParam = Exact<{
  session: string
}>

export type reachabilityReachabilityChangedRpcParam = Exact<{
  reachability: Reachability
}>

export type rekeyGetRevokeWarningRpcParam = Exact<{
  session: int,
  actingDevice: DeviceID,
  targetDevice: DeviceID
}>

export type rekeyRekeySyncRpcParam = Exact<{
  force: boolean
}>

export type rekeyUIRefreshRpcParam = Exact<{
  problemSetDevices: ProblemSetDevices
}>

export type rekeyUIRekeySendEventRpcParam = Exact<{
  event: RekeyEvent
}>

export type revokeRevokeDeviceRpcParam = Exact<{
  deviceID: DeviceID,
  forceSelf: boolean,
  forceLast: boolean
}>

export type revokeRevokeKeyRpcParam = Exact<{
  keyID: KID
}>

export type revokeRevokeSigsRpcParam = Exact<{
  sigIDQueries?: ?Array<string>
}>

export type saltpackSaltpackDecryptRpcParam = Exact<{
  source: Stream,
  sink: Stream,
  opts: SaltpackDecryptOptions
}>

export type saltpackSaltpackEncryptRpcParam = Exact<{
  source: Stream,
  sink: Stream,
  opts: SaltpackEncryptOptions
}>

export type saltpackSaltpackSignRpcParam = Exact<{
  source: Stream,
  sink: Stream,
  opts: SaltpackSignOptions
}>

export type saltpackSaltpackVerifyRpcParam = Exact<{
  source: Stream,
  sink: Stream,
  opts: SaltpackVerifyOptions
}>

export type saltpackUiSaltpackPromptForDecryptRpcParam = Exact<{
  sender: SaltpackSender,
  usedDelegateUI: boolean
}>

export type saltpackUiSaltpackVerifyBadSenderRpcParam = Exact<{
  signingKID: KID,
  sender: SaltpackSender
}>

export type saltpackUiSaltpackVerifySuccessRpcParam = Exact<{
  signingKID: KID,
  sender: SaltpackSender
}>

export type secretUiGetPassphraseRpcParam = Exact<{
  pinentry: GUIEntryArg,
  terminal?: ?SecretEntryArg
}>

export type signupCheckInvitationCodeRpcParam = Exact<{
  invitationCode: string
}>

export type signupCheckUsernameAvailableRpcParam = Exact<{
  username: string
}>

export type signupInviteRequestRpcParam = Exact<{
  email: string,
  fullname: string,
  notes: string
}>

export type signupSignupRpcParam = Exact<{
  email: string,
  inviteCode: string,
  passphrase: string,
  username: string,
  deviceName: string,
  deviceType: DeviceType,
  storeSecret: boolean,
  skipMail: boolean,
  genPGPBatch: boolean,
  genPaper: boolean
}>

export type sigsSigListJSONRpcParam = Exact<{
  arg: SigListArgs
}>

export type sigsSigListRpcParam = Exact<{
  arg: SigListArgs
}>

export type streamUiCloseRpcParam = Exact<{
  s: Stream
}>

export type streamUiReadRpcParam = Exact<{
  s: Stream,
  sz: int
}>

export type streamUiResetRpcParam = Exact<{
  s: Stream
}>

export type streamUiWriteRpcParam = Exact<{
  s: Stream,
  buf: bytes
}>

export type teamsGetTeamRootIDRpcParam = Exact<{
  id: TeamID
}>

export type teamsLoadTeamPlusApplicationKeysRpcParam = Exact<{
  id: TeamID,
  application: TeamApplication,
  refreshers: TeamRefreshers
}>

export type teamsLookupImplicitTeamRpcParam = Exact<{
  name: string,
  public: boolean
}>

export type teamsLookupOrCreateImplicitTeamRpcParam = Exact<{
  name: string,
  public: boolean
}>

export type teamsTeamAcceptInviteOrRequestAccessRpcParam = Exact<{
  tokenOrName: string
}>

export type teamsTeamAcceptInviteRpcParam = Exact<{
  token: string
}>

export type teamsTeamAddMemberRpcParam = Exact<{
  name: string,
  email: string,
  username: string,
  role: TeamRole,
  sendChatNotification: boolean
}>

export type teamsTeamChangeMembershipRpcParam = Exact<{
  name: string,
  req: TeamChangeReq
}>

export type teamsTeamCreateRpcParam = Exact<{
  name: string,
  sendChatNotification: boolean
}>

export type teamsTeamCreateWithSettingsRpcParam = Exact<{
  name: string,
  sendChatNotification: boolean,
  settings: TeamSettings
}>

export type teamsTeamDeleteRpcParam = Exact<{
  name: string
}>

export type teamsTeamEditMemberRpcParam = Exact<{
  name: string,
  username: string,
  role: TeamRole
}>

export type teamsTeamGetRpcParam = Exact<{
  name: string,
  forceRepoll: boolean
}>

export type teamsTeamIgnoreRequestRpcParam = Exact<{
  name: string,
  username: string
}>

export type teamsTeamLeaveRpcParam = Exact<{
  name: string,
  permanent: boolean
}>

export type teamsTeamListRpcParam = Exact<{
  userAssertion: string,
  all: boolean,
  includeImplicitTeams: boolean
}>

export type teamsTeamListSubteamsRecursiveRpcParam = Exact<{
  parentTeamName: string,
  forceRepoll: boolean
}>

export type teamsTeamReAddMemberAfterResetRpcParam = Exact<{
  id: TeamID,
  username: string
}>

export type teamsTeamRemoveMemberRpcParam = Exact<{
  name: string,
  username: string
}>

export type teamsTeamRenameRpcParam = Exact<{
  prevName: TeamName,
  newName: TeamName
}>

export type teamsTeamRequestAccessRpcParam = Exact<{
  name: string
}>

export type teamsTeamSetSettingsRpcParam = Exact<{
  name: string,
  settings: TeamSettings
}>

export type teamsTeamTreeRpcParam = Exact<{
  name: TeamName
}>

export type teamsUiConfirmRootTeamDeleteRpcParam = Exact<{
  teamName: string
}>

export type teamsUiConfirmSubteamDeleteRpcParam = Exact<{
  teamName: string
}>

export type testPanicRpcParam = Exact<{
  message: string
}>

export type testTestCallbackRpcParam = Exact<{
  name: string
}>

export type testTestRpcParam = Exact<{
  name: string
}>

export type tlfCompleteAndCanonicalizePrivateTlfNameRpcParam = Exact<{
  query: TLFQuery
}>

export type tlfCryptKeysRpcParam = Exact<{
  query: TLFQuery
}>

export type tlfKeysGetPublicCanonicalTLFNameAndIDRpcParam = Exact<{
  query: TLFQuery
}>

export type tlfKeysGetTLFCryptKeysRpcParam = Exact<{
  query: TLFQuery
}>

export type tlfPublicCanonicalTLFNameAndIDRpcParam = Exact<{
  query: TLFQuery
}>

export type trackDismissWithTokenRpcParam = Exact<{
  trackToken: TrackToken
}>

export type trackFakeTrackingChangedRpcParam = Exact<{
  username: string,
  isTracking: boolean
}>

export type trackTrackRpcParam = Exact<{
  userAssertion: string,
  options: TrackOptions,
  forceRemoteCheck: boolean
}>

export type trackTrackWithTokenRpcParam = Exact<{
  trackToken: TrackToken,
  options: TrackOptions
}>

export type trackUntrackRpcParam = Exact<{
  username: string
}>

export type uiPromptYesNoRpcParam = Exact<{
  text: Text,
  promptDefault: PromptDefault
}>

export type userInterestingPeopleRpcParam = Exact<{
  maxUsers: int
}>

export type userListTrackers2RpcParam = Exact<{
  assertion: string,
  reverse: boolean
}>

export type userListTrackersByNameRpcParam = Exact<{
  username: string
}>

export type userListTrackersRpcParam = Exact<{
  uid: UID
}>

export type userListTrackingJSONRpcParam = Exact<{
  filter: string,
  verbose: boolean,
  assertion: string
}>

export type userListTrackingRpcParam = Exact<{
  filter: string,
  assertion: string
}>

export type userLoadAllPublicKeysUnverifiedRpcParam = Exact<{
  uid: UID
}>

export type userLoadPublicKeysRpcParam = Exact<{
  uid: UID
}>

export type userLoadUncheckedUserSummariesRpcParam = Exact<{
  uids?: ?Array<UID>
}>

export type userLoadUserByNameRpcParam = Exact<{
  username: string
}>

export type userLoadUserPlusKeysRpcParam = Exact<{
  uid: UID,
  pollForKID: KID
}>

export type userLoadUserRpcParam = Exact<{
  uid: UID
}>

export type userProfileEditRpcParam = Exact<{
  fullName: string,
  location: string,
  bio: string
}>

export type userSearchRpcParam = Exact<{
  query: string
}>
type KBFSGitCreateRepoResult = RepoID
type Kex2Provisionee2Hello2Result = Hello2Res
type Kex2ProvisioneeHelloResult = HelloRes
type SecretKeysGetSecretKeysResult = SecretKeys
type SimpleFSSimpleFSCheckResult = Progress
type SimpleFSSimpleFSGetOpsResult = ?Array<OpDescription>
type SimpleFSSimpleFSMakeOpidResult = OpID
type SimpleFSSimpleFSReadListResult = SimpleFSListResult
type SimpleFSSimpleFSReadResult = FileContent
type SimpleFSSimpleFSStatResult = Dirent
type accountHasServerKeysResult = HasServerKeysRes
type accountPassphrasePromptResult = GetPassphraseRes
type apiserverDeleteResult = APIRes
type apiserverGetResult = APIRes
type apiserverGetWithSessionResult = APIRes
type apiserverPostJSONResult = APIRes
type apiserverPostResult = APIRes
type badgerGetBadgeStateResult = BadgeState
type blockArchiveReferenceResult = ?Array<BlockReference>
type blockArchiveReferenceWithCountResult = DowngradeReferenceRes
type blockBlockPingResult = BlockPingResponse
type blockDelReferenceWithCountResult = DowngradeReferenceRes
type blockGetBlockResult = GetBlockRes
type blockGetSessionChallengeResult = ChallengeInfo
type blockGetTeamQuotaInfoResult = bytes
type blockGetUserQuotaInfoResult = bytes
type configCheckAPIServerOutOfDateWarningResult = OutOfDateInfo
type configGetBootstrapStatusResult = BootstrapStatus
type configGetConfigResult = Config
type configGetCurrentStatusResult = GetCurrentStatusRes
type configGetExtendedStatusResult = ExtendedStatus
type configGetValueResult = ConfigValue
type configWaitForClientResult = boolean
type cryptoSignED25519ForKBFSResult = ED25519SignatureInfo
type cryptoSignED25519Result = ED25519SignatureInfo
type cryptoSignToStringResult = string
type cryptoUnboxBytes32AnyResult = UnboxAnyRes
type cryptoUnboxBytes32Result = Bytes32
type cryptocurrencyRegisterAddressResult = RegisterAddressRes
type ctlDbGetResult = ?DbValue
type debuggingFirstStepResult = FirstStepResult
type debuggingIncrementResult = int
type debuggingSecondStepResult = int
type deviceCheckDeviceNameFormatResult = boolean
type deviceDeviceHistoryListResult = ?Array<DeviceDetail>
type deviceDeviceListResult = ?Array<Device>
type favoriteGetFavoritesResult = FavoritesResult
type fsListResult = ListResult
type gitCreatePersonalRepoResult = RepoID
type gitCreateTeamRepoResult = RepoID
type gitGetAllGitMetadataResult = ?Array<GitRepoResult>
type gitGetGitMetadataResult = ?Array<GitRepoResult>
type gpgUiConfirmDuplicateKeyChosenResult = boolean
type gpgUiGetTTYResult = string
type gpgUiSelectKeyAndPushOptionResult = SelectKeyRes
type gpgUiSelectKeyResult = string
type gpgUiSignResult = string
type gpgUiWantToAddGPGKeyResult = boolean
type gregorGetStateResult = gregor1.State
type gregorInjectItemResult = gregor1.MsgID
type identifyIdentify2Result = Identify2Res
type identifyIdentifyLiteResult = IdentifyLiteRes
type identifyResolve3Result = UserOrTeamLite
type identifyResolveIdentifyImplicitTeamResult = ResolveIdentifyImplicitTeamRes
type identifyUiConfirmResult = ConfirmResult
type identifyUiDelegateIdentifyUIResult = int
type installFuseStatusResult = FuseStatus
type installInstallCommandLinePrivilegedResult = InstallResult
type installInstallFuseResult = InstallResult
type installInstallKBFSResult = InstallResult
type installUninstallKBFSResult = UninstallResult
type kbfsMountGetAllAvailableMountDirsResult = ?Array<string>
type kbfsMountGetCurrentMountDirResult = string
type loginGetConfiguredAccountsResult = ?Array<ConfiguredAccount>
type loginUiGetEmailOrUsernameResult = string
type loginUiPromptRevokePaperKeysResult = boolean
type merkleGetCurrentMerkleRootResult = MerkleRootAndTime
type metadataAuthenticateResult = int
type metadataGetChallengeResult = ChallengeInfo
type metadataGetFolderHandleResult = bytes
type metadataGetKeyBundlesResult = KeyBundleResponse
type metadataGetKeyResult = bytes
type metadataGetLatestFolderHandleResult = bytes
type metadataGetMerkleNodeResult = bytes
type metadataGetMerkleRootLatestResult = MerkleRoot
type metadataGetMerkleRootResult = MerkleRoot
type metadataGetMerkleRootSinceResult = MerkleRoot
type metadataGetMetadataResult = MetadataResponse
type metadataPing2Result = PingResponse
type metadataTruncateLockResult = boolean
type metadataTruncateUnlockResult = boolean
type pgpPgpDecryptResult = PGPSigVerification
type pgpPgpExportByFingerprintResult = ?Array<KeyInfo>
type pgpPgpExportByKIDResult = ?Array<KeyInfo>
type pgpPgpExportResult = ?Array<KeyInfo>
type pgpPgpPurgeResult = PGPPurgeRes
type pgpPgpVerifyResult = PGPSigVerification
type pgpUiShouldPushPrivateResult = boolean
type proveCheckProofResult = CheckProofStatus
type proveStartProofResult = StartProofResult
type proveUiOkToCheckResult = boolean
type proveUiPreProofWarningResult = boolean
type proveUiPromptOverwriteResult = boolean
type proveUiPromptUsernameResult = string
type provisionUiChooseDeviceResult = DeviceID
type provisionUiChooseDeviceTypeResult = DeviceType
type provisionUiChooseGPGMethodResult = GPGMethod
type provisionUiChooseProvisioningMethodResult = ProvisionMethod
type provisionUiDisplayAndPromptSecretResult = SecretResponse
type provisionUiPromptNewDeviceNameResult = string
type provisionUiSwitchToGPGSignOKResult = boolean
type quotaVerifySessionResult = VerifySessionRes
type reachabilityCheckReachabilityResult = Reachability
type reachabilityStartReachabilityResult = Reachability
type rekeyGetPendingRekeyStatusResult = ProblemSetDevices
type rekeyGetRevokeWarningResult = RevokeWarning
type rekeyRekeyStatusFinishResult = Outcome
type rekeyUIDelegateRekeyUIResult = int
type saltpackSaltpackDecryptResult = SaltpackEncryptedMessageInfo
type secretUiGetPassphraseResult = GetPassphraseRes
type sessionCurrentSessionResult = Session
type signupGetInvitationCodeResult = string
type signupSignupResult = SignupRes
type sigsSigListJSONResult = string
type sigsSigListResult = ?Array<Sig>
type streamUiReadResult = bytes
type streamUiWriteResult = int
type teamsGetTeamRootIDResult = TeamID
type teamsLoadTeamPlusApplicationKeysResult = TeamPlusApplicationKeys
type teamsLookupImplicitTeamResult = TeamID
type teamsLookupOrCreateImplicitTeamResult = TeamID
type teamsTeamAddMemberResult = TeamAddMemberResult
type teamsTeamCreateResult = TeamCreateResult
type teamsTeamCreateWithSettingsResult = TeamCreateResult
type teamsTeamGetResult = TeamDetails
type teamsTeamListRequestsResult = ?Array<TeamJoinRequest>
type teamsTeamListResult = AnnotatedTeamList
type teamsTeamListSubteamsRecursiveResult = ?Array<TeamIDAndName>
type teamsTeamTreeResult = TeamTreeResult
type teamsUiConfirmRootTeamDeleteResult = boolean
type teamsUiConfirmSubteamDeleteResult = boolean
type testTestCallbackResult = string
type testTestResult = Test
type tlfCompleteAndCanonicalizePrivateTlfNameResult = CanonicalTLFNameAndIDWithBreaks
type tlfCryptKeysResult = GetTLFCryptKeysRes
type tlfKeysGetPublicCanonicalTLFNameAndIDResult = CanonicalTLFNameAndIDWithBreaks
type tlfKeysGetTLFCryptKeysResult = GetTLFCryptKeysRes
type tlfPublicCanonicalTLFNameAndIDResult = CanonicalTLFNameAndIDWithBreaks
type trackTrackResult = ConfirmResult
type uiPromptYesNoResult = boolean
type userInterestingPeopleResult = ?Array<InterestingPerson>
type userListTrackers2Result = UserSummary2Set
type userListTrackersByNameResult = ?Array<Tracker>
type userListTrackersResult = ?Array<Tracker>
type userListTrackersSelfResult = ?Array<Tracker>
type userListTrackingJSONResult = string
type userListTrackingResult = ?Array<UserSummary>
type userLoadAllPublicKeysUnverifiedResult = ?Array<PublicKey>
type userLoadMyPublicKeysResult = ?Array<PublicKey>
type userLoadMySettingsResult = UserSettings
type userLoadPublicKeysResult = ?Array<PublicKey>
type userLoadUncheckedUserSummariesResult = ?Array<UserSummary>
type userLoadUserByNameResult = User
type userLoadUserPlusKeysResult = UserPlusKeys
type userLoadUserResult = User
type userSearchResult = ?Array<SearchResult>

export type incomingCallMapType = Exact<{
  'keybase.1.gpgUi.wantToAddGPGKey'?: (
    params: Exact<{
      sessionID: int
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: gpgUiWantToAddGPGKeyResult) => void,
    }
  ) => void,
  'keybase.1.gpgUi.confirmDuplicateKeyChosen'?: (
    params: Exact<{
      sessionID: int
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: gpgUiConfirmDuplicateKeyChosenResult) => void,
    }
  ) => void,
  'keybase.1.gpgUi.selectKeyAndPushOption'?: (
    params: Exact<{
      sessionID: int,
      keys?: ?Array<GPGKey>
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: gpgUiSelectKeyAndPushOptionResult) => void,
    }
  ) => void,
  'keybase.1.gpgUi.selectKey'?: (
    params: Exact<{
      sessionID: int,
      keys?: ?Array<GPGKey>
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: gpgUiSelectKeyResult) => void,
    }
  ) => void,
  'keybase.1.gpgUi.sign'?: (
    params: Exact<{
      msg: bytes,
      fingerprint: bytes
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: gpgUiSignResult) => void,
    }
  ) => void,
  'keybase.1.gpgUi.getTTY'?: (
    params: Exact<{}>,
    response: {
      error: RPCErrorHandler,
      result: (result: gpgUiGetTTYResult) => void,
    }
  ) => void,
  'keybase.1.gregorUI.pushState'?: (
    params: Exact<{
      state: gregor1.State,
      reason: PushReason
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.gregorUI.pushOutOfBandMessages'?: (
    params: Exact<{
      oobm?: ?Array<gregor1.OutOfBandMessage>
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.identifyUi.displayTLFCreateWithInvite'?: (
    params: Exact<{
      sessionID: int,
      folderName: string,
      isPrivate: boolean,
      assertion: string,
      socialAssertion: SocialAssertion,
      inviteLink: string,
      throttled: boolean
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.identifyUi.delegateIdentifyUI'?: (
    params: Exact<{}>,
    response: {
      error: RPCErrorHandler,
      result: (result: identifyUiDelegateIdentifyUIResult) => void,
    }
  ) => void,
  'keybase.1.identifyUi.start'?: (
    params: Exact<{
      sessionID: int,
      username: string,
      reason: IdentifyReason,
      forceDisplay?: boolean
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.identifyUi.displayKey'?: (
    params: Exact<{
      sessionID: int,
      key: IdentifyKey
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.identifyUi.reportLastTrack'?: (
    params: Exact<{
      sessionID: int,
      track?: ?TrackSummary
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.identifyUi.launchNetworkChecks'?: (
    params: Exact<{
      sessionID: int,
      identity: Identity,
      user: User
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.identifyUi.displayTrackStatement'?: (
    params: Exact<{
      sessionID: int,
      stmt: string
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.identifyUi.finishWebProofCheck'?: (
    params: Exact<{
      sessionID: int,
      rp: RemoteProof,
      lcr: LinkCheckResult
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.identifyUi.finishSocialProofCheck'?: (
    params: Exact<{
      sessionID: int,
      rp: RemoteProof,
      lcr: LinkCheckResult
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.identifyUi.displayCryptocurrency'?: (
    params: Exact<{
      sessionID: int,
      c: Cryptocurrency
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.identifyUi.reportTrackToken'?: (
    params: Exact<{
      sessionID: int,
      trackToken: TrackToken
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.identifyUi.displayUserCard'?: (
    params: Exact<{
      sessionID: int,
      card: UserCard
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.identifyUi.confirm'?: (
    params: Exact<{
      sessionID: int,
      outcome: IdentifyOutcome
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: identifyUiConfirmResult) => void,
    }
  ) => void,
  'keybase.1.identifyUi.cancel'?: (
    params: Exact<{
      sessionID: int
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.identifyUi.finish'?: (
    params: Exact<{
      sessionID: int
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.identifyUi.dismiss'?: (
    params: Exact<{
      sessionID: int,
      username: string,
      reason: DismissReason
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.logUi.log'?: (
    params: Exact<{
      sessionID: int,
      level: LogLevel,
      text: Text
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.loginUi.getEmailOrUsername'?: (
    params: Exact<{
      sessionID: int
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: loginUiGetEmailOrUsernameResult) => void,
    }
  ) => void,
  'keybase.1.loginUi.promptRevokePaperKeys'?: (
    params: Exact<{
      sessionID: int,
      device: Device,
      index: int
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: loginUiPromptRevokePaperKeysResult) => void,
    }
  ) => void,
  'keybase.1.loginUi.displayPaperKeyPhrase'?: (
    params: Exact<{
      sessionID: int,
      phrase: string
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.loginUi.displayPrimaryPaperKey'?: (
    params: Exact<{
      sessionID: int,
      phrase: string
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.logsend.prepareLogsend'?: (
    params: Exact<{}>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.NotifyApp.exit'?: (
    params: Exact<{}>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.NotifyBadges.badgeState'?: (
    params: Exact<{
      badgeState: BadgeState
    }> /* ,
    response: {} // Notify call
    */
  ) => void,
  'keybase.1.NotifyFavorites.favoritesChanged'?: (
    params: Exact<{
      uid: UID
    }> /* ,
    response: {} // Notify call
    */
  ) => void,
  'keybase.1.NotifyFS.FSActivity'?: (
    params: Exact<{
      notification: FSNotification
    }> /* ,
    response: {} // Notify call
    */
  ) => void,
  'keybase.1.NotifyFS.FSSyncActivity'?: (
    params: Exact<{
      status: FSPathSyncStatus
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.NotifyFS.FSEditListResponse'?: (
    params: Exact<{
      edits?: ?Array<FSNotification>,
      requestID: int
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.NotifyFS.FSSyncStatusResponse'?: (
    params: Exact<{
      status: FSSyncStatus,
      requestID: int
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.NotifyKeyfamily.keyfamilyChanged'?: (
    params: Exact<{
      uid: UID
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.NotifyPaperKey.paperKeyCached'?: (
    params: Exact<{
      uid: UID,
      encKID: KID,
      sigKID: KID
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.NotifyPGP.pgpKeyInSecretStoreFile'?: (
    params: Exact<{}>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.NotifyService.shutdown'?: (
    params: Exact<{}>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.NotifySession.loggedOut'?: (
    params: Exact<{}> /* ,
    response: {} // Notify call
    */
  ) => void,
  'keybase.1.NotifySession.loggedIn'?: (
    params: Exact<{
      username: string
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.NotifySession.clientOutOfDate'?: (
    params: Exact<{
      upgradeTo: string,
      upgradeURI: string,
      upgradeMsg: string
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.NotifyTeam.teamChanged'?: (
    params: Exact<{
      teamID: TeamID,
      teamName: string,
      latestSeqno: Seqno,
      changes: TeamChangeSet
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.NotifyTeam.teamDeleted'?: (
    params: Exact<{
      teamID: TeamID
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.NotifyTracking.trackingChanged'?: (
    params: Exact<{
      uid: UID,
      username: string,
      isTracking: boolean
    }> /* ,
    response: {} // Notify call
    */
  ) => void,
  'keybase.1.NotifyUsers.userChanged'?: (
    params: Exact<{
      uid: UID
    }> /* ,
    response: {} // Notify call
    */
  ) => void,
  'keybase.1.pgpUi.outputSignatureSuccess'?: (
    params: Exact<{
      sessionID: int,
      fingerprint: string,
      username: string,
      signedAt: Time
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.pgpUi.outputSignatureSuccessNonKeybase'?: (
    params: Exact<{
      sessionID: int,
      keyID: string,
      signedAt: Time
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.pgpUi.keyGenerated'?: (
    params: Exact<{
      sessionID: int,
      kid: KID,
      key: KeyInfo
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.pgpUi.shouldPushPrivate'?: (
    params: Exact<{
      sessionID: int
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: pgpUiShouldPushPrivateResult) => void,
    }
  ) => void,
  'keybase.1.pgpUi.finished'?: (
    params: Exact<{
      sessionID: int
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.proveUi.promptOverwrite'?: (
    params: Exact<{
      sessionID: int,
      account: string,
      typ: PromptOverwriteType
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: proveUiPromptOverwriteResult) => void,
    }
  ) => void,
  'keybase.1.proveUi.promptUsername'?: (
    params: Exact<{
      sessionID: int,
      prompt: string,
      prevError?: ?Status
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: proveUiPromptUsernameResult) => void,
    }
  ) => void,
  'keybase.1.proveUi.outputPrechecks'?: (
    params: Exact<{
      sessionID: int,
      text: Text
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.proveUi.preProofWarning'?: (
    params: Exact<{
      sessionID: int,
      text: Text
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: proveUiPreProofWarningResult) => void,
    }
  ) => void,
  'keybase.1.proveUi.outputInstructions'?: (
    params: Exact<{
      sessionID: int,
      instructions: Text,
      proof: string
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.proveUi.okToCheck'?: (
    params: Exact<{
      sessionID: int,
      name: string,
      attempt: int
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: proveUiOkToCheckResult) => void,
    }
  ) => void,
  'keybase.1.proveUi.displayRecheckWarning'?: (
    params: Exact<{
      sessionID: int,
      text: Text
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.provisionUi.chooseProvisioningMethod'?: (
    params: Exact<{
      sessionID: int,
      gpgOption: boolean
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: provisionUiChooseProvisioningMethodResult) => void,
    }
  ) => void,
  'keybase.1.provisionUi.chooseGPGMethod'?: (
    params: Exact<{
      sessionID: int,
      keys?: ?Array<GPGKey>
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: provisionUiChooseGPGMethodResult) => void,
    }
  ) => void,
  'keybase.1.provisionUi.switchToGPGSignOK'?: (
    params: Exact<{
      sessionID: int,
      key: GPGKey,
      importError: string
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: provisionUiSwitchToGPGSignOKResult) => void,
    }
  ) => void,
  'keybase.1.provisionUi.chooseDevice'?: (
    params: Exact<{
      sessionID: int,
      devices?: ?Array<Device>,
      canSelectNoDevice: boolean
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: provisionUiChooseDeviceResult) => void,
    }
  ) => void,
  'keybase.1.provisionUi.chooseDeviceType'?: (
    params: Exact<{
      sessionID: int,
      kind: ChooseType
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: provisionUiChooseDeviceTypeResult) => void,
    }
  ) => void,
  'keybase.1.provisionUi.DisplayAndPromptSecret'?: (
    params: Exact<{
      sessionID: int,
      secret: bytes,
      phrase: string,
      otherDeviceType: DeviceType,
      previousErr: string
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: provisionUiDisplayAndPromptSecretResult) => void,
    }
  ) => void,
  'keybase.1.provisionUi.DisplaySecretExchanged'?: (
    params: Exact<{
      sessionID: int
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.provisionUi.PromptNewDeviceName'?: (
    params: Exact<{
      sessionID: int,
      existingDevices?: ?Array<string>,
      errorMessage: string
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: provisionUiPromptNewDeviceNameResult) => void,
    }
  ) => void,
  'keybase.1.provisionUi.ProvisioneeSuccess'?: (
    params: Exact<{
      sessionID: int,
      username: string,
      deviceName: string
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.provisionUi.ProvisionerSuccess'?: (
    params: Exact<{
      sessionID: int,
      deviceName: string,
      deviceType: string
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.rekeyUI.delegateRekeyUI'?: (
    params: Exact<{}>,
    response: {
      error: RPCErrorHandler,
      result: (result: rekeyUIDelegateRekeyUIResult) => void,
    }
  ) => void,
  'keybase.1.rekeyUI.refresh'?: (
    params: Exact<{
      sessionID: int,
      problemSetDevices: ProblemSetDevices
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.rekeyUI.rekeySendEvent'?: (
    params: Exact<{
      sessionID: int,
      event: RekeyEvent
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.saltpackUi.saltpackPromptForDecrypt'?: (
    params: Exact<{
      sessionID: int,
      sender: SaltpackSender,
      usedDelegateUI: boolean
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.saltpackUi.saltpackVerifySuccess'?: (
    params: Exact<{
      sessionID: int,
      signingKID: KID,
      sender: SaltpackSender
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.saltpackUi.saltpackVerifyBadSender'?: (
    params: Exact<{
      sessionID: int,
      signingKID: KID,
      sender: SaltpackSender
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.secretUi.getPassphrase'?: (
    params: Exact<{
      sessionID: int,
      pinentry: GUIEntryArg,
      terminal?: ?SecretEntryArg
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: secretUiGetPassphraseResult) => void,
    }
  ) => void,
  'keybase.1.streamUi.close'?: (
    params: Exact<{
      sessionID: int,
      s: Stream
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.streamUi.read'?: (
    params: Exact<{
      sessionID: int,
      s: Stream,
      sz: int
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: streamUiReadResult) => void,
    }
  ) => void,
  'keybase.1.streamUi.reset'?: (
    params: Exact<{
      sessionID: int,
      s: Stream
    }>,
    response: CommonResponseHandler
  ) => void,
  'keybase.1.streamUi.write'?: (
    params: Exact<{
      sessionID: int,
      s: Stream,
      buf: bytes
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: streamUiWriteResult) => void,
    }
  ) => void,
  'keybase.1.teamsUi.confirmRootTeamDelete'?: (
    params: Exact<{
      sessionID: int,
      teamName: string
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: teamsUiConfirmRootTeamDeleteResult) => void,
    }
  ) => void,
  'keybase.1.teamsUi.confirmSubteamDelete'?: (
    params: Exact<{
      sessionID: int,
      teamName: string
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: teamsUiConfirmSubteamDeleteResult) => void,
    }
  ) => void,
  'keybase.1.ui.promptYesNo'?: (
    params: Exact<{
      sessionID: int,
      text: Text,
      promptDefault: PromptDefault
    }>,
    response: {
      error: RPCErrorHandler,
      result: (result: uiPromptYesNoResult) => void,
    }
  ) => void
}>
