/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import org.apache.avro.AvroRemoteException;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.ipc.HttpTransceiver;
import org.apache.avro.ipc.RPCContext;
import org.apache.avro.ipc.RPCPlugin;
import org.apache.avro.ipc.Requestor;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.Server;
import org.apache.avro.ipc.SocketServer;
import org.apache.avro.ipc.SocketTransceiver;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.generic.GenericRequestor;
import org.apache.avro.ipc.specific.SpecificRequestor;
import org.apache.avro.ipc.specific.SpecificResponder;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.test.Kind;
import org.apache.avro.test.MD5;
import org.apache.avro.test.Simple;
import org.apache.avro.test.TestError;
import org.apache.avro.test.TestRecord;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestProtocolSpecific {
    protected static final int REPEATING = -1;
    protected static final File SERVER_PORTS_DIR = new File(System.getProperty("test.dir", "/tmp") + "/server-ports/");
    public static int ackCount;
    private static boolean throwUndeclaredError;
    protected static Server server;
    protected static Transceiver client;
    protected static Simple proxy;
    protected static SpecificResponder responder;
    protected static HandshakeMonitor monitor;

    @Before
    public void testStartServer() throws Exception {
        if (server != null) {
            return;
        }
        responder = new SpecificResponder(Simple.class, (Object)new TestImpl());
        server = this.createServer(responder);
        server.start();
        client = this.createTransceiver();
        SpecificRequestor req = new SpecificRequestor(Simple.class, client);
        this.addRpcPlugins(req);
        proxy = SpecificRequestor.getClient(Simple.class, req);
        monitor = new HandshakeMonitor();
        responder.addRPCPlugin(monitor);
    }

    public void addRpcPlugins(Requestor requestor) {
    }

    public Server createServer(Responder testResponder) throws Exception {
        server = new SocketServer(testResponder, new InetSocketAddress(0));
        return server;
    }

    public Transceiver createTransceiver() throws Exception {
        return new SocketTransceiver(new InetSocketAddress(server.getPort()));
    }

    @Test
    public void testClassLoader() throws Exception {
        ClassLoader loader = new ClassLoader(){};
        SpecificResponder responder = new SpecificResponder(Simple.class, (Object)new TestImpl(), new SpecificData(loader));
        Assert.assertEquals((Object)responder.getSpecificData().getClassLoader(), (Object)loader);
        SpecificRequestor requestor = new SpecificRequestor(Simple.class, client, new SpecificData(loader));
        Assert.assertEquals((Object)requestor.getSpecificData().getClassLoader(), (Object)loader);
    }

    @Test
    public void testGetRemote() throws IOException {
        Assert.assertEquals((Object)Simple.PROTOCOL, (Object)SpecificRequestor.getRemote(proxy));
    }

    @Test
    public void testHello() throws IOException {
        String response = proxy.hello("bob");
        Assert.assertEquals((Object)"goodbye", (Object)response);
    }

    @Test
    public void testHashCode() throws IOException {
        TestError error = new TestError();
        error.hashCode();
    }

    @Test
    public void testEcho() throws IOException {
        TestRecord record = new TestRecord();
        record.setName("foo");
        record.setKind(Kind.BAR);
        record.setHash(new MD5(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5}));
        TestRecord echoed = proxy.echo(record);
        Assert.assertEquals((Object)record, (Object)echoed);
        Assert.assertEquals((long)record.hashCode(), (long)echoed.hashCode());
    }

    @Test
    public void testAdd() throws IOException {
        int result = proxy.add(1, 2);
        Assert.assertEquals((long)3L, (long)result);
    }

    @Test
    public void testEchoBytes() throws IOException {
        Random random = new Random();
        int length = random.nextInt(16384);
        ByteBuffer data = ByteBuffer.allocate(length);
        random.nextBytes(data.array());
        data.flip();
        ByteBuffer echoed = proxy.echoBytes(data);
        Assert.assertEquals((Object)data, (Object)echoed);
    }

    @Test
    public void testEmptyEchoBytes() throws IOException {
        ByteBuffer data = ByteBuffer.allocate(0);
        ByteBuffer echoed = proxy.echoBytes(data);
        data.flip();
        Assert.assertEquals((Object)data, (Object)echoed);
    }

    @Test
    public void testError() throws IOException {
        TestError error = null;
        try {
            proxy.error();
        }
        catch (TestError e) {
            error = e;
        }
        Assert.assertNotNull((Object)error);
        Assert.assertEquals((Object)"an error", (Object)error.getMessage$().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUndeclaredError() throws Exception {
        throwUndeclaredError = true;
        RuntimeException error = null;
        try {
            proxy.error();
        }
        catch (RuntimeException e) {
            error = e;
        }
        finally {
            throwUndeclaredError = false;
        }
        Assert.assertNotNull((Object)error);
        Assert.assertTrue((boolean)error.toString().contains("foo"));
    }

    @Test
    public void testOneWay() throws IOException {
        ackCount = 0;
        proxy.ack();
        proxy.hello("foo");
        proxy.ack();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)2L, (long)ackCount);
    }

    @Test
    public void testRepeatedAccess() throws Exception {
        for (int x = 0; x < 1000; ++x) {
            proxy.hello("hi!");
        }
    }

    @Test(expected=Exception.class)
    public void testConnectionRefusedOneWay() throws IOException {
        HttpTransceiver client = new HttpTransceiver(new URL("http://localhost:4444"));
        SpecificRequestor req = new SpecificRequestor(Simple.class, (Transceiver)client);
        this.addRpcPlugins(req);
        Simple proxy = SpecificRequestor.getClient(Simple.class, req);
        proxy.ack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParamVariation() throws Exception {
        Protocol protocol = new Protocol("Simple", "org.apache.avro.test");
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        fields.add(new Schema.Field("extra", Schema.create(Schema.Type.BOOLEAN), null, null));
        fields.add(new Schema.Field("greeting", Schema.create(Schema.Type.STRING), null, null));
        Protocol.Message message = protocol.createMessage("hello", null, Schema.createRecord(fields), Schema.create(Schema.Type.STRING), Schema.createUnion(new ArrayList<Schema>()));
        protocol.getMessages().put("hello", message);
        Transceiver t = this.createTransceiver();
        try {
            GenericRequestor r = new GenericRequestor(protocol, t);
            this.addRpcPlugins(r);
            GenericData.Record params = new GenericData.Record(message.getRequest());
            params.put("extra", (Object)Boolean.TRUE);
            params.put("greeting", (Object)"bob");
            String response = r.request("hello", params).toString();
            Assert.assertEquals((Object)"goodbye", (Object)response);
        }
        finally {
            t.close();
        }
    }

    @AfterClass
    public static void testHandshakeCount() throws IOException {
        monitor.assertHandshake();
    }

    @AfterClass
    public static void testStopServer() throws IOException {
        client.close();
        server.close();
        server = null;
    }

    protected int getExpectedHandshakeCount() {
        return 3;
    }

    public static class InteropTest {
        @Test
        public void testClient() throws Exception {
            for (File f : SERVER_PORTS_DIR.listFiles()) {
                LineNumberReader reader = new LineNumberReader(new FileReader(f));
                int port = Integer.parseInt(reader.readLine());
                System.out.println("Validating java client to " + f.getName() + " - " + port);
                SocketTransceiver client = new SocketTransceiver(new InetSocketAddress("localhost", port));
                proxy = SpecificRequestor.getClient(Simple.class, client);
                TestProtocolSpecific proto = new TestProtocolSpecific();
                proto.testHello();
                proto.testEcho();
                proto.testEchoBytes();
                proto.testError();
                System.out.println("Done! Validation java client to " + f.getName() + " - " + port);
            }
        }

        public static void main(String[] args) throws Exception {
            SocketServer server = new SocketServer(new SpecificResponder(Simple.class, (Object)new TestImpl()), new InetSocketAddress(0));
            server.start();
            File portFile = new File(SERVER_PORTS_DIR, "java-port");
            FileWriter w = new FileWriter(portFile);
            w.write(Integer.toString(server.getPort()));
            w.close();
        }
    }

    public class HandshakeMonitor
    extends RPCPlugin {
        private int handshakes;
        private HashSet<String> seenProtocols = new HashSet();

        @Override
        public void serverConnecting(RPCContext context) {
            ++this.handshakes;
            int expected = TestProtocolSpecific.this.getExpectedHandshakeCount();
            if (expected > 0 && this.handshakes > expected) {
                throw new IllegalStateException("Expected number of Protocol negotiation handshakes exceeded expected " + expected + " was " + this.handshakes);
            }
            String clientProtocol = context.getHandshakeRequest().clientProtocol;
            if (clientProtocol != null) {
                Assert.assertFalse((boolean)this.seenProtocols.contains(clientProtocol));
                this.seenProtocols.add(clientProtocol);
            }
        }

        public void assertHandshake() {
            int expected = TestProtocolSpecific.this.getExpectedHandshakeCount();
            if (expected != -1) {
                Assert.assertEquals((String)"Expected number of handshakes did not take place.", (long)expected, (long)this.handshakes);
            }
        }
    }

    public static class TestImpl
    implements Simple {
        @Override
        public String hello(String greeting) {
            return "goodbye";
        }

        @Override
        public int add(int arg1, int arg2) {
            return arg1 + arg2;
        }

        @Override
        public TestRecord echo(TestRecord record) {
            return record;
        }

        @Override
        public ByteBuffer echoBytes(ByteBuffer data) {
            return data;
        }

        @Override
        public Void error() throws AvroRemoteException {
            if (throwUndeclaredError) {
                throw new RuntimeException("foo");
            }
            throw TestError.newBuilder().setMessage$("an error").build();
        }

        @Override
        public void ack() {
            ++ackCount;
        }
    }
}

