#!/bin/sh
##
## Copyright (c) 2004, Darren L. LaChausse
## ALL RIGHTS RESERVED
##
## Redistribution and use in source and binary forms, with or without
## modification, are permitted provided that the following conditions
## are met:
## 1. Redistributions of source code must retain the above copyright
##    notice, this list of conditions and the following disclaimer.
## 2. Redistributions in binary form must reproduce the above copyright
##    notice, this list of conditions and the following disclaimer in the
##    documentation and/or other materials provided with the distribution.
## 3. Neither the name of the Author nor the names of contributors
##    may be used to endorse or promote products derived from this software
##    without specific prior written permission.
##
## THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
## ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
## IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
## ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
## FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
## DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
## OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
## HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
## LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
## OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
## SUCH DAMAGE.

##
## This shell script generates the website for the keep project using
## the POD documentation contained inside keep itself.
##

##
## Constants and configuration variables
##

htmlroot="/"
htmldir="www"
infile="bin/keep"
outfile="www/index.html"
title="The Keep Project"
css="keep.css"

##
## Generate the website from the POD documentation inside the keep source file
##

# Make a directory to store the website
mkdir -p www

# Call pod2html
pod2html --htmlroot="$htmlroot" --htmldir="$htmldir" --infile="$infile" --outfile="$outfile" --title="$title" --noindex --css="$css" --verbose

# Copy over the site's stylesheet
cp misc/$css www

# Copy over the site's logo
cp misc/logo.png www

# Copy over the README file
cp README www

# Cleanup temporary files
rm -f pod2htm?.tmp
