# 	$Id: Juman.pm,v 1.6 2008/08/06 01:54:39 kawahara Exp $	

package Juman;
require 5.004_04; # For base pragma.
use Carp;
use Juman::Result;
use strict;
use vars qw/ $VERSION %DEFAULT /;
use base qw/ Juman::Process Juman::Hinsi /;

=head1 NAME

Juman -	ǲϤԤ⥸塼

=head1 SYNOPSIS

 use Juman;
 $juman = new Juman;
 $result = $juman->analysis( "ʸǲϤƤ" );
 print $result->all();

=head1 DESCRIPTION

C<Juman> ϡǲϴ JUMAN  Perl Ѥ뤿Υ⥸塼
롥

ñ˷ǲϤԤʤСC<Juman::Simple> ѤǤ롥
C<Juman::Simple> ϡC<Juman> ⥸塼ΥåѡǤꡤñ˷
ǲϴѤǤ褦߷פƤ롥

=head1 CONSTRUCTOR

C<Juman> ֥Ȥ륳󥹥ȥ饯ϡʲΰդ
롥

=head2 Synopsis

    $juman = new Juman
               [ -Server        => string,]
               [ -Port          => integer,]
               [ -Command       => string,]
               [ -Timeout       => integer,]
               [ -Option        => string,]
               [ -Rcfile        => filename,]
               [ -IgnorePattern => string,]

=head2 Options

=over 4

ưΰ̣ϼ̤ꡥ

=item -Server

JUMAN СΥۥ̾ά줿ϡĶѿ C<JUMANSERVER> 
ꤵ줿СѤ롥ĶѿꤵƤʤϡ
Juman ҥץȤƸƤӽФ

=item -Port

СΥݡֹ桥

=item -Command

Juman μ¹ԥե̾Juman СѤʤ˻Ȥ롥

=item -Timeout

Сޤϻҥץ̿Ԥ֡

=item -Option

JUMAN ¹ԤݤΥޥɥ饤άϡ
C<$Juman::DEFAULT{option}> ͤѤ롥

եꤹ C<-r> ץȡKNP ˤä̵뤵
Ƭѥꤹ C<-i> ץˤĤƤϡ줾̤ 
C<-Rcfile>, C<-IgnorePattern> ˤäƻꤹ٤Ǥ롥

=item -Rcfile

JUMAN եꤹ륪ץ

ΥץȡJuman СѤξΩʤȤ¿äˡ
СѤƤ뼭Ȱ㤦ꤷƤեϡտޤ
̤ˤưʤ

=item -IgnorePattern

JUMAN ˤä̵뤵Ƭѥ

=back

=head1 METHODS

=over 4

=item analysis( STR )

ꤵ줿ʸ STR ǲϤη̤ C<Juman::Result> 
ȤȤ֤

=item juman ( STR )

C<analysis> ̾

=back

=head1 ENVIRONMENT

=over 4

=item JUMANSERVER

Ķѿ C<JUMANSERVER> ꤵƤϡꤵƤۥȤ 
Juman СȤѤ롥

=back

=head1 SEE ALSO

=over 4

=item *

L<Juman::Result>

=item *

L<Juman::Simple>

=back

=head1 HISTORY

This module is the completely rewritten version of the original module
written by Taku Kudoh <taku-ku@is.aist-nara.ac.jp>.

=head1 AUTHOR

=over 4

=item
TSUCHIYA Masatoshi <tsuchiya@pine.kuee.kyoto-u.ac.jp>

=back

=head1 COPYRIGHT

ѵڤӺۤˤĤƤ GPL2 ޤ Artistic License ˽äƤ

=cut

# Сɽ
$VERSION = '0.5.7';

# ޥѿ
%DEFAULT =
    ( command => &Juman::Process::which_command('juman'),
      server  => $ENV{JUMANSERVER} || '',	# Juman СΥۥ̾
      port    => 32000,				# Juman СΥݡֹ
      timeout => 30,				# Juman СαԤ
      option  => '-e2 -B',
      rcfile  => $ENV{HOME}.'/.jumanrc',
      mclass  => $Juman::Result::DEFAULT{mclass},
      ignorepattern => '',
    );

# Juman ҥץȤƼ¹Ԥ硤ɸϤΥХåե󥰤ˤ
# ƽϤŤˤʤʤ褦ˤ뤿Τޤʤ
sub BEGIN {
    unless( $DEFAULT{server} ){
	require FileHandle or die "Juman.pm (BEGIN): Can't load module: FileHandle\n";
	STDOUT->autoflush(1);
    }
}

sub new {
    my $class = shift @_;
    my $this = {};
    bless $this, $class;

    if( @_ == 1 ){
	# СηǸƤӽФ줿ν
	my( $argv ) = @_;
	$this->setup( $argv, \%DEFAULT );
#	$this->setup( { 'option' => $argv }, \%DEFAULT );
    } else {
	# ǸƤӽФ줿ν
	my( %option ) = @_;
	$this->setup( \%option, \%DEFAULT );
    }

    if( $this->{OPTION}->{rcfile} and $this->{OPTION}->{server} ){
	carp "Rcfile option may not work with Juman server";
    }

    $this;
}

# EUC-JP3Хȥɤ򢮤Ѵ
sub conv_3bytecode_to_geta {
    my ($buf) = @_;
    my ($ret_buf);

    while ($buf =~ /([^\x80-\xfe]|[\x80-\x8e\x90-\xfe][\x80-\xfe]|\x8f[\x80-\xfe][\x80-\xfe])/g) {
	my $chr = $1;
	if ($chr =~ /^\x8f/) { # 3byte code (JISX0212)
	    $ret_buf .= '';
	}
	else {
	    $ret_buf .= $chr;
	}
    }

    return $ret_buf;
}

sub juman_lines {
    my( $this, $str ) = @_;
    my $socket  = $this->open();
    my $pattern = $this->pattern();
    my @buf;

    # UTFե饰å
    if (utf8::is_utf8($str)) {
	require Encode;
	# euc-jpˤʤʸJISX0212(3Х)ϢѴ
	$str = &conv_3bytecode_to_geta(Encode::encode('euc-jp', $str, sub {''}));
	$this->{input_is_utf8} = 1;
    }
    else {
	$this->{input_is_utf8} = 0;
    }

    # ץʸ
    $str =~ s/[\r\n\f\t]*$/\n/s;
    $socket->print( $str );
    # Ϸ̤ɤ߽Ф
    while( defined( $str = $socket->getline ) ){
	if ($this->{input_is_utf8}) {
	    $str = Encode::decode('euc-jp', $str);
	}
	push( @buf, $str );
	last if $str =~ /$pattern/;
    }
    \@buf;
}
    
# ǲϤԤ᥽å
sub analysis { &juman(@_); }
sub juman {
    my( $this, $str ) = @_;
    new Juman::Result( result  => &juman_lines( $this, $str ),
		       pattern => $this->pattern(),
		       mclass  => $this->{OPTION}->{mclass} );
}

1;
__END__
# Local Variables:
# mode: perl
# coding: euc-japan
# use-kuten-for-period: nil
# use-touten-for-comma: nil
# End:
