// This file is a part of Julia. License is MIT: https://julialang.org/license

#define JL_RUNTIME_EXPORTED_FUNCS(XX) \
    XX(jl_active_task_stack) \
    XX(jl_add_standard_imports) \
    XX(jl_adopt_thread) \
    XX(jl_alignment) \
    XX(jl_alloc_array_1d) \
    XX(jl_alloc_array_2d) \
    XX(jl_alloc_array_3d) \
    XX(jl_alloc_string) \
    XX(jl_alloc_svec) \
    XX(jl_alloc_svec_uninit) \
    XX(jl_alloc_vec_any) \
    XX(jl_apply_array_type) \
    XX(jl_apply_cmpswap_type) \
    XX(jl_apply_generic) \
    XX(jl_apply_tuple_type) \
    XX(jl_apply_tuple_type_v) \
    XX(jl_apply_type) \
    XX(jl_apply_type1) \
    XX(jl_apply_type2) \
    XX(jl_argument_datatype) \
    XX(jl_argument_method_table) \
    XX(jl_arraylen) \
    XX(jl_arrayref) \
    XX(jl_arrayset) \
    XX(jl_arrayunset) \
    XX(jl_array_cconvert_cstring) \
    XX(jl_array_copy) \
    XX(jl_array_del_at) \
    XX(jl_array_del_beg) \
    XX(jl_array_del_end) \
    XX(jl_array_eltype) \
    XX(jl_array_grow_at) \
    XX(jl_array_grow_beg) \
    XX(jl_array_grow_end) \
    XX(jl_array_isassigned) \
    XX(jl_array_ptr) \
    XX(jl_array_ptr_1d_append) \
    XX(jl_array_ptr_1d_push) \
    XX(jl_array_ptr_copy) \
    XX(jl_array_rank) \
    XX(jl_array_size) \
    XX(jl_array_sizehint) \
    XX(jl_array_to_string) \
    XX(jl_array_typetagdata) \
    XX(jl_array_validate_dims) \
    XX(jl_atexit_hook) \
    XX(jl_atomic_bool_cmpswap_bits) \
    XX(jl_atomic_cmpswap_bits) \
    XX(jl_atomic_error) \
    XX(jl_atomic_new_bits) \
    XX(jl_atomic_store_bits) \
    XX(jl_atomic_swap_bits) \
    XX(jl_backtrace_from_here) \
    XX(jl_base_relative_to) \
    XX(jl_binding_owner) \
    XX(jl_binding_resolved_p) \
    XX(jl_bitcast) \
    XX(jl_boundp) \
    XX(jl_bounds_error) \
    XX(jl_bounds_error_int) \
    XX(jl_bounds_error_ints) \
    XX(jl_bounds_error_tuple_int) \
    XX(jl_bounds_error_unboxed_int) \
    XX(jl_bounds_error_v) \
    XX(jl_box_bool) \
    XX(jl_box_char) \
    XX(jl_box_float32) \
    XX(jl_box_float64) \
    XX(jl_box_int16) \
    XX(jl_box_int32) \
    XX(jl_box_int64) \
    XX(jl_box_int8) \
    XX(jl_box_slotnumber) \
    XX(jl_box_ssavalue) \
    XX(jl_box_uint16) \
    XX(jl_box_uint32) \
    XX(jl_box_uint64) \
    XX(jl_box_uint8) \
    XX(jl_box_uint8pointer) \
    XX(jl_box_voidpointer) \
    XX(jl_call) \
    XX(jl_call0) \
    XX(jl_call1) \
    XX(jl_call2) \
    XX(jl_call3) \
    XX(jl_calloc) \
    XX(jl_call_in_typeinf_world) \
    XX(jl_capture_interp_frame) \
    XX(jl_ceil_llvm) \
    XX(jl_ceil_llvm_withtype) \
    XX(jl_cglobal) \
    XX(jl_cglobal_auto) \
    XX(jl_checked_assignment) \
    XX(jl_clear_implicit_imports) \
    XX(jl_close_uv) \
    XX(jl_code_for_staged) \
    XX(jl_compile_hint) \
    XX(jl_compile_method_instance) \
    XX(jl_compress_argnames) \
    XX(jl_compress_ir) \
    XX(jl_compute_fieldtypes) \
    XX(jl_copy_ast) \
    XX(jl_copy_code_info) \
    XX(jl_cpu_threads) \
    XX(jl_effective_threads) \
    XX(jl_crc32c_sw) \
    XX(jl_create_system_image) \
    XX(jl_cstr_to_string) \
    XX(jl_current_exception) \
    XX(jl_debug_method_invalidation) \
    XX(jl_declare_constant) \
    XX(jl_defines_or_exports_p) \
    XX(jl_deprecate_binding) \
    XX(jl_dlclose) \
    XX(jl_dlopen) \
    XX(jl_dlsym) \
    XX(jl_dump_host_cpu) \
    XX(jl_check_pkgimage_clones) \
    XX(jl_egal) \
    XX(jl_egal__bits) \
    XX(jl_egal__special) \
    XX(jl_eh_restore_state) \
    XX(jl_enter_handler) \
    XX(jl_enter_threaded_region) \
    XX(jl_environ) \
    XX(jl_eof_error) \
    XX(jl_eqtable_get) \
    XX(jl_eqtable_pop) \
    XX(jl_eqtable_put) \
    XX(jl_errno) \
    XX(jl_error) \
    XX(jl_errorf) \
    XX(jl_eval_string) \
    XX(jl_exceptionf) \
    XX(jl_exception_clear) \
    XX(jl_exception_occurred) \
    XX(jl_excstack_state) \
    XX(jl_exit) \
    XX(jl_exit_on_sigint) \
    XX(jl_exit_threaded_region) \
    XX(jl_expand) \
    XX(jl_expand_and_resolve) \
    XX(jl_expand_stmt) \
    XX(jl_expand_stmt_with_loc) \
    XX(jl_expand_with_loc) \
    XX(jl_expand_with_loc_warn) \
    XX(jl_field_index) \
    XX(jl_field_isdefined) \
    XX(jl_gc_add_finalizer) \
    XX(jl_gc_add_finalizer_th) \
    XX(jl_gc_add_ptr_finalizer) \
    XX(jl_gc_add_quiescent) \
    XX(jl_gc_allocobj) \
    XX(jl_gc_alloc_0w) \
    XX(jl_gc_alloc_1w) \
    XX(jl_gc_alloc_2w) \
    XX(jl_gc_alloc_3w) \
    XX(jl_gc_alloc_typed) \
    XX(jl_gc_big_alloc) \
    XX(jl_gc_collect) \
    XX(jl_gc_conservative_gc_support_enabled) \
    XX(jl_gc_counted_calloc) \
    XX(jl_gc_counted_free_with_size) \
    XX(jl_gc_counted_malloc) \
    XX(jl_gc_counted_realloc_with_old_size) \
    XX(jl_gc_diff_total_bytes) \
    XX(jl_gc_enable) \
    XX(jl_gc_enable_conservative_gc_support) \
    XX(jl_gc_enable_finalizers) \
    XX(jl_gc_external_obj_hdr_size) \
    XX(jl_gc_find_taggedvalue_pool) \
    XX(jl_gc_get_total_bytes) \
    XX(jl_gc_get_max_memory) \
    XX(jl_gc_internal_obj_base_ptr) \
    XX(jl_gc_is_enabled) \
    XX(jl_gc_live_bytes) \
    XX(jl_gc_managed_malloc) \
    XX(jl_gc_managed_realloc) \
    XX(jl_gc_mark_queue_obj) \
    XX(jl_gc_mark_queue_objarray) \
    XX(jl_gc_max_internal_obj_size) \
    XX(jl_gc_new_weakref) \
    XX(jl_gc_new_weakref_th) \
    XX(jl_gc_num) \
    XX(jl_gc_pool_alloc) \
    XX(jl_gc_queue_multiroot) \
    XX(jl_gc_queue_root) \
    XX(jl_gc_safepoint) \
    XX(jl_gc_schedule_foreign_sweepfunc) \
    XX(jl_gc_set_cb_notify_external_alloc) \
    XX(jl_gc_set_cb_notify_external_free) \
    XX(jl_gc_set_cb_post_gc) \
    XX(jl_gc_set_cb_pre_gc) \
    XX(jl_gc_set_cb_root_scanner) \
    XX(jl_gc_set_cb_task_scanner) \
    XX(jl_gc_sync_total_bytes) \
    XX(jl_gc_total_hrtime) \
    XX(jl_gdblookup) \
    XX(jl_generating_output) \
    XX(jl_generic_function_def) \
    XX(jl_gensym) \
    XX(jl_getallocationgranularity) \
    XX(jl_getnameinfo) \
    XX(jl_getpagesize) \
    XX(jl_get_ARCH) \
    XX(jl_get_backtrace) \
    XX(jl_get_binding) \
    XX(jl_get_binding_for_method_def) \
    XX(jl_get_binding_or_error) \
    XX(jl_get_binding_wr_or_error) \
    XX(jl_get_binding_wr) \
    XX(jl_get_cpu_name) \
    XX(jl_get_current_task) \
    XX(jl_get_default_sysimg_path) \
    XX(jl_get_excstack) \
    XX(jl_get_fenv_consts) \
    XX(jl_get_field) \
    XX(jl_get_global) \
    XX(jl_get_image_file) \
    XX(jl_get_JIT) \
    XX(jl_get_julia_bin) \
    XX(jl_get_julia_bindir) \
    XX(jl_get_method_inferred) \
    XX(jl_get_module_binding) \
    XX(jl_get_module_compile) \
    XX(jl_get_module_infer) \
    XX(jl_get_module_of_binding) \
    XX(jl_get_module_optlevel) \
    XX(jl_get_next_task) \
    XX(jl_get_nth_field) \
    XX(jl_get_nth_field_checked) \
    XX(jl_get_nth_field_noalloc) \
    XX(jl_get_pgcstack) \
    XX(jl_get_ptls_states) \
    XX(jl_get_root_symbol) \
    XX(jl_get_safe_restore) \
    XX(jl_get_size) \
    XX(jl_get_task_tid) \
    XX(jl_get_task_threadpoolid) \
    XX(jl_get_tls_world_age) \
    XX(jl_get_UNAME) \
    XX(jl_get_world_counter) \
    XX(jl_get_zero_subnormals) \
    XX(jl_gf_invoke_lookup) \
    XX(jl_gf_invoke_lookup_worlds) \
    XX(jl_git_branch) \
    XX(jl_git_commit) \
    XX(jl_global_event_loop) \
    XX(jl_has_empty_intersection) \
    XX(jl_has_free_typevars) \
    XX(jl_has_so_reuseport) \
    XX(jl_has_typevar) \
    XX(jl_has_typevar_from_unionall) \
    XX(jl_hrtime) \
    XX(jl_idtable_rehash) \
    XX(jl_infer_thunk) \
    XX(jl_init) \
    XX(jl_init_options) \
    XX(jl_init_restored_modules) \
    XX(jl_init_with_image) \
    XX(jl_init_with_image__threading) \
    XX(jl_init__threading) \
    XX(jl_install_sigint_handler) \
    XX(jl_instantiate_type_in_env) \
    XX(jl_instantiate_unionall) \
    XX(jl_intersect_types) \
    XX(jl_intrinsic_name) \
    XX(jl_invoke) \
    XX(jl_invoke_api) \
    XX(jl_in_threaded_region) \
    XX(jl_iolock_begin) \
    XX(jl_iolock_end) \
    XX(jl_ios_buffer_n) \
    XX(jl_ios_fd) \
    XX(jl_ios_get_nbyte_int) \
    XX(jl_ir_flag_inferred) \
    XX(jl_ir_inlining_cost) \
    XX(jl_ir_flag_pure) \
    XX(jl_ir_nslots) \
    XX(jl_ir_slotflag) \
    XX(jl_isa) \
    XX(jl_isa_compileable_sig) \
    XX(jl_islayout_inline) \
    XX(jl_istopmod) \
    XX(jl_is_binding_deprecated) \
    XX(jl_is_char_signed) \
    XX(jl_is_const) \
    XX(jl_is_debugbuild) \
    XX(jl_is_foreign_type) \
    XX(jl_is_identifier) \
    XX(jl_is_imported) \
    XX(jl_is_initialized) \
    XX(jl_is_in_pure_context) \
    XX(jl_is_memdebug) \
    XX(jl_is_not_broken_subtype) \
    XX(jl_is_operator) \
    XX(jl_is_task_started) \
    XX(jl_is_unary_and_binary_operator) \
    XX(jl_is_unary_operator) \
    XX(jl_lazy_load_and_lookup) \
    XX(jl_lisp_prompt) \
    XX(jl_load) \
    XX(jl_load_) \
    XX(jl_load_and_lookup) \
    XX(jl_load_dynamic_library) \
    XX(jl_load_file_string) \
    XX(jl_lookup_code_address) \
    XX(jl_lseek) \
    XX(jl_lstat) \
    XX(jl_macroexpand) \
    XX(jl_macroexpand1) \
    XX(jl_malloc) \
    XX(jl_malloc_stack) \
    XX(jl_matching_methods) \
    XX(jl_maxrss) \
    XX(jl_method_def) \
    XX(jl_method_instance_add_backedge) \
    XX(jl_method_table_add_backedge) \
    XX(jl_method_table_disable) \
    XX(jl_method_table_for) \
    XX(jl_method_table_insert) \
    XX(jl_methtable_lookup) \
    XX(jl_mi_cache_insert) \
    XX(jl_module_build_id) \
    XX(jl_module_export) \
    XX(jl_module_exports_p) \
    XX(jl_module_globalref) \
    XX(jl_module_import) \
    XX(jl_module_name) \
    XX(jl_module_names) \
    XX(jl_module_parent) \
    XX(jl_module_use) \
    XX(jl_module_using) \
    XX(jl_module_usings) \
    XX(jl_module_uuid) \
    XX(jl_native_alignment) \
    XX(jl_nb_available) \
    XX(jl_new_array) \
    XX(jl_new_bits) \
    XX(jl_new_codeinst) \
    XX(jl_new_code_info_uninit) \
    XX(jl_new_datatype) \
    XX(jl_new_foreign_type) \
    XX(jl_reinit_foreign_type) \
    XX(jl_new_method_instance_uninit) \
    XX(jl_new_method_table) \
    XX(jl_new_method_uninit) \
    XX(jl_new_module) \
    XX(jl_new_primitivetype) \
    XX(jl_new_struct) \
    XX(jl_new_structt) \
    XX(jl_new_structv) \
    XX(jl_new_struct_uninit) \
    XX(jl_new_task) \
    XX(jl_new_typename_in) \
    XX(jl_new_typevar) \
    XX(jl_next_from_addrinfo) \
    XX(jl_normalize_to_compilable_sig) \
    XX(jl_no_exc_handler) \
    XX(jl_object_id) \
    XX(jl_object_id_) \
    XX(jl_obvious_subtype) \
    XX(jl_operator_precedence) \
    XX(jl_parse) \
    XX(jl_parse_all) \
    XX(jl_parse_input_line) \
    XX(jl_parse_opts) \
    XX(jl_parse_string) \
    XX(jl_pathname_for_handle) \
    XX(jl_pchar_to_array) \
    XX(jl_pchar_to_string) \
    XX(jl_pointerref) \
    XX(jl_pointerset) \
    XX(jl_pop_handler) \
    XX(jl_preload_sysimg_so) \
    XX(jl_prepend_cwd) \
    XX(jl_printf) \
    XX(jl_print_backtrace) \
    XX(jl_process_events) \
    XX(jl_profile_clear_data) \
    XX(jl_profile_delay_nsec) \
    XX(jl_profile_get_data) \
    XX(jl_profile_init) \
    XX(jl_profile_is_running) \
    XX(jl_profile_len_data) \
    XX(jl_profile_maxlen_data) \
    XX(jl_profile_start_timer) \
    XX(jl_profile_stop_timer) \
    XX(jl_ptrarrayref) \
    XX(jl_ptr_to_array) \
    XX(jl_ptr_to_array_1d) \
    XX(jl_queue_work) \
    XX(jl_raise_debugger) \
    XX(jl_readuntil) \
    XX(jl_cache_flags) \
    XX(jl_match_cache_flags) \
    XX(jl_read_verify_header) \
    XX(jl_realloc) \
    XX(jl_register_newmeth_tracer) \
    XX(jl_reshape_array) \
    XX(jl_resolve_globals_in_ir) \
    XX(jl_restore_excstack) \
    XX(jl_restore_incremental) \
    XX(jl_restore_package_image_from_file) \
    XX(jl_restore_system_image) \
    XX(jl_restore_system_image_data) \
    XX(jl_rethrow) \
    XX(jl_rethrow_other) \
    XX(jl_rettype_inferred) \
    XX(jl_running_on_valgrind) \
    XX(jl_safe_printf) \
    XX(jl_SC_CLK_TCK) \
    XX(jl_set_ARGS) \
    XX(jl_set_const) \
    XX(jl_set_errno) \
    XX(jl_set_global) \
    XX(jl_set_istopmod) \
    XX(jl_set_module_compile) \
    XX(jl_set_module_infer) \
    XX(jl_set_module_nospecialize) \
    XX(jl_set_module_optlevel) \
    XX(jl_set_module_uuid) \
    XX(jl_set_next_task) \
    XX(jl_set_nth_field) \
    XX(jl_set_safe_restore) \
    XX(jl_set_sysimg_so) \
    XX(jl_set_task_tid) \
    XX(jl_set_task_threadpoolid) \
    XX(jl_set_typeinf_func) \
    XX(jl_set_zero_subnormals) \
    XX(jl_sigatomic_begin) \
    XX(jl_sigatomic_end) \
    XX(jl_sig_throw) \
    XX(jl_spawn) \
    XX(jl_specializations_get_linfo) \
    XX(jl_specializations_lookup) \
    XX(jl_static_show) \
    XX(jl_static_show_func_sig) \
    XX(jl_stderr_obj) \
    XX(jl_stderr_stream) \
    XX(jl_stdin_stream) \
    XX(jl_stdout_obj) \
    XX(jl_stdout_stream) \
    XX(jl_stored_inline) \
    XX(jl_string_ptr) \
    XX(jl_string_to_array) \
    XX(jl_subtype) \
    XX(jl_subtype_env) \
    XX(jl_subtype_env_size) \
    XX(jl_svec) \
    XX(jl_svec1) \
    XX(jl_svec2) \
    XX(jl_svec_copy) \
    XX(jl_svec_fill) \
    XX(jl_svec_ref) \
    XX(jl_switch) \
    XX(jl_switchto) \
    XX(jl_symbol) \
    XX(jl_symbol_lookup) \
    XX(jl_symbol_n) \
    XX(jl_tagged_gensym) \
    XX(jl_take_buffer) \
    XX(jl_task_get_next) \
    XX(jl_task_stack_buffer) \
    XX(jl_termios_size) \
    XX(jl_test_cpu_feature) \
    XX(jl_threadid) \
    XX(jl_threadpoolid) \
    XX(jl_throw) \
    XX(jl_throw_out_of_memory_error) \
    XX(jl_too_few_args) \
    XX(jl_too_many_args) \
    XX(jl_toplevel_eval) \
    XX(jl_toplevel_eval_in) \
    XX(jl_try_substrtod) \
    XX(jl_try_substrtof) \
    XX(jl_tty_set_mode) \
    XX(jl_tupletype_fill) \
    XX(jl_typeassert) \
    XX(jl_typeinf_lock_begin) \
    XX(jl_typeinf_lock_end) \
    XX(jl_typeinf_timing_begin) \
    XX(jl_typeinf_timing_end) \
    XX(jl_typename_str) \
    XX(jl_typeof_str) \
    XX(jl_types_equal) \
    XX(jl_type_equality_is_identity) \
    XX(jl_type_error) \
    XX(jl_type_error_rt) \
    XX(jl_type_intersection) \
    XX(jl_type_intersection_with_env) \
    XX(jl_type_morespecific) \
    XX(jl_type_morespecific_no_subtype) \
    XX(jl_type_union) \
    XX(jl_type_unionall) \
    XX(jl_unbox_bool) \
    XX(jl_unbox_float32) \
    XX(jl_unbox_float64) \
    XX(jl_unbox_int16) \
    XX(jl_unbox_int32) \
    XX(jl_unbox_int64) \
    XX(jl_unbox_int8) \
    XX(jl_unbox_uint16) \
    XX(jl_unbox_uint32) \
    XX(jl_unbox_uint64) \
    XX(jl_unbox_uint8) \
    XX(jl_unbox_uint8pointer) \
    XX(jl_unbox_voidpointer) \
    XX(jl_uncompress_argnames) \
    XX(jl_uncompress_argname_n) \
    XX(jl_uncompress_ir) \
    XX(jl_undefined_var_error) \
    XX(jl_has_no_field_error) \
    XX(jl_value_ptr) \
    XX(jl_ver_is_release) \
    XX(jl_ver_major) \
    XX(jl_ver_minor) \
    XX(jl_ver_patch) \
    XX(jl_ver_string) \
    XX(jl_vexceptionf) \
    XX(jl_vprintf) \
    XX(jl_wakeup_thread) \
    XX(jl_write_compiler_output) \
    XX(jl_yield) \

#define JL_RUNTIME_EXPORTED_FUNCS_WIN(XX) \
    XX(jl_setjmp) \

// use YY instead of XX to avoid jl -> ijl renaming in libjulia-codegen
#define JL_CODEGEN_EXPORTED_FUNCS(YY) \
    YY(jl_dump_function_ir) \
    YY(jl_dump_method_asm) \
    YY(jl_extern_c) \
    YY(jl_get_llvmf_defn) \
    YY(jl_get_llvm_function) \
    YY(jl_get_llvm_module) \
    YY(jl_get_LLVM_VERSION) \
    YY(jl_dump_native) \
    YY(jl_get_llvm_gvs) \
    YY(jl_get_llvm_external_fns) \
    YY(jl_dump_function_asm) \
    YY(jl_LLVMCreateDisasm) \
    YY(jl_LLVMDisasmInstruction) \
    YY(jl_init_codegen) \
    YY(jl_getFunctionInfo) \
    YY(jl_register_fptrs) \
    YY(jl_generate_fptr) \
    YY(jl_generate_fptr_for_unspecialized) \
    YY(jl_compile_extern_c) \
    YY(jl_teardown_codegen) \
    YY(jl_jit_total_bytes) \
    YY(jl_create_native) \
    YY(jl_dump_compiles) \
    YY(jl_dump_emitted_mi_name) \
    YY(jl_dump_llvm_opt) \
    YY(jl_dump_fptr_asm) \
    YY(jl_get_function_id) \
    YY(jl_type_to_llvm) \
    YY(jl_getUnwindInfo) \
    YY(jl_get_libllvm) \
    YY(jl_add_optimization_passes) \
    YY(LLVMExtraAddLowerSimdLoopPass) \
    YY(LLVMExtraAddFinalLowerGCPass) \
    YY(LLVMExtraAddPropagateJuliaAddrspaces) \
    YY(LLVMExtraAddRemoveJuliaAddrspacesPass) \
    YY(LLVMExtraAddCombineMulAddPass) \
    YY(LLVMExtraAddMultiVersioningPass) \
    YY(LLVMExtraAddLowerExcHandlersPass) \
    YY(LLVMExtraAddLateLowerGCFramePass) \
    YY(LLVMExtraJuliaLICMPass) \
    YY(LLVMExtraAddAllocOptPass) \
    YY(LLVMExtraAddLowerPTLSPass) \
    YY(LLVMExtraAddRemoveNIPass) \
    YY(LLVMExtraAddGCInvariantVerifierPass) \
    YY(LLVMExtraAddDemoteFloat16Pass) \
    YY(LLVMExtraAddCPUFeaturesPass) \

// end of file
