Installation
=============================

| Name                           |  Description                                                |
|  ----------------------------  |  ---------------------------------------------------------  |
|[ add_license_to_files.jl ](https://github.com/JuliaLang/julia/blob/master/contrib/add_license_to_files.jl ) | Add the Julia license to files in the Julia Project |
|[ build_sysimg.jl ](https://github.com/JuliaLang/julia/blob/master/contrib/build_sysimg.jl) | Build a system image binary |
|[ check-whitespace.sh ](https://github.com/JuliaLang/julia/blob/master/contrib/check-whitespace.sh) | Check for trailing white space |
|[ commit-name.sh ](https://github.com/JuliaLang/julia/blob/master/contrib/commit-name.sh) | Computes a version name for a commit |
|[ filterArgs.sh ](https://github.com/JuliaLang/julia/blob/master/contrib/filterArgs.sh) | Update library search code to use only tokens that start with -L |
|[ fixup-libgfortran.sh ](https://github.com/JuliaLang/julia/blob/master/contrib/fixup-libgfortran.sh) | Include libgfortran  and libquadmath for installations |
|[ fixup-libstdc++.sh ](https://github.com/JuliaLang/julia/blob/master/contrib/fixup-libstdc++.sh) | Include libstdc++ for    installations |
|[ install.sh ](https://github.com/JuliaLang/julia/blob/master/contrib/install.sh) | Installation script with different permissions |
|[ julia.appdata.xml ](https://github.com/JuliaLang/julia/blob/master/contrib/julia.appdata.xml) | Appdata config file |
|[ julia-config.jl ](https://github.com/JuliaLang/julia/blob/master/contrib/julia-config.jl) | Determines build parameters required by an embedded Julia |
|[ julia.desktop ](https://github.com/JuliaLang/julia/blob/master/contrib/julia.desktop) | GNOME desktop config file |
|[ julia.svg ](https://github.com/JuliaLang/julia/blob/master/contrib/julia.svg) | Julia svg image file |
|[ mac/ ](https://github.com/JuliaLang/julia/blob/master/contrib/mac/) | Mac install files |
|[ relative_path.sh ](https://github.com/JuliaLang/julia/blob/master/contrib/relative_path.sh) | Convert absolute path into   relative path script |
|[ repackage_system_suitesparse4.make ](https://github.com/JuliaLang/julia/blob/master/contrib/repackage_system_suitesparse4.make) | Links shared    libraries from static-library for suitesparse4 |
|[ stringreplace.c ](https://github.com/JuliaLang/julia/blob/master/contrib/stringreplace.c) | Replace strings to hardcoded paths in binaries during `make install` |
|[ travis_fastfail.sh ](https://github.com/JuliaLang/julia/blob/master/contrib/travis_fastfail.sh ) |  Checks for queued build tests in Travis |
|[ vagrant/ ](https://github.com/JuliaLang/julia/blob/master/contrib/vagrant/) | Portable development environment Vagrant install files |
|[ windows/ ](https://github.com/JuliaLang/julia/blob/master/contrib/windows/) | Windows install files |

Editors  + Debuggers
=============================

| Name                           |  Description                                                |
| ------------------------------ | ----------------------------------------------------------- |
|[ ackrc ](https://github.com/JuliaLang/julia/blob/master/contrib/ackrc ) |  Config for Ack search tool |
|[ ctags ](https://github.com/JuliaLang/julia/blob/master/contrib/ctags) | Add more keywords to ctags regex search tool |
|[ debug_bootstrap.gdb ](https://github.com/JuliaLang/julia/blob/master/contrib/debug_bootstrap.gdb) | Bootstrap process using the debug build |
|[ julia.hrc ](https://github.com/JuliaLang/julia/blob/master/contrib/julia.hrc) | Julia syntax highlighting definition for Colorer |
|[ julia.lang ](https://github.com/JuliaLang/julia/blob/master/contrib/julia.lang) | GtkSourceView (GTK+ framework) for multiline text editing config file |
|[ Julia_Notepad++.xml ](https://github.com/JuliaLang/julia/blob/master/contrib/Julia_Notepad++.xml) | Notepad++ config file |
|[ julia.xml ](https://github.com/JuliaLang/julia/blob/master/contrib/julia.xml) | KDE editors Kate and Kwrite config file |
|[ Notepad++_2_Julia.ahk ](https://github.com/JuliaLang/julia/blob/master/contrib/Notepad++_2_Julia.ahk) | Auto Hotkey for Notepad++ config file |
|[ README.ackrc.txt ](https://github.com/JuliaLang/julia/blob/master/contrib/README.ackrc.txt) | README for ackrc  config file |
|[ README.ctags.txt ](https://github.com/JuliaLang/julia/blob/master/contrib/README.ctags.txt) | README for ctags  config file |
|[ valgrind-julia.supp ](https://github.com/JuliaLang/julia/blob/master/contrib/valgrind-julia.supp) | Suppressions  for Valgrind debugging tool |
