//
// msgpack::rpc::session_pool - MessagePack-RPC for C++
//
// Copyright (C) 2009-2010 FURUHASHI Sadayuki
// Copyright (C) 2013 Preferred Infrastructure and Nippon Telegraph and Telephone Corporation.
//
//    Licensed under the Apache License, Version 2.0 (the "License");
//    you may not use this file except in compliance with the License.
//    You may obtain a copy of the License at
//
//        http://www.apache.org/licenses/LICENSE-2.0
//
//    Unless required by applicable law or agreed to in writing, software
//    distributed under the License is distributed on an "AS IS" BASIS,
//    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//    See the License for the specific language governing permissions and
//    limitations under the License.
//
#ifndef MSGPACK_RPC_SESSION_POOL_IMPL_H__
#define MSGPACK_RPC_SESSION_POOL_IMPL_H__

#include "session_pool.h"
#include "transport_impl.h"
#include <jubatus/mp/sync.h>
#include <jubatus/mp/unordered_map.h>

namespace msgpack {
namespace rpc {


class session_pool_impl : public mp::enable_shared_from_this<session_pool_impl> {
public:
	session_pool_impl(const builder& b, loop lo);
	~session_pool_impl();

	session get_session(const address& addr);

	session get_session(const std::string& host, uint16_t port)
		{ return get_session(ip_address(host, port)); }

	void remove_session(const session& sess);

	loop get_loop()
		{ return m_loop; }

	const loop& get_loop() const
		{ return m_loop; }

	loop& get_loop_ref()
		{ return m_loop; }

	const loop& get_loop_ref() const
		{ return m_loop; }

	void set_pool_time_limit(int limit_sec);
	int get_pool_time_limit()
		{ return m_pool_time_limit_sec; }
	void set_pool_size_limit(size_t limit);
	size_t get_pool_size_limit()
		{ return m_pool_size_limit; }
	size_t get_pool_size();

public:
	void step_timeout();

private:
	struct entry_t {
		shared_session session;
		unsigned int ttl;
		entry_t(const shared_session &s, unsigned int c) :
			session(s), ttl(c)
		{ }
	};

	typedef mp::unordered_map<address, entry_t, address::hash> table_t;
	typedef mp::sync<table_t>::ref table_ref;
	mp::sync<table_t> m_table;

	loop m_loop;

	std::auto_ptr<builder> m_builder;

	int m_pool_time_limit_sec;
	size_t m_pool_size_limit;

private:
	session_pool_impl(const session_pool_impl&);
};


}  // namespace rpc
}  // namespace msgpack

#endif /* msgpack/rpc/session_pool_impl.h */

