// Jubatus: Online machine learning framework for distributed environment
// Copyright (C) 2013 Preferred Infrastructure and Nippon Telegraph and Telephone Corporation.
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License version 2.1 as published by the Free Software Foundation.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

#include "version.hpp"
#include <ostream>

namespace jubatus {
namespace core {
namespace storage {

version::version()
    : version_number_(0LLU) {}

std::ostream& operator<<(std::ostream& os, const version& v) {
  os << "(version)" << v.version_number_;
  return os;
}

void version::increment() {
  ++version_number_;
}

uint64_t version::get_number() const {
  return version_number_;
}

}  // namespace storage
}  // namespace core
}  // namespace jubatus
