/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collection;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.SlackAnnouncer;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class SlackAnnouncerValidator {
    private static final String DEFAULT_SLACK_TPL = "src/jreleaser/templates/slack.tpl";

    private SlackAnnouncerValidator() {
    }

    public static void validateSlack(JReleaserContext context, SlackAnnouncer announcer, Errors errors) {
        context.getLogger().debug("announce.slack");
        Validator.resolveActivatable(context, (Activatable)announcer, "announce.slack", "NEVER");
        if (!announcer.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        Errors ignored = new Errors();
        announcer.setToken(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.slack.token", "SLACK_TOKEN"}), "announce.slack.token", announcer.getToken(), ignored, context.isDryrun()));
        announcer.setWebhook(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.slack.webhook", "SLACK_WEBHOOK"}), "announce.slack.webhook", announcer.getWebhook(), ignored, context.isDryrun()));
        String token = announcer.getToken();
        String webhook = announcer.getWebhook();
        if (!context.isDryrun() && StringUtils.isBlank((String)token) && StringUtils.isBlank((String)webhook)) {
            errors.configuration(RB.$((String)"validation_slack_token", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((String)announcer.getChannel())) {
            announcer.setChannel("#announce");
        }
        if (StringUtils.isBlank((String)announcer.getMessage()) && StringUtils.isBlank((String)announcer.getMessageTemplate())) {
            if (Files.exists(context.getBasedir().resolve(DEFAULT_SLACK_TPL), new LinkOption[0])) {
                announcer.setMessageTemplate(DEFAULT_SLACK_TPL);
            } else {
                announcer.setMessage(RB.$((String)"default.release.message", (Object[])new Object[0]));
            }
        }
        if (StringUtils.isNotBlank((String)announcer.getMessageTemplate()) && !Files.exists(context.getBasedir().resolve(announcer.getMessageTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"slack.messageTemplate ", announcer.getMessageTemplate()}));
        }
        Validator.validateTimeout(announcer);
    }
}

