/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.linkedin;

import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.function.Supplier;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.spi.announce.AnnounceException;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.commons.RestAPIException;
import org.jreleaser.sdk.linkedin.LinkedinException;
import org.jreleaser.sdk.linkedin.api.LinkedinAPI;
import org.jreleaser.sdk.linkedin.api.Message;
import org.jreleaser.sdk.linkedin.api.Profile;
import org.jreleaser.util.StringUtils;

public class LinkedinSdk {
    private final JReleaserLogger logger;
    private final LinkedinAPI api;
    private final boolean dryrun;
    private final int connectTimeout;
    private final int readTimeout;
    private final String apiHost;
    private final String accessToken;

    private LinkedinSdk(JReleaserLogger logger, String apiHost, String accessToken, int connectTimeout, int readTimeout, boolean dryrun) {
        this.logger = Objects.requireNonNull(logger, "'logger' must not be null");
        this.apiHost = StringUtils.requireNonBlank((String)apiHost, (String)"'apiHost' must not be blank");
        this.accessToken = StringUtils.requireNonBlank((String)accessToken, (String)"'accessToken' must not be blank");
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.dryrun = dryrun;
        this.api = (LinkedinAPI)ClientUtils.builder((JReleaserLogger)logger, (int)connectTimeout, (int)readTimeout).requestInterceptor(template -> template.header("Authorization", new String[]{String.format("Bearer %s", accessToken)})).target(LinkedinAPI.class, apiHost);
        this.logger.debug(RB.$((String)"workflow.dryrun", (Object[])new Object[0]), new Object[]{dryrun});
    }

    public void share(String owner, Message payload) throws LinkedinException {
        this.logger.debug("linkedin.subject: " + payload.getSubject());
        this.wrap(() -> {
            if (StringUtils.isNotBlank((String)owner)) {
                payload.setOwner(owner);
            } else {
                Profile profile = this.api.getProfile();
                payload.setOwner(profile.urn());
            }
            this.api.share(payload);
        });
    }

    public void share(String owner, String subject, String text) throws AnnounceException, LinkedinException {
        this.logger.debug("linkedin.subject: " + subject);
        if (this.dryrun) {
            return;
        }
        if (StringUtils.isNotBlank((String)owner)) {
            text = text.replace("{{linkedinOwner}}", owner);
        } else {
            Profile profile = this.wrap(this.api::getProfile);
            text = text.replace("{{linkedinOwner}}", profile.urn());
        }
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        headers.put("Authorization", String.format("Bearer %s", this.accessToken));
        ClientUtils.post((JReleaserLogger)this.logger, (String)(this.apiHost + "/shares"), (int)this.connectTimeout, (int)this.readTimeout, (String)text, headers);
    }

    private void wrap(Runnable runnable) throws LinkedinException {
        try {
            if (!this.dryrun) {
                runnable.run();
            }
        }
        catch (RestAPIException e) {
            this.logger.trace(e.getStatus() + ": " + e.getReason());
            this.logger.trace((Throwable)e);
            throw new LinkedinException(RB.$((String)"sdk.operation.failed", (Object[])new Object[]{"Linkedin"}), e);
        }
    }

    private <T> T wrap(Supplier<T> supplier) throws LinkedinException {
        try {
            if (!this.dryrun) {
                return supplier.get();
            }
            return null;
        }
        catch (RestAPIException e) {
            this.logger.trace(e.getStatus() + ": " + e.getReason());
            this.logger.trace((Throwable)e);
            throw new LinkedinException(RB.$((String)"sdk.operation.failed", (Object[])new Object[]{"Linkedin"}), e);
        }
    }

    public static Builder builder(JReleaserLogger logger) {
        return new Builder(logger);
    }

    public static class Builder {
        private final JReleaserLogger logger;
        private boolean dryrun;
        private String apiHost;
        private String accessToken;
        private int connectTimeout = 20;
        private int readTimeout = 60;

        private Builder(JReleaserLogger logger) {
            this.logger = Objects.requireNonNull(logger, "'logger' must not be null");
        }

        public Builder dryrun(boolean dryrun) {
            this.dryrun = dryrun;
            return this;
        }

        public Builder apiHost(String apiHost) {
            this.apiHost = StringUtils.requireNonBlank((String)apiHost, (String)"'apiHost' must not be blank").trim();
            return this;
        }

        public Builder accessToken(String accessToken) {
            this.accessToken = StringUtils.requireNonBlank((String)accessToken, (String)"'accessToken' must not be blank").trim();
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        private void validate() {
            StringUtils.requireNonBlank((String)this.accessToken, (String)"'token' must not be blank");
            if (StringUtils.isBlank((String)this.apiHost)) {
                this.apiHost("https://api.linkedin.com/v2");
            }
        }

        public LinkedinSdk build() {
            this.validate();
            return new LinkedinSdk(this.logger, this.apiHost, this.accessToken, this.connectTimeout, this.readTimeout, this.dryrun);
        }
    }
}

