/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;

public final class CollectionUtils {
    private static final String ERROR_MAP_NULL = "Argument 'map' must not be null";

    private CollectionUtils() {
    }

    public static void safePut(String key, Map<String, Object> src, Properties dest) {
        if (src.containsKey(key)) {
            dest.put(key, String.valueOf(src.get(key)));
        }
    }

    public static void safePut(String key, Map<String, Object> src, Properties dest, boolean forceKey) {
        if (src.containsKey(key)) {
            dest.put(key, String.valueOf(src.get(key)));
        } else if (forceKey) {
            dest.put(key, "");
        }
    }

    public static void safePut(String key, Map<String, Object> src, Map<String, Object> dest) {
        if (src.containsKey(key)) {
            dest.put(key, src.get(key));
        }
    }

    public static void safePut(String key, Map<String, Object> src, Map<String, Object> dest, boolean forceKey) {
        if (src.containsKey(key)) {
            dest.put(key, src.get(key));
        } else if (forceKey) {
            dest.put(key, "");
        }
    }

    public static void safePut(String key, Object value, Map<String, Object> dest) {
        if (null != value) {
            dest.put(key, value);
        }
    }

    public static void safePut(String key, Object value, Map<String, Object> dest, boolean forceKey) {
        if (null != value) {
            dest.put(key, value);
        } else if (forceKey) {
            dest.put(key, "");
        }
    }

    public static <T> boolean intersects(Set<T> s1, Set<T> s2) {
        LinkedHashSet<T> intersection = new LinkedHashSet<T>(s1);
        intersection.removeAll(s2);
        return intersection.size() != s1.size();
    }

    public static <T> List<T> reverse(List<T> input) {
        ArrayList<T> output = new ArrayList<T>(input);
        Collections.reverse(output);
        return output;
    }

    public static <T> List<T> reverse(Collection<T> input) {
        ArrayList<T> output = new ArrayList<T>(input);
        Collections.reverse(output);
        return output;
    }

    @Deprecated
    public static <K, V> Map newMap(Object ... keysAndValues) {
        return CollectionUtils.mapOf(keysAndValues);
    }

    public static <K, V> Map mapOf(Object ... keysAndValues) {
        if (null == keysAndValues) {
            return Collections.emptyMap();
        }
        if (keysAndValues.length % 2 == 1) {
            throw new IllegalArgumentException("Must have an even number of keys and values");
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < keysAndValues.length; i += 2) {
            map.put(keysAndValues[i], keysAndValues[i + 1]);
        }
        return map;
    }

    @Deprecated
    @SafeVarargs
    public static <T> Set<T> newSet(T ... values) {
        return CollectionUtils.setOf(values);
    }

    @SafeVarargs
    public static <T> Set<T> setOf(T ... values) {
        if (null == values) {
            return Collections.emptySet();
        }
        return new HashSet<T>(Arrays.asList(values));
    }

    @Deprecated
    @SafeVarargs
    public static <T> List<T> newList(T ... values) {
        return CollectionUtils.listOf(values);
    }

    @SafeVarargs
    public static <T> List<T> listOf(T ... values) {
        if (null == values) {
            return Collections.emptyList();
        }
        return new ArrayList<T>(Arrays.asList(values));
    }

    public static <K, V> MapBuilder<K, V> map() {
        return CollectionUtils.map(new LinkedHashMap());
    }

    public static <K, V> MapBuilder<K, V> map(Map<K, V> delegate) {
        return new MapBuilder<K, V>(delegate);
    }

    public static <E> ListBuilder<E> list() {
        return CollectionUtils.list(new ArrayList());
    }

    public static <E> ListBuilder<E> list(List<E> delegate) {
        return new ListBuilder<E>(delegate);
    }

    public static <E> SetBuilder<E> set() {
        return CollectionUtils.set(new HashSet());
    }

    public static <E> SetBuilder<E> set(Set<E> delegate) {
        return new SetBuilder<E>(delegate);
    }

    public static Properties toProperties(Map<String, Object> map) {
        Objects.requireNonNull(map, ERROR_MAP_NULL);
        return new MapToPropertiesAdapter(map);
    }

    public static Properties toPropertiesDeep(Map<String, Object> map) {
        Objects.requireNonNull(map, ERROR_MAP_NULL);
        Properties properties = new Properties();
        for (Map.Entry<String, Object> e : map.entrySet()) {
            CollectionUtils.createKey(properties, e.getKey(), e.getValue());
        }
        return properties;
    }

    private static void createKey(Properties properties, String key, Object value) {
        if (value instanceof Map) {
            Map map = (Map)value;
            for (Map.Entry e : map.entrySet()) {
                CollectionUtils.createKey(properties, key + "." + (String)e.getKey(), e.getValue());
            }
        } else {
            properties.put(key, value);
        }
    }

    private static class MapToPropertiesAdapter
    extends Properties {
        private static final long serialVersionUID = -5465075555013344300L;
        private final transient Map<String, Object> map;

        private MapToPropertiesAdapter(Map<String, Object> map) {
            this.map = map;
        }

        @Override
        public synchronized Object setProperty(String key, String value) {
            return this.map.put(key, value);
        }

        @Override
        public String getProperty(String key) {
            Object value = this.map.get(key);
            return null != value ? String.valueOf(value) : null;
        }

        @Override
        public String getProperty(String key, String defaultValue) {
            Object value = this.map.get(key);
            return null != value ? String.valueOf(value) : defaultValue;
        }

        @Override
        public Enumeration<?> propertyNames() {
            return this.keys();
        }

        @Override
        public Set<String> stringPropertyNames() {
            return this.map.keySet();
        }

        @Override
        public synchronized int size() {
            return this.map.size();
        }

        @Override
        public synchronized boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            return new Enumeration<Object>(){
                private final Iterator<String> keys;
                {
                    this.keys = new ArrayList(map.keySet()).iterator();
                }

                @Override
                public boolean hasMoreElements() {
                    return this.keys.hasNext();
                }

                @Override
                public String nextElement() {
                    return this.keys.next();
                }
            };
        }

        @Override
        public synchronized Enumeration<Object> elements() {
            return new Enumeration<Object>(){
                private final Iterator<Object> values;
                {
                    this.values = new ArrayList(map.values()).iterator();
                }

                @Override
                public boolean hasMoreElements() {
                    return this.values.hasNext();
                }

                @Override
                public Object nextElement() {
                    return this.values.next();
                }
            };
        }

        @Override
        public synchronized boolean contains(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        public synchronized boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        @Override
        public synchronized Object get(Object key) {
            return this.map.get(key);
        }

        @Override
        public synchronized Object put(Object key, Object value) {
            return this.map.put(String.valueOf(key), value);
        }

        @Override
        public synchronized Object remove(Object key) {
            return this.map.remove(key);
        }

        @Override
        public synchronized void putAll(Map<?, ?> t) {
            this.map.putAll(t);
        }

        @Override
        public synchronized void clear() {
            this.map.clear();
        }

        @Override
        public Set<Object> keySet() {
            return new LinkedHashSet<Object>(this.map.keySet());
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            LinkedHashSet<Map.Entry<String, Object>> set = new LinkedHashSet<Map.Entry<String, Object>>(this.map.entrySet());
            return new LinkedHashSet<Map.Entry<Object, Object>>(set);
        }

        @Override
        public Collection<Object> values() {
            return this.map.values();
        }

        @Override
        public synchronized Object clone() {
            LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>(this.map);
            return new MapToPropertiesAdapter((Map<String, Object>)m);
        }
    }

    public static class SetBuilder<E>
    implements Set<E> {
        private final Set<E> delegate;

        public SetBuilder(Set<E> delegate) {
            this.delegate = delegate;
        }

        public SetBuilder<E> e(E e) {
            this.delegate.add(e);
            return this;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        public Iterator<E> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.delegate.toArray();
        }

        @Override
        public <T> T[] toArray(T[] ts) {
            return this.delegate.toArray(ts);
        }

        @Override
        public boolean add(E e) {
            return this.delegate.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.delegate.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> objects) {
            return this.delegate.containsAll(objects);
        }

        @Override
        public boolean addAll(Collection<? extends E> es) {
            return this.delegate.addAll(es);
        }

        @Override
        public boolean retainAll(Collection<?> objects) {
            return this.delegate.retainAll(objects);
        }

        @Override
        public boolean removeAll(Collection<?> objects) {
            return this.delegate.removeAll(objects);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    public static class ListBuilder<E>
    implements List<E> {
        private final List<E> delegate;

        public ListBuilder(List<E> delegate) {
            this.delegate = delegate;
        }

        public ListBuilder<E> e(E e) {
            this.delegate.add(e);
            return this;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        public Iterator<E> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.delegate.toArray();
        }

        @Override
        public <T> T[] toArray(T[] ts) {
            return this.delegate.toArray(ts);
        }

        @Override
        public boolean add(E e) {
            return this.delegate.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.delegate.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> objects) {
            return this.delegate.containsAll(objects);
        }

        @Override
        public boolean addAll(Collection<? extends E> es) {
            return this.delegate.addAll(es);
        }

        @Override
        public boolean addAll(int i, Collection<? extends E> es) {
            return this.delegate.addAll(i, es);
        }

        @Override
        public boolean removeAll(Collection<?> objects) {
            return this.delegate.removeAll(objects);
        }

        @Override
        public boolean retainAll(Collection<?> objects) {
            return this.delegate.retainAll(objects);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public E get(int i) {
            return this.delegate.get(i);
        }

        @Override
        public E set(int i, E e) {
            return this.delegate.set(i, e);
        }

        @Override
        public void add(int i, E e) {
            this.delegate.add(i, e);
        }

        @Override
        public E remove(int i) {
            return this.delegate.remove(i);
        }

        @Override
        public int indexOf(Object o) {
            return this.delegate.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.delegate.lastIndexOf(o);
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.delegate.listIterator();
        }

        @Override
        public ListIterator<E> listIterator(int i) {
            return this.delegate.listIterator(i);
        }

        @Override
        public List<E> subList(int i, int i1) {
            return this.delegate.subList(i, i1);
        }
    }

    public static class MapBuilder<K, V>
    implements Map<K, V> {
        private final Map<K, V> delegate;

        public MapBuilder(Map<K, V> delegate) {
            this.delegate = delegate;
        }

        public MapBuilder<K, V> e(K k, V v) {
            this.delegate.put(k, v);
            return this;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean containsKey(Object o) {
            return this.delegate.containsKey(o);
        }

        @Override
        public boolean containsValue(Object o) {
            return this.delegate.containsValue(o);
        }

        @Override
        public V get(Object o) {
            return this.delegate.get(o);
        }

        @Override
        public V put(K k, V v) {
            return this.delegate.put(k, v);
        }

        @Override
        public V remove(Object o) {
            return this.delegate.remove(o);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            this.delegate.putAll(map);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public Set<K> keySet() {
            return this.delegate.keySet();
        }

        @Override
        public Collection<V> values() {
            return this.delegate.values();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.delegate.entrySet();
        }

        @Override
        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

