/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.auth;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import twitter4j.BASE64Encoder;
import twitter4j.HttpClient;
import twitter4j.HttpClientFactory;
import twitter4j.HttpParameter;
import twitter4j.HttpRequest;
import twitter4j.Logger;
import twitter4j.TwitterException;
import twitter4j.auth.AccessToken;
import twitter4j.auth.Authorization;
import twitter4j.auth.OAuthSupport;
import twitter4j.auth.OAuthToken;
import twitter4j.auth.RequestToken;
import twitter4j.conf.Configuration;

public class OAuthAuthorization
implements Authorization,
Serializable,
OAuthSupport {
    private static final long serialVersionUID = -886869424811858868L;
    private final Configuration conf;
    private static transient HttpClient http;
    private static final String HMAC_SHA1 = "HmacSHA1";
    private static final HttpParameter OAUTH_SIGNATURE_METHOD;
    private static final Logger logger;
    private String consumerKey = "";
    private String consumerSecret;
    private String realm = null;
    private OAuthToken oauthToken = null;
    private static final Random RAND;

    public OAuthAuthorization(Configuration conf) {
        this.conf = conf;
        http = HttpClientFactory.getInstance(conf.getHttpClientConfiguration());
        this.setOAuthConsumer(conf.getOAuthConsumerKey(), conf.getOAuthConsumerSecret());
        if (conf.getOAuthAccessToken() != null && conf.getOAuthAccessTokenSecret() != null) {
            this.setOAuthAccessToken(new AccessToken(conf.getOAuthAccessToken(), conf.getOAuthAccessTokenSecret()));
        }
    }

    @Override
    public String getAuthorizationHeader(HttpRequest req) {
        return this.generateAuthorizationHeader(req.getMethod().name(), req.getURL(), req.getParameters(), this.oauthToken);
    }

    private void ensureTokenIsAvailable() {
        if (null == this.oauthToken) {
            throw new IllegalStateException("No Token available.");
        }
    }

    @Override
    public boolean isEnabled() {
        return this.oauthToken != null && this.oauthToken instanceof AccessToken;
    }

    @Override
    public RequestToken getOAuthRequestToken() throws TwitterException {
        return this.getOAuthRequestToken(null, null, null);
    }

    @Override
    public RequestToken getOAuthRequestToken(String callbackURL) throws TwitterException {
        return this.getOAuthRequestToken(callbackURL, null, null);
    }

    @Override
    public RequestToken getOAuthRequestToken(String callbackURL, String xAuthAccessType) throws TwitterException {
        return this.getOAuthRequestToken(callbackURL, xAuthAccessType, null);
    }

    @Override
    public RequestToken getOAuthRequestToken(String callbackURL, String xAuthAccessType, String xAuthMode) throws TwitterException {
        if (this.oauthToken instanceof AccessToken) {
            throw new IllegalStateException("Access token already available.");
        }
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        if (callbackURL != null) {
            params.add(new HttpParameter("oauth_callback", callbackURL));
        }
        if (xAuthAccessType != null) {
            params.add(new HttpParameter("x_auth_access_type", xAuthAccessType));
        }
        if (xAuthMode != null) {
            params.add(new HttpParameter("x_auth_mode", xAuthMode));
        }
        this.oauthToken = new RequestToken(http.post(this.conf.getOAuthRequestTokenURL(), params.toArray(new HttpParameter[params.size()]), this, null), this);
        return (RequestToken)this.oauthToken;
    }

    @Override
    public AccessToken getOAuthAccessToken() throws TwitterException {
        this.ensureTokenIsAvailable();
        if (this.oauthToken instanceof AccessToken) {
            return (AccessToken)this.oauthToken;
        }
        this.oauthToken = new AccessToken(http.post(this.conf.getOAuthAccessTokenURL(), null, this, null));
        return (AccessToken)this.oauthToken;
    }

    @Override
    public AccessToken getOAuthAccessToken(String oauthVerifier) throws TwitterException {
        this.ensureTokenIsAvailable();
        this.oauthToken = new AccessToken(http.post(this.conf.getOAuthAccessTokenURL(), new HttpParameter[]{new HttpParameter("oauth_verifier", oauthVerifier)}, this, null));
        return (AccessToken)this.oauthToken;
    }

    @Override
    public AccessToken getOAuthAccessToken(RequestToken requestToken) throws TwitterException {
        this.oauthToken = requestToken;
        return this.getOAuthAccessToken();
    }

    @Override
    public AccessToken getOAuthAccessToken(RequestToken requestToken, String oauthVerifier) throws TwitterException {
        this.oauthToken = requestToken;
        return this.getOAuthAccessToken(oauthVerifier);
    }

    @Override
    public AccessToken getOAuthAccessToken(String screenName, String password) throws TwitterException {
        try {
            String url = this.conf.getOAuthAccessTokenURL();
            if (0 == url.indexOf("http://")) {
                url = "https://" + url.substring(7);
            }
            this.oauthToken = new AccessToken(http.post(url, new HttpParameter[]{new HttpParameter("x_auth_username", screenName), new HttpParameter("x_auth_password", password), new HttpParameter("x_auth_mode", "client_auth")}, this, null));
            return (AccessToken)this.oauthToken;
        }
        catch (TwitterException te) {
            throw new TwitterException("The screen name / password combination seems to be invalid.", te, te.getStatusCode());
        }
    }

    @Override
    public void setOAuthAccessToken(AccessToken accessToken) {
        this.oauthToken = accessToken;
    }

    public void setOAuthRealm(String realm) {
        this.realm = realm;
    }

    String generateAuthorizationHeader(String method, String url, HttpParameter[] params, String nonce, String timestamp, OAuthToken otoken) {
        if (null == params) {
            params = new HttpParameter[]{};
        }
        ArrayList<HttpParameter> oauthHeaderParams = new ArrayList<HttpParameter>(5);
        oauthHeaderParams.add(new HttpParameter("oauth_consumer_key", this.consumerKey));
        oauthHeaderParams.add(OAUTH_SIGNATURE_METHOD);
        oauthHeaderParams.add(new HttpParameter("oauth_timestamp", timestamp));
        oauthHeaderParams.add(new HttpParameter("oauth_nonce", nonce));
        oauthHeaderParams.add(new HttpParameter("oauth_version", "1.0"));
        if (otoken != null) {
            oauthHeaderParams.add(new HttpParameter("oauth_token", otoken.getToken()));
        }
        ArrayList<HttpParameter> signatureBaseParams = new ArrayList<HttpParameter>(oauthHeaderParams.size() + params.length);
        signatureBaseParams.addAll(oauthHeaderParams);
        if (!HttpParameter.containsFile(params)) {
            signatureBaseParams.addAll(OAuthAuthorization.toParamList(params));
        }
        this.parseGetParameters(url, signatureBaseParams);
        StringBuilder base = new StringBuilder(method).append("&").append(HttpParameter.encode(OAuthAuthorization.constructRequestURL(url))).append("&");
        base.append(HttpParameter.encode(OAuthAuthorization.normalizeRequestParameters(signatureBaseParams)));
        String oauthBaseString = base.toString();
        logger.debug("OAuth base string: ", oauthBaseString);
        String signature = this.generateSignature(oauthBaseString, otoken);
        logger.debug("OAuth signature: ", signature);
        oauthHeaderParams.add(new HttpParameter("oauth_signature", signature));
        if (this.realm != null) {
            oauthHeaderParams.add(new HttpParameter("realm", this.realm));
        }
        return "OAuth " + OAuthAuthorization.encodeParameters(oauthHeaderParams, ",", true);
    }

    private void parseGetParameters(String url, List<HttpParameter> signatureBaseParams) {
        int queryStart = url.indexOf("?");
        if (-1 != queryStart) {
            String[] queryStrs = url.substring(queryStart + 1).split("&");
            try {
                for (String query : queryStrs) {
                    String[] split = query.split("=");
                    if (split.length == 2) {
                        signatureBaseParams.add(new HttpParameter(URLDecoder.decode(split[0], "UTF-8"), URLDecoder.decode(split[1], "UTF-8")));
                        continue;
                    }
                    signatureBaseParams.add(new HttpParameter(URLDecoder.decode(split[0], "UTF-8"), ""));
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    String generateAuthorizationHeader(String method, String url, HttpParameter[] params, OAuthToken token) {
        long timestamp = System.currentTimeMillis() / 1000L;
        long nonce = timestamp + (long)RAND.nextInt();
        return this.generateAuthorizationHeader(method, url, params, String.valueOf(nonce), String.valueOf(timestamp), token);
    }

    public List<HttpParameter> generateOAuthSignatureHttpParams(String method, String url) {
        long timestamp = System.currentTimeMillis() / 1000L;
        long nonce = timestamp + (long)RAND.nextInt();
        ArrayList<HttpParameter> oauthHeaderParams = new ArrayList<HttpParameter>(5);
        oauthHeaderParams.add(new HttpParameter("oauth_consumer_key", this.consumerKey));
        oauthHeaderParams.add(OAUTH_SIGNATURE_METHOD);
        oauthHeaderParams.add(new HttpParameter("oauth_timestamp", timestamp));
        oauthHeaderParams.add(new HttpParameter("oauth_nonce", nonce));
        oauthHeaderParams.add(new HttpParameter("oauth_version", "1.0"));
        if (this.oauthToken != null) {
            oauthHeaderParams.add(new HttpParameter("oauth_token", this.oauthToken.getToken()));
        }
        ArrayList<HttpParameter> signatureBaseParams = new ArrayList<HttpParameter>(oauthHeaderParams.size());
        signatureBaseParams.addAll(oauthHeaderParams);
        this.parseGetParameters(url, signatureBaseParams);
        StringBuilder base = new StringBuilder(method).append("&").append(HttpParameter.encode(OAuthAuthorization.constructRequestURL(url))).append("&");
        base.append(HttpParameter.encode(OAuthAuthorization.normalizeRequestParameters(signatureBaseParams)));
        String oauthBaseString = base.toString();
        String signature = this.generateSignature(oauthBaseString, this.oauthToken);
        oauthHeaderParams.add(new HttpParameter("oauth_signature", signature));
        return oauthHeaderParams;
    }

    String generateSignature(String data, OAuthToken token) {
        byte[] byteHMAC = null;
        try {
            SecretKeySpec spec;
            Mac mac = Mac.getInstance(HMAC_SHA1);
            if (null == token) {
                String oauthSignature = HttpParameter.encode(this.consumerSecret) + "&";
                spec = new SecretKeySpec(oauthSignature.getBytes(), HMAC_SHA1);
            } else {
                spec = token.getSecretKeySpec();
                if (null == spec) {
                    String oauthSignature = HttpParameter.encode(this.consumerSecret) + "&" + HttpParameter.encode(token.getTokenSecret());
                    spec = new SecretKeySpec(oauthSignature.getBytes(), HMAC_SHA1);
                    token.setSecretKeySpec(spec);
                }
            }
            mac.init(spec);
            byteHMAC = mac.doFinal(data.getBytes());
        }
        catch (InvalidKeyException ike) {
            logger.error("Failed initialize \"Message Authentication Code\" (MAC)", ike);
            throw new AssertionError((Object)ike);
        }
        catch (NoSuchAlgorithmException nsae) {
            logger.error("Failed to get HmacSHA1 \"Message Authentication Code\" (MAC)", nsae);
            throw new AssertionError((Object)nsae);
        }
        return BASE64Encoder.encode(byteHMAC);
    }

    String generateSignature(String data) {
        return this.generateSignature(data, null);
    }

    static String normalizeRequestParameters(HttpParameter[] params) {
        return OAuthAuthorization.normalizeRequestParameters(OAuthAuthorization.toParamList(params));
    }

    private static String normalizeRequestParameters(List<HttpParameter> params) {
        Collections.sort(params);
        return OAuthAuthorization.encodeParameters(params);
    }

    private static List<HttpParameter> toParamList(HttpParameter[] params) {
        ArrayList<HttpParameter> paramList = new ArrayList<HttpParameter>(params.length);
        paramList.addAll(Arrays.asList(params));
        return paramList;
    }

    public static String encodeParameters(List<HttpParameter> httpParams) {
        return OAuthAuthorization.encodeParameters(httpParams, "&", false);
    }

    public static String encodeParameters(List<HttpParameter> httpParams, String splitter, boolean quot) {
        StringBuilder buf = new StringBuilder();
        for (HttpParameter param : httpParams) {
            if (param.isFile() || param.isJson()) continue;
            if (buf.length() != 0) {
                if (quot) {
                    buf.append("\"");
                }
                buf.append(splitter);
            }
            buf.append(HttpParameter.encode(param.getName())).append("=");
            if (quot) {
                buf.append("\"");
            }
            buf.append(HttpParameter.encode(param.getValue()));
        }
        if (buf.length() != 0 && quot) {
            buf.append("\"");
        }
        return buf.toString();
    }

    static String constructRequestURL(String url) {
        int slashIndex;
        String baseURL;
        int colonIndex;
        int index = url.indexOf("?");
        if (-1 != index) {
            url = url.substring(0, index);
        }
        if (-1 != (colonIndex = (baseURL = url.substring(0, slashIndex = url.indexOf("/", 8)).toLowerCase()).indexOf(":", 8))) {
            if (baseURL.startsWith("http://") && baseURL.endsWith(":80")) {
                baseURL = baseURL.substring(0, colonIndex);
            } else if (baseURL.startsWith("https://") && baseURL.endsWith(":443")) {
                baseURL = baseURL.substring(0, colonIndex);
            }
        }
        url = baseURL + url.substring(slashIndex);
        return url;
    }

    @Override
    public void setOAuthConsumer(String consumerKey, String consumerSecret) {
        this.consumerKey = consumerKey != null ? consumerKey : "";
        this.consumerSecret = consumerSecret != null ? consumerSecret : "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OAuthSupport)) {
            return false;
        }
        OAuthAuthorization that = (OAuthAuthorization)o;
        if (this.consumerKey != null ? !this.consumerKey.equals(that.consumerKey) : that.consumerKey != null) {
            return false;
        }
        if (this.consumerSecret != null ? !this.consumerSecret.equals(that.consumerSecret) : that.consumerSecret != null) {
            return false;
        }
        return !(this.oauthToken != null ? !this.oauthToken.equals(that.oauthToken) : that.oauthToken != null);
    }

    public int hashCode() {
        int result = this.consumerKey != null ? this.consumerKey.hashCode() : 0;
        result = 31 * result + (this.consumerSecret != null ? this.consumerSecret.hashCode() : 0);
        result = 31 * result + (this.oauthToken != null ? this.oauthToken.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "OAuthAuthorization{consumerKey='" + this.consumerKey + '\'' + ", consumerSecret='******************************************', oauthToken=" + this.oauthToken + '}';
    }

    static {
        OAUTH_SIGNATURE_METHOD = new HttpParameter("oauth_signature_method", "HMAC-SHA1");
        logger = Logger.getLogger(OAuthAuthorization.class);
        RAND = new Random();
    }
}

