/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.project;

import java.nio.file.Path;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.LicenseId;
import org.jreleaser.model.VersionPattern;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.StringUtils;

public final class ProjectValidator {
    private ProjectValidator() {
    }

    public static void validateProject(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        boolean nexusDeployers;
        context.getLogger().debug("project");
        Project project = context.getModel().getProject();
        project.setName(Validator.checkProperty(context, "PROJECT_NAME", "project.name", project.getName(), errors));
        project.setVersion(Validator.checkProperty(context, "PROJECT_VERSION", "project.version", project.getVersion(), errors));
        project.setVersionPattern(Validator.checkProperty(context, "PROJECT_VERSION_PATTERN", "project.versionPattern", project.getVersionPattern(), VersionPattern.Type.SEMVER.toString()));
        project.getSnapshot().setPattern(Validator.checkProperty(context, "PROJECT_SNAPSHOT_PATTERN", "project.snapshot.pattern", project.getSnapshot().getPattern(), ".*-SNAPSHOT"));
        project.getSnapshot().setLabel(Validator.checkProperty(context, "PROJECT_SNAPSHOT_LABEL", "project.snapshot.label", project.getSnapshot().getLabel(), "early-access"));
        project.getSnapshot().getResolvedLabel(context.getModel());
        project.getSnapshot().setFullChangelog(Validator.checkProperty(context, "PROJECT_SNAPSHOT_FULL_CHANGELOG", "project.snapshot.fullChangelog", project.getSnapshot().getFullChangelog(), false));
        if (project.versionPattern().getType() == VersionPattern.Type.CALVER && StringUtils.isBlank((String)project.versionPattern().getFormat())) {
            errors.configuration(RB.$((String)"validation_version_format_missing", (Object[])new Object[]{"project.versionPattern", VersionPattern.Type.CALVER.toString()}));
        }
        boolean javaDistributions = context.getModel().getDistributions().values().stream().map(Distribution::getType).anyMatch(type -> type == Distribution.DistributionType.JAVA_BINARY || type == Distribution.DistributionType.SINGLE_JAR || type == Distribution.DistributionType.NATIVE_PACKAGE) || context.getModel().getDistributions().values().stream().anyMatch(distribution -> distribution.getType() == Distribution.DistributionType.BINARY && StringUtils.isTrue((Object)distribution.getExtraProperties().get("graalVMNativeImage")));
        boolean javaAssemblers = !context.getModel().getAssemble().getJlink().isEmpty() || !context.getModel().getAssemble().getJpackage().isEmpty() || !context.getModel().getAssemble().getNativeImage().isEmpty();
        boolean bl = nexusDeployers = !context.getModel().getDeploy().getMaven().getNexus2().isEmpty();
        if (javaAssemblers || nexusDeployers || mode.validateConfig() && javaDistributions) {
            ProjectValidator.validateJava(context, project, errors);
        }
        Validator.validateScreenshots(project.getScreenshots(), errors, "project");
        Validator.validateIcons(project.getIcons(), errors, "project");
    }

    public static void postValidateProject(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        context.getLogger().debug("project");
        Project project = context.getModel().getProject();
        if (null == project.getInceptionYear() && project.getExtraProperties().containsKey("inceptionYear")) {
            project.setInceptionYear(project.getExtraProperty("inceptionYear"));
            context.nag("1.2.0", "Use project.inceptionYear instead of project.extraProperties.inceptionYear");
        }
        if (StringUtils.isBlank((String)project.getLinks().getLicense()) && StringUtils.isNotBlank((String)project.getLicense())) {
            LicenseId.findByLiteral((String)project.getLicense()).ifPresent(licenseId -> project.getLinks().setLicense(licenseId.url()));
        }
        if (StringUtils.isBlank((String)project.getLinks().getLicense()) && null != context.getModel().getCommit()) {
            FileUtils.findLicenseFile((Path)context.getBasedir()).ifPresent(path -> {
                BaseReleaser<?, ?> service = context.getModel().getRelease().getReleaser();
                String srcUrl = service.getResolvedSrcUrl(context.getModel());
                if (!srcUrl.endsWith("/")) {
                    srcUrl = srcUrl + "/";
                }
                srcUrl = srcUrl + path.getFileName().toString();
                project.getLinks().setLicense(srcUrl);
            });
        }
        if (StringUtils.isBlank((String)project.getLinks().getVcsBrowser())) {
            project.getLinks().setVcsBrowser(context.getModel().getRelease().getReleaser().getRepoUrl());
        }
        if (StringUtils.isBlank((String)project.getLinks().getBugTracker())) {
            project.getLinks().setBugTracker(context.getModel().getRelease().getReleaser().getIssueTrackerUrl());
        }
        if (StringUtils.isBlank((String)project.getLinks().getDocumentation())) {
            project.getLinks().setDocumentation(project.getLinks().getHomepage());
        }
        if (context.getModel().getAssemble().isEnabled()) {
            if (StringUtils.isBlank((String)project.getDescription())) {
                errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"project.description"}));
            }
            if (StringUtils.isBlank((String)project.getCopyright())) {
                if (null != project.getInceptionYear() && !project.getAuthors().isEmpty()) {
                    project.setCopyright(project.getInceptionYear() + " " + String.join((CharSequence)", ", project.getAuthors()));
                } else {
                    errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"project.copyright"}));
                }
            }
        }
        if (!mode.validateConfig() && !mode.validateAnnounce()) {
            return;
        }
        if (context.getModel().getActiveDistributions().isEmpty() && !context.getModel().getAnnounce().isEnabled()) {
            return;
        }
        if (StringUtils.isBlank((String)project.getCopyright())) {
            if (null != project.getInceptionYear() && !project.getAuthors().isEmpty()) {
                project.setCopyright(project.getInceptionYear() + " " + String.join((CharSequence)", ", project.getAuthors()));
            } else {
                errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"project.copyright"}));
            }
        }
        if (StringUtils.isBlank((String)project.getDescription())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"project.description"}));
        }
        if (StringUtils.isBlank((String)project.getLinks().getHomepage())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"project.website"}));
        }
        if (StringUtils.isBlank((String)project.getLinks().getDocumentation())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"project.docsUrl"}));
        }
        if (StringUtils.isBlank((String)project.getLicense())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"project.license"}));
        }
        if (StringUtils.isBlank((String)project.getLongDescription())) {
            project.setLongDescription(project.getDescription());
        }
        if (project.getAuthors().isEmpty()) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"project.authors"}));
        }
    }

    private static void validateJava(JReleaserContext context, Project project, Errors errors) {
        context.getLogger().debug("project.java");
        if (!project.getJava().isSet()) {
            return;
        }
        project.getJava().setEnabled(true);
        if (StringUtils.isBlank((String)project.getJava().getArtifactId())) {
            project.getJava().setArtifactId(project.getName());
        }
        if (StringUtils.isBlank((String)project.getJava().getGroupId())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"project.java.groupId"}));
        }
        if (StringUtils.isBlank((String)project.getJava().getArtifactId())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"project.java.artifactId"}));
        }
        if (!project.getJava().isMultiProjectSet()) {
            project.getJava().setMultiProject(false);
        }
    }
}

