/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.upload;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.ExtraProperties;
import org.jreleaser.model.internal.upload.Uploader;
import org.jreleaser.model.internal.util.Artifacts;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.StringUtils;

public abstract class AbstractUploader<A extends org.jreleaser.model.api.upload.Uploader, S extends AbstractUploader<A, S>>
extends AbstractActivatable<S>
implements Uploader<A>,
ExtraProperties {
    private static final long serialVersionUID = 2011958303607038304L;
    @JsonIgnore
    private final String type;
    private final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    @JsonIgnore
    private String name;
    private int connectTimeout;
    private int readTimeout;
    protected Boolean artifacts;
    protected Boolean files;
    protected Boolean signatures;
    protected Boolean checksums;
    protected Boolean catalogs;

    protected AbstractUploader(String type) {
        this.type = type;
    }

    @Override
    public void merge(S source) {
        super.merge(source);
        this.name = this.merge(this.name, ((AbstractUploader)source).getName());
        this.connectTimeout = this.merge(this.getConnectTimeout(), ((AbstractUploader)source).getConnectTimeout());
        this.readTimeout = this.merge(this.getReadTimeout(), ((AbstractUploader)source).getReadTimeout());
        this.artifacts = this.merge(this.artifacts, ((AbstractUploader)source).artifacts);
        this.files = this.merge(this.files, ((AbstractUploader)source).files);
        this.signatures = this.merge(this.signatures, ((AbstractUploader)source).signatures);
        this.checksums = this.merge(this.checksums, ((AbstractUploader)source).checksums);
        this.catalogs = this.merge(this.catalogs, ((AbstractUploader)source).catalogs);
        this.setExtraProperties(this.merge(this.extraProperties, ((AbstractUploader)source).getExtraProperties()));
    }

    @Override
    public String prefix() {
        return this.getType();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isSnapshotSupported() {
        return true;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public boolean isArtifacts() {
        return null == this.artifacts || this.artifacts != false;
    }

    @Override
    public void setArtifacts(Boolean artifacts) {
        this.artifacts = artifacts;
    }

    @Override
    public boolean isArtifactsSet() {
        return null != this.artifacts;
    }

    @Override
    public boolean isFiles() {
        return null == this.files || this.files != false;
    }

    @Override
    public void setFiles(Boolean files) {
        this.files = files;
    }

    @Override
    public boolean isFilesSet() {
        return null != this.files;
    }

    @Override
    public boolean isSignatures() {
        return null == this.signatures || this.signatures != false;
    }

    @Override
    public void setSignatures(Boolean signatures) {
        this.signatures = signatures;
    }

    @Override
    public boolean isSignaturesSet() {
        return null != this.signatures;
    }

    @Override
    public boolean isChecksumsSet() {
        return null != this.checksums;
    }

    @Override
    public boolean isChecksums() {
        return null == this.checksums || this.checksums != false;
    }

    @Override
    public void setChecksums(Boolean checksums) {
        this.checksums = checksums;
    }

    @Override
    public boolean isCatalogsSet() {
        return null != this.catalogs;
    }

    @Override
    public boolean isCatalogs() {
        return null == this.catalogs || this.catalogs != false;
    }

    @Override
    public void setCatalogs(Boolean catalogs) {
        this.catalogs = catalogs;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("enabled", this.isEnabled());
        props.put("active", this.getActive());
        props.put("connectTimeout", this.connectTimeout);
        props.put("readTimeout", this.readTimeout);
        props.put("artifacts", this.isArtifacts());
        props.put("files", this.isFiles());
        props.put("signatures", this.isSignatures());
        props.put("checksums", this.isChecksums());
        props.put("catalogs", this.isCatalogs());
        this.asMap(full, props);
        props.put("extraProperties", this.resolvedExtraProperties());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(this.getName(), props);
        return map;
    }

    protected abstract void asMap(boolean var1, Map<String, Object> var2);

    @Override
    public List<String> resolveSkipKeys() {
        String skipUpload = "skipUpload";
        String skipUploadByType = skipUpload + StringUtils.capitalize((String)this.type);
        String skipUploadByName = skipUploadByType + StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)this.name);
        return CollectionUtils.listOf((Object[])new String[]{skipUpload, skipUploadByType, skipUploadByName});
    }

    @Override
    public TemplateContext artifactProps(JReleaserContext context, Artifact artifact) {
        return this.artifactProps(context.fullProps(), artifact);
    }

    @Override
    public TemplateContext artifactProps(TemplateContext props, Artifact artifact) {
        props.set("uploaderName", (Object)this.getName());
        Artifacts.artifactProps(artifact, props);
        LinkedHashSet keys = new LinkedHashSet(props.keys());
        keys.stream().filter(k -> k.contains("skip") || k.contains("Skip")).forEach(arg_0 -> ((TemplateContext)props).remove(arg_0));
        return props;
    }
}

