/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.hooks;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.hooks.Hook;

public abstract class AbstractHook<S extends AbstractHook<S>>
extends AbstractActivatable<S>
implements Hook {
    private static final long serialVersionUID = -8314368794997861783L;
    private final Hook.Filter filter = new Hook.Filter();
    protected Boolean continueOnError;

    @Override
    public void merge(S source) {
        super.merge(source);
        this.continueOnError = this.merge(this.continueOnError, ((AbstractHook)source).continueOnError);
        this.setFilter(((AbstractHook)source).getFilter());
    }

    @Override
    public boolean isContinueOnError() {
        return null != this.continueOnError && this.continueOnError != false;
    }

    @Override
    public void setContinueOnError(Boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    @Override
    public boolean isContinueOnErrorSet() {
        return null != this.continueOnError;
    }

    @Override
    public Hook.Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Hook.Filter filter) {
        this.filter.merge(filter);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("active", this.getActive());
        map.put("continueOnError", this.isContinueOnError());
        Map<String, Object> filterAsMap = this.filter.asMap(full);
        if (full || !filterAsMap.isEmpty()) {
            map.put("filter", filterAsMap);
        }
        this.asMap(full, map);
        return map;
    }

    protected abstract void asMap(boolean var1, Map<String, Object> var2);
}

