/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.announce;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.announce.ArticleAnnouncer;
import org.jreleaser.model.internal.announce.AbstractAnnouncer;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.CommitAuthor;
import org.jreleaser.model.internal.common.CommitAuthorAware;
import org.jreleaser.model.internal.packagers.AbstractRepositoryTap;

public final class ArticleAnnouncer
extends AbstractAnnouncer<ArticleAnnouncer, org.jreleaser.model.api.announce.ArticleAnnouncer>
implements CommitAuthorAware {
    private static final long serialVersionUID = 8118441310808540594L;
    private final Set<Artifact> files = new LinkedHashSet<Artifact>();
    private final CommitAuthor commitAuthor = new CommitAuthor();
    private final Repository repository = new Repository();
    private String templateDirectory;
    @JsonIgnore
    private final org.jreleaser.model.api.announce.ArticleAnnouncer immutable = new org.jreleaser.model.api.announce.ArticleAnnouncer(){
        private static final long serialVersionUID = 6971332126023008307L;
        private Set<? extends org.jreleaser.model.api.common.Artifact> files;

        public String getType() {
            return "article";
        }

        public Set<? extends org.jreleaser.model.api.common.Artifact> getFiles() {
            if (null == this.files) {
                this.files = ArticleAnnouncer.this.files.stream().map(Artifact::asImmutable).collect(Collectors.toSet());
            }
            return this.files;
        }

        public ArticleAnnouncer.Repository getRepository() {
            return ArticleAnnouncer.this.repository.asImmutable();
        }

        public String getTemplateDirectory() {
            return ArticleAnnouncer.this.templateDirectory;
        }

        public String getName() {
            return ArticleAnnouncer.this.getName();
        }

        public boolean isSnapshotSupported() {
            return ArticleAnnouncer.this.isSnapshotSupported();
        }

        public Active getActive() {
            return ArticleAnnouncer.this.getActive();
        }

        public boolean isEnabled() {
            return ArticleAnnouncer.this.isEnabled();
        }

        public org.jreleaser.model.api.common.CommitAuthor getCommitAuthor() {
            return ArticleAnnouncer.this.commitAuthor.asImmutable();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(ArticleAnnouncer.this.asMap(full));
        }

        public String getPrefix() {
            return ArticleAnnouncer.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(ArticleAnnouncer.this.getExtraProperties());
        }

        public Integer getConnectTimeout() {
            return ArticleAnnouncer.this.getConnectTimeout();
        }

        public Integer getReadTimeout() {
            return ArticleAnnouncer.this.getReadTimeout();
        }
    };

    public ArticleAnnouncer() {
        super("article");
    }

    @Override
    public org.jreleaser.model.api.announce.ArticleAnnouncer asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(ArticleAnnouncer source) {
        super.merge(source);
        this.templateDirectory = this.merge(this.templateDirectory, source.templateDirectory);
        this.setFiles(this.merge(this.files, source.files));
        this.setCommitAuthor(source.commitAuthor);
        this.setRepository(source.repository);
    }

    public Set<Artifact> getFiles() {
        return Artifact.sortArtifacts(this.files);
    }

    public void setFiles(Set<Artifact> files) {
        this.files.clear();
        this.files.addAll(files);
    }

    public void addFiles(Set<Artifact> files) {
        this.files.addAll(files);
    }

    public void addFile(Artifact artifact) {
        if (null != artifact) {
            this.files.add(artifact);
        }
    }

    @Override
    public CommitAuthor getCommitAuthor() {
        return this.commitAuthor;
    }

    @Override
    public void setCommitAuthor(CommitAuthor commitAuthor) {
        this.commitAuthor.merge(commitAuthor);
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository.merge(repository);
    }

    public String getTemplateDirectory() {
        return this.templateDirectory;
    }

    public void setTemplateDirectory(String templateDirectory) {
        this.templateDirectory = templateDirectory;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("commitAuthor", this.commitAuthor.asMap(full));
        props.put("repository", this.repository.asMap(full));
        LinkedHashMap<String, Map<String, Object>> mappedArtifacts = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (Artifact artifact : this.getFiles()) {
            mappedArtifacts.put("files " + i++, artifact.asMap(full));
        }
        props.put("files", mappedArtifacts);
        props.put("templateDirectory", this.templateDirectory);
    }

    public static final class Repository
    extends AbstractRepositoryTap<Repository> {
        private static final long serialVersionUID = -1923514428336002946L;
        @JsonIgnore
        private final ArticleAnnouncer.Repository immutable = new ArticleAnnouncer.Repository(){
            private static final long serialVersionUID = 4466712256400781859L;

            public String getBasename() {
                return this.getBasename();
            }

            public String getCanonicalRepoName() {
                return this.getCanonicalRepoName();
            }

            public String getName() {
                return this.getName();
            }

            public String getTagName() {
                return this.getTagName();
            }

            public String getBranch() {
                return this.getBranch();
            }

            public String getUsername() {
                return this.getUsername();
            }

            public String getToken() {
                return this.getToken();
            }

            public String getCommitMessage() {
                return this.getCommitMessage();
            }

            public Active getActive() {
                return this.getActive();
            }

            public boolean isEnabled() {
                return this.isEnabled();
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }

            public String getOwner() {
                return this.getOwner();
            }
        };

        public Repository() {
            super("article", "article");
        }

        private ArticleAnnouncer.Repository asImmutable() {
            return this.immutable;
        }
    }
}

