/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.git;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Changelog;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.release.Changelog;
import org.jreleaser.model.internal.util.VersionUtils;
import org.jreleaser.model.spi.release.User;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.sdk.git.ChangelogProvider;
import org.jreleaser.sdk.git.GitSdk;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.ComparatorUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.version.Version;

public class ChangelogGenerator {
    private static final String UNCATEGORIZED = "<<UNCATEGORIZED>>";
    private static final String REGEX_PREFIX = "regex:";

    protected String createChangelog(JReleaserContext context) throws IOException {
        BaseReleaser releaser = context.getModel().getRelease().getReleaser();
        Changelog changelog = releaser.getChangelog();
        String separator = System.lineSeparator();
        if ("gitlab".equals(releaser.getServiceName())) {
            separator = separator + System.lineSeparator();
        }
        String commitSeparator = separator;
        try {
            Git git = GitSdk.of(context).open();
            context.getLogger().debug(RB.$((String)"changelog.generator.resolve.commits", (Object[])new Object[0]));
            Iterable<RevCommit> commits = this.resolveCommits(git, context);
            Comparator<RevCommit> revCommitComparator = Comparator.comparing(RevCommit::getCommitTime).reversed();
            if (changelog.getSort() == Changelog.Sort.ASC) {
                revCommitComparator = Comparator.comparing(RevCommit::getCommitTime);
            }
            context.getLogger().debug(RB.$((String)"changelog.generator.sort.commits", (Object[])new Object[0]), new Object[]{changelog.getSort()});
            List<RevCommit> commitList = StreamSupport.stream(commits.spliterator(), false).filter(c -> !changelog.isSkipMergeCommits() || c.getParentCount() <= 1).collect(Collectors.toList());
            if (context.getModel().getRelease().getReleaser().getIssues().isEnabled()) {
                String rawContent = commitList.stream().map(RevCommit::getFullMessage).collect(Collectors.joining(System.lineSeparator()));
                context.getLogger().info(RB.$((String)"issues.generator.extract", (Object[])new Object[0]));
                Set<Integer> issues = ChangelogProvider.extractIssues(context, rawContent);
                ChangelogProvider.storeIssues(context, issues);
            }
            if (changelog.resolveFormatted(context.getModel().getProject())) {
                return this.formatChangelog(context, changelog, commitList, revCommitComparator, commitSeparator);
            }
            String commitsUrl = releaser.getResolvedCommitUrl(context.getModel());
            return "## Changelog" + System.lineSeparator() + System.lineSeparator() + commitList.stream().sorted(revCommitComparator).map(commit -> this.formatCommit((RevCommit)commit, commitsUrl, changelog, commitSeparator)).collect(Collectors.joining(commitSeparator));
        }
        catch (GitAPIException e) {
            throw new IOException(e);
        }
    }

    protected String formatCommit(RevCommit commit, String commitsUrl, Changelog changelog, String commitSeparator) {
        String commitHash = commit.getId().name();
        String abbreviation = commit.getId().abbreviate(7).name();
        String[] input = commit.getFullMessage().trim().split(System.lineSeparator());
        ArrayList<String> lines = new ArrayList<String>();
        if (changelog.isLinks()) {
            lines.add("[" + abbreviation + "](" + commitsUrl + "/" + commitHash + ") " + input[0].trim());
        } else {
            lines.add(abbreviation + " " + input[0].trim());
        }
        return String.join((CharSequence)commitSeparator, lines);
    }

    private Version version(JReleaserContext context, Ref tag, Pattern versionPattern) {
        return this.version(context, tag, versionPattern, false);
    }

    private Version version(JReleaserContext context, Ref tag, Pattern versionPattern, boolean strict) {
        return VersionUtils.version((JReleaserContext)context, (String)GitSdk.extractTagName(tag), (Pattern)versionPattern, (boolean)strict);
    }

    private Version defaultVersion(JReleaserContext context) {
        return VersionUtils.defaultVersion((JReleaserContext)context);
    }

    public Tags resolveTags(Git git, JReleaserContext context) throws GitAPIException {
        Project.Snapshot snapshot;
        String effectiveLabel;
        GitSdk gitSdk = GitSdk.of(context);
        if (gitSdk.isShallow()) {
            context.getLogger().warn(RB.$((String)"changelog.shallow.warning", (Object[])new Object[0]));
        }
        List tags = git.tagList().call();
        BaseReleaser releaser = context.getModel().getRelease().getReleaser();
        String effectiveTagName = releaser.getEffectiveTagName(context.getModel());
        String tagName = releaser.getTagName();
        String tagPattern = tagName.replaceAll("\\{\\{.*}}", "\\.\\*");
        Pattern versionPattern = VersionUtils.resolveVersionPattern((JReleaserContext)context);
        VersionUtils.clearUnparseableTags();
        tags.sort((tag1, tag2) -> {
            Version v1 = this.version(context, (Ref)tag1, versionPattern);
            Version v2 = this.version(context, (Ref)tag2, versionPattern);
            return v2.compareTo((Object)v1);
        });
        context.getLogger().debug(RB.$((String)"changelog.generator.lookup.tag", (Object[])new Object[0]), new Object[]{effectiveTagName});
        Optional<Object> tag = tags.stream().filter(ref -> GitSdk.extractTagName(ref).equals(effectiveTagName)).findFirst();
        Optional<Object> previousTag = Optional.empty();
        String previousTagName = releaser.getResolvedPreviousTagName(context.getModel());
        if (StringUtils.isNotBlank((String)previousTagName)) {
            context.getLogger().debug(RB.$((String)"changelog.generator.lookup.previous.tag", (Object[])new Object[0]), new Object[]{previousTagName});
            previousTag = tags.stream().filter(ref -> GitSdk.extractTagName(ref).equals(previousTagName)).findFirst();
        }
        Version currentVersion = context.getModel().getProject().version();
        Version defaultVersion = this.defaultVersion(context);
        if (context.getModel().getProject().isSnapshot() && (effectiveLabel = (snapshot = context.getModel().getProject().getSnapshot()).getEffectiveLabel()).equals(effectiveTagName)) {
            if (snapshot.isFullChangelog()) {
                tag = Optional.empty();
            }
            if (!tag.isPresent()) {
                if (previousTag.isPresent()) {
                    tag = previousTag;
                }
                if (!tag.isPresent()) {
                    context.getLogger().debug(RB.$((String)"changelog.generator.lookup.matching.tag", (Object[])new Object[0]), new Object[]{tagPattern, effectiveTagName});
                    tag = tags.stream().filter(ref -> !GitSdk.extractTagName(ref).equals(effectiveTagName)).filter(ref -> versionPattern.matcher(GitSdk.extractTagName(ref)).matches()).filter(ref -> currentVersion.equalsSpec(this.version(context, (Ref)ref, versionPattern, true))).filter(ref -> !defaultVersion.equals(this.version(context, (Ref)ref, versionPattern, true))).findFirst();
                }
            } else {
                previousTag = tags.stream().filter(ref -> GitSdk.extractTagName(ref).matches(tagPattern)).filter(ref -> !defaultVersion.equals(this.version(context, (Ref)ref, versionPattern, true))).filter(ref -> ComparatorUtils.lessThan((Comparable)this.version(context, (Ref)ref, versionPattern, true), (Comparable)currentVersion)).findFirst();
                if (previousTag.isPresent()) {
                    RevCommit earlyAccessCommit = gitSdk.resolveSingleCommit(git, (Ref)tag.get());
                    RevCommit previousTagCommit = gitSdk.resolveSingleCommit(git, (Ref)previousTag.get());
                    if (previousTagCommit.getCommitTime() > earlyAccessCommit.getCommitTime()) {
                        tag = previousTag;
                    }
                }
            }
            if (tag.isPresent()) {
                context.getLogger().debug(RB.$((String)"changelog.generator.tag.found", (Object[])new Object[0]), new Object[]{GitSdk.extractTagName((Ref)tag.get())});
                context.getModel().getRelease().getReleaser().setPreviousTagName(GitSdk.extractTagName((Ref)tag.get()));
                return Tags.previous((Ref)tag.get());
            }
            return Tags.empty();
        }
        if (!tag.isPresent()) {
            if (previousTag.isPresent()) {
                tag = previousTag;
            }
            if (!tag.isPresent()) {
                context.getLogger().debug(RB.$((String)"changelog.generator.lookup.matching.tag", (Object[])new Object[0]), new Object[]{tagPattern, effectiveTagName});
                tag = tags.stream().filter(ref -> !GitSdk.extractTagName(ref).equals(effectiveTagName)).filter(ref -> versionPattern.matcher(GitSdk.extractTagName(ref)).matches()).filter(ref -> currentVersion.equalsSpec(this.version(context, (Ref)ref, versionPattern, true))).filter(ref -> !defaultVersion.equals(this.version(context, (Ref)ref, versionPattern, true))).findFirst();
            }
            if (tag.isPresent()) {
                context.getLogger().debug(RB.$((String)"changelog.generator.tag.found", (Object[])new Object[0]), new Object[]{GitSdk.extractTagName((Ref)tag.get())});
                context.getModel().getRelease().getReleaser().setPreviousTagName(GitSdk.extractTagName((Ref)tag.get()));
                return Tags.previous((Ref)tag.get());
            }
            return Tags.empty();
        }
        if (!previousTag.isPresent()) {
            context.getLogger().debug(RB.$((String)"changelog.generator.lookup.before.tag", (Object[])new Object[0]), new Object[]{effectiveTagName, tagPattern});
            previousTag = tags.stream().filter(ref -> GitSdk.extractTagName(ref).matches(tagPattern)).filter(ref -> !defaultVersion.equals(this.version(context, (Ref)ref, versionPattern, true))).filter(ref -> ComparatorUtils.lessThan((Comparable)this.version(context, (Ref)ref, versionPattern, true), (Comparable)currentVersion)).findFirst();
        }
        if (previousTag.isPresent()) {
            context.getLogger().debug(RB.$((String)"changelog.generator.tag.found", (Object[])new Object[0]), new Object[]{GitSdk.extractTagName((Ref)previousTag.get())});
            context.getModel().getRelease().getReleaser().setPreviousTagName(GitSdk.extractTagName((Ref)previousTag.get()));
            return Tags.of((Ref)tag.get(), (Ref)previousTag.get());
        }
        return Tags.current((Ref)tag.get());
    }

    protected Iterable<RevCommit> resolveCommits(Git git, JReleaserContext context) throws GitAPIException, IOException {
        Ref fromRef;
        Project.Snapshot snapshot;
        String effectiveLabel;
        Tags tags = this.resolveTags(git, context);
        BaseReleaser releaser = context.getModel().getRelease().getReleaser();
        ObjectId head = git.getRepository().resolve("HEAD");
        if (context.getModel().getProject().isSnapshot() && (effectiveLabel = (snapshot = context.getModel().getProject().getSnapshot()).getEffectiveLabel()).equals(releaser.getEffectiveTagName(context.getModel()))) {
            if (tags.getPrevious().isPresent()) {
                Ref fromRef2 = tags.getPrevious().get();
                return git.log().addRange((AnyObjectId)this.getObjectId(git, fromRef2), (AnyObjectId)head).call();
            }
            return git.log().add((AnyObjectId)head).call();
        }
        if (!tags.getCurrent().isPresent()) {
            if (tags.getPrevious().isPresent()) {
                fromRef = tags.getPrevious().get();
                return git.log().addRange((AnyObjectId)this.getObjectId(git, fromRef), (AnyObjectId)head).call();
            }
            return git.log().add((AnyObjectId)head).call();
        }
        if (tags.getPrevious().isPresent()) {
            fromRef = this.getObjectId(git, tags.getPrevious().get());
            ObjectId toRef = this.getObjectId(git, tags.getCurrent().get());
            return git.log().addRange((AnyObjectId)fromRef, (AnyObjectId)toRef).call();
        }
        ObjectId toRef = this.getObjectId(git, tags.getCurrent().get());
        return git.log().add((AnyObjectId)toRef).call();
    }

    private ObjectId getObjectId(Git git, Ref ref) throws IOException {
        Ref peeled = git.getRepository().getRefDatabase().peel(ref);
        return null != peeled.getPeeledObjectId() ? peeled.getPeeledObjectId() : peeled.getObjectId();
    }

    protected String formatChangelog(JReleaserContext context, Changelog changelog, List<RevCommit> commits, Comparator<RevCommit> revCommitComparator, String lineSeparator) {
        TreeSet<Contributor> contributors = new TreeSet<Contributor>();
        LinkedHashMap categories = new LinkedHashMap();
        commits.stream().sorted(revCommitComparator).map(rc -> "conventional-commits".equals(changelog.getPreset()) ? ConventionalCommit.of(rc) : Commit.of(rc)).map(c -> c.extractIssues(context)).peek(c -> {
            this.applyLabels((Commit)c, changelog.getLabelers());
            if (!changelog.getContributors().isEnabled()) {
                return;
            }
            if (!changelog.getHide().containsContributor(((Commit)c).author.name)) {
                contributors.add(new Contributor(((Commit)c).author));
            }
            ((Commit)c).committers.stream().filter(author -> !changelog.getHide().containsContributor(author.name)).forEach(author -> contributors.add(new Contributor((Author)author)));
        }).filter(c -> this.checkLabels((Commit)c, changelog)).forEach(commit -> categories.computeIfAbsent(this.categorize((Commit)commit, changelog), k -> new ArrayList()).add(commit));
        BaseReleaser releaser = context.getModel().getRelease().getReleaser();
        String commitsUrl = releaser.getResolvedCommitUrl(context.getModel());
        String issueTracker = releaser.getResolvedIssueTrackerUrl(context.getModel(), true);
        TemplateContext props = context.fullProps();
        props.setAll(changelog.resolvedExtraProperties());
        StringBuilder changes = new StringBuilder();
        for (Changelog.Category category : changelog.getCategories()) {
            String categoryKey = category.getKey();
            if (!categories.containsKey(categoryKey) || changelog.getHide().containsCategory(categoryKey)) continue;
            props.set("categoryTitle", (Object)category.getTitle());
            changes.append(MustacheUtils.applyTemplate((String)changelog.getCategoryTitleFormat(), (TemplateContext)props)).append(lineSeparator);
            String categoryFormat = this.resolveCommitFormat(changelog, category);
            if (this.isConventionalCommits(changelog) && this.isCategorizeScopes(changelog)) {
                Map<String, List<Commit>> scopes = ((List)categories.get(categoryKey)).stream().collect(Collectors.groupingBy(commit -> {
                    ConventionalCommit cc = (ConventionalCommit)commit;
                    return StringUtils.isNotBlank((String)cc.ccScope) ? cc.ccScope : UNCATEGORIZED;
                }));
                scopes.keySet().stream().sorted().filter(scope -> !UNCATEGORIZED.equals(scope)).forEach(scope -> changes.append("**").append((String)scope).append("**").append(lineSeparator).append(((List)scopes.get(scope)).stream().map(c -> {
                    ((ConventionalCommit)c).ccScope = "";
                    return Templates.resolveTemplate((String)categoryFormat, (TemplateContext)c.asContext(changelog.isLinks(), commitsUrl, issueTracker));
                }).collect(Collectors.joining(lineSeparator))).append(lineSeparator).append(System.lineSeparator()));
                if (!scopes.containsKey(UNCATEGORIZED)) continue;
                if (scopes.size() > 1) {
                    changes.append("**unscoped**");
                }
                changes.append(lineSeparator).append(scopes.get(UNCATEGORIZED).stream().map(c -> Templates.resolveTemplate((String)categoryFormat, (TemplateContext)c.asContext(changelog.isLinks(), commitsUrl, issueTracker))).collect(Collectors.joining(lineSeparator))).append(lineSeparator).append(System.lineSeparator());
                continue;
            }
            changes.append(((List)categories.get(categoryKey)).stream().map(c -> Templates.resolveTemplate((String)categoryFormat, (TemplateContext)c.asContext(changelog.isLinks(), commitsUrl, issueTracker))).collect(Collectors.joining(lineSeparator))).append(lineSeparator).append(System.lineSeparator());
        }
        if (!changelog.getHide().isUncategorized() && categories.containsKey(UNCATEGORIZED)) {
            if (changes.length() > 0) {
                changes.append("---").append(lineSeparator);
            }
            changes.append(((List)categories.get(UNCATEGORIZED)).stream().map(c -> Templates.resolveTemplate((String)changelog.getFormat(), (TemplateContext)c.asContext(changelog.isLinks(), commitsUrl, issueTracker))).collect(Collectors.joining(lineSeparator))).append(lineSeparator).append(System.lineSeparator());
        }
        StringBuilder formattedContributors = new StringBuilder();
        if (changelog.getContributors().isEnabled() && !contributors.isEmpty()) {
            formattedContributors.append(MustacheUtils.applyTemplate((String)changelog.getContributorsTitleFormat(), (TemplateContext)props)).append(lineSeparator).append("We'd like to thank the following people for their contributions:").append(lineSeparator).append(this.formatContributors(context, changelog, contributors, lineSeparator)).append(lineSeparator);
        }
        props.set("changelogChanges", (Object)MustacheUtils.passThrough((String)changes.toString()));
        props.set("changelogContributors", (Object)MustacheUtils.passThrough((String)formattedContributors.toString()));
        context.getChangelog().setFormattedChanges(changes.toString());
        context.getChangelog().setFormattedContributors(formattedContributors.toString());
        return this.applyReplacers(context, changelog, StringUtils.stripMargin((String)MustacheUtils.applyTemplate((Reader)changelog.getResolvedContentTemplate(context), (TemplateContext)props)));
    }

    private boolean isConventionalCommits(Changelog changelog) {
        return StringUtils.isNotBlank((String)changelog.getPreset()) && "conventional-commits".equals(changelog.getPreset().toLowerCase(Locale.ENGLISH).trim());
    }

    private boolean isCategorizeScopes(Changelog changelog) {
        return StringUtils.isTrue(changelog.getExtraProperties().get("categorizeScopes"));
    }

    private String resolveCommitFormat(Changelog changelog, Changelog.Category category) {
        if (StringUtils.isNotBlank((String)category.getFormat())) {
            return category.getFormat();
        }
        return changelog.getFormat();
    }

    private String formatContributors(JReleaserContext context, Changelog changelog, Set<Contributor> contributors, String lineSeparator) {
        ArrayList list = new ArrayList();
        String format = changelog.getContributors().getFormat();
        Map<String, List<Contributor>> grouped = contributors.stream().peek(contributor -> {
            block2: {
                block3: {
                    if (context.isDryrun() || !StringUtils.isNotBlank((String)format)) break block2;
                    if (format.contains("AsLink")) break block3;
                    if (!format.contains("Username")) break block2;
                }
                context.getReleaser().findUser(((Contributor)contributor).email, ((Contributor)contributor).name).ifPresent(contributor::setUser);
            }
        }).collect(Collectors.groupingBy(Contributor::getName));
        String contributorFormat = StringUtils.isNotBlank((String)format) ? format : "{{contributorName}}";
        grouped.keySet().stream().sorted().forEach(name -> {
            List cs = (List)grouped.get(name);
            Optional<Contributor> contributor = cs.stream().filter(c -> null != c.getUser()).findFirst();
            if (contributor.isPresent()) {
                list.add(Templates.resolveTemplate((String)contributorFormat, (TemplateContext)contributor.get().asContext()));
            } else {
                list.add(Templates.resolveTemplate((String)contributorFormat, (TemplateContext)((Contributor)cs.get(0)).asContext()));
            }
        });
        String separator = contributorFormat.startsWith("-") || contributorFormat.startsWith("*") ? lineSeparator : ", ";
        return String.join((CharSequence)separator, list);
    }

    private String applyReplacers(JReleaserContext context, Changelog changelog, String text) {
        TemplateContext props = context.getModel().props();
        context.getModel().getRelease().getReleaser().fillProps(props, context.getModel());
        for (Changelog.Replacer replacer : changelog.getReplacers()) {
            String search = Templates.resolveTemplate((String)replacer.getSearch(), (TemplateContext)props);
            String replace = Templates.resolveTemplate((String)replacer.getReplace(), (TemplateContext)props);
            text = text.replaceAll(search, replace);
        }
        return text;
    }

    protected String categorize(Commit commit, Changelog changelog) {
        if (!commit.labels.isEmpty()) {
            for (Changelog.Category category : changelog.getCategories()) {
                if (!CollectionUtils.intersects((Set)category.getLabels(), (Set)commit.labels)) continue;
                return category.getKey();
            }
        }
        return UNCATEGORIZED;
    }

    private void applyLabels(Commit commit, Set<Changelog.Labeler> labelers) {
        for (Changelog.Labeler labeler : labelers) {
            String regex;
            if (StringUtils.isNotBlank((String)labeler.getTitle())) {
                if (labeler.getTitle().startsWith(REGEX_PREFIX)) {
                    regex = labeler.getTitle().substring(REGEX_PREFIX.length());
                    if (commit.title.matches(StringUtils.normalizeRegexPattern((String)regex))) {
                        commit.labels.add(labeler.getLabel());
                    }
                } else if (commit.title.contains(labeler.getTitle()) || commit.title.matches(StringUtils.toSafeRegexPattern((String)labeler.getTitle()))) {
                    commit.labels.add(labeler.getLabel());
                }
            }
            if (!StringUtils.isNotBlank((String)labeler.getBody())) continue;
            if (labeler.getBody().startsWith(REGEX_PREFIX)) {
                regex = labeler.getBody().substring(REGEX_PREFIX.length());
                if (!commit.body.matches(StringUtils.normalizeRegexPattern((String)regex))) continue;
                commit.labels.add(labeler.getLabel());
                continue;
            }
            if (!commit.body.contains(labeler.getBody()) && !commit.body.matches(StringUtils.toSafeRegexPattern((String)labeler.getBody()))) continue;
            commit.labels.add(labeler.getLabel());
        }
    }

    protected boolean checkLabels(Commit commit, Changelog changelog) {
        if (!changelog.getIncludeLabels().isEmpty()) {
            return CollectionUtils.intersects((Set)changelog.getIncludeLabels(), (Set)commit.labels);
        }
        if (!changelog.getExcludeLabels().isEmpty()) {
            return !CollectionUtils.intersects((Set)changelog.getExcludeLabels(), (Set)commit.labels);
        }
        return true;
    }

    public static String generate(JReleaserContext context) throws IOException {
        if (!context.getModel().getRelease().getReleaser().getChangelog().isEnabled()) {
            return "";
        }
        return new ChangelogGenerator().createChangelog(context);
    }

    private static class Contributor
    implements Comparable<Contributor> {
        private final String name;
        private final String email;
        private User user;

        private Contributor(Author author) {
            this.name = author.name;
            this.email = author.email;
        }

        public String getName() {
            return this.name;
        }

        public String getEmail() {
            return this.email;
        }

        public User getUser() {
            return this.user;
        }

        public void setUser(User user) {
            this.user = user;
        }

        TemplateContext asContext() {
            TemplateContext context = new TemplateContext();
            context.set("contributorName", (Object)MustacheUtils.passThrough((String)this.name));
            context.set("contributorNameAsLink", (Object)MustacheUtils.passThrough((String)this.name));
            context.set("contributorUsername", (Object)"");
            context.set("contributorUsernameAsLink", (Object)"");
            if (null != this.user) {
                context.set("contributorNameAsLink", (Object)MustacheUtils.passThrough((String)this.user.asLink(this.name)));
                context.set("contributorUsername", (Object)MustacheUtils.passThrough((String)this.user.getUsername()));
                context.set("contributorUsernameAsLink", (Object)MustacheUtils.passThrough((String)this.user.asLink("@" + this.user.getUsername())));
            }
            return context;
        }

        @Override
        public int compareTo(Contributor that) {
            return this.name.compareTo(that.name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (null == o || this.getClass() != o.getClass()) {
                return false;
            }
            Contributor that = (Contributor)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public String toString() {
            return this.name + " <" + this.email + ">";
        }
    }

    private static class Author
    implements Comparable<Author> {
        protected final String name;
        protected final String email;

        private Author(String name, String email) {
            this.name = name;
            this.email = email;
        }

        public String getName() {
            return this.name;
        }

        public String getEmail() {
            return this.email;
        }

        @Override
        public int compareTo(Author that) {
            return this.name.compareTo(that.name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (null == o || this.getClass() != o.getClass()) {
                return false;
            }
            Author that = (Author)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public String toString() {
            return this.name + " <" + this.email + ">";
        }
    }

    static class ConventionalCommit
    extends Commit {
        private static final Pattern FIRST_LINE_PATTERN = Pattern.compile("^(?<type>[a-z]+)(?:\\((?<scope>\\w+)\\))?(?<bang>!)?: (?<description>.*$)");
        private static final Pattern BREAKING_CHANGE_PATTERN = Pattern.compile("^BREAKING[ \\-]CHANGE:\\s+(?<content>[\\w\\W]+)", 8);
        private static final Pattern TRAILER_PATTERN = Pattern.compile("(?<token>^\\w+(?:-\\w+)*)(?:: | #)(?<value>.*$)");
        private final List<Trailer> trailers = new ArrayList<Trailer>();
        private boolean isConventional = true;
        private boolean ccIsBreakingChange;
        private String ccType = "";
        private String ccScope = "";
        private String ccDescription = "";
        private String ccBody = "";
        private String ccBreakingChangeContent = "";

        private ConventionalCommit(RevCommit rc) {
            super(rc);
            String token;
            Matcher matcherTrailer;
            ArrayList<String> lines = new ArrayList<String>(Arrays.asList(ConventionalCommit.split(this.body)));
            Matcher matcherFirstLine = FIRST_LINE_PATTERN.matcher((CharSequence)lines.get(0));
            if (matcherFirstLine.matches()) {
                lines.remove(0);
                if (null != matcherFirstLine.group("bang") && !matcherFirstLine.group("bang").isEmpty()) {
                    this.ccIsBreakingChange = true;
                }
                this.ccType = matcherFirstLine.group("type");
                this.ccScope = null == matcherFirstLine.group("scope") ? "" : matcherFirstLine.group("scope");
                this.ccDescription = matcherFirstLine.group("description");
            } else {
                this.isConventional = false;
                return;
            }
            while (!lines.isEmpty() && "".equals(lines.get(0))) {
                lines.remove(0);
            }
            while (!lines.isEmpty() && (matcherTrailer = TRAILER_PATTERN.matcher((CharSequence)lines.get(lines.size() - 1))).matches() && !"BREAKING-CHANGE".equals(token = matcherTrailer.group("token"))) {
                this.trailers.add(new Trailer(token, matcherTrailer.group("value")));
                lines.remove(lines.size() - 1);
            }
            while (!lines.isEmpty() && "".equals(lines.get(lines.size() - 1))) {
                lines.remove(lines.size() - 1);
            }
            Matcher matcherBC = BREAKING_CHANGE_PATTERN.matcher(String.join((CharSequence)"\n", lines));
            if (matcherBC.find()) {
                this.ccIsBreakingChange = true;
                this.ccBreakingChangeContent = matcherBC.group("content");
                OptionalInt match = IntStream.range(0, lines.size()).filter(i -> BREAKING_CHANGE_PATTERN.matcher((CharSequence)lines.get(i)).find()).findFirst();
                if (match.isPresent() && lines.size() > match.getAsInt()) {
                    lines.subList(match.getAsInt(), lines.size()).clear();
                }
            }
            this.ccBody = String.join((CharSequence)"\n", lines);
        }

        @Override
        TemplateContext asContext(boolean links, String commitsUrl, String issueTrackerUrl) {
            TemplateContext context = super.asContext(links, commitsUrl, issueTrackerUrl);
            context.set("commitIsConventional", (Object)this.isConventional);
            context.set("conventionalCommitBreakingChangeContent", (Object)MustacheUtils.passThrough((String)this.ccBreakingChangeContent));
            context.set("conventionalCommitIsBreakingChange", (Object)this.ccIsBreakingChange);
            context.set("conventionalCommitType", (Object)this.ccType);
            context.set("conventionalCommitScope", (Object)this.ccScope);
            context.set("conventionalCommitDescription", (Object)MustacheUtils.passThrough((String)this.ccDescription));
            context.set("conventionalCommitBody", (Object)MustacheUtils.passThrough((String)this.ccBody));
            context.set("conventionalCommitTrailers", Collections.unmodifiableList(this.trailers));
            return context;
        }

        public List<Trailer> getTrailers() {
            return this.trailers;
        }

        public static Commit of(RevCommit rc) {
            ConventionalCommit c = new ConventionalCommit(rc);
            if (c.isConventional) {
                return c;
            }
            return Commit.of(rc);
        }

        static class Trailer {
            private final String token;
            private final String value;

            public Trailer(String token, String value) {
                this.token = token;
                this.value = value;
            }

            public String getToken() {
                return this.token;
            }

            public String getValue() {
                return this.value;
            }

            public String toString() {
                return MustacheUtils.passThrough((String)(this.token + ": " + this.value));
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof Trailer)) {
                    return false;
                }
                Trailer trailer = (Trailer)o;
                return this.token.equals(trailer.token) && this.value.equals(trailer.value);
            }

            public int hashCode() {
                return Objects.hash(this.token, this.value);
            }
        }
    }

    protected static class Commit {
        private static final Pattern CO_AUTHORED_BY_PATTERN = Pattern.compile("^[Cc]o-authored-by:\\s+(.*)\\s+<(.*)>.*$");
        private final Set<String> labels = new LinkedHashSet<String>();
        private final Set<Author> committers = new LinkedHashSet<Author>();
        private final Set<Integer> issues = new TreeSet<Integer>();
        private final String fullHash;
        private final String shortHash;
        private final String title;
        private final Author author;
        protected String body;

        protected Commit(RevCommit rc) {
            this.fullHash = rc.getId().name();
            this.shortHash = rc.getId().abbreviate(7).name();
            this.body = rc.getFullMessage();
            String[] lines = Commit.split(this.body);
            this.title = lines[0];
            this.author = new Author(rc.getAuthorIdent().getName(), rc.getAuthorIdent().getEmailAddress());
            this.addContributor(rc.getCommitterIdent().getName(), rc.getCommitterIdent().getEmailAddress());
            for (String line : lines) {
                Matcher m = CO_AUTHORED_BY_PATTERN.matcher(line);
                if (!m.matches()) continue;
                this.addContributor(m.group(1), m.group(2));
            }
        }

        TemplateContext asContext(boolean links, String commitsUrl, String issueTrackerUrl) {
            TemplateContext context = new TemplateContext();
            if (links) {
                context.set("commitShortHash", (Object)MustacheUtils.passThrough((String)("[" + this.shortHash + "](" + commitsUrl + "/" + this.shortHash + ")")));
            } else {
                context.set("commitShortHash", (Object)this.shortHash);
            }
            context.set("commitsUrl", (Object)commitsUrl);
            context.set("commitFullHash", (Object)this.fullHash);
            context.set("commitTitle", (Object)MustacheUtils.passThrough((String)this.title));
            context.set("commitAuthor", (Object)MustacheUtils.passThrough((String)this.author.name));
            context.set("commitBody", (Object)MustacheUtils.passThrough((String)this.body));
            context.set("commitHasIssues", (Object)(!this.issues.isEmpty() ? 1 : 0));
            context.set("commitIssues", this.issues.stream().map(i -> {
                String issue = links ? MustacheUtils.passThrough((String)("[#" + i + "](" + issueTrackerUrl + i + ")")) : "#" + i;
                return Collections.singletonMap("issue", issue);
            }).collect(Collectors.toList()));
            return context;
        }

        public Set<Integer> getIssues() {
            return Collections.unmodifiableSet(this.issues);
        }

        private void addContributor(String name, String email) {
            if (StringUtils.isNotBlank((String)name) && StringUtils.isNotBlank((String)email)) {
                this.committers.add(new Author(name, email));
            }
        }

        public Commit extractIssues(JReleaserContext context) {
            this.issues.addAll(ChangelogProvider.extractIssues(context, this.body));
            return this;
        }

        static Commit of(RevCommit rc) {
            return new Commit(rc);
        }

        protected static String[] split(String str) {
            return str.split("\\R");
        }
    }

    public static class Tags {
        private final Ref current;
        private final Ref previous;

        private Tags(Ref current, Ref previous) {
            this.current = current;
            this.previous = previous;
        }

        public Optional<Ref> getCurrent() {
            return Optional.ofNullable(this.current);
        }

        public Optional<Ref> getPrevious() {
            return Optional.ofNullable(this.previous);
        }

        private static Tags empty() {
            return new Tags(null, null);
        }

        private static Tags current(Ref tag) {
            return new Tags(tag, null);
        }

        private static Tags previous(Ref tag) {
            return new Tags(null, tag);
        }

        private static Tags of(Ref tag1, Ref tag2) {
            return new Tags(tag1, tag2);
        }
    }
}

