/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.BrewPackager;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.util.Artifacts;
import org.jreleaser.model.spi.packagers.PackagerProcessingException;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.Templates;
import org.jreleaser.packagers.AbstractRepositoryPackagerProcessor;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.Algorithm;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public class BrewPackagerProcessor
extends AbstractRepositoryPackagerProcessor<BrewPackager> {
    private static final String KEY_DISTRIBUTION_CHECKSUM_SHA_256 = "distributionChecksumSha256";
    private static final String TPL_MAC_ARM = "  if OS.mac? && Hardware::CPU.arm?\n    url \"{{distributionUrl}}\"\n    sha256 \"{{distributionChecksumSha256}}\"\n  end\n";
    private static final String TPL_MAC_INTEL = "  if OS.mac? && Hardware::CPU.intel?\n    url \"{{distributionUrl}}\"\n    sha256 \"{{distributionChecksumSha256}}\"\n  end\n";
    private static final String TPL_LINUX_ARM = "  if OS.linux? && Hardware::CPU.arm? && Hardware::CPU.is_64_bit?\n    url \"{{distributionUrl}}\"\n    sha256 \"{{distributionChecksumSha256}}\"\n  end\n";
    private static final String TPL_LINUX_INTEL = "  if OS.linux? && Hardware::CPU.intel?\n    url \"{{distributionUrl}}\"\n    sha256 \"{{distributionChecksumSha256}}\"\n  end\n";
    private static final String TPL_MAC_ARM_FLAT_BINARY = "  if OS.mac? && Hardware::CPU.arm?\n    url \"{{distributionUrl}}\"\n    sha256 \"{{distributionChecksumSha256}}\"\n\n    def install\n      bin.install \"{{distributionArtifactFileName}}\" => \"{{distributionExecutableName}}\"\n    end\n  end\n";
    private static final String TPL_MAC_INTEL_FLAT_BINARY = "  if OS.mac? && Hardware::CPU.intel?\n    url \"{{distributionUrl}}\"\n    sha256 \"{{distributionChecksumSha256}}\"\n\n    def install\n      bin.install \"{{distributionArtifactFileName}}\" => \"{{distributionExecutableName}}\"\n    end\n  end\n";
    private static final String TPL_LINUX_ARM_FLAT_BINARY = "  if OS.linux? && Hardware::CPU.arm? && Hardware::CPU.is_64_bit?\n    url \"{{distributionUrl}}\"\n    sha256 \"{{distributionChecksumSha256}}\"\n\n    def install\n      bin.install \"{{distributionArtifactFileName}}\" => \"{{distributionExecutableName}}\"\n    end\n  end\n";
    private static final String TPL_LINUX_INTEL_FLAT_BINARY = "  if OS.linux? && Hardware::CPU.intel?\n    url \"{{distributionUrl}}\"\n    sha256 \"{{distributionChecksumSha256}}\"\n\n    def install\n      bin.install \"{{distributionArtifactFileName}}\" => \"{{distributionExecutableName}}\"\n    end\n  end\n";
    private static final String CASK_RB = "cask.rb";
    private static final String CASKS = "Casks";
    private static final String FORMULA = "Formula";
    private static final String FORMULA_RB = "formula.rb";
    private static final String FORMULA_MULTI_RB = "formula-multi.rb";
    private static final String RB = ".rb";
    private static final String SKIP_JAVA = "skipJava";

    public BrewPackagerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, Map<String, Object> props, Path packageDirectory) throws PackagerProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        this.copyPreparedFiles(distribution, props);
    }

    @Override
    protected void fillPackagerProperties(Map<String, Object> props, Distribution distribution) throws PackagerProcessingException {
        BrewPackager.Cask cask;
        BaseReleaser releaser = this.context.getModel().getRelease().getReleaser();
        props.put("brewFormulaName", ((BrewPackager)this.packager).getResolvedFormulaName(props));
        props.put("brewTapRepoOwner", ((BrewPackager)this.packager).getTap().getOwner());
        props.put("brewTapRepoName", ((BrewPackager)this.packager).getTap().getResolvedName());
        props.put("brewTapName", ((BrewPackager)this.packager).getTap().getResolvedName().substring("homebrew-".length()));
        props.put("brewTapRepoUrl", releaser.getResolvedRepoUrl(this.context.getModel(), ((BrewPackager)this.packager).getTap().getOwner(), ((BrewPackager)this.packager).getTap().getResolvedName()));
        props.put("brewTapRepoCloneUrl", releaser.getResolvedRepoCloneUrl(this.context.getModel(), ((BrewPackager)this.packager).getTap().getOwner(), ((BrewPackager)this.packager).getTap().getResolvedName()));
        props.put("brewHasLivecheck", ((BrewPackager)this.packager).hasLivecheck());
        if (((BrewPackager)this.packager).hasLivecheck()) {
            props.put("brewLivecheck", ((BrewPackager)this.packager).getLivecheck().stream().map(line -> Templates.resolveTemplate((String)line, (Map)props)).map(MustacheUtils::passThrough).collect(Collectors.toList()));
        }
        if ((cask = ((BrewPackager)this.packager).getCask()).isEnabled()) {
            boolean hasPkg = StringUtils.isNotBlank((String)cask.getPkgName());
            boolean hasApp = StringUtils.isNotBlank((String)cask.getAppName());
            props.put("brewCaskName", cask.getResolvedCaskName(props));
            props.put("brewCaskDisplayName", cask.getResolvedDisplayName(props));
            props.put("brewCaskHasUninstall", !cask.getUninstallItems().isEmpty());
            props.put("brewCaskHasPkg", hasPkg);
            if (hasPkg) {
                props.put("brewCaskPkg", cask.getResolvedPkgName(props));
            }
            props.put("brewCaskHasApp", hasApp);
            if (hasApp) {
                props.put("brewCaskApp", cask.getResolvedAppName(props));
            }
            props.put("brewCaskUninstall", cask.getUninstallItems());
            props.put("brewCaskHasZap", !cask.getZapItems().isEmpty());
            props.put("brewCaskZap", cask.getZapItems());
            String appcast = cask.getResolvedAppcast(props);
            props.put("brewCaskHasAppcast", StringUtils.isNotBlank((String)appcast));
            props.put("brewCaskAppcast", appcast);
            if (!hasApp && !hasPkg) {
                for (Artifact artifact : this.collectArtifacts(distribution)) {
                    if (!artifact.getPath().endsWith(FileType.ZIP.extension())) continue;
                    props.put("distributionUrl", this.resolveArtifactUrl(props, distribution, artifact));
                    props.put("brewCaskHasBinary", true);
                    break;
                }
            }
        } else if (((BrewPackager)this.packager).isMultiPlatform()) {
            ArrayList<String> multiPlatforms = new ArrayList<String>();
            Artifact osxIntelArtifact = null;
            Artifact osxArmArtifact = null;
            boolean flatBinary = distribution.getType() == Distribution.DistributionType.FLAT_BINARY;
            for (Artifact artifact : this.collectArtifacts(distribution)) {
                if (!artifact.getPath().endsWith(FileType.ZIP.extension()) && !flatBinary || StringUtils.isBlank((String)artifact.getPlatform())) continue;
                String template = null;
                String artifactUrl = this.resolveArtifactUrl(props, distribution, artifact);
                String artifactFile = artifact.getEffectivePath().getFileName().toString();
                String artifactFileName = StringUtils.getFilename((String)artifactFile, (Collection)FileType.getSupportedExtensions());
                if (PlatformUtils.isMac((String)artifact.getPlatform())) {
                    if (PlatformUtils.isArm((String)artifact.getPlatform())) {
                        template = flatBinary ? TPL_LINUX_ARM_FLAT_BINARY : TPL_MAC_ARM;
                        osxArmArtifact = artifact;
                    } else {
                        template = flatBinary ? TPL_MAC_INTEL_FLAT_BINARY : TPL_MAC_INTEL;
                        osxIntelArtifact = artifact;
                    }
                } else if (PlatformUtils.isLinux((String)artifact.getPlatform())) {
                    if (PlatformUtils.isArm((String)artifact.getPlatform())) {
                        template = flatBinary ? TPL_LINUX_ARM_FLAT_BINARY : TPL_LINUX_ARM;
                    } else {
                        String string = template = flatBinary ? TPL_LINUX_INTEL_FLAT_BINARY : TPL_LINUX_INTEL;
                    }
                }
                if (!StringUtils.isNotBlank(template)) continue;
                LinkedHashMap<String, Object> newProps = new LinkedHashMap<String, Object>(props);
                newProps.put("distributionUrl", artifactUrl);
                newProps.put("distributionArtifactFileName", artifactFileName);
                newProps.put(KEY_DISTRIBUTION_CHECKSUM_SHA_256, artifact.getHash(Algorithm.SHA_256));
                multiPlatforms.add(Templates.resolveTemplate((String)template, newProps));
            }
            if (osxIntelArtifact != null && osxArmArtifact == null) {
                String artifactUrl = this.resolveArtifactUrl(props, distribution, osxIntelArtifact);
                String artifactFile = osxIntelArtifact.getEffectivePath().getFileName().toString();
                String artifactFileName = StringUtils.getFilename((String)artifactFile, (Collection)FileType.getSupportedExtensions());
                LinkedHashMap<String, Object> newProps = new LinkedHashMap<String, Object>(props);
                newProps.put("distributionUrl", artifactUrl);
                newProps.put("distributionArtifactFileName", artifactFileName);
                newProps.put(KEY_DISTRIBUTION_CHECKSUM_SHA_256, osxIntelArtifact.getHash(Algorithm.SHA_256));
                multiPlatforms.add(Templates.resolveTemplate((String)(flatBinary ? TPL_LINUX_ARM_FLAT_BINARY : TPL_MAC_ARM), newProps));
            }
            if (multiPlatforms.isEmpty()) {
                throw new PackagerProcessingException(org.jreleaser.bundle.RB.$((String)"ERROR_brew_multiplatform_artifacts", (Object[])new Object[0]));
            }
            props.put("brewMultiPlatform", MustacheUtils.passThrough((String)String.join((CharSequence)(System.lineSeparator() + "  "), multiPlatforms)));
        } else if (!(distribution.getType() != Distribution.DistributionType.JAVA_BINARY && distribution.getType() != Distribution.DistributionType.SINGLE_JAR || StringUtils.isTrue(((BrewPackager)this.packager).getExtraProperties().get(SKIP_JAVA)))) {
            ((BrewPackager)this.packager).addDependency("openjdk@" + props.get("distributionJavaVersion"));
        }
        props.put("brewDependencies", ((BrewPackager)this.packager).getDependenciesAsList().stream().map(dependency -> MustacheUtils.passThrough((String)dependency.toString())).collect(Collectors.toList()));
    }

    private String resolveArtifactUrl(Map<String, Object> props, Distribution distribution, Artifact artifact) {
        return Artifacts.resolveDownloadUrl((JReleaserContext)this.context, (String)"brew", (Distribution)distribution, (Artifact)artifact);
    }

    @Override
    protected void writeFile(Project project, Distribution distribution, String content, Map<String, Object> props, Path outputDirectory, String fileName) throws PackagerProcessingException {
        fileName = TemplateUtils.trimTplExtension((String)fileName);
        if (((BrewPackager)this.packager).getCask().isEnabled()) {
            if (FORMULA_RB.equals(fileName) || FORMULA_MULTI_RB.equals(fileName)) {
                return;
            }
            Path outputFile = CASK_RB.equals(fileName) ? outputDirectory.resolve(CASKS).resolve(((BrewPackager)this.packager).getCask().getResolvedCaskName(props).concat(RB)) : outputDirectory.resolve(fileName);
            this.writeFile(content, outputFile);
        } else if (((BrewPackager)this.packager).isMultiPlatform()) {
            if (CASK_RB.equals(fileName) || FORMULA_RB.equals(fileName)) {
                return;
            }
            Path outputFile = FORMULA_MULTI_RB.equals(fileName) ? outputDirectory.resolve(FORMULA).resolve(distribution.getExecutable().getName().concat(RB)) : outputDirectory.resolve(fileName);
            this.writeFile(content, outputFile);
        } else {
            if (CASK_RB.equals(fileName) || FORMULA_MULTI_RB.equals(fileName)) {
                return;
            }
            Path outputFile = FORMULA_RB.equals(fileName) ? outputDirectory.resolve(FORMULA).resolve(StringUtils.getHyphenatedName((String)((BrewPackager)this.packager).getFormulaName()).concat(RB)) : outputDirectory.resolve(fileName);
            this.writeFile(content, outputFile);
        }
    }
}

