/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.assemble;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.Archive;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.api.assemble.NativeImageAssembler;
import org.jreleaser.model.api.common.Artifact;
import org.jreleaser.model.api.common.Glob;
import org.jreleaser.model.api.common.Java;
import org.jreleaser.model.api.platform.Platform;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.AbstractJavaAssembler;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.FileSet;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class NativeImageAssembler
extends AbstractJavaAssembler<NativeImageAssembler, org.jreleaser.model.api.assemble.NativeImageAssembler> {
    private final List<String> args = new ArrayList<String>();
    private final Set<String> components = new LinkedHashSet<String>();
    private final org.jreleaser.model.internal.common.Artifact graal = new org.jreleaser.model.internal.common.Artifact();
    private final Set<org.jreleaser.model.internal.common.Artifact> graalJdks = new LinkedHashSet<org.jreleaser.model.internal.common.Artifact>();
    private final Upx upx = new Upx();
    private final Linux linux = new Linux();
    private final Windows windows = new Windows();
    private final Osx osx = new Osx();
    private String imageName;
    private String imageNameTransform;
    private Archive.Format archiveFormat;
    private final org.jreleaser.model.api.assemble.NativeImageAssembler immutable = new org.jreleaser.model.api.assemble.NativeImageAssembler(){
        private Set<? extends Artifact> graalJdks;
        private List<? extends org.jreleaser.model.api.common.FileSet> fileSets;
        private Set<? extends Artifact> outputs;
        private List<? extends Glob> jars;
        private List<? extends Glob> files;

        public String getImageName() {
            return NativeImageAssembler.this.imageName;
        }

        public String getImageNameTransform() {
            return NativeImageAssembler.this.imageNameTransform;
        }

        public Archive.Format getArchiveFormat() {
            return NativeImageAssembler.this.archiveFormat;
        }

        public Artifact getGraal() {
            return NativeImageAssembler.this.graal.asImmutable();
        }

        public Set<? extends Artifact> getGraalJdks() {
            if (null == this.graalJdks) {
                this.graalJdks = NativeImageAssembler.this.graalJdks.stream().map(org.jreleaser.model.internal.common.Artifact::asImmutable).collect(Collectors.toSet());
            }
            return this.graalJdks;
        }

        public List<String> getArgs() {
            return Collections.unmodifiableList(NativeImageAssembler.this.args);
        }

        public Set<String> getComponents() {
            return Collections.unmodifiableSet(NativeImageAssembler.this.components);
        }

        public NativeImageAssembler.Upx getUpx() {
            return NativeImageAssembler.this.upx.asImmutable();
        }

        public NativeImageAssembler.Linux getLinux() {
            return NativeImageAssembler.this.linux.asImmutable();
        }

        public NativeImageAssembler.Windows getWindows() {
            return NativeImageAssembler.this.windows.asImmutable();
        }

        public NativeImageAssembler.Osx getOsx() {
            return NativeImageAssembler.this.osx.asImmutable();
        }

        public String getExecutable() {
            return NativeImageAssembler.this.executable;
        }

        public String getTemplateDirectory() {
            return NativeImageAssembler.this.templateDirectory;
        }

        public Java getJava() {
            return NativeImageAssembler.this.java.asImmutable();
        }

        public Artifact getMainJar() {
            return NativeImageAssembler.this.mainJar.asImmutable();
        }

        public List<? extends Glob> getJars() {
            if (null == this.jars) {
                this.jars = NativeImageAssembler.this.jars.stream().map(org.jreleaser.model.internal.common.Glob::asImmutable).collect(Collectors.toList());
            }
            return this.jars;
        }

        public List<? extends Glob> getFiles() {
            if (null == this.files) {
                this.files = NativeImageAssembler.this.files.stream().map(org.jreleaser.model.internal.common.Glob::asImmutable).collect(Collectors.toList());
            }
            return this.files;
        }

        public Platform getPlatform() {
            return NativeImageAssembler.this.platform.asImmutable();
        }

        public Distribution.DistributionType getDistributionType() {
            return NativeImageAssembler.this.getDistributionType();
        }

        public String getType() {
            return NativeImageAssembler.this.type;
        }

        public Stereotype getStereotype() {
            return NativeImageAssembler.this.getStereotype();
        }

        public boolean isExported() {
            return NativeImageAssembler.this.isExported();
        }

        public String getName() {
            return NativeImageAssembler.this.name;
        }

        public List<? extends org.jreleaser.model.api.common.FileSet> getFileSets() {
            if (null == this.fileSets) {
                this.fileSets = NativeImageAssembler.this.fileSets.stream().map(FileSet::asImmutable).collect(Collectors.toList());
            }
            return this.fileSets;
        }

        public Set<? extends Artifact> getOutputs() {
            if (null == this.outputs) {
                this.outputs = NativeImageAssembler.this.outputs.stream().map(org.jreleaser.model.internal.common.Artifact::asImmutable).collect(Collectors.toSet());
            }
            return this.outputs;
        }

        public Active getActive() {
            return NativeImageAssembler.this.active;
        }

        public boolean isEnabled() {
            return NativeImageAssembler.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(NativeImageAssembler.this.asMap(full));
        }

        public String getPrefix() {
            return NativeImageAssembler.this.getPrefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(NativeImageAssembler.this.extraProperties);
        }
    };

    public NativeImageAssembler() {
        super("native-image");
    }

    @Override
    public org.jreleaser.model.api.assemble.NativeImageAssembler asImmutable() {
        return this.immutable;
    }

    @Override
    public Distribution.DistributionType getDistributionType() {
        return Distribution.DistributionType.BINARY;
    }

    @Override
    public void merge(NativeImageAssembler source) {
        super.merge(source);
        this.imageName = this.merge(this.imageName, source.imageName);
        this.imageNameTransform = this.merge(this.imageNameTransform, source.imageNameTransform);
        this.archiveFormat = this.merge(this.archiveFormat, source.archiveFormat);
        this.setGraal(source.graal);
        this.setGraalJdks(this.merge(this.graalJdks, source.graalJdks));
        this.setArgs(this.merge(this.args, source.args));
        this.setComponents(this.merge(this.components, source.components));
        this.setUpx(source.upx);
        this.setLinux(source.linux);
        this.setWindows(source.windows);
        this.setOsx(source.osx);
    }

    public String getResolvedImageName(JReleaserContext context) {
        Map<String, Object> props = context.getModel().props();
        props.putAll(this.props());
        return Templates.resolveTemplate((String)this.imageName, props);
    }

    public String getResolvedImageNameTransform(JReleaserContext context) {
        if (StringUtils.isBlank((String)this.imageNameTransform)) {
            return null;
        }
        Map<String, Object> props = context.getModel().props();
        props.putAll(this.props());
        return Templates.resolveTemplate((String)this.imageNameTransform, props);
    }

    public PlatformCustomizer getResolvedPlatformCustomizer() {
        String currentPlatform = PlatformUtils.getCurrentFull();
        if (PlatformUtils.isMac((String)currentPlatform)) {
            return this.getOsx();
        }
        if (PlatformUtils.isWindows((String)currentPlatform)) {
            return this.getWindows();
        }
        return this.getLinux();
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public String getImageNameTransform() {
        return this.imageNameTransform;
    }

    public void setImageNameTransform(String imageNameTransform) {
        this.imageNameTransform = imageNameTransform;
    }

    public Archive.Format getArchiveFormat() {
        return this.archiveFormat;
    }

    public void setArchiveFormat(Archive.Format archiveFormat) {
        this.archiveFormat = archiveFormat;
    }

    public void setArchiveFormat(String archiveFormat) {
        this.archiveFormat = Archive.Format.of((String)archiveFormat);
    }

    public org.jreleaser.model.internal.common.Artifact getGraal() {
        return this.graal;
    }

    public void setGraal(org.jreleaser.model.internal.common.Artifact graal) {
        this.graal.merge(graal);
    }

    public Set<org.jreleaser.model.internal.common.Artifact> getGraalJdks() {
        return org.jreleaser.model.internal.common.Artifact.sortArtifacts(this.graalJdks);
    }

    public void setGraalJdks(Set<org.jreleaser.model.internal.common.Artifact> graalJdks) {
        this.graalJdks.clear();
        this.graalJdks.addAll(graalJdks);
    }

    public void addGraalJdks(Set<org.jreleaser.model.internal.common.Artifact> graalJdks) {
        this.graalJdks.addAll(graalJdks);
    }

    public void addGraalJdk(org.jreleaser.model.internal.common.Artifact jdk) {
        if (null != jdk) {
            this.graalJdks.add(jdk);
        }
    }

    public List<String> getArgs() {
        return this.args;
    }

    public void setArgs(List<String> args) {
        this.args.clear();
        this.args.addAll(args);
    }

    public Set<String> getComponents() {
        return this.components;
    }

    public void setComponents(Set<String> components) {
        this.components.clear();
        this.components.addAll(components);
    }

    public Upx getUpx() {
        return this.upx;
    }

    public void setUpx(Upx upx) {
        this.upx.merge(upx);
    }

    public Linux getLinux() {
        return this.linux;
    }

    public void setLinux(Linux linux) {
        this.linux.merge(linux);
    }

    public Windows getWindows() {
        return this.windows;
    }

    public void setWindows(Windows windows) {
        this.windows.merge(windows);
    }

    public Osx getOsx() {
        return this.osx;
    }

    public void setOsx(Osx osx) {
        this.osx.merge(osx);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("imageName", this.imageName);
        props.put("imageNameTransform", this.imageNameTransform);
        props.put("archiveFormat", this.archiveFormat);
        LinkedHashMap<String, Map<String, Object>> mappedJdks = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (org.jreleaser.model.internal.common.Artifact graalJdk : this.getGraalJdks()) {
            mappedJdks.put("jdk " + i++, graalJdk.asMap(full));
        }
        props.put("graal", this.graal.asMap(full));
        props.put("graalJdks", mappedJdks);
        props.put("args", this.args);
        props.put("components", this.components);
        props.put("upx", this.upx.asMap(full));
        props.putAll(this.linux.asMap(full));
        props.putAll(this.osx.asMap(full));
        props.putAll(this.windows.asMap(full));
    }

    public static final class Osx
    extends AbstractPlatformCustomizer<Osx> {
        private final NativeImageAssembler.Osx immutable = new NativeImageAssembler.Osx(){

            public String getPlatform() {
                return platform;
            }

            public List<String> getArgs() {
                return Collections.unmodifiableList(args);
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public Osx() {
            super("osx");
        }

        public NativeImageAssembler.Osx asImmutable() {
            return this.immutable;
        }
    }

    public static final class Windows
    extends AbstractPlatformCustomizer<Windows> {
        private final NativeImageAssembler.Windows immutable = new NativeImageAssembler.Windows(){

            public String getPlatform() {
                return platform;
            }

            public List<String> getArgs() {
                return Collections.unmodifiableList(args);
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public Windows() {
            super("windows");
        }

        public NativeImageAssembler.Windows asImmutable() {
            return this.immutable;
        }
    }

    public static final class Linux
    extends AbstractPlatformCustomizer<Linux> {
        private final NativeImageAssembler.Linux immutable = new NativeImageAssembler.Linux(){

            public String getPlatform() {
                return platform;
            }

            public List<String> getArgs() {
                return Collections.unmodifiableList(args);
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public Linux() {
            super("linux");
        }

        public NativeImageAssembler.Linux asImmutable() {
            return this.immutable;
        }
    }

    private static abstract class AbstractPlatformCustomizer<S extends AbstractPlatformCustomizer<S>>
    extends AbstractModelObject<S>
    implements PlatformCustomizer {
        protected final List<String> args = new ArrayList<String>();
        protected final String platform;

        protected AbstractPlatformCustomizer(String platform) {
            this.platform = platform;
        }

        @Override
        public void merge(S source) {
            this.setArgs(this.merge(this.args, ((AbstractPlatformCustomizer)source).args));
        }

        @Override
        public List<String> getArgs() {
            return this.args;
        }

        @Override
        public void setArgs(List<String> args) {
            this.args.clear();
            this.args.addAll(args);
        }

        @Override
        public String getPlatform() {
            return this.platform;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, List<String>> props = new LinkedHashMap<String, List<String>>();
            props.put("args", this.args);
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put(this.platform, props);
            return map;
        }
    }

    public static final class Upx
    extends AbstractModelObject<Upx>
    implements Domain,
    Activatable {
        private final List<String> args = new ArrayList<String>();
        @JsonIgnore
        private boolean enabled;
        private Active active;
        private String version;
        private final NativeImageAssembler.Upx immutable = new NativeImageAssembler.Upx(){

            public String getVersion() {
                return version;
            }

            public List<String> getArgs() {
                return Collections.unmodifiableList(args);
            }

            public Active getActive() {
                return active;
            }

            public boolean isEnabled() {
                return this.isEnabled();
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public NativeImageAssembler.Upx asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Upx source) {
            this.active = this.merge(this.active, source.active);
            this.enabled = this.merge(this.enabled, source.enabled);
            this.version = this.merge(this.version, source.version);
            this.setArgs(this.merge(this.args, source.args));
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public void disable() {
            this.active = Active.NEVER;
            this.enabled = false;
        }

        public boolean resolveEnabled(Project project) {
            if (null == this.active) {
                this.active = Active.NEVER;
            }
            this.enabled = this.active.check((Active.Releaseable)project);
            return this.enabled;
        }

        @Override
        public Active getActive() {
            return this.active;
        }

        @Override
        public void setActive(Active active) {
            this.active = active;
        }

        @Override
        public void setActive(String str) {
            this.setActive(Active.of((String)str));
        }

        @Override
        public boolean isActiveSet() {
            return this.active != null;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public List<String> getArgs() {
            return this.args;
        }

        public void setArgs(List<String> args) {
            this.args.clear();
            this.args.addAll(args);
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            if (!full && !this.isEnabled()) {
                return Collections.emptyMap();
            }
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("enabled", this.isEnabled());
            props.put("active", this.active);
            props.put("version", this.version);
            return props;
        }
    }

    public static interface PlatformCustomizer
    extends Domain {
        public String getPlatform();

        public List<String> getArgs();

        public void setArgs(List<String> var1);
    }
}

