/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.assemble;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.Archive;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.api.common.Artifact;
import org.jreleaser.model.api.platform.Platform;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.AbstractAssembler;
import org.jreleaser.model.internal.common.FileSet;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.PlatformUtils;

public final class ArchiveAssembler
extends AbstractAssembler<ArchiveAssembler, org.jreleaser.model.api.assemble.ArchiveAssembler> {
    private final Set<Archive.Format> formats = new LinkedHashSet<Archive.Format>();
    private String archiveName;
    private Boolean attachPlatform;
    private Distribution.DistributionType distributionType;
    private final org.jreleaser.model.api.assemble.ArchiveAssembler immutable = new org.jreleaser.model.api.assemble.ArchiveAssembler(){
        private List<? extends org.jreleaser.model.api.common.FileSet> fileSets;
        private Set<? extends Artifact> outputs;

        public String getArchiveName() {
            return ArchiveAssembler.this.archiveName;
        }

        public boolean isAttachPlatform() {
            return ArchiveAssembler.this.isAttachPlatform();
        }

        public Set<Archive.Format> getFormats() {
            return Collections.unmodifiableSet(ArchiveAssembler.this.formats);
        }

        public Platform getPlatform() {
            return ArchiveAssembler.this.platform.asImmutable();
        }

        public Distribution.DistributionType getDistributionType() {
            return ArchiveAssembler.this.getDistributionType();
        }

        public String getType() {
            return ArchiveAssembler.this.type;
        }

        public Stereotype getStereotype() {
            return ArchiveAssembler.this.getStereotype();
        }

        public boolean isExported() {
            return ArchiveAssembler.this.isExported();
        }

        public String getName() {
            return ArchiveAssembler.this.name;
        }

        public List<? extends org.jreleaser.model.api.common.FileSet> getFileSets() {
            if (null == this.fileSets) {
                this.fileSets = ArchiveAssembler.this.fileSets.stream().map(FileSet::asImmutable).collect(Collectors.toList());
            }
            return this.fileSets;
        }

        public Set<? extends Artifact> getOutputs() {
            if (null == this.outputs) {
                this.outputs = ArchiveAssembler.this.outputs.stream().map(org.jreleaser.model.internal.common.Artifact::asImmutable).collect(Collectors.toSet());
            }
            return this.outputs;
        }

        public Active getActive() {
            return ArchiveAssembler.this.active;
        }

        public boolean isEnabled() {
            return ArchiveAssembler.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(ArchiveAssembler.this.asMap(full));
        }

        public String getPrefix() {
            return ArchiveAssembler.this.getPrefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(ArchiveAssembler.this.extraProperties);
        }
    };

    public ArchiveAssembler() {
        super("archive");
    }

    @Override
    public org.jreleaser.model.api.assemble.ArchiveAssembler asImmutable() {
        return this.immutable;
    }

    @Override
    public Distribution.DistributionType getDistributionType() {
        return this.distributionType;
    }

    public void setDistributionType(Distribution.DistributionType distributionType) {
        this.distributionType = distributionType;
    }

    public void setDistributionType(String distributionType) {
        this.distributionType = Distribution.DistributionType.of((String)distributionType);
    }

    @Override
    public void merge(ArchiveAssembler source) {
        super.merge(source);
        this.archiveName = this.merge(source.archiveName, source.archiveName);
        this.distributionType = this.merge(source.distributionType, source.distributionType);
        this.attachPlatform = this.merge(source.attachPlatform, source.attachPlatform);
        this.setFormats(this.merge(this.formats, source.formats));
    }

    public String getResolvedArchiveName(JReleaserContext context) {
        Map<String, Object> props = context.fullProps();
        props.putAll(this.props());
        String result = Templates.resolveTemplate((String)this.archiveName, props);
        if (this.isAttachPlatform()) {
            result = result + "-" + this.getPlatform().applyReplacements(PlatformUtils.getCurrentFull());
        }
        return result;
    }

    public String getArchiveName() {
        return this.archiveName;
    }

    public void setArchiveName(String archiveName) {
        this.archiveName = archiveName;
    }

    public boolean isAttachPlatformSet() {
        return this.attachPlatform != null;
    }

    public boolean isAttachPlatform() {
        return this.attachPlatform != null && this.attachPlatform != false;
    }

    public void setAttachPlatform(Boolean attachPlatform) {
        this.attachPlatform = attachPlatform;
    }

    public Set<Archive.Format> getFormats() {
        return this.formats;
    }

    public void setFormats(Set<Archive.Format> formats) {
        this.formats.clear();
        this.formats.addAll(formats);
    }

    public void addFormat(Archive.Format format) {
        this.formats.add(format);
    }

    public void addFormat(String str) {
        this.formats.add(Archive.Format.of((String)str));
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("archiveName", this.archiveName);
        props.put("distributionType", this.distributionType);
        props.put("attachPlatform", this.isAttachPlatform());
        props.put("formats", this.formats);
    }
}

