/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.announce;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.AbstractAnnouncer;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.StringUtils;

public final class DiscourseAnnouncer
extends AbstractAnnouncer<DiscourseAnnouncer, org.jreleaser.model.api.announce.DiscourseAnnouncer> {
    private String host;
    private String apiKey;
    private String username;
    private String categoryName;
    private String title;
    private String message;
    private String messageTemplate;
    private final org.jreleaser.model.api.announce.DiscourseAnnouncer immutable = new org.jreleaser.model.api.announce.DiscourseAnnouncer(){

        public String getType() {
            return "discourse";
        }

        public String getHost() {
            return DiscourseAnnouncer.this.host;
        }

        public String getApiKey() {
            return DiscourseAnnouncer.this.apiKey;
        }

        public String getUsername() {
            return DiscourseAnnouncer.this.username;
        }

        public String getCategoryName() {
            return DiscourseAnnouncer.this.categoryName;
        }

        public String getTitle() {
            return DiscourseAnnouncer.this.title;
        }

        public String getMessage() {
            return DiscourseAnnouncer.this.message;
        }

        public String getMessageTemplate() {
            return DiscourseAnnouncer.this.messageTemplate;
        }

        public String getName() {
            return DiscourseAnnouncer.this.name;
        }

        public boolean isSnapshotSupported() {
            return DiscourseAnnouncer.this.isSnapshotSupported();
        }

        public Active getActive() {
            return DiscourseAnnouncer.this.active;
        }

        public boolean isEnabled() {
            return DiscourseAnnouncer.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(DiscourseAnnouncer.this.asMap(full));
        }

        public String getPrefix() {
            return DiscourseAnnouncer.this.getPrefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(DiscourseAnnouncer.this.extraProperties);
        }

        public Integer getConnectTimeout() {
            return DiscourseAnnouncer.this.connectTimeout;
        }

        public Integer getReadTimeout() {
            return DiscourseAnnouncer.this.readTimeout;
        }
    };

    public DiscourseAnnouncer() {
        super("discourse");
    }

    @Override
    public org.jreleaser.model.api.announce.DiscourseAnnouncer asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(DiscourseAnnouncer source) {
        super.merge(source);
        this.host = this.merge(this.host, source.host);
        this.apiKey = this.merge(this.apiKey, source.apiKey);
        this.username = this.merge(this.username, source.username);
        this.categoryName = this.merge(this.categoryName, source.categoryName);
        this.title = this.merge(this.title, source.title);
        this.message = this.merge(this.message, source.message);
        this.messageTemplate = this.merge(this.messageTemplate, source.messageTemplate);
    }

    public String getResolvedTitle(JReleaserContext context) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        return Templates.resolveTemplate((String)this.title, props);
    }

    public String getResolvedMessage(JReleaserContext context) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        return Templates.resolveTemplate((String)this.message, props);
    }

    public String getResolvedMessageTemplate(JReleaserContext context, Map<String, Object> extraProps) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        props.put("tagName", context.getModel().getRelease().getReleaser().getEffectiveTagName(context.getModel()));
        props.putAll(extraProps);
        Path templatePath = context.getBasedir().resolve(this.messageTemplate);
        try {
            BufferedReader reader = Files.newBufferedReader(templatePath);
            return MustacheUtils.applyTemplate((Reader)reader, props);
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_reading_template", (Object[])new Object[]{context.relativizeToBasedir(templatePath)}));
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    public void setMessageTemplate(String messageTemplate) {
        this.messageTemplate = messageTemplate;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("host", this.host);
        props.put("apiKey", StringUtils.isNotBlank((String)this.apiKey) ? "************" : "**unset**");
        props.put("username", StringUtils.isNotBlank((String)this.username) ? "************" : "**unset**");
        props.put("categoryName", this.categoryName);
        props.put("title", this.title);
        props.put("message", this.message);
        props.put("messageTemplate", this.messageTemplate);
    }
}

