/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.Locale;
import org.jreleaser.util.StringUtils;

public class Distribution {

    public static enum DistributionType {
        BINARY("binary"),
        FLAT_BINARY("flat"),
        JAVA_BINARY("java"),
        JLINK("jlink"),
        SINGLE_JAR("uberjar"),
        NATIVE_IMAGE("graal"),
        NATIVE_PACKAGE("jpackage");

        private final String alias;

        private DistributionType(String alias) {
            this.alias = alias.toUpperCase(Locale.ENGLISH);
        }

        public static DistributionType of(String str) {
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            String value = str.replaceAll(" ", "_").replaceAll("-", "_").toUpperCase(Locale.ENGLISH).trim();
            for (DistributionType type : DistributionType.values()) {
                if (!type.alias.equals(value)) continue;
                return type;
            }
            return DistributionType.valueOf(value);
        }
    }
}

