/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.smtp;

import java.util.LinkedHashMap;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.spi.announce.AnnounceException;
import org.jreleaser.model.spi.announce.Announcer;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.sdk.smtp.MessageSmtpCommand;
import org.jreleaser.sdk.smtp.SmtpException;
import org.jreleaser.util.StringUtils;

public class SmtpAnnouncer
implements Announcer<org.jreleaser.model.api.announce.SmtpAnnouncer> {
    private final JReleaserContext context;
    private final org.jreleaser.model.internal.announce.SmtpAnnouncer smtp;

    public SmtpAnnouncer(JReleaserContext context) {
        this.context = context;
        this.smtp = context.getModel().getAnnounce().getSmtp();
    }

    public org.jreleaser.model.api.announce.SmtpAnnouncer getAnnouncer() {
        return this.smtp.asImmutable();
    }

    public String getName() {
        return "smtp";
    }

    public boolean isEnabled() {
        return this.smtp.isEnabled();
    }

    public void announce() throws AnnounceException {
        String message = "";
        if (StringUtils.isNotBlank((String)this.smtp.getMessage())) {
            message = this.smtp.getResolvedMessage(this.context);
        } else {
            LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
            props.put("changelog", MustacheUtils.passThrough((String)this.context.getChangelog()));
            this.context.getModel().getRelease().getReleaser().fillProps(props, this.context.getModel());
            message = this.smtp.getResolvedMessageTemplate(this.context, props);
        }
        String subject = this.smtp.getResolvedSubject(this.context);
        this.context.getLogger().info("subject: {}", new Object[]{subject});
        this.context.getLogger().debug("message: {}", new Object[]{message});
        try {
            MessageSmtpCommand.builder(this.context.getLogger()).dryrun(this.context.isDryrun()).transport(this.smtp.getTransport()).host(this.smtp.getHost()).port(this.smtp.getPort()).auth(this.smtp.isAuth()).username(this.smtp.getUsername()).password(this.context.isDryrun() ? "**UNDEFINED**" : this.smtp.getPassword()).from(this.smtp.getFrom()).to(this.smtp.getTo()).cc(this.smtp.getCc()).bcc(this.smtp.getBcc()).subject(subject).message(message).mimeType(this.smtp.getMimeType()).build().execute();
        }
        catch (SmtpException e) {
            this.context.getLogger().trace((Throwable)e);
            throw new AnnounceException((Throwable)e);
        }
    }
}

