/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.ChocolateyPackager;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.release.GithubReleaser;
import org.jreleaser.model.spi.packagers.PackagerProcessingException;
import org.jreleaser.mustache.Templates;
import org.jreleaser.packagers.AbstractRepositoryPackagerProcessor;
import org.jreleaser.sdk.command.Command;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public class ChocolateyPackagerProcessor
extends AbstractRepositoryPackagerProcessor<ChocolateyPackager> {
    public ChocolateyPackagerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, Map<String, Object> props, Path packageDirectory) throws PackagerProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        this.copyPreparedFiles(distribution, props);
        if (((ChocolateyPackager)this.packager).isRemoteBuild()) {
            return;
        }
        if (!PlatformUtils.isWindows()) {
            this.context.getLogger().warn(RB.$((String)"ERROR_packager_requires_platform", (Object[])new Object[]{"Windows"}));
            return;
        }
        this.createChocolateyPackage(distribution, props);
    }

    @Override
    protected void doPublishDistribution(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
        if (((ChocolateyPackager)this.packager).isRemoteBuild()) {
            super.doPublishDistribution(distribution, props);
            return;
        }
        if (this.context.isDryrun()) {
            this.context.getLogger().error(RB.$((String)"dryrun.set", (Object[])new Object[0]));
            return;
        }
        if (!PlatformUtils.isWindows()) {
            this.context.getLogger().warn(RB.$((String)"ERROR_packager_requires_platform", (Object[])new Object[]{"Windows"}));
            return;
        }
        this.publishChocolateyPackage(distribution, props);
    }

    @Override
    protected void fillPackagerProperties(Map<String, Object> props, Distribution distribution) throws PackagerProcessingException {
        BaseReleaser releaser = this.context.getModel().getRelease().getReleaser();
        if (!props.containsKey("projectLicenseUrl") || StringUtils.isBlank((String)((String)props.get("projectLicenseUrl")))) {
            this.context.getLogger().warn(RB.$((String)"ERROR_project_no_license_url", (Object[])new Object[0]));
        }
        String repoUrl = releaser.getResolvedRepoUrl(this.context.getModel());
        String bucketRepoUrl = releaser.getResolvedRepoUrl(this.context.getModel(), ((ChocolateyPackager)this.packager).getBucket().getOwner(), ((ChocolateyPackager)this.packager).getBucket().getResolvedName());
        props.put("chocolateyPackageSourceUrl", ((ChocolateyPackager)this.packager).isRemoteBuild() ? bucketRepoUrl : repoUrl);
        props.put("chocolateyBucketRepoUrl", bucketRepoUrl);
        props.put("chocolateyBucketRepoCloneUrl", releaser.getResolvedRepoCloneUrl(this.context.getModel(), ((ChocolateyPackager)this.packager).getBucket().getOwner(), ((ChocolateyPackager)this.packager).getBucket().getResolvedName()));
        props.put("chocolateyPackageName", ((ChocolateyPackager)this.packager).getPackageName());
        props.put("chocolateyPackageVersion", Templates.resolveTemplate((String)((ChocolateyPackager)this.packager).getPackageVersion(), props));
        props.put("chocolateyUsername", ((ChocolateyPackager)this.packager).getUsername());
        props.put("chocolateyTitle", ((ChocolateyPackager)this.packager).getTitle());
        props.put("chocolateyIconUrl", Templates.resolveTemplate((String)((ChocolateyPackager)this.packager).getIconUrl(), props));
        props.put("chocolateySource", ((ChocolateyPackager)this.packager).getSource());
    }

    @Override
    protected void writeFile(Project project, Distribution distribution, String content, Map<String, Object> props, Path outputDirectory, String fileName) throws PackagerProcessingException {
        BaseReleaser gitService = this.context.getModel().getRelease().getReleaser();
        if (!(!fileName.contains(".github") || ((ChocolateyPackager)this.packager).isRemoteBuild() && gitService instanceof GithubReleaser)) {
            return;
        }
        Path outputFile = "binary.nuspec".equals(fileName = TemplateUtils.trimTplExtension((String)fileName)) ? outputDirectory.resolve(distribution.getName()).resolve(((ChocolateyPackager)this.packager).getPackageName().concat(".nuspec")) : (fileName.endsWith(".ps1") ? outputDirectory.resolve(distribution.getName()).resolve(fileName) : outputDirectory.resolve(fileName));
        this.writeFile(content, outputFile);
    }

    private void createChocolateyPackage(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
        Path packageDirectory = (Path)props.get("distributionPackageDirectory");
        Path execDirectory = packageDirectory.resolve(distribution.getName());
        Command cmd = new Command("choco").arg("pack").arg(((ChocolateyPackager)this.packager).getPackageName() + ".nuspec");
        this.context.getLogger().debug(String.join((CharSequence)" ", cmd.getArgs()));
        this.executeCommand(execDirectory, cmd);
    }

    private void publishChocolateyPackage(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
        Path packageDirectory = (Path)props.get("distributionPackageDirectory");
        Path execDirectory = packageDirectory.resolve(distribution.getName());
        Command cmd = new Command("choco").arg("apikey").arg("-k").arg(((ChocolateyPackager)this.packager).getResolvedApiKey()).arg("-source").arg(((ChocolateyPackager)this.packager).getSource());
        this.executeCommand(execDirectory, cmd);
        try {
            Optional nuget = (Optional)FileUtils.listFilesAndProcess((Path)execDirectory, files -> files.map(Path::getFileName).map(Path::toString).filter(s -> s.endsWith(".nupkg")).findFirst());
            if (!nuget.isPresent()) {
                throw new PackagerProcessingException(RB.$((String)"ERROR_chocolatey_nuget_not_found", (Object[])new Object[]{this.context.relativizeToBasedir(execDirectory)}));
            }
            cmd = new Command("choco").arg("push").arg((String)nuget.get()).arg("-s").arg(((ChocolateyPackager)this.packager).getSource());
            this.context.getLogger().debug(String.join((CharSequence)" ", cmd.getArgs()));
            this.executeCommand(execDirectory, cmd);
        }
        catch (IOException e) {
            throw new PackagerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }
}

