/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.announce;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.AbstractAnnouncer;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;

public final class MattermostAnnouncer
extends AbstractAnnouncer<MattermostAnnouncer, org.jreleaser.model.api.announce.MattermostAnnouncer> {
    private String webhook;
    private String message;
    private String messageTemplate;
    private final org.jreleaser.model.api.announce.MattermostAnnouncer immutable = new org.jreleaser.model.api.announce.MattermostAnnouncer(){

        public String getType() {
            return "mattermost";
        }

        public String getWebhook() {
            return MattermostAnnouncer.this.webhook;
        }

        public String getMessage() {
            return MattermostAnnouncer.this.message;
        }

        public String getMessageTemplate() {
            return MattermostAnnouncer.this.messageTemplate;
        }

        public String getName() {
            return MattermostAnnouncer.this.name;
        }

        public boolean isSnapshotSupported() {
            return MattermostAnnouncer.this.isSnapshotSupported();
        }

        public Active getActive() {
            return MattermostAnnouncer.this.active;
        }

        public boolean isEnabled() {
            return MattermostAnnouncer.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(MattermostAnnouncer.this.asMap(full));
        }

        public String getPrefix() {
            return MattermostAnnouncer.this.getPrefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(MattermostAnnouncer.this.extraProperties);
        }

        public Integer getConnectTimeout() {
            return MattermostAnnouncer.this.connectTimeout;
        }

        public Integer getReadTimeout() {
            return MattermostAnnouncer.this.readTimeout;
        }
    };

    public MattermostAnnouncer() {
        super("mattermost");
    }

    @Override
    public org.jreleaser.model.api.announce.MattermostAnnouncer asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(MattermostAnnouncer source) {
        super.merge(source);
        this.webhook = this.merge(this.webhook, source.webhook);
        this.message = this.merge(this.message, source.message);
        this.messageTemplate = this.merge(this.messageTemplate, source.messageTemplate);
    }

    public String getResolvedMessage(JReleaserContext context) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        return Templates.resolveTemplate((String)this.message, props);
    }

    public String getResolvedMessageTemplate(JReleaserContext context, Map<String, Object> extraProps) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        props.put("tagName", context.getModel().getRelease().getReleaser().getEffectiveTagName(context.getModel()));
        props.putAll(extraProps);
        Path templatePath = context.getBasedir().resolve(this.messageTemplate);
        try {
            BufferedReader reader = Files.newBufferedReader(templatePath);
            return MustacheUtils.applyTemplate((Reader)reader, props);
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_reading_template", (Object[])new Object[]{context.relativizeToBasedir(templatePath)}));
        }
    }

    public String getResolvedWebhook() {
        return Env.env((String)"MATTERMOST_WEBHOOK", (String)this.webhook);
    }

    public String getWebhook() {
        return this.webhook;
    }

    public void setWebhook(String webhook) {
        this.webhook = webhook;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    public void setMessageTemplate(String messageTemplate) {
        this.messageTemplate = messageTemplate;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("webhook", StringUtils.isNotBlank((String)this.getResolvedWebhook()) ? "************" : "**unset**");
        props.put("message", this.message);
        props.put("messageTemplate", this.messageTemplate);
    }
}

