/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.git;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.release.Changelog;
import org.jreleaser.sdk.git.ChangelogGenerator;
import org.jreleaser.util.StringUtils;

public class ChangelogProvider {
    public static final String ISSUES_FILE = "issues.txt";
    public static final String CHANGELOG_FILE = "CHANGELOG.md";

    public static String getChangelog(JReleaserContext context) throws IOException {
        Changelog changelog = context.getModel().getRelease().getReleaser().getChangelog();
        if (!changelog.isEnabled()) {
            context.getLogger().info(RB.$((String)"changelog.disabled", (Object[])new Object[0]));
            return "";
        }
        String content = ChangelogProvider.resolveChangelog(context);
        return ChangelogProvider.storeChangelog(context, content);
    }

    public static String storeChangelog(JReleaserContext context, String content) throws IOException {
        Path changelogFile = ChangelogProvider.getReleaseFilePath(context, CHANGELOG_FILE);
        context.getLogger().info(RB.$((String)"changelog.generator.store", (Object[])new Object[0]), new Object[]{context.getBasedir().relativize(changelogFile)});
        context.getLogger().debug(content);
        Files.createDirectories(changelogFile.getParent(), new FileAttribute[0]);
        Files.write(changelogFile, content.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        return content;
    }

    public static List<String> getIssues(JReleaserContext context) throws IOException {
        Path issuesFile = ChangelogProvider.getReleaseFilePath(context, ISSUES_FILE);
        if (Files.exists(issuesFile, new LinkOption[0])) {
            return Files.readAllLines(issuesFile);
        }
        return Collections.emptyList();
    }

    private static String resolveChangelog(JReleaserContext context) throws IOException {
        Changelog changelog;
        String externalChangelog;
        Path issuesFile = ChangelogProvider.getReleaseFilePath(context, ISSUES_FILE);
        if (Files.exists(issuesFile, new LinkOption[0])) {
            Files.delete(issuesFile);
        }
        if (StringUtils.isNotBlank((String)(externalChangelog = (changelog = context.getModel().getRelease().getReleaser().getChangelog()).getExternal()))) {
            Path externalChangelogPath = context.getBasedir().resolve(Paths.get(externalChangelog, new String[0]));
            File externalChangelogFile = externalChangelogPath.toFile();
            if (!externalChangelogFile.exists()) {
                throw new IllegalStateException(RB.$((String)"ERROR_changelog_not_exist", (Object[])new Object[]{context.getBasedir().relativize(externalChangelogPath)}));
            }
            context.getLogger().info(RB.$((String)"changelog.generator.read", (Object[])new Object[0]), new Object[]{context.getBasedir().relativize(externalChangelogPath)});
            String content = new String(Files.readAllBytes(externalChangelogPath));
            if (context.getModel().getRelease().getReleaser().getIssues().isEnabled()) {
                Set<Integer> issues = ChangelogProvider.extractIssues(context, content);
                ChangelogProvider.storeIssues(context, issues);
            }
            return content;
        }
        context.getLogger().info(RB.$((String)"changelog.generator.generate", (Object[])new Object[0]));
        return ChangelogGenerator.generate(context);
    }

    public static Set<Integer> extractIssues(JReleaserContext context, String content) {
        context.getLogger().info(RB.$((String)"issues.generator.extract", (Object[])new Object[0]));
        BaseReleaser releaser = context.getModel().getRelease().getReleaser();
        String issueTracker = releaser.getResolvedIssueTrackerUrl(context.getModel());
        if (!issueTracker.endsWith("/")) {
            issueTracker = issueTracker + "/";
        }
        String p1 = StringUtils.escapeRegexChars((String)issueTracker);
        String p2 = StringUtils.escapeRegexChars((String)releaser.getCanonicalRepoName());
        Pattern pattern = Pattern.compile(".*" + p1 + "(\\d+)|.*" + p2 + "#(\\d+)|.*#(\\d+).*");
        Matcher matcher = pattern.matcher(content);
        TreeSet<Integer> issues = new TreeSet<Integer>();
        while (matcher.find()) {
            if (StringUtils.isNotBlank((String)matcher.group(1))) {
                issues.add(Integer.valueOf(matcher.group(1)));
            }
            if (StringUtils.isNotBlank((String)matcher.group(2))) {
                issues.add(Integer.valueOf(matcher.group(2)));
            }
            if (!StringUtils.isNotBlank((String)matcher.group(3))) continue;
            issues.add(Integer.valueOf(matcher.group(3)));
        }
        return issues;
    }

    public static void storeIssues(JReleaserContext context, Set<Integer> issues) throws IOException {
        if (issues.isEmpty()) {
            return;
        }
        Path issuesFile = ChangelogProvider.getReleaseFilePath(context, ISSUES_FILE);
        String content = issues.stream().map(String::valueOf).collect(Collectors.joining(System.lineSeparator()));
        context.getLogger().info(RB.$((String)"issues.generator.store", (Object[])new Object[0]), new Object[]{context.getBasedir().relativize(issuesFile)});
        context.getLogger().debug(content);
        Files.createDirectories(issuesFile.getParent(), new FileAttribute[0]);
        Files.write(issuesFile, content.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    public static Path getReleaseFilePath(JReleaserContext context, String fileName) {
        return context.getOutputDirectory().resolve("release").resolve(fileName);
    }
}

