/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.github;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.UpdateSection;
import org.jreleaser.model.api.common.Apply;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.util.VersionUtils;
import org.jreleaser.model.spi.release.AbstractReleaser;
import org.jreleaser.model.spi.release.Asset;
import org.jreleaser.model.spi.release.Release;
import org.jreleaser.model.spi.release.ReleaseException;
import org.jreleaser.model.spi.release.Repository;
import org.jreleaser.model.spi.release.User;
import org.jreleaser.mustache.Templates;
import org.jreleaser.sdk.commons.RestAPIException;
import org.jreleaser.sdk.git.ChangelogGenerator;
import org.jreleaser.sdk.git.ChangelogProvider;
import org.jreleaser.sdk.git.GitSdk;
import org.jreleaser.sdk.git.ReleaseUtils;
import org.jreleaser.sdk.github.Github;
import org.jreleaser.sdk.github.XGithub;
import org.jreleaser.sdk.github.api.GhRelease;
import org.jreleaser.sdk.github.api.GhReleaseNotes;
import org.jreleaser.sdk.github.api.GhReleaseNotesParams;
import org.jreleaser.util.StringUtils;
import org.kohsuke.github.GHAsset;
import org.kohsuke.github.GHBranch;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHLabel;
import org.kohsuke.github.GHMilestone;
import org.kohsuke.github.GHRelease;
import org.kohsuke.github.GHReleaseUpdater;
import org.kohsuke.github.GHRepository;

public class GithubReleaser
extends AbstractReleaser<org.jreleaser.model.api.release.GithubReleaser> {
    private final org.jreleaser.model.internal.release.GithubReleaser github;

    public GithubReleaser(JReleaserContext context, List<Asset> assets) {
        super(context, assets);
        this.github = context.getModel().getRelease().getGithub();
    }

    public org.jreleaser.model.api.release.GithubReleaser getReleaser() {
        return this.github.asImmutable();
    }

    public String generateReleaseNotes() throws IOException {
        if (this.github.getReleaseNotes().isEnabled()) {
            String content = this.generateReleaseNotesByAPI();
            if (this.github.getIssues().isEnabled()) {
                Set issues = ChangelogProvider.extractIssues((JReleaserContext)this.context, (String)content);
                ChangelogProvider.storeIssues((JReleaserContext)this.context, (Set)issues);
            }
            return ChangelogProvider.storeChangelog((JReleaserContext)this.context, (String)content);
        }
        try {
            return ChangelogProvider.getChangelog((JReleaserContext)this.context).trim();
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_changelog", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private String generateReleaseNotesByAPI() throws JReleaserException {
        org.jreleaser.model.internal.release.GithubReleaser github = this.context.getModel().getRelease().getGithub();
        String tagName = github.getEffectiveTagName(this.context.getModel());
        try {
            Git git = GitSdk.of((JReleaserContext)this.context).open();
            ChangelogGenerator.Tags tags = new ChangelogGenerator().resolveTags(git, this.context);
            GhReleaseNotesParams params = new GhReleaseNotesParams();
            params.setTagName(tagName);
            if (!this.isTagInRemote(this.context, tagName)) {
                params.setTagName("HEAD");
            }
            if (tags.getPrevious().isPresent()) {
                params.setPreviousTagName(GitSdk.extractTagName((Ref)((Ref)tags.getPrevious().get())));
            }
            params.setTargetCommitish(github.getBranch());
            GhReleaseNotes releaseNotes = new XGithub(this.context.getLogger(), github.getApiEndpoint(), github.getResolvedToken(), github.getConnectTimeout(), github.getReadTimeout()).generateReleaseNotes(github.getOwner(), github.getName(), params);
            return releaseNotes.getBody().replace("...HEAD", "..." + tagName);
        }
        catch (IOException | GitAPIException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_changelog", (Object[])new Object[0]), e);
        }
    }

    protected boolean isTagInRemote(JReleaserContext context, String tagName) {
        org.jreleaser.model.internal.release.GithubReleaser github = context.getModel().getRelease().getGithub();
        try {
            Github api = new Github(context.getLogger(), github.getApiEndpoint(), github.getResolvedToken(), github.getConnectTimeout(), github.getReadTimeout());
            GHRepository repository = api.findRepository(github.getOwner(), github.getName());
            if (null == repository) {
                throw new IllegalStateException(RB.$((String)"ERROR_git_repository_not_exists", (Object[])new Object[]{github.getCanonicalRepoName()}));
            }
            return null != repository.getRef("tags/" + tagName);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            context.getLogger().trace((Throwable)e);
            throw new JReleaserException((Throwable)e);
        }
    }

    protected void createTag() throws ReleaseException {
        ReleaseUtils.createTag((JReleaserContext)this.context);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createRelease() throws ReleaseException {
        org.jreleaser.model.internal.release.GithubReleaser github = this.context.getModel().getRelease().getGithub();
        this.context.getLogger().info(RB.$((String)"git.releaser.releasing", (Object[])new Object[0]), new Object[]{github.getResolvedRepoUrl(this.context.getModel())});
        String tagName = github.getEffectiveTagName(this.context.getModel());
        try {
            Github api = new Github(this.context.getLogger(), github.getApiEndpoint(), github.getResolvedToken(), github.getConnectTimeout(), github.getReadTimeout());
            String branch = github.getBranch();
            Map<String, GHBranch> branches = api.listBranches(github.getOwner(), github.getName());
            if (!branches.containsKey(branch)) {
                throw new ReleaseException(RB.$((String)"ERROR_git_release_branch_not_exists", (Object[])new Object[]{branch, branches.keySet()}));
            }
            String changelog = this.context.getChangelog();
            this.context.getLogger().debug(RB.$((String)"git.releaser.release.lookup", (Object[])new Object[0]), new Object[]{tagName, github.getCanonicalRepoName()});
            GHRelease release = api.findReleaseByTag(github.getCanonicalRepoName(), tagName);
            boolean snapshot = this.context.getModel().getProject().isSnapshot();
            if (null != release) {
                this.context.getLogger().debug(RB.$((String)"git.releaser.release.exists", (Object[])new Object[0]), new Object[]{tagName});
                if (github.isOverwrite() || snapshot) {
                    this.context.getLogger().debug(RB.$((String)"git.releaser.release.delete", (Object[])new Object[0]), new Object[]{tagName});
                    if (!this.context.isDryrun()) {
                        release.delete();
                    }
                    this.context.getLogger().debug(RB.$((String)"git.releaser.release.create", (Object[])new Object[0]), new Object[]{tagName});
                    this.createRelease(api, tagName, changelog, github.isMatch());
                    return;
                }
                if (github.getUpdate().isEnabled()) {
                    this.context.getLogger().debug(RB.$((String)"git.releaser.release.update", (Object[])new Object[0]), new Object[]{tagName});
                    if (this.context.isDryrun()) return;
                    GHReleaseUpdater updater = release.update();
                    updater.prerelease(github.getPrerelease().isEnabled());
                    updater.draft(github.isDraft());
                    if (github.getUpdate().getSections().contains(UpdateSection.TITLE)) {
                        this.context.getLogger().info(RB.$((String)"git.releaser.release.update.title", (Object[])new Object[0]), new Object[]{github.getEffectiveReleaseName()});
                        updater.name(github.getEffectiveReleaseName());
                    }
                    if (github.getUpdate().getSections().contains(UpdateSection.BODY)) {
                        this.context.getLogger().info(RB.$((String)"git.releaser.release.update.body", (Object[])new Object[0]));
                        updater.body(changelog);
                    }
                    release = updater.update();
                    if (github.getUpdate().getSections().contains(UpdateSection.ASSETS)) {
                        this.updateAssets(api, release);
                    }
                    this.linkDiscussion(tagName, release);
                    this.updateIssues(github, api);
                    return;
                }
                if (this.context.isDryrun()) {
                    this.context.getLogger().debug(RB.$((String)"git.releaser.release.create", (Object[])new Object[0]), new Object[]{tagName});
                    this.createRelease(api, tagName, changelog, false);
                    return;
                }
                throw new IllegalStateException(RB.$((String)"ERROR_git_releaser_cannot_release", (Object[])new Object[]{"GitHub", tagName}));
            }
            this.context.getLogger().debug(RB.$((String)"git.releaser.release.not.found", (Object[])new Object[0]), new Object[]{tagName});
            this.context.getLogger().debug(RB.$((String)"git.releaser.release.create", (Object[])new Object[0]), new Object[]{tagName});
            this.createRelease(api, tagName, changelog, snapshot && github.isMatch());
            return;
        }
        catch (RestAPIException e) {
            this.context.getLogger().trace(e.getStatus() + " " + e.getReason());
            this.context.getLogger().trace((Throwable)e);
            throw new ReleaseException((Throwable)e);
        }
        catch (IOException | IllegalStateException e) {
            this.context.getLogger().trace((Throwable)e);
            throw new ReleaseException((Throwable)e);
        }
    }

    public Repository maybeCreateRepository(String owner, String repo, String password) throws IOException {
        org.jreleaser.model.internal.release.GithubReleaser github = this.context.getModel().getRelease().getGithub();
        this.context.getLogger().debug(RB.$((String)"git.repository.lookup", (Object[])new Object[0]), new Object[]{owner, repo});
        Github api = new Github(this.context.getLogger(), github.getApiEndpoint(), password, github.getConnectTimeout(), github.getReadTimeout());
        GHRepository repository = api.findRepository(owner, repo);
        if (null == repository) {
            repository = api.createRepository(owner, repo);
        }
        return new Repository(Repository.Kind.GITHUB, owner, repo, repository.getUrl().toExternalForm(), repository.getHttpTransportUrl());
    }

    public Optional<User> findUser(String email, String name) {
        org.jreleaser.model.internal.release.GithubReleaser github = this.context.getModel().getRelease().getGithub();
        try {
            return new XGithub(this.context.getLogger(), github.getApiEndpoint(), github.getResolvedToken(), github.getConnectTimeout(), github.getReadTimeout()).findUser(email, name);
        }
        catch (IOException | RestAPIException e) {
            this.context.getLogger().trace(e);
            this.context.getLogger().debug(RB.$((String)"git.releaser.user.not.found", (Object[])new Object[0]), new Object[]{email});
            return Optional.empty();
        }
    }

    public List<Release> listReleases(String owner, String repo) throws IOException {
        org.jreleaser.model.internal.release.GithubReleaser github = this.context.getModel().getRelease().getGithub();
        Github api = new Github(this.context.getLogger(), github.getApiEndpoint(), github.getResolvedToken(), github.getConnectTimeout(), github.getReadTimeout());
        ArrayList<Release> releases = new ArrayList<Release>();
        for (GHRelease ghRelease : api.listReleases(owner, repo).toList()) {
            if (ghRelease.isDraft() || ghRelease.isPrerelease()) continue;
            releases.add(new Release(ghRelease.getName(), ghRelease.getTagName(), ghRelease.getHtmlUrl().toExternalForm(), ghRelease.getPublished_at()));
        }
        VersionUtils.clearUnparseableTags();
        Pattern versionPattern = VersionUtils.resolveVersionPattern((JReleaserContext)this.context);
        for (Release release : releases) {
            release.setVersion(VersionUtils.version((JReleaserContext)this.context, (String)release.getTagName(), (Pattern)versionPattern));
        }
        releases.sort((r1, r2) -> r2.getVersion().compareTo((Object)r1.getVersion()));
        return releases;
    }

    private void createRelease(Github api, String tagName, String changelog, boolean deleteTags) throws IOException {
        Optional<GHMilestone> milestone;
        org.jreleaser.model.internal.release.GithubReleaser github = this.context.getModel().getRelease().getGithub();
        if (this.context.isDryrun()) {
            for (Asset asset : this.assets) {
                if (0L == Files.size(asset.getPath()) || !Files.exists(asset.getPath(), new LinkOption[0])) continue;
                this.context.getLogger().info(" " + RB.$((String)"git.upload.asset", (Object[])new Object[0]), new Object[]{asset.getFilename()});
            }
            this.updateIssues(github, api);
            return;
        }
        if (deleteTags) {
            this.deleteTags(api, github.getCanonicalRepoName(), tagName);
        }
        if (deleteTags || !github.isSkipTag()) {
            this.context.getLogger().debug(RB.$((String)"git.releaser.repository.tag", (Object[])new Object[0]), new Object[]{tagName});
            GitSdk.of((JReleaserContext)this.context).tag(tagName, true, this.context);
        }
        GHRelease release = api.createRelease(github.getCanonicalRepoName(), tagName).commitish(github.getBranch()).name(github.getEffectiveReleaseName()).draft(github.isDraft()).prerelease(github.getPrerelease().isEnabled()).body(changelog).create();
        api.uploadAssets(release, this.assets);
        if (github.getMilestone().isClose() && !this.context.getModel().getProject().isSnapshot() && (milestone = api.findMilestoneByName(github.getOwner(), github.getName(), github.getMilestone().getEffectiveName())).isPresent()) {
            api.closeMilestone(github.getOwner(), github.getName(), milestone.get());
        }
        this.linkDiscussion(tagName, release);
        this.updateIssues(github, api);
    }

    private void updateIssues(org.jreleaser.model.internal.release.GithubReleaser github, Github api) throws IOException {
        if (!github.getIssues().isEnabled()) {
            return;
        }
        List issueNumbers = ChangelogProvider.getIssues((JReleaserContext)this.context);
        if (!issueNumbers.isEmpty()) {
            this.context.getLogger().info(RB.$((String)"git.issue.release.mark", (Object[])new Object[]{issueNumbers.size()}));
        }
        if (this.context.isDryrun()) {
            for (String issueNumber : issueNumbers) {
                this.context.getLogger().debug(RB.$((String)"git.issue.release", (Object[])new Object[]{issueNumber}));
            }
            return;
        }
        String tagName = github.getEffectiveTagName(this.context.getModel());
        String labelName = github.getIssues().getLabel().getName();
        String labelColor = github.getIssues().getLabel().getColor();
        Map props = github.props(this.context.getModel());
        github.fillProps(props, this.context.getModel());
        String comment = Templates.resolveTemplate((String)github.getIssues().getComment(), (Map)props);
        if (labelColor.startsWith("#")) {
            labelColor = labelColor.substring(1);
        }
        GHRepository ghRepository = api.findRepository(github.getOwner(), github.getName());
        GHLabel ghLabel = null;
        try {
            ghLabel = api.getOrCreateLabel(ghRepository, labelName, labelColor, github.getIssues().getLabel().getDescription());
        }
        catch (IOException e) {
            throw new IllegalStateException(RB.$((String)"ERROR_git_releaser_fetch_label", (Object[])new Object[]{tagName, labelName}), e);
        }
        Optional<Object> milestone = Optional.empty();
        Apply applyMilestone = github.getIssues().getApplyMilestone();
        if (applyMilestone != Apply.NEVER && !(milestone = api.findMilestoneByName(github.getOwner(), github.getName(), github.getMilestone().getEffectiveName())).isPresent()) {
            milestone = api.findClosedMilestoneByName(github.getOwner(), github.getName(), github.getMilestone().getEffectiveName());
        }
        for (String issueNumber : issueNumbers) {
            try {
                GHIssue ghIssue;
                Optional<GHIssue> op = api.findIssue(ghRepository, Integer.parseInt(issueNumber));
                if (!op.isPresent() || (ghIssue = op.get()).getState() != GHIssueState.CLOSED || !ghIssue.getLabels().stream().noneMatch(l -> l.getName().equals(labelName))) continue;
                this.context.getLogger().debug(RB.$((String)"git.issue.release", (Object[])new Object[]{issueNumber}));
                ghIssue.addLabels(new GHLabel[]{ghLabel});
                ghIssue.comment(comment);
                if (!milestone.isPresent()) continue;
                this.applyMilestone(issueNumber, ghIssue, applyMilestone, (GHMilestone)milestone.get());
            }
            catch (IOException e) {
                throw new IllegalStateException(RB.$((String)"ERROR_git_releaser_cannot_release", (Object[])new Object[]{tagName, issueNumber}), e);
            }
        }
    }

    private void applyMilestone(String issueNumber, GHIssue ghIssue, Apply applyMilestone, GHMilestone targetMilestone) throws IOException {
        GHMilestone issueMilestone = ghIssue.getMilestone();
        String targetMilestoneTitle = targetMilestone.getTitle();
        if (null == issueMilestone) {
            this.context.getLogger().debug(RB.$((String)"git.issue.milestone.apply", (Object[])new Object[]{targetMilestoneTitle, issueNumber}));
            ghIssue.setMilestone(targetMilestone);
        } else {
            String milestoneTitle = issueMilestone.getTitle();
            if (applyMilestone == Apply.ALWAYS) {
                this.context.getLogger().debug(StringUtils.uncapitalize((String)RB.$((String)"git.issue.milestone.warn", (Object[])new Object[]{issueNumber, milestoneTitle})));
            } else if (applyMilestone == Apply.WARN) {
                if (!milestoneTitle.equals(targetMilestoneTitle)) {
                    this.context.getLogger().warn(RB.$((String)"git.issue.milestone.warn", (Object[])new Object[]{issueNumber, milestoneTitle}));
                }
            } else if (applyMilestone == Apply.FORCE) {
                if (!milestoneTitle.equals(targetMilestoneTitle)) {
                    this.context.getLogger().warn(RB.$((String)"git.issue.milestone.force", (Object[])new Object[]{targetMilestoneTitle, issueNumber, milestoneTitle}));
                    ghIssue.setMilestone(targetMilestone);
                } else {
                    this.context.getLogger().debug(StringUtils.uncapitalize((String)RB.$((String)"git.issue.milestone.warn", (Object[])new Object[]{issueNumber, milestoneTitle})));
                }
            }
        }
    }

    private void updateAssets(Github api, GHRelease release) throws IOException {
        org.jreleaser.model.internal.release.GithubReleaser github = this.context.getModel().getRelease().getGithub();
        ArrayList<Asset> assetsToBeUpdated = new ArrayList<Asset>();
        ArrayList<Asset> assetsToBeUploaded = new ArrayList<Asset>();
        Map<String, GHAsset> existingAssets = api.listAssets(github.getOwner(), github.getName(), release);
        LinkedHashMap assetsToBePublished = new LinkedHashMap();
        this.assets.forEach(asset -> assetsToBePublished.put(asset.getFilename(), asset));
        assetsToBePublished.keySet().forEach(name -> {
            if (existingAssets.containsKey(name)) {
                assetsToBeUpdated.add((Asset)assetsToBePublished.get(name));
            } else {
                assetsToBeUploaded.add((Asset)assetsToBePublished.get(name));
            }
        });
        api.updateAssets(release, assetsToBeUpdated, existingAssets);
        api.uploadAssets(release, assetsToBeUploaded);
    }

    private void linkDiscussion(String tagName, GHRelease release) {
        org.jreleaser.model.internal.release.GithubReleaser github = this.context.getModel().getRelease().getGithub();
        String discussionCategoryName = github.getDiscussionCategoryName();
        if (this.context.getModel().getProject().isSnapshot() || StringUtils.isBlank((String)discussionCategoryName) || github.isDraft()) {
            return;
        }
        this.context.getLogger().debug(RB.$((String)"git.releaser.link.discussion", (Object[])new Object[0]), new Object[]{tagName, discussionCategoryName});
        if (this.context.isDryrun()) {
            return;
        }
        try {
            XGithub xapi = new XGithub(this.context.getLogger(), github.getApiEndpoint(), github.getResolvedToken(), github.getConnectTimeout(), github.getReadTimeout());
            GhRelease ghRelease = new GhRelease();
            ghRelease.setDiscussionCategoryName(discussionCategoryName);
            xapi.updateRelease(github.getOwner(), github.getName(), tagName, release.getId(), ghRelease);
        }
        catch (IOException | RestAPIException e) {
            this.context.getLogger().trace(e);
            this.context.getLogger().warn(RB.$((String)"git.releaser.link.discussion.error", (Object[])new Object[0]), new Object[]{tagName, discussionCategoryName});
        }
    }

    private void deleteTags(Github api, String repo, String tagName) {
        try {
            api.deleteTag(repo, tagName);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

