/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.download;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.download.Downloader;
import org.jreleaser.model.internal.download.ScpDownloader;
import org.jreleaser.model.internal.validation.common.SshValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class ScpDownloaderValidator
extends Validator {
    public static void validateScpDownloader(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, ScpDownloader> scp = context.getModel().getDownload().getScp();
        if (!scp.isEmpty()) {
            context.getLogger().debug("download.scp");
        }
        for (Map.Entry<String, ScpDownloader> e : scp.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig() && !mode.validateDownload()) continue;
            ScpDownloaderValidator.validateScpDownloader(context, mode, e.getValue(), errors);
        }
    }

    private static void validateScpDownloader(JReleaserContext context, JReleaserContext.Mode mode, ScpDownloader scp, Errors errors) {
        context.getLogger().debug("download.scp.{}", new Object[]{scp.getName()});
        if (!scp.isActiveSet()) {
            scp.setActive(Active.ALWAYS);
        }
        if (!scp.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        SshValidator.validateSsh(context, scp, scp.getName(), "SCP", scp.getType(), errors);
        ScpDownloaderValidator.validateTimeout(scp);
        if (scp.getAssets().isEmpty()) {
            errors.configuration(RB.$((String)"validation_must_not_be_empty", (Object[])new Object[]{"scp." + scp.getName() + ".assets"}));
        } else {
            int index = 0;
            for (Downloader.Asset asset : scp.getAssets()) {
                if (!StringUtils.isBlank((String)asset.getInput())) continue;
                errors.configuration(RB.$((String)"validation_must_not_be_null", (Object[])new Object[]{"scp." + scp.getName() + ".asset[" + index++ + "].input"}));
            }
        }
    }
}

