/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.assemble;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.ArchiveAssembler;
import org.jreleaser.model.internal.assemble.Assemble;
import org.jreleaser.model.internal.assemble.JlinkAssembler;
import org.jreleaser.model.internal.assemble.JpackageAssembler;
import org.jreleaser.model.internal.assemble.NativeImageAssembler;
import org.jreleaser.model.internal.validation.assemble.ArchiveAssemblerValidator;
import org.jreleaser.model.internal.validation.assemble.JlinkAssemblerValidator;
import org.jreleaser.model.internal.validation.assemble.JpackageAssemblerValidator;
import org.jreleaser.model.internal.validation.assemble.NativeImageAssemblerValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;

public abstract class AssemblersValidator
extends Validator {
    public static void validateAssemblers(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        List types2;
        Assemble assemble = context.getModel().getAssemble();
        context.getLogger().debug("assemble");
        ArchiveAssemblerValidator.validateArchive(context, mode, errors);
        JlinkAssemblerValidator.validateJlink(context, mode, errors);
        JpackageAssemblerValidator.validateJpackage(context, mode, errors);
        NativeImageAssemblerValidator.validateNativeImage(context, mode, errors);
        if (!mode.validateConfig() && !mode.validateAssembly()) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        LinkedHashMap<String, List> byDistributionName = new LinkedHashMap<String, List>();
        for (ArchiveAssembler archive : assemble.getActiveArchives()) {
            types2 = byDistributionName.computeIfAbsent(archive.getName(), k -> new ArrayList());
            types2.add(archive.getType());
        }
        for (JlinkAssembler jlink : assemble.getActiveJlinks()) {
            types2 = byDistributionName.computeIfAbsent(jlink.getName(), k -> new ArrayList());
            if (!jlink.isExported()) continue;
            types2.add(jlink.getType());
        }
        for (JpackageAssembler jpackage : assemble.getActiveJpackages()) {
            types2 = byDistributionName.computeIfAbsent(jpackage.getName(), k -> new ArrayList());
            if (!jpackage.isExported()) continue;
            types2.add(jpackage.getType());
        }
        for (NativeImageAssembler nativeImage : assemble.getActiveNativeImages()) {
            types2 = byDistributionName.computeIfAbsent(nativeImage.getName(), k -> new ArrayList());
            if (!nativeImage.isExported()) continue;
            types2.add(nativeImage.getType());
        }
        byDistributionName.forEach((name, types) -> {
            if (types.size() > 1) {
                errors.configuration(RB.$((String)"validation_multiple_assemblers", (Object[])new Object[]{"distribution." + name, types}));
                context.getLogger().debug(RB.$((String)"validation.disabled.error", (Object[])new Object[0]));
                assemble.disable();
            }
        });
        boolean activeSet = assemble.isActiveSet();
        assemble.resolveEnabled(context.getModel().getProject());
        if (assemble.isEnabled()) {
            boolean enabled;
            boolean bl = enabled = !assemble.getActiveArchives().isEmpty() || !assemble.getActiveJlinks().isEmpty() || !assemble.getActiveJpackages().isEmpty() || !assemble.getActiveNativeImages().isEmpty();
            if (!activeSet && !enabled) {
                context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
                assemble.disable();
            }
        }
    }

    public static void postValidateAssemblers(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        context.getLogger().debug("assemble");
        JpackageAssemblerValidator.postValidateJpackage(context, mode, errors);
    }
}

