/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.mustachejava.TemplateFunction;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.JReleaserVersion;
import org.jreleaser.model.api.JReleaserModel;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.Announce;
import org.jreleaser.model.internal.assemble.Assemble;
import org.jreleaser.model.internal.catalog.Catalog;
import org.jreleaser.model.internal.checksum.Checksum;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.common.Matrix;
import org.jreleaser.model.internal.deploy.Deploy;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.download.Download;
import org.jreleaser.model.internal.environment.Environment;
import org.jreleaser.model.internal.extensions.Extension;
import org.jreleaser.model.internal.files.Files;
import org.jreleaser.model.internal.hooks.Hooks;
import org.jreleaser.model.internal.packagers.Packagers;
import org.jreleaser.model.internal.platform.Platform;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.release.Release;
import org.jreleaser.model.internal.signing.Signing;
import org.jreleaser.model.internal.upload.Upload;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.TimeUtils;

public class JReleaserModel {
    private final Environment environment = new Environment();
    private final Matrix matrix = new Matrix();
    private final Hooks hooks = new Hooks();
    private final Project project = new Project();
    private final Platform platform = new Platform();
    private final Release release = new Release();
    private final Packagers packagers = new Packagers();
    private final Announce announce = new Announce();
    private final Download download = new Download();
    private final Assemble assemble = new Assemble();
    private final Deploy deploy = new Deploy();
    private final Upload upload = new Upload();
    private final Checksum checksum = new Checksum();
    private final Signing signing = new Signing();
    private final Files files = new Files();
    private final Catalog catalog = new Catalog();
    private final Map<String, Distribution> distributions = new LinkedHashMap<String, Distribution>();
    private final Map<String, Extension> extensions = new LinkedHashMap<String, Extension>();
    @JsonIgnore
    private final ZonedDateTime now;
    @JsonIgnore
    private final String timestamp;
    @JsonIgnore
    private JReleaserModel.Commit commit;
    @JsonIgnore
    private final org.jreleaser.model.api.JReleaserModel immutable = new org.jreleaser.model.api.JReleaserModel(){
        private static final long serialVersionUID = 7516005666920509247L;
        private Map<String, ? extends org.jreleaser.model.api.distributions.Distribution> distributions;
        private Map<String, ? extends org.jreleaser.model.api.extensions.Extension> extensions;

        public ZonedDateTime getNow() {
            return JReleaserModel.this.now;
        }

        public String getTimestamp() {
            return JReleaserModel.this.timestamp;
        }

        public JReleaserModel.Commit getCommit() {
            return JReleaserModel.this.commit;
        }

        public org.jreleaser.model.api.environment.Environment getEnvironment() {
            return JReleaserModel.this.environment.asImmutable();
        }

        public org.jreleaser.model.api.common.Matrix getMatrix() {
            return JReleaserModel.this.matrix.asImmutable();
        }

        public org.jreleaser.model.api.hooks.Hooks getHooks() {
            return JReleaserModel.this.hooks.asImmutable();
        }

        public org.jreleaser.model.api.platform.Platform getPlatform() {
            return JReleaserModel.this.platform.asImmutable();
        }

        public org.jreleaser.model.api.project.Project getProject() {
            return JReleaserModel.this.project.asImmutable();
        }

        public org.jreleaser.model.api.release.Release getRelease() {
            return JReleaserModel.this.release.asImmutable();
        }

        public org.jreleaser.model.api.packagers.Packagers getPackagers() {
            return JReleaserModel.this.packagers.asImmutable();
        }

        public org.jreleaser.model.api.announce.Announce getAnnounce() {
            return JReleaserModel.this.announce.asImmutable();
        }

        public org.jreleaser.model.api.assemble.Assemble getAssemble() {
            return JReleaserModel.this.assemble.asImmutable();
        }

        public org.jreleaser.model.api.download.Download getDownload() {
            return JReleaserModel.this.download.asImmutable();
        }

        public org.jreleaser.model.api.deploy.Deploy getDeploy() {
            return JReleaserModel.this.deploy.asImmutable();
        }

        public org.jreleaser.model.api.upload.Upload getUpload() {
            return JReleaserModel.this.upload.asImmutable();
        }

        public org.jreleaser.model.api.checksum.Checksum getChecksum() {
            return JReleaserModel.this.checksum.asImmutable();
        }

        public org.jreleaser.model.api.signing.Signing getSigning() {
            return JReleaserModel.this.signing.asImmutable();
        }

        public org.jreleaser.model.api.files.Files getFiles() {
            return JReleaserModel.this.files.asImmutable();
        }

        public org.jreleaser.model.api.catalog.Catalog getCatalog() {
            return JReleaserModel.this.catalog.asImmutable();
        }

        public Map<String, ? extends org.jreleaser.model.api.distributions.Distribution> getDistributions() {
            if (null == this.distributions) {
                this.distributions = JReleaserModel.this.distributions.values().stream().map(Distribution::asImmutable).collect(Collectors.toMap(org.jreleaser.model.api.distributions.Distribution::getName, Function.identity()));
            }
            return this.distributions;
        }

        public Map<String, ? extends org.jreleaser.model.api.extensions.Extension> getExtensions() {
            if (null == this.extensions) {
                this.extensions = JReleaserModel.this.extensions.values().stream().map(Extension::asImmutable).collect(Collectors.toMap(org.jreleaser.model.api.extensions.Extension::getName, Function.identity()));
            }
            return this.extensions;
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(JReleaserModel.this.asMap(full));
        }
    };

    public JReleaserModel() {
        this.now = ZonedDateTime.now();
        this.timestamp = this.now.format(TimeUtils.TIMESTAMP_FORMATTER);
    }

    public org.jreleaser.model.api.JReleaserModel asImmutable() {
        return this.immutable;
    }

    public ZonedDateTime getNow() {
        return this.now;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public JReleaserModel.Commit getCommit() {
        return this.commit;
    }

    public void setCommit(JReleaserModel.Commit commit) {
        this.commit = commit;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment.merge(environment);
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public void setMatrix(Matrix matrix) {
        this.matrix.merge(matrix);
    }

    public Hooks getHooks() {
        return this.hooks;
    }

    public void setHooks(Hooks hooks) {
        this.hooks.merge(hooks);
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform.merge(platform);
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project.merge(project);
    }

    public Release getRelease() {
        return this.release;
    }

    public void setRelease(Release release) {
        this.release.merge(release);
    }

    public Packagers getPackagers() {
        return this.packagers;
    }

    public void setPackagers(Packagers packagers) {
        this.packagers.merge(packagers);
    }

    public Announce getAnnounce() {
        return this.announce;
    }

    public void setAnnounce(Announce announce) {
        this.announce.merge(announce);
    }

    public Assemble getAssemble() {
        return this.assemble;
    }

    public void setAssemble(Assemble assemble) {
        this.assemble.merge(assemble);
    }

    public Download getDownload() {
        return this.download;
    }

    public void setDownload(Download download) {
        this.download.merge(download);
    }

    public Deploy getDeploy() {
        return this.deploy;
    }

    public void setDeploy(Deploy deploy) {
        this.deploy.merge(deploy);
    }

    public Upload getUpload() {
        return this.upload;
    }

    public void setUpload(Upload upload) {
        this.upload.merge(upload);
    }

    public Checksum getChecksum() {
        return this.checksum;
    }

    public void setChecksum(Checksum checksum) {
        this.checksum.merge(checksum);
    }

    public Signing getSigning() {
        return this.signing;
    }

    public void setSigning(Signing signing) {
        this.signing.merge(signing);
    }

    public Files getFiles() {
        return this.files;
    }

    public void setFiles(Files files) {
        this.files.merge(files);
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(Catalog catalog) {
        this.catalog.merge(catalog);
    }

    public List<Distribution> getActiveDistributions() {
        return this.distributions.values().stream().filter(AbstractActivatable::isEnabled).collect(Collectors.toList());
    }

    public Map<String, Distribution> getDistributions() {
        return this.distributions;
    }

    public void setDistributions(Map<String, Distribution> distributions) {
        this.distributions.clear();
        this.distributions.putAll(distributions);
    }

    public void addDistribution(Distribution distribution) {
        this.distributions.put(distribution.getName(), distribution);
    }

    public Distribution findDistribution(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new JReleaserException(RB.$((String)"ERROR_distribution_name_is_blank", (Object[])new Object[0]));
        }
        if (this.distributions.containsKey(name)) {
            return this.distributions.get(name);
        }
        throw new JReleaserException(RB.$((String)"ERROR_distribution_not_found", (Object[])new Object[]{name}));
    }

    public List<Extension> getActiveExtensions() {
        return this.extensions.values().stream().filter(Extension::isEnabled).collect(Collectors.toList());
    }

    public Map<String, Extension> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Map<String, Extension> extensions) {
        this.extensions.clear();
        this.extensions.putAll(extensions);
    }

    public void addExtension(Extension extension) {
        this.extensions.put(extension.getName(), extension);
    }

    public ZonedDateTime resolveArchiveTimestamp() {
        if (null != this.commit) {
            return this.commit.getTimestamp();
        }
        return this.now;
    }

    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        List extensions = this.extensions.values().stream().filter(e -> full || e.isEnabled()).map(e -> e.asMap(full)).collect(Collectors.toList());
        if (!extensions.isEmpty()) {
            map.put("extensions", extensions);
        }
        if (full || this.environment.isSet()) {
            map.put("environment", this.environment.asMap(full));
        }
        this.matrix.asMap(map);
        if (full || this.hooks.isSet()) {
            map.put("hooks", this.hooks.asMap(full));
        }
        map.put("project", this.project.asMap(full));
        if (full || this.platform.isSet()) {
            map.put("platform", this.platform.asMap(full));
        }
        map.put("release", this.release.asMap(full));
        map.put("checksum", this.checksum.asMap(full));
        if (full || this.signing.isEnabled()) {
            map.put("signing", this.signing.asMap(full));
        }
        if (full || this.announce.isEnabled()) {
            map.put("announce", this.announce.asMap(full));
        }
        if (!this.files.isEmpty()) {
            map.put("files", this.files.asMap(full));
        }
        if (full || this.packagers.hasEnabledPackagers()) {
            map.put("packagers", this.packagers.asMap(full));
        }
        if (full || this.download.isEnabled()) {
            map.put("download", this.download.asMap(full));
        }
        if (full || this.assemble.isEnabled()) {
            map.put("assemble", this.assemble.asMap(full));
        }
        if (full || this.deploy.isEnabled()) {
            map.put("deploy", this.deploy.asMap(full));
        }
        if (full || this.upload.isEnabled()) {
            map.put("upload", this.upload.asMap(full));
        }
        map.put("catalog", this.catalog.asMap(full));
        List distributions = this.distributions.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList());
        if (!distributions.isEmpty()) {
            map.put("distributions", distributions);
        }
        return map;
    }

    public TemplateContext props(JReleaserContext context) {
        TemplateContext props = new TemplateContext();
        props.set("Model", (Object)this.asImmutable());
        String jreleaserCreationStamp = String.format("Generated with JReleaser %s at %s", JReleaserVersion.getPlainVersion(), this.timestamp);
        props.set("jreleaserCreationStamp", (Object)jreleaserCreationStamp);
        this.fillProjectProperties(context, props, this.project);
        this.fillReleaserProperties(context, props, this.release);
        String osName = PlatformUtils.getDetectedOs();
        String osArch = PlatformUtils.getDetectedArch();
        props.set("osName", (Object)osName);
        props.set("osArch", (Object)osArch);
        props.set("osVersion", (Object)PlatformUtils.getDetectedVersion());
        props.set("osPlatform", (Object)PlatformUtils.getCurrentFull());
        props.set("osPlatformReplaced", (Object)this.getPlatform().applyReplacements(PlatformUtils.getCurrentFull()));
        MustacheUtils.applyTemplates((JReleaserLogger)context.getLogger(), (TemplateContext)props, this.project.resolvedExtraProperties());
        props.set("__ZonedDateTime_now__", (Object)this.now);
        props.set("f_release_download_url", (Object)new ReleaserDownloadUrl());
        return props;
    }

    private void fillProjectProperties(JReleaserContext context, TemplateContext props, Project project) {
        props.setAll(this.environment.getProperties());
        props.setAll(this.environment.getSourcedProperties());
        props.set("timestamp", (Object)this.timestamp);
        if (null != this.commit) {
            props.set("commitShortHash", (Object)this.commit.getShortHash());
            props.set("commitFullHash", (Object)this.commit.getFullHash());
        }
        props.set("projectName", (Object)project.getName());
        props.set("projectNameCapitalized", (Object)StringUtils.getCapitalizedName((String)project.getName()));
        props.set("projectVersion", (Object)project.getVersion());
        props.set("projectStereotype", (Object)project.getStereotype());
        props.set("projectEffectiveVersion", (Object)project.getEffectiveVersion());
        props.set("projectSnapshot", (Object)String.valueOf(project.isSnapshot()));
        if (StringUtils.isNotBlank((String)project.getDescription())) {
            props.set("projectDescription", (Object)MustacheUtils.passThrough((String)project.getDescription()));
        }
        if (StringUtils.isNotBlank((String)project.getLongDescription())) {
            props.set("projectLongDescription", (Object)MustacheUtils.passThrough((String)project.getLongDescription()));
        }
        if (StringUtils.isNotBlank((String)project.getLicense())) {
            props.set("projectLicense", (Object)project.getLicense());
        }
        if (null != project.getInceptionYear()) {
            props.set("projectInceptionYear", (Object)project.getInceptionYear());
        }
        if (StringUtils.isNotBlank((String)project.getCopyright())) {
            props.set("projectCopyright", (Object)project.getCopyright());
        }
        if (StringUtils.isNotBlank((String)project.getVendor())) {
            props.set("projectVendor", (Object)project.getVendor());
        }
        project.getLinks().fillProps(props);
        props.set("projectAuthorsBySpace", (Object)String.join((CharSequence)" ", project.getAuthors()));
        props.set("projectAuthorsByComma", (Object)String.join((CharSequence)",", project.getAuthors()));
        props.set("projectTagsBySpace", (Object)String.join((CharSequence)" ", project.getTags()));
        props.set("projectTagsByComma", (Object)String.join((CharSequence)",", project.getTags()));
        project.getLanguages().fillProperties(props);
        project.parseVersion();
        props.setAll(project.resolvedExtraProperties());
    }

    private void fillReleaserProperties(JReleaserContext context, TemplateContext props, Release release) {
        BaseReleaser<?, ?> service = release.getReleaser();
        if (null == service) {
            return;
        }
        props.set("repoHost", (Object)service.getHost());
        props.set("repoOwner", (Object)service.getOwner());
        props.set("repoName", (Object)service.getName());
        props.set("repoBranch", (Object)service.getBranch());
        props.set("repoBranchPush", (Object)service.getResolvedBranchPush(context));
        props.set("reverseRepoHost", (Object)service.getReverseRepoHost());
        props.set("repoCanonicalName", (Object)service.getCanonicalRepoName());
        props.set("tagName", (Object)service.getEffectiveTagName(context));
        props.set("previousTagName", (Object)service.getResolvedPreviousTagName(context));
        props.set("releaseName", (Object)service.getEffectiveReleaseName());
        props.set("milestoneName", (Object)service.getMilestone().getEffectiveName());
        props.set("repoUrl", (Object)service.getResolvedRepoUrl(context));
        props.set("repoCloneUrl", (Object)service.getResolvedRepoCloneUrl(context));
        props.set("commitsUrl", (Object)service.getResolvedCommitUrl(context));
        props.set("srcUrl", (Object)service.getResolvedSrcUrl(context));
        props.set("releaseNotesUrl", (Object)service.getResolvedReleaseNotesUrl(context));
        props.set("latestReleaseUrl", (Object)service.getResolvedLatestReleaseUrl(context));
        props.set("issueTrackerUrl", (Object)service.getResolvedIssueTrackerUrl(context, false));
    }

    private final class ReleaserDownloadUrl
    implements TemplateFunction {
        private static final String NAME = "f_release_download_url";
        private static final String MARKDOWN = "md";
        private static final String ASCIIDOC = "adoc";
        private static final String HTML = "html";

        private ReleaserDownloadUrl() {
        }

        public String apply(String input) {
            String format = MARKDOWN;
            String artifactFile = "";
            String linkName = "";
            String[] parts = input.split(":");
            if (parts.length == 1) {
                linkName = artifactFile = parts[0];
            } else if (parts.length == 2) {
                linkName = parts[0];
                artifactFile = parts[1];
            } else if (parts.length == 3) {
                format = parts[0];
                linkName = parts[1];
                artifactFile = parts[2];
            } else {
                throw new JReleaserException(RB.$((String)"ERROR_invalid_function_input", (Object[])new Object[]{input, NAME}));
            }
            switch (linkName) {
                case "md": 
                case "adoc": 
                case "html": {
                    format = linkName;
                    linkName = artifactFile;
                }
            }
            switch (format.toLowerCase(Locale.ENGLISH)) {
                case "md": {
                    return ("[" + linkName + "](" + JReleaserModel.this.getRelease().getReleaser().getDownloadUrl() + ")").replace("{{artifactFile}}", artifactFile);
                }
                case "adoc": {
                    return ("link:" + JReleaserModel.this.getRelease().getReleaser().getDownloadUrl() + "[" + linkName + "]").replace("{{artifactFile}}", artifactFile);
                }
                case "html": {
                    return ("<a href=\"" + JReleaserModel.this.getRelease().getReleaser().getDownloadUrl() + "\">" + linkName + "</a>").replace("{{artifactFile}}", artifactFile);
                }
            }
            throw new JReleaserException(RB.$((String)"ERROR_invalid_function_input", (Object[])new Object[]{input, NAME}));
        }
    }
}

