/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.upload;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.JReleaserOutput;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.ExtraProperties;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.upload.AbstractUploader;
import org.jreleaser.model.internal.upload.ArtifactoryUploader;
import org.jreleaser.model.internal.upload.ForgejoUploader;
import org.jreleaser.model.internal.upload.FtpUploader;
import org.jreleaser.model.internal.upload.GiteaUploader;
import org.jreleaser.model.internal.upload.GitlabUploader;
import org.jreleaser.model.internal.upload.HttpUploader;
import org.jreleaser.model.internal.upload.S3Uploader;
import org.jreleaser.model.internal.upload.ScpUploader;
import org.jreleaser.model.internal.upload.SftpUploader;
import org.jreleaser.model.internal.upload.Uploader;
import org.jreleaser.util.StringUtils;

public final class Upload
extends AbstractActivatable<Upload>
implements Domain {
    private static final long serialVersionUID = 8786687188258016652L;
    private final Map<String, ArtifactoryUploader> artifactory = new LinkedHashMap<String, ArtifactoryUploader>();
    private final Map<String, FtpUploader> ftp = new LinkedHashMap<String, FtpUploader>();
    private final Map<String, ForgejoUploader> forgejo = new LinkedHashMap<String, ForgejoUploader>();
    private final Map<String, GiteaUploader> gitea = new LinkedHashMap<String, GiteaUploader>();
    private final Map<String, GitlabUploader> gitlab = new LinkedHashMap<String, GitlabUploader>();
    private final Map<String, HttpUploader> http = new LinkedHashMap<String, HttpUploader>();
    private final Map<String, S3Uploader> s3 = new LinkedHashMap<String, S3Uploader>();
    private final Map<String, ScpUploader> scp = new LinkedHashMap<String, ScpUploader>();
    private final Map<String, SftpUploader> sftp = new LinkedHashMap<String, SftpUploader>();
    @JsonIgnore
    private final org.jreleaser.model.api.upload.Upload immutable = new org.jreleaser.model.api.upload.Upload(){
        private static final long serialVersionUID = -2795529763700221567L;
        private Map<String, ? extends org.jreleaser.model.api.upload.ArtifactoryUploader> artifactory;
        private Map<String, ? extends org.jreleaser.model.api.upload.FtpUploader> ftp;
        private Map<String, ? extends org.jreleaser.model.api.upload.ForgejoUploader> forgejo;
        private Map<String, ? extends org.jreleaser.model.api.upload.GiteaUploader> gitea;
        private Map<String, ? extends org.jreleaser.model.api.upload.GitlabUploader> gitlab;
        private Map<String, ? extends org.jreleaser.model.api.upload.HttpUploader> http;
        private Map<String, ? extends org.jreleaser.model.api.upload.S3Uploader> s3;
        private Map<String, ? extends org.jreleaser.model.api.upload.ScpUploader> scp;
        private Map<String, ? extends org.jreleaser.model.api.upload.SftpUploader> sftp;

        public Map<String, ? extends org.jreleaser.model.api.upload.ArtifactoryUploader> getArtifactory() {
            if (null == this.artifactory) {
                this.artifactory = Upload.this.artifactory.values().stream().map(ArtifactoryUploader::asImmutable).collect(Collectors.toMap(org.jreleaser.model.api.upload.Uploader::getName, Function.identity()));
            }
            return this.artifactory;
        }

        public Map<String, ? extends org.jreleaser.model.api.upload.FtpUploader> getFtp() {
            if (null == this.ftp) {
                this.ftp = Upload.this.ftp.values().stream().map(FtpUploader::asImmutable).collect(Collectors.toMap(org.jreleaser.model.api.upload.Uploader::getName, Function.identity()));
            }
            return this.ftp;
        }

        public Map<String, ? extends org.jreleaser.model.api.upload.ForgejoUploader> getForgejo() {
            if (null == this.forgejo) {
                this.forgejo = Upload.this.forgejo.values().stream().map(ForgejoUploader::asImmutable).collect(Collectors.toMap(org.jreleaser.model.api.upload.Uploader::getName, Function.identity()));
            }
            return this.forgejo;
        }

        public Map<String, ? extends org.jreleaser.model.api.upload.GiteaUploader> getGitea() {
            if (null == this.gitea) {
                this.gitea = Upload.this.gitea.values().stream().map(GiteaUploader::asImmutable).collect(Collectors.toMap(org.jreleaser.model.api.upload.Uploader::getName, Function.identity()));
            }
            return this.gitea;
        }

        public Map<String, ? extends org.jreleaser.model.api.upload.GitlabUploader> getGitlab() {
            if (null == this.gitlab) {
                this.gitlab = Upload.this.gitlab.values().stream().map(GitlabUploader::asImmutable).collect(Collectors.toMap(org.jreleaser.model.api.upload.Uploader::getName, Function.identity()));
            }
            return this.gitlab;
        }

        public Map<String, ? extends org.jreleaser.model.api.upload.HttpUploader> getHttp() {
            if (null == this.http) {
                this.http = Upload.this.http.values().stream().map(HttpUploader::asImmutable).collect(Collectors.toMap(org.jreleaser.model.api.upload.Uploader::getName, Function.identity()));
            }
            return this.http;
        }

        public Map<String, ? extends org.jreleaser.model.api.upload.S3Uploader> getS3() {
            if (null == this.s3) {
                this.s3 = Upload.this.s3.values().stream().map(S3Uploader::asImmutable).collect(Collectors.toMap(org.jreleaser.model.api.upload.Uploader::getName, Function.identity()));
            }
            return this.s3;
        }

        public Map<String, ? extends org.jreleaser.model.api.upload.ScpUploader> getScp() {
            if (null == this.scp) {
                this.scp = Upload.this.scp.values().stream().map(ScpUploader::asImmutable).collect(Collectors.toMap(org.jreleaser.model.api.upload.Uploader::getName, Function.identity()));
            }
            return this.scp;
        }

        public Map<String, ? extends org.jreleaser.model.api.upload.SftpUploader> getSftp() {
            if (null == this.sftp) {
                this.sftp = Upload.this.sftp.values().stream().map(SftpUploader::asImmutable).collect(Collectors.toMap(org.jreleaser.model.api.upload.Uploader::getName, Function.identity()));
            }
            return this.sftp;
        }

        public Active getActive() {
            return Upload.this.getActive();
        }

        public boolean isEnabled() {
            return Upload.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Upload.this.asMap(full));
        }
    };

    public Upload() {
        this.enabledSet(true);
    }

    public org.jreleaser.model.api.upload.Upload asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Upload source) {
        super.merge(source);
        this.setArtifactory(this.mergeModel(this.artifactory, source.artifactory));
        this.setFtp(this.mergeModel(this.ftp, source.ftp));
        this.setForgejo(this.mergeModel(this.forgejo, source.forgejo));
        this.setGitea(this.mergeModel(this.gitea, source.gitea));
        this.setGitlab(this.mergeModel(this.gitlab, source.gitlab));
        this.setHttp(this.mergeModel(this.http, source.http));
        this.setS3(this.mergeModel(this.s3, source.s3));
        this.setScp(this.mergeModel(this.scp, source.scp));
        this.setSftp(this.mergeModel(this.sftp, source.sftp));
    }

    @Deprecated
    @JsonPropertyDescription(value="upload.enabled is deprecated since 1.1.0 and will be removed in 2.0.0")
    public void setEnabled(Boolean enabled) {
        JReleaserOutput.nag((String)"upload.enabled is deprecated since 1.1.0 and will be removed in 2.0.0");
        if (null != enabled) {
            this.setActive(enabled != false ? Active.ALWAYS : Active.NEVER);
        }
    }

    public Optional<? extends Uploader<?>> getUploader(String type, String name) {
        switch (type) {
            case "artifactory": {
                return Optional.ofNullable(this.artifactory.get(name));
            }
            case "ftp": {
                return Optional.ofNullable(this.ftp.get(name));
            }
            case "forgejo": {
                return Optional.ofNullable(this.forgejo.get(name));
            }
            case "gitea": {
                return Optional.ofNullable(this.gitea.get(name));
            }
            case "gitlab": {
                return Optional.ofNullable(this.gitlab.get(name));
            }
            case "http": {
                return Optional.ofNullable(this.http.get(name));
            }
            case "s3": {
                return Optional.ofNullable(this.s3.get(name));
            }
            case "scp": {
                return Optional.ofNullable(this.scp.get(name));
            }
            case "sftp": {
                return Optional.ofNullable(this.sftp.get(name));
            }
        }
        return Optional.empty();
    }

    public Optional<? extends Uploader<?>> getActiveUploader(String type, String name) {
        switch (type) {
            case "artifactory": {
                return this.getActiveArtifactory(name);
            }
            case "ftp": {
                return this.getActiveFtp(name);
            }
            case "forgejo": {
                return this.getActiveForgejo(name);
            }
            case "gitea": {
                return this.getActiveGitea(name);
            }
            case "gitlab": {
                return this.getActiveGitlab(name);
            }
            case "http": {
                return this.getActiveHttp(name);
            }
            case "s3": {
                return this.getActiveS3(name);
            }
            case "scp": {
                return this.getActiveScp(name);
            }
            case "sftp": {
                return this.getActiveSftp(name);
            }
        }
        return Optional.empty();
    }

    public Optional<ArtifactoryUploader> getActiveArtifactory(String name) {
        return this.artifactory.values().stream().filter(Activatable::isEnabled).filter(a -> name.equals(a.getName())).findFirst();
    }

    public Optional<FtpUploader> getActiveFtp(String name) {
        return this.ftp.values().stream().filter(Activatable::isEnabled).filter(a -> name.equals(a.getName())).findFirst();
    }

    public Optional<ForgejoUploader> getActiveForgejo(String name) {
        return this.forgejo.values().stream().filter(Activatable::isEnabled).filter(a -> name.equals(a.getName())).findFirst();
    }

    public Optional<GiteaUploader> getActiveGitea(String name) {
        return this.gitea.values().stream().filter(Activatable::isEnabled).filter(a -> name.equals(a.getName())).findFirst();
    }

    public Optional<GitlabUploader> getActiveGitlab(String name) {
        return this.gitlab.values().stream().filter(Activatable::isEnabled).filter(a -> name.equals(a.getName())).findFirst();
    }

    public Optional<HttpUploader> getActiveHttp(String name) {
        return this.http.values().stream().filter(Activatable::isEnabled).filter(a -> name.equals(a.getName())).findFirst();
    }

    public Optional<S3Uploader> getActiveS3(String name) {
        return this.s3.values().stream().filter(Activatable::isEnabled).filter(a -> name.equals(a.getName())).findFirst();
    }

    public Optional<ScpUploader> getActiveScp(String name) {
        return this.scp.values().stream().filter(Activatable::isEnabled).filter(a -> name.equals(a.getName())).findFirst();
    }

    public Optional<SftpUploader> getActiveSftp(String name) {
        return this.sftp.values().stream().filter(Activatable::isEnabled).filter(a -> name.equals(a.getName())).findFirst();
    }

    public List<ArtifactoryUploader> getActiveArtifactories() {
        return this.artifactory.values().stream().filter(AbstractActivatable::isEnabled).collect(Collectors.toList());
    }

    public Map<String, ArtifactoryUploader> getArtifactory() {
        return this.artifactory;
    }

    public void setArtifactory(Map<String, ArtifactoryUploader> artifactory) {
        this.artifactory.clear();
        this.artifactory.putAll(artifactory);
    }

    public void addArtifactory(ArtifactoryUploader artifactory) {
        this.artifactory.put(artifactory.getName(), artifactory);
    }

    public List<FtpUploader> getActiveFtps() {
        return this.ftp.values().stream().filter(AbstractActivatable::isEnabled).collect(Collectors.toList());
    }

    public Map<String, FtpUploader> getFtp() {
        return this.ftp;
    }

    public void setFtp(Map<String, FtpUploader> ftp) {
        this.ftp.clear();
        this.ftp.putAll(ftp);
    }

    public void addFtp(FtpUploader ftp) {
        this.ftp.put(ftp.getName(), ftp);
    }

    public List<ForgejoUploader> getActiveForgejos() {
        return this.forgejo.values().stream().filter(AbstractActivatable::isEnabled).collect(Collectors.toList());
    }

    public Map<String, ForgejoUploader> getForgejo() {
        return this.forgejo;
    }

    public void setForgejo(Map<String, ForgejoUploader> forgejo) {
        this.forgejo.clear();
        this.forgejo.putAll(forgejo);
    }

    public void addForgejo(ForgejoUploader forgejo) {
        this.forgejo.put(forgejo.getName(), forgejo);
    }

    public List<GiteaUploader> getActiveGiteas() {
        return this.gitea.values().stream().filter(AbstractActivatable::isEnabled).collect(Collectors.toList());
    }

    public Map<String, GiteaUploader> getGitea() {
        return this.gitea;
    }

    public void setGitea(Map<String, GiteaUploader> gitea) {
        this.gitea.clear();
        this.gitea.putAll(gitea);
    }

    public void addGitea(GiteaUploader gitea) {
        this.gitea.put(gitea.getName(), gitea);
    }

    public List<GitlabUploader> getActiveGitlabs() {
        return this.gitlab.values().stream().filter(AbstractActivatable::isEnabled).collect(Collectors.toList());
    }

    public Map<String, GitlabUploader> getGitlab() {
        return this.gitlab;
    }

    public void setGitlab(Map<String, GitlabUploader> gitlab) {
        this.gitlab.clear();
        this.gitlab.putAll(gitlab);
    }

    public void addGitlab(GitlabUploader gitlab) {
        this.gitlab.put(gitlab.getName(), gitlab);
    }

    public List<HttpUploader> getActiveHttps() {
        return this.http.values().stream().filter(AbstractActivatable::isEnabled).collect(Collectors.toList());
    }

    public Map<String, HttpUploader> getHttp() {
        return this.http;
    }

    public void setHttp(Map<String, HttpUploader> http) {
        this.http.clear();
        this.http.putAll(http);
    }

    public void addHttp(HttpUploader http) {
        this.http.put(http.getName(), http);
    }

    public List<S3Uploader> getActiveS3s() {
        return this.s3.values().stream().filter(AbstractActivatable::isEnabled).collect(Collectors.toList());
    }

    public Map<String, S3Uploader> getS3() {
        return this.s3;
    }

    public void setS3(Map<String, S3Uploader> s3) {
        this.s3.clear();
        this.s3.putAll(s3);
    }

    public void addS3(S3Uploader s3) {
        this.s3.put(s3.getName(), s3);
    }

    public List<ScpUploader> getActiveScps() {
        return this.scp.values().stream().filter(AbstractActivatable::isEnabled).collect(Collectors.toList());
    }

    public Map<String, ScpUploader> getScp() {
        return this.scp;
    }

    public void setScp(Map<String, ScpUploader> scp) {
        this.scp.clear();
        this.scp.putAll(scp);
    }

    public void addScp(ScpUploader scp) {
        this.scp.put(scp.getName(), scp);
    }

    public List<SftpUploader> getActiveSftps() {
        return this.sftp.values().stream().filter(AbstractActivatable::isEnabled).collect(Collectors.toList());
    }

    public Map<String, SftpUploader> getSftp() {
        return this.sftp;
    }

    public void setSftp(Map<String, SftpUploader> sftp) {
        this.sftp.clear();
        this.sftp.putAll(sftp);
    }

    public void addSftp(SftpUploader sftp) {
        this.sftp.put(sftp.getName(), sftp);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        List sftp;
        List scp;
        List s3;
        List http;
        List gitlab;
        List gitea;
        List forgejo;
        List ftp;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("active", this.getActive());
        List artifactory = this.artifactory.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList());
        if (!artifactory.isEmpty()) {
            map.put("artifactory", artifactory);
        }
        if (!(ftp = this.ftp.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("ftp", ftp);
        }
        if (!(forgejo = this.forgejo.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("forgejo", forgejo);
        }
        if (!(gitea = this.gitea.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("gitea", gitea);
        }
        if (!(gitlab = this.gitlab.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("gitlab", gitlab);
        }
        if (!(http = this.http.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("http", http);
        }
        if (!(s3 = this.s3.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("s3", s3);
        }
        if (!(scp = this.scp.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("scp", scp);
        }
        if (!(sftp = this.sftp.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("sftp", sftp);
        }
        return map;
    }

    public <A extends Uploader<?>> Map<String, A> findUploadersByType(String uploaderType) {
        switch (uploaderType) {
            case "artifactory": {
                return this.artifactory;
            }
            case "ftp": {
                return this.ftp;
            }
            case "forgejo": {
                return this.forgejo;
            }
            case "gitea": {
                return this.gitea;
            }
            case "gitlab": {
                return this.gitlab;
            }
            case "http": {
                return this.http;
            }
            case "s3": {
                return this.s3;
            }
            case "scp": {
                return this.scp;
            }
            case "sftp": {
                return this.sftp;
            }
        }
        return Collections.emptyMap();
    }

    public <A extends Uploader<?>> List<A> findAllActiveUploaders() {
        ArrayList<AbstractUploader> uploaders = new ArrayList<AbstractUploader>();
        uploaders.addAll(this.getActiveArtifactories());
        uploaders.addAll(this.getActiveFtps());
        uploaders.addAll(this.getActiveForgejos());
        uploaders.addAll(this.getActiveGiteas());
        uploaders.addAll(this.getActiveGitlabs());
        uploaders.addAll(this.getActiveHttps());
        uploaders.addAll(this.getActiveS3s());
        uploaders.addAll(this.getActiveScps());
        uploaders.addAll(this.getActiveSftps());
        return uploaders;
    }

    public Map<String, String> resolveDownloadUrls(JReleaserContext context, Distribution distribution, Artifact artifact, String prefix) {
        Uploader uploader;
        List<String> keys;
        LinkedHashMap<String, String> urls = new LinkedHashMap<String, String>();
        List uploaders = this.findAllActiveUploaders();
        for (Uploader uploader2 : uploaders) {
            List<String> keys2 = uploader2.resolveSkipKeys();
            if (this.isSkip(distribution, keys2) || this.isSkip(artifact, keys2)) continue;
            String key = prefix + "Download" + StringUtils.capitalize((String)uploader2.getType()) + StringUtils.getClassNameForLowerCaseHyphenSeparatedName((String)uploader2.getName()) + "Url";
            String url = uploader2.getResolvedDownloadUrl(context, artifact);
            urls.put(key, url);
            if (this.findUploadersByType(uploader2.getType()).size() != 1 || this.isSkip(distribution, keys2) || this.isSkip(artifact, keys2)) continue;
            key = prefix + "Download" + StringUtils.capitalize((String)uploader2.getType()) + "Url";
            url = uploader2.getResolvedDownloadUrl(context, artifact);
            urls.put(key, url);
        }
        if (uploaders.size() == 1 && !this.isSkip(distribution, keys = (uploader = (Uploader)uploaders.get(0)).resolveSkipKeys()) && !this.isSkip(artifact, keys)) {
            String key = prefix + "DownloadUrl";
            String url = uploader.getResolvedDownloadUrl(context, artifact);
            urls.put(key, url);
        }
        return urls;
    }

    private boolean isSkip(ExtraProperties props, List<String> keys) {
        for (String key : keys) {
            if (!props.extraPropertyIsTrue(key)) continue;
            return true;
        }
        return false;
    }
}

