/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.nio.file.Path;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.LicenseId;
import org.jreleaser.model.Project;
import org.jreleaser.model.VersionPattern;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.StringUtils;

public abstract class ProjectValidator
extends Validator {
    public static void validateProject(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        boolean javaAssemblers;
        context.getLogger().debug("project");
        Project project = context.getModel().getProject();
        project.setName(ProjectValidator.checkProperty(context, "PROJECT_NAME", "project.name", project.getName(), errors));
        project.setVersion(ProjectValidator.checkProperty(context, "PROJECT_VERSION", "project.version", project.getVersion(), errors));
        project.setVersionPattern(ProjectValidator.checkProperty(context, "PROJECT_VERSION_PATTERN", "project.versionPattern", project.getVersionPattern(), VersionPattern.Type.SEMVER.toString()));
        project.getSnapshot().setPattern(ProjectValidator.checkProperty(context, "PROJECT_SNAPSHOT_PATTERN", "project.snapshot.pattern", project.getSnapshot().getPattern(), ".*-SNAPSHOT"));
        project.getSnapshot().setLabel(ProjectValidator.checkProperty(context, "PROJECT_SNAPSHOT_LABEL", "project.snapshot.label", project.getSnapshot().getLabel(), "early-access"));
        project.getSnapshot().getResolvedLabel(context.getModel());
        project.getSnapshot().setFullChangelog(ProjectValidator.checkProperty(context, "PROJECT_SNAPSHOT_FULL_CHANGELOG", "project.snapshot.fullChangelog", project.getSnapshot().getFullChangelog(), false));
        if (project.versionPattern().getType() == VersionPattern.Type.CALVER && StringUtils.isBlank((String)project.versionPattern().getFormat())) {
            errors.configuration(RB.$((String)"validation_version_format_missing", (Object[])new Object[]{"project.versionPattern", VersionPattern.Type.CALVER.toString()}));
        }
        boolean javaDistributions = context.getModel().getDistributions().values().stream().map(Distribution::getType).anyMatch(type -> type == Distribution.DistributionType.JAVA_BINARY || type == Distribution.DistributionType.SINGLE_JAR || type == Distribution.DistributionType.NATIVE_IMAGE || type == Distribution.DistributionType.NATIVE_PACKAGE);
        boolean bl = javaAssemblers = !context.getModel().getAssemble().getJlink().isEmpty() || !context.getModel().getAssemble().getJpackage().isEmpty() || !context.getModel().getAssemble().getNativeImage().isEmpty();
        if (javaAssemblers || mode.validateConfig() && javaDistributions) {
            ProjectValidator.validateJava(context, project, errors);
        }
        ProjectValidator.validateScreenshots(context, mode, project.getScreenshots(), errors, "project");
        ProjectValidator.validateIcons(context, mode, project.getIcons(), errors, "project");
    }

    public static void postValidateProject(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        context.getLogger().debug("project");
        Project project = context.getModel().getProject();
        if (null == project.getInceptionYear() && project.getExtraProperties().containsKey("inceptionYear")) {
            project.setInceptionYear(project.getExtraProperty("inceptionYear"));
            context.nag("1.2.0", "Use project.inceptionYear instead of project.extraProperties.inceptionYear");
        }
        if (StringUtils.isBlank((String)project.getCopyright())) {
            if (project.getInceptionYear() != null && !project.getAuthors().isEmpty()) {
                project.setCopyright(project.getInceptionYear() + " " + String.join((CharSequence)",", project.getAuthors()));
            } else {
                errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"project.copyright"}));
            }
        }
        if (StringUtils.isBlank((String)project.getLinks().getLicense()) && StringUtils.isNotBlank((String)project.getLicense())) {
            LicenseId.findByLiteral(project.getLicense()).ifPresent(licenseId -> project.getLinks().setLicense(licenseId.url()));
        }
        if (StringUtils.isBlank((String)project.getLinks().getLicense()) && context.getModel().getCommit() != null) {
            FileUtils.findLicenseFile((Path)context.getBasedir()).ifPresent(path -> {
                GitService service = context.getModel().getRelease().getGitService();
                String srcUrl = service.getResolvedSrcUrl(context.getModel());
                if (!srcUrl.endsWith("/")) {
                    srcUrl = srcUrl + "/";
                }
                srcUrl = srcUrl + path.getFileName().toString();
                project.getLinks().setLicense(srcUrl);
            });
        }
        if (StringUtils.isBlank((String)project.getLinks().getVcsBrowser())) {
            project.getLinks().setVcsBrowser(context.getModel().getRelease().getGitService().getRepoUrl());
        }
        if (StringUtils.isBlank((String)project.getLinks().getBugTracker())) {
            project.getLinks().setBugTracker(context.getModel().getRelease().getGitService().getIssueTrackerUrl());
        }
        if (StringUtils.isBlank((String)project.getLinks().getDocumentation())) {
            project.getLinks().setDocumentation(project.getLinks().getHomepage());
        }
        if (mode.validateAssembly() && StringUtils.isBlank((String)project.getDescription())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"project.description"}));
        }
        if (!mode.validateConfig() && !mode.validateAnnounce()) {
            return;
        }
        if (context.getModel().getActiveDistributions().isEmpty() || !context.getModel().getAnnounce().isEnabled()) {
            return;
        }
        if (StringUtils.isBlank((String)project.getDescription())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"project.description"}));
        }
        if (StringUtils.isBlank((String)project.getLinks().getHomepage())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"project.website"}));
        }
        if (StringUtils.isBlank((String)project.getLinks().getDocumentation())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"project.docsUrl"}));
        }
        if (StringUtils.isBlank((String)project.getLicense())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"project.license"}));
        }
        if (StringUtils.isBlank((String)project.getLongDescription())) {
            project.setLongDescription(project.getDescription());
        }
        if (project.getAuthors().isEmpty()) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"project.authors"}));
        }
    }

    private static void validateJava(JReleaserContext context, Project project, Errors errors) {
        context.getLogger().debug("project.java");
        if (!project.getJava().isSet()) {
            return;
        }
        project.getJava().setEnabled(true);
        if (StringUtils.isBlank((String)project.getJava().getArtifactId())) {
            project.getJava().setArtifactId(project.getName());
        }
        if (StringUtils.isBlank((String)project.getJava().getGroupId())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"project.java.groupId"}));
        }
        if (StringUtils.isBlank((String)project.getJava().getArtifactId())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"project.java.artifactId"}));
        }
        if (!project.getJava().isMultiProjectSet()) {
            project.getJava().setMultiProject(false);
        }
    }
}

