/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Jpackage;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.JReleaserException;

public abstract class JpackageResolver
extends Validator {
    public static void resolveJpackageOutputs(JReleaserContext context, Errors errors) {
        List<Jpackage> activeJpackages = context.getModel().getAssemble().getActiveJpackages();
        if (!activeJpackages.isEmpty()) {
            context.getLogger().debug("assemble.jpackage");
        }
        for (Jpackage jpackage : activeJpackages) {
            if (!jpackage.isExported()) continue;
            JpackageResolver.resolveJpackageOutputs(context, jpackage, errors);
        }
    }

    private static void resolveJpackageOutputs(JReleaserContext context, Jpackage jpackage, Errors errors) {
        Path baseOutputDirectory = context.getAssembleDirectory().resolve(jpackage.getName()).resolve(jpackage.getType());
        Artifact jdk = jpackage.getResolvedPlatformPackager().getJdk();
        if (!context.isPlatformSelected(jdk)) {
            return;
        }
        Jpackage.PlatformPackager packager = jpackage.getResolvedPlatformPackager();
        String platform = jdk.getPlatform();
        for (String type : packager.getTypes()) {
            try {
                Optional file = (Optional)FileUtils.listFilesAndProcess((Path)baseOutputDirectory, files -> files.filter(path -> path.getFileName().toString().endsWith(type)).findFirst());
                if (!file.isPresent()) {
                    errors.assembly(RB.$((String)"validation_missing_assembly", (Object[])new Object[]{jpackage.getType(), jpackage.getName(), jpackage.getName()}));
                    continue;
                }
                Artifact artifact = Artifact.of((Path)file.get(), platform);
                artifact.setExtraProperties(jpackage.getExtraProperties());
                artifact.activate();
                jpackage.addOutput(artifact);
            }
            catch (IOException e) {
                throw new JReleaserException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
            }
        }
    }
}

