/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import org.jreleaser.bundle.RB;
import org.jreleaser.model.Download;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.validation.FtpDownloaderValidator;
import org.jreleaser.model.validation.HttpDownloaderValidator;
import org.jreleaser.model.validation.ScpDownloaderValidator;
import org.jreleaser.model.validation.SftpDownloaderValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;

public abstract class DownloadersValidator
extends Validator {
    public static void validateDownloaders(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Download download = context.getModel().getDownload();
        context.getLogger().debug("download");
        boolean skipValidation = !mode.validateDownload() && !mode.validateConfig();
        Errors errorCollector = skipValidation ? new Errors() : errors;
        FtpDownloaderValidator.validateFtpDownloader(context, mode, errorCollector);
        HttpDownloaderValidator.validateHttpDownloader(context, mode, errorCollector);
        ScpDownloaderValidator.validateScpDownloader(context, mode, errorCollector);
        SftpDownloaderValidator.validateSftpDownloader(context, mode, errorCollector);
        if (!skipValidation) {
            boolean activeSet = download.isActiveSet();
            if (mode.validateConfig() || mode.validateDownload()) {
                download.resolveEnabled(context.getModel().getProject());
            }
            if (download.isEnabled()) {
                boolean enabled;
                boolean bl = enabled = !download.getActiveFtps().isEmpty() || !download.getActiveHttps().isEmpty() || !download.getActiveScps().isEmpty() || !download.getActiveSftps().isEmpty();
                if (!activeSet && !enabled) {
                    context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
                    download.disable();
                }
            }
        }
    }
}

