/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Discussions;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class DiscussionsValidator
extends Validator {
    private static final String DEFAULT_DISCUSSIONS_TPL = "src/jreleaser/templates/discussions.tpl";

    public static void validateDiscussions(JReleaserContext context, Discussions discussions, Errors errors) {
        context.getLogger().debug("announce.discussions");
        if (!discussions.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (!"github".equals(context.getModel().getRelease().getGitService().getServiceName())) {
            errors.configuration(RB.$((String)"validation_discussions_enabled", (Object[])new Object[0]));
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            discussions.disable();
            return;
        }
        if (StringUtils.isBlank((String)discussions.getOrganization())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"discussions.organization"}));
        }
        if (StringUtils.isBlank((String)discussions.getTeam())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"discussions.team"}));
        }
        if (StringUtils.isBlank((String)discussions.getTitle())) {
            discussions.setTitle(RB.$((String)"default.discussion.title", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((String)discussions.getMessage()) && StringUtils.isBlank((String)discussions.getMessageTemplate())) {
            discussions.setMessageTemplate(DEFAULT_DISCUSSIONS_TPL);
        }
        if (StringUtils.isBlank((String)discussions.getMessage()) && StringUtils.isBlank((String)discussions.getMessageTemplate())) {
            if (Files.exists(context.getBasedir().resolve(DEFAULT_DISCUSSIONS_TPL), new LinkOption[0])) {
                discussions.setMessageTemplate(DEFAULT_DISCUSSIONS_TPL);
            } else {
                discussions.setMessage(RB.$((String)"default.release.message", (Object[])new Object[0]));
            }
        }
        if (StringUtils.isNotBlank((String)discussions.getMessageTemplate()) && !Files.exists(context.getBasedir().resolve(discussions.getMessageTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"discussions.messageTemplate", discussions.getMessageTemplate()}));
        }
        DiscussionsValidator.validateTimeout(discussions);
    }
}

