/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.AbstractUploader;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Templates;

public class S3
extends AbstractUploader<S3> {
    public static final String TYPE = "s3";
    private final Map<String, String> headers = new LinkedHashMap<String, String>();
    private String region;
    private String bucket;
    private String path;
    private String downloadUrl;
    private String endpoint;
    private String accessKeyId;
    private String secretKey;
    private String sessionToken;

    public S3() {
        super(TYPE);
    }

    @Override
    public void merge(S3 s3) {
        this.freezeCheck();
        super.merge(s3);
        this.region = this.merge(this.region, s3.region);
        this.bucket = this.merge(this.bucket, s3.bucket);
        this.path = this.merge(this.path, s3.path);
        this.downloadUrl = this.merge(this.downloadUrl, s3.downloadUrl);
        this.endpoint = this.merge(this.endpoint, s3.endpoint);
        this.accessKeyId = this.merge(this.accessKeyId, s3.accessKeyId);
        this.secretKey = this.merge(this.secretKey, s3.secretKey);
        this.sessionToken = this.merge(this.sessionToken, s3.sessionToken);
        this.setHeaders(this.merge(this.headers, s3.headers));
    }

    @Override
    public String getResolvedDownloadUrl(JReleaserContext context, Artifact artifact) {
        return this.getResolvedDownloadUrl(context.fullProps(), artifact);
    }

    @Override
    public String getResolvedDownloadUrl(Map<String, Object> props, Artifact artifact) {
        if (StringUtils.isNotBlank((String)this.getResolvedDownloadUrl())) {
            LinkedHashMap<String, Object> p = new LinkedHashMap<String, Object>(this.artifactProps((Map)props, artifact));
            p.putAll(this.getResolvedExtraProperties());
            p.put("bucket", this.bucket);
            p.put("region", this.region);
            return Templates.resolveTemplate((String)this.getResolvedDownloadUrl(), p);
        }
        if (StringUtils.isBlank((String)this.getResolvedEndpoint())) {
            String url = "https://{{bucket}}.s3.{{region}}.amazonaws.com/" + this.getResolvedPath();
            LinkedHashMap<String, Object> p = new LinkedHashMap<String, Object>(this.artifactProps((Map)props, artifact));
            p.putAll(this.getResolvedExtraProperties());
            p.put("bucket", this.bucket);
            p.put("region", this.region);
            return Templates.resolveTemplate((String)url, p);
        }
        return "";
    }

    public String getResolvedPath(JReleaserContext context, Artifact artifact) {
        String artifactPath = this.getResolvedPath();
        String customPathKey = TYPE + StringUtils.capitalize((String)this.getName()) + "Path";
        if (artifact.getExtraProperties().containsKey(customPathKey)) {
            artifactPath = artifact.getExtraProperty(customPathKey);
        }
        LinkedHashMap<String, Object> p = new LinkedHashMap<String, Object>(this.artifactProps(context, artifact));
        p.putAll(this.getResolvedExtraProperties());
        return Templates.resolveTemplate((String)artifactPath, p);
    }

    public String getResolvedRegion() {
        return Env.env((String)("S3_" + Env.toVar((String)this.name) + "_REGION"), (String)this.region);
    }

    public String getResolvedBucket() {
        return Env.env((String)("S3_" + Env.toVar((String)this.name) + "_BUCKET"), (String)this.bucket);
    }

    public String getResolvedAccessKeyId() {
        return Env.env((String)("S3_" + Env.toVar((String)this.name) + "_ACCESS_KEY_ID"), (String)this.accessKeyId);
    }

    public String getResolvedSecretKey() {
        return Env.env((String)("S3_" + Env.toVar((String)this.name) + "_SECRET_KEY"), (String)this.secretKey);
    }

    public String getResolvedSessionToken() {
        return Env.env((String)("S3_" + Env.toVar((String)this.name) + "_SESSION_TOKEN"), (String)this.sessionToken);
    }

    public String getResolvedPath() {
        return Env.env((String)("S3_" + Env.toVar((String)this.name) + "_PATH"), (String)this.path);
    }

    public String getResolvedDownloadUrl() {
        return Env.env((String)("S3_" + Env.toVar((String)this.name) + "_DOWNLOAD_URL"), (String)this.downloadUrl);
    }

    public String getResolvedEndpoint() {
        return Env.env((String)("S3_" + Env.toVar((String)this.name) + "_ENDPOINT"), (String)this.endpoint);
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.freezeCheck();
        this.region = region;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.freezeCheck();
        this.bucket = bucket;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.freezeCheck();
        this.accessKeyId = accessKeyId;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.freezeCheck();
        this.secretKey = secretKey;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public void setSessionToken(String sessionToken) {
        this.freezeCheck();
        this.sessionToken = sessionToken;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.freezeCheck();
        this.path = path;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.freezeCheck();
        this.downloadUrl = downloadUrl;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.freezeCheck();
        this.endpoint = endpoint;
    }

    public Map<String, String> getHeaders() {
        return this.freezeWrap(this.headers);
    }

    public void setHeaders(Map<String, String> headers) {
        this.freezeCheck();
        this.headers.putAll(headers);
    }

    @Override
    protected void asMap(Map<String, Object> props, boolean full) {
        props.put("region", this.getResolvedRegion());
        props.put("bucket", this.getResolvedBucket());
        props.put("accessKeyId", StringUtils.isNotBlank((String)this.getResolvedAccessKeyId()) ? "************" : "**unset**");
        props.put("secretKey", StringUtils.isNotBlank((String)this.getResolvedSecretKey()) ? "************" : "**unset**");
        props.put("sessionToken", StringUtils.isNotBlank((String)this.getResolvedSessionToken()) ? "************" : "**unset**");
        props.put("path", this.getResolvedPath());
        props.put("downloadUrl", this.getResolvedDownloadUrl());
        props.put("endpoint", this.getResolvedEndpoint());
        props.put("headers", this.headers);
    }
}

