/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.jreleaser.model.AbstractModelObject;
import org.jreleaser.model.Domain;
import org.jreleaser.model.ExtraProperties;
import org.jreleaser.util.StringUtils;

public class Icon
extends AbstractModelObject<Icon>
implements Domain,
ExtraProperties {
    protected final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    private String url;
    private Integer width;
    private Integer height;
    private Boolean primary;

    @Override
    public void merge(Icon source) {
        this.freezeCheck();
        this.url = this.merge(this.url, source.url);
        this.width = this.merge(this.width, source.width);
        this.height = this.merge(this.height, source.height);
        this.primary = this.merge(this.primary, source.primary);
        this.setExtraProperties(this.merge(this.extraProperties, source.extraProperties));
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.freezeCheck();
        this.url = url;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.freezeCheck();
        this.width = width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.freezeCheck();
        this.height = height;
    }

    public boolean isPrimary() {
        return this.primary != null && this.primary != false;
    }

    public void setPrimary(Boolean primary) {
        this.freezeCheck();
        this.primary = primary;
    }

    @Override
    public String getPrefix() {
        return "icon";
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.freezeWrap(this.extraProperties);
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.freezeCheck();
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.freezeCheck();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("url", this.url);
        map.put("width", this.width);
        map.put("height", this.height);
        if (this.isPrimary()) {
            map.put("primary", this.isPrimary());
        }
        map.put("extraProperties", this.getResolvedExtraProperties());
        return map;
    }

    public static enum Type {
        SOURCE,
        THUMBNAIL;


        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public static Type of(String str) {
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            return Type.valueOf(str.toUpperCase(Locale.ENGLISH).trim());
        }
    }
}

