/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.Map;
import org.jreleaser.model.AbstractDownloader;
import org.jreleaser.model.Ftp;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;

public class FtpDownloader
extends AbstractDownloader<FtpDownloader>
implements Ftp {
    public static final String TYPE = "ftp";
    private String username;
    private String password;
    private String host;
    private Integer port;

    public FtpDownloader() {
        super(TYPE);
    }

    @Override
    public void merge(FtpDownloader ftp) {
        this.freezeCheck();
        super.merge(ftp);
        this.username = this.merge(this.username, ftp.username);
        this.password = this.merge(this.password, ftp.password);
        this.host = this.merge(this.host, ftp.host);
        this.port = this.merge(this.port, ftp.port);
    }

    @Override
    public String getResolvedUsername() {
        return Env.env((String)("FTP_" + Env.toVar((String)this.name) + "_USERNAME"), (String)this.username);
    }

    @Override
    public String getResolvedPassword() {
        return Env.env((String)("FTP_" + Env.toVar((String)this.name) + "_PASSWORD"), (String)this.password);
    }

    @Override
    public String getResolvedHost() {
        return Env.env((String)("FTP_" + Env.toVar((String)this.name) + "_HOST"), (String)this.host);
    }

    @Override
    public Integer getResolvedPort() {
        String value = Env.env((String)("FTP_" + Env.toVar((String)this.name) + "_PORT"), (String)(null == this.port ? "" : String.valueOf(this.port)));
        return StringUtils.isBlank((String)value) ? 21 : Integer.parseInt(value);
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.freezeCheck();
        this.username = username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.freezeCheck();
        this.password = password;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public void setHost(String host) {
        this.freezeCheck();
        this.host = host;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public void setPort(Integer port) {
        this.freezeCheck();
        this.port = port;
    }

    @Override
    protected void asMap(Map<String, Object> props, boolean full) {
        props.put("host", this.getResolvedHost());
        props.put("port", this.getResolvedPort());
        props.put("username", StringUtils.isNotBlank((String)this.getResolvedUsername()) ? "************" : "**unset**");
        props.put("password", StringUtils.isNotBlank((String)this.getResolvedPassword()) ? "************" : "**unset**");
    }
}

