/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.AbstractUploader;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.SshUploader;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Templates;

public abstract class AbstractSshUploader<S extends AbstractSshUploader<S>>
extends AbstractUploader<S>
implements SshUploader {
    protected String username;
    protected String password;
    protected String host;
    protected Integer port;
    protected String knownHostsFile;
    protected String publicKey;
    protected String privateKey;
    protected String passphrase;
    protected String fingerprint;
    protected String path;
    protected String downloadUrl;

    public AbstractSshUploader(String type) {
        super(type);
    }

    @Override
    public void merge(S uploader) {
        this.freezeCheck();
        super.merge(uploader);
        this.username = this.merge(this.username, ((AbstractSshUploader)uploader).username);
        this.password = this.merge(this.password, ((AbstractSshUploader)uploader).password);
        this.host = this.merge(this.host, ((AbstractSshUploader)uploader).host);
        this.port = this.merge(this.port, ((AbstractSshUploader)uploader).port);
        this.knownHostsFile = this.merge(this.knownHostsFile, ((AbstractSshUploader)uploader).knownHostsFile);
        this.publicKey = this.merge(this.publicKey, ((AbstractSshUploader)uploader).publicKey);
        this.privateKey = this.merge(this.privateKey, ((AbstractSshUploader)uploader).privateKey);
        this.passphrase = this.merge(this.passphrase, ((AbstractSshUploader)uploader).passphrase);
        this.fingerprint = this.merge(this.fingerprint, ((AbstractSshUploader)uploader).fingerprint);
        this.path = this.merge(this.path, ((AbstractSshUploader)uploader).path);
        this.downloadUrl = this.merge(this.downloadUrl, ((AbstractSshUploader)uploader).downloadUrl);
    }

    protected abstract String getEnvPrefix();

    @Override
    public String getResolvedUsername() {
        return Env.env((Collection)CollectionUtils.listOf((Object[])new String[]{this.getEnvPrefix() + "_" + Env.toVar((String)this.name) + "_USERNAME", "SSH_" + Env.toVar((String)this.name) + "_USERNAME", this.getEnvPrefix() + "_USERNAME", "SSH_USERNAME"}), (String)this.username);
    }

    @Override
    public String getResolvedPassword() {
        return Env.env((Collection)CollectionUtils.listOf((Object[])new String[]{this.getEnvPrefix() + "_" + Env.toVar((String)this.name) + "_PASSWORD", "SSH_" + Env.toVar((String)this.name) + "_PASSWORD", this.getEnvPrefix() + "_PASSWORD", "SSH_PASSWORD"}), (String)this.password);
    }

    @Override
    public String getResolvedHost() {
        return Env.env((Collection)CollectionUtils.listOf((Object[])new String[]{this.getEnvPrefix() + "_" + Env.toVar((String)this.name) + "_HOST", "SSH_" + Env.toVar((String)this.name) + "_HOST", this.getEnvPrefix() + "_HOST", "SSH_HOST"}), (String)this.host);
    }

    @Override
    public Integer getResolvedPort() {
        String value = Env.env((Collection)CollectionUtils.listOf((Object[])new String[]{this.getEnvPrefix() + "_" + Env.toVar((String)this.name) + "_PORT", "SSH_" + Env.toVar((String)this.name) + "_PORT", this.getEnvPrefix() + "_PORT", "SSH_PORT"}), (String)(null == this.port ? "" : String.valueOf(this.port)));
        return StringUtils.isBlank((String)value) ? 22 : Integer.parseInt(value);
    }

    @Override
    public String getResolvedPublicKey() {
        return Env.env((Collection)CollectionUtils.listOf((Object[])new String[]{this.getEnvPrefix() + "_" + Env.toVar((String)this.name) + "_PUBLIC_KEY", "SSH_" + Env.toVar((String)this.name) + "_PUBLIC_KEY", this.getEnvPrefix() + "_PUBLIC_KEY", "SSH_PUBLIC_KEY"}), (String)this.publicKey);
    }

    @Override
    public String getResolvedPrivateKey() {
        return Env.env((Collection)CollectionUtils.listOf((Object[])new String[]{this.getEnvPrefix() + "_" + Env.toVar((String)this.name) + "_PRIVATE_KEY", "SSH_" + Env.toVar((String)this.name) + "_PRIVATE_KEY", this.getEnvPrefix() + "_PRIVATE_KEY", "SSH_PRIVATE_KEY"}), (String)this.privateKey);
    }

    @Override
    public String getResolvedPassphrase() {
        return Env.env((Collection)CollectionUtils.listOf((Object[])new String[]{this.getEnvPrefix() + "_" + Env.toVar((String)this.name) + "_PASSPHRASE", "SSH_" + Env.toVar((String)this.name) + "_PASSPHRASE", this.getEnvPrefix() + "_PASSPHRASE", "SSH_PASSPHRASE"}), (String)this.passphrase);
    }

    @Override
    public String getResolvedFingerprint() {
        return Env.env((Collection)CollectionUtils.listOf((Object[])new String[]{this.getEnvPrefix() + "_" + Env.toVar((String)this.name) + "_FINGERPRINT", "SSH_" + Env.toVar((String)this.name) + "_FINGERPRINT", this.getEnvPrefix() + "_FINGERPRINT", "SSH_FINGERPRINT"}), (String)this.fingerprint);
    }

    @Override
    public String getResolvedPath(JReleaserContext context, Artifact artifact) {
        Map p = this.artifactProps((Map)context.fullProps(), artifact);
        p.putAll(this.getResolvedExtraProperties());
        return Templates.resolveTemplate((String)this.path, (Map)p);
    }

    @Override
    public String getResolvedDownloadUrl(JReleaserContext context, Artifact artifact) {
        return this.getResolvedDownloadUrl(context.fullProps(), artifact);
    }

    @Override
    public String getResolvedDownloadUrl(Map<String, Object> props, Artifact artifact) {
        LinkedHashMap<String, Object> p = new LinkedHashMap<String, Object>(this.artifactProps((Map)props, artifact));
        p.putAll(this.getResolvedExtraProperties());
        return Templates.resolveTemplate((String)this.downloadUrl, p);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.freezeCheck();
        this.path = path;
    }

    @Override
    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    @Override
    public void setDownloadUrl(String downloadUrl) {
        this.freezeCheck();
        this.downloadUrl = downloadUrl;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.freezeCheck();
        this.username = username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.freezeCheck();
        this.password = password;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public void setHost(String host) {
        this.freezeCheck();
        this.host = host;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public void setPort(Integer port) {
        this.freezeCheck();
        this.port = port;
    }

    @Override
    public String getKnownHostsFile() {
        return this.knownHostsFile;
    }

    @Override
    public void setKnownHostsFile(String knownHostsFile) {
        this.freezeCheck();
        this.knownHostsFile = knownHostsFile;
    }

    @Override
    public String getPublicKey() {
        return this.publicKey;
    }

    @Override
    public void setPublicKey(String publicKey) {
        this.freezeCheck();
        this.publicKey = publicKey;
    }

    @Override
    public String getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public void setPrivateKey(String privateKey) {
        this.freezeCheck();
        this.privateKey = privateKey;
    }

    @Override
    public String getPassphrase() {
        return this.passphrase;
    }

    @Override
    public void setPassphrase(String passphrase) {
        this.freezeCheck();
        this.passphrase = passphrase;
    }

    @Override
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public void setFingerprint(String fingerprint) {
        this.freezeCheck();
        this.fingerprint = fingerprint;
    }

    @Override
    protected void asMap(Map<String, Object> props, boolean full) {
        props.put("host", StringUtils.isNotBlank((String)this.getResolvedHost()) ? "************" : "**unset**");
        props.put("port", this.getResolvedPort());
        props.put("username", StringUtils.isNotBlank((String)this.getResolvedUsername()) ? "************" : "**unset**");
        props.put("password", StringUtils.isNotBlank((String)this.getResolvedPassword()) ? "************" : "**unset**");
        props.put("knownHostsFile", this.knownHostsFile);
        props.put("publicKey", StringUtils.isNotBlank((String)this.getResolvedPublicKey()) ? "************" : "**unset**");
        props.put("privateKey", StringUtils.isNotBlank((String)this.getResolvedPrivateKey()) ? "************" : "**unset**");
        props.put("passphrase", StringUtils.isNotBlank((String)this.getResolvedPassphrase()) ? "************" : "**unset**");
        props.put("fingerprint", StringUtils.isNotBlank((String)this.getResolvedFingerprint()) ? "************" : "**unset**");
        props.put("path", this.path);
        props.put("downloadUrl", this.downloadUrl);
    }
}

