/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.github;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.apache.tika.Tika;
import org.apache.tika.mime.MediaType;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserVersion;
import org.jreleaser.model.releaser.spi.Asset;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.StringUtils;
import org.kohsuke.github.GHAsset;
import org.kohsuke.github.GHBranch;
import org.kohsuke.github.GHDiscussion;
import org.kohsuke.github.GHException;
import org.kohsuke.github.GHFileNotFoundException;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHMilestone;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHRelease;
import org.kohsuke.github.GHReleaseBuilder;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTeam;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.HttpConnector;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.extras.ImpatientHttpConnector;

class Github {
    static final String ENDPOINT = "https://api.github.com";
    private final Tika tika = new Tika();
    private final JReleaserLogger logger;
    private final GitHub github;

    Github(JReleaserLogger logger, String token, int connectTimeout, int readTimeout) throws IOException {
        this(logger, ENDPOINT, token, connectTimeout, readTimeout);
    }

    Github(JReleaserLogger logger, String endpoint, String token, int connectTimeout, int readTimeout) throws IOException {
        this.logger = logger;
        if (StringUtils.isBlank((String)endpoint)) {
            endpoint = ENDPOINT;
        }
        this.github = new GitHubBuilder().withConnector((HttpConnector)new JReleaserHttpConnector(connectTimeout, readTimeout)).withEndpoint(endpoint).withOAuthToken(token).build();
    }

    PagedIterable<GHRelease> listReleases(String owner, String repo) throws IOException {
        this.logger.debug(RB.$((String)"git.list.releases", (Object[])new Object[0]), new Object[]{owner, repo});
        return this.github.getRepository(owner + "/" + repo).listReleases();
    }

    Map<String, GHBranch> listBranches(String owner, String repo) throws IOException {
        this.logger.debug(RB.$((String)"git.list.branches", (Object[])new Object[0]), new Object[]{owner, repo});
        return this.github.getRepository(owner + "/" + repo).getBranches();
    }

    Map<String, GHAsset> listAssets(String owner, String repo, GHRelease release) throws IOException {
        this.logger.debug(RB.$((String)"git.list.assets.github", (Object[])new Object[0]), new Object[]{owner, repo, release.getId()});
        LinkedHashMap<String, GHAsset> assets = new LinkedHashMap<String, GHAsset>();
        for (GHAsset asset : release.listAssets()) {
            assets.put(asset.getName(), asset);
        }
        return assets;
    }

    GHRepository findRepository(String owner, String repo) throws IOException {
        this.logger.debug(RB.$((String)"git.repository.lookup", (Object[])new Object[0]), new Object[]{owner, repo});
        try {
            return this.github.getRepository(owner + "/" + repo);
        }
        catch (GHFileNotFoundException e) {
            return null;
        }
    }

    GHRepository createRepository(String owner, String repo) throws IOException {
        this.logger.debug(RB.$((String)"git.repository.create", (Object[])new Object[0]), new Object[]{owner, repo});
        GHOrganization organization = this.resolveOrganization(owner);
        if (null != organization) {
            return organization.createRepository(repo).create();
        }
        return this.github.createRepository(repo).create();
    }

    Optional<GHMilestone> findMilestoneByName(String owner, String repo, String milestoneName) throws IOException {
        this.logger.debug(RB.$((String)"git.milestone.lookup", (Object[])new Object[0]), new Object[]{milestoneName, owner, repo});
        GHRepository repository = this.findRepository(owner, repo);
        PagedIterable milestones = repository.listMilestones(GHIssueState.OPEN);
        return StreamSupport.stream(milestones.spliterator(), false).filter(m -> milestoneName.equals(m.getTitle())).findFirst();
    }

    void closeMilestone(String owner, String repo, GHMilestone milestone) throws IOException {
        this.logger.debug(RB.$((String)"git.milestone.close", (Object[])new Object[0]), new Object[]{milestone.getTitle(), owner, repo});
        milestone.close();
    }

    GHRelease findReleaseByTag(String repo, String tagName) throws IOException {
        this.logger.debug(RB.$((String)"git.fetch.release.on.tag", (Object[])new Object[0]), new Object[]{repo, tagName});
        return this.github.getRepository(repo).getReleaseByTagName(tagName);
    }

    void deleteTag(String repo, String tagName) throws IOException {
        this.logger.debug(RB.$((String)"git.delete.tag.from.repository", (Object[])new Object[0]), new Object[]{tagName, repo});
        this.github.getRepository(repo).getRef("refs/tags/" + tagName).delete();
    }

    GHReleaseBuilder createRelease(String repo, String tagName) throws IOException {
        this.logger.debug(RB.$((String)"git.create.release.repository", (Object[])new Object[0]), new Object[]{repo, tagName});
        return this.github.getRepository(repo).createRelease(tagName);
    }

    void uploadAssets(GHRelease release, List<Asset> assets) throws IOException {
        for (Asset asset : assets) {
            if (0L == Files.size(asset.getPath()) || !Files.exists(asset.getPath(), new LinkOption[0])) continue;
            this.logger.info(" " + RB.$((String)"git.upload.asset", (Object[])new Object[0]), new Object[]{asset.getFilename()});
            GHAsset ghasset = release.uploadAsset(asset.getPath().toFile(), MediaType.parse((String)this.tika.detect(asset.getPath())).toString());
            if ("uploaded".equalsIgnoreCase(ghasset.getState())) continue;
            this.logger.warn(" " + RB.$((String)"git.upload.asset.failure", (Object[])new Object[0]), new Object[]{asset.getFilename()});
        }
    }

    void updateAssets(GHRelease release, List<Asset> assets, Map<String, GHAsset> existingAssets) throws IOException {
        for (Asset asset : assets) {
            if (0L == Files.size(asset.getPath()) || !Files.exists(asset.getPath(), new LinkOption[0])) continue;
            this.logger.debug(" " + RB.$((String)"git.delete.asset", (Object[])new Object[0]), new Object[]{asset.getFilename()});
            try {
                existingAssets.get(asset.getFilename()).delete();
            }
            catch (IOException e) {
                this.logger.error(" " + RB.$((String)"git.delete.asset.failure", (Object[])new Object[0]), new Object[]{asset.getFilename()});
                throw e;
            }
            this.logger.info(" " + RB.$((String)"git.update.asset", (Object[])new Object[0]), new Object[]{asset.getFilename()});
            GHAsset ghasset = release.uploadAsset(asset.getPath().toFile(), MediaType.parse((String)this.tika.detect(asset.getPath())).toString());
            if ("uploaded".equalsIgnoreCase(ghasset.getState())) continue;
            this.logger.warn(" " + RB.$((String)"git.update.asset.failure", (Object[])new Object[0]), new Object[]{asset.getFilename()});
        }
    }

    Optional<GHDiscussion> findDiscussion(String organization, String team, String title) throws IOException {
        GHTeam ghTeam = this.resolveTeam(organization, team);
        try {
            return StreamSupport.stream(ghTeam.listDiscussions().spliterator(), false).filter(d -> title.equals(d.getTitle())).findFirst();
        }
        catch (GHException ghe) {
            if (ghe.getCause() instanceof GHFileNotFoundException) {
                return Optional.empty();
            }
            throw ghe;
        }
    }

    GHDiscussion createDiscussion(String organization, String team, String title, String message) throws IOException {
        GHTeam ghTeam = this.resolveTeam(organization, team);
        return ((GHDiscussion.Creator)ghTeam.createDiscussion(title).body(message)).done();
    }

    private GHOrganization resolveOrganization(String name) throws IOException {
        try {
            return this.github.getOrganization(name);
        }
        catch (GHFileNotFoundException ignored) {
            return null;
        }
    }

    private GHTeam resolveTeam(String organization, String team) throws IOException {
        GHOrganization ghOrganization = null;
        try {
            ghOrganization = this.github.getOrganization(organization);
        }
        catch (GHFileNotFoundException e) {
            throw new IllegalStateException(RB.$((String)"ERROR_git_organization_not_exist", (Object[])new Object[]{organization}));
        }
        GHTeam ghTeam = null;
        try {
            ghTeam = ghOrganization.getTeamByName(team);
        }
        catch (IOException e) {
            throw new IllegalStateException(RB.$((String)"ERROR_git_team_not_exist", (Object[])new Object[0]));
        }
        if (null == ghTeam) {
            throw new IllegalStateException(RB.$((String)"ERROR_git_team_not_exist", (Object[])new Object[0]));
        }
        return ghTeam;
    }

    private static class JReleaserHttpConnector
    extends ImpatientHttpConnector {
        public JReleaserHttpConnector(int connectTimeout, int readTimeout) {
            super(HttpConnector.DEFAULT, connectTimeout * 1000, readTimeout * 1000);
        }

        public HttpURLConnection connect(URL url) throws IOException {
            HttpURLConnection connection = super.connect(url);
            connection.addRequestProperty("User-Agent", "JReleaser/" + JReleaserVersion.getPlainVersion());
            return connection;
        }
    }
}

