/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.gitlab;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.FormData;
import feign.form.FormEncoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.tika.Tika;
import org.apache.tika.mime.MediaType;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.releaser.spi.Asset;
import org.jreleaser.model.releaser.spi.Release;
import org.jreleaser.model.releaser.spi.User;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.commons.RestAPIException;
import org.jreleaser.sdk.gitlab.api.GitlabAPI;
import org.jreleaser.sdk.gitlab.api.GlBranch;
import org.jreleaser.sdk.gitlab.api.GlFileUpload;
import org.jreleaser.sdk.gitlab.api.GlLinkRequest;
import org.jreleaser.sdk.gitlab.api.GlMilestone;
import org.jreleaser.sdk.gitlab.api.GlProject;
import org.jreleaser.sdk.gitlab.api.GlRelease;
import org.jreleaser.sdk.gitlab.api.GlUser;
import org.jreleaser.sdk.gitlab.internal.Page;
import org.jreleaser.sdk.gitlab.internal.PaginatingDecoder;
import org.jreleaser.sdk.gitlab.internal.UrlEncoder;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.StringUtils;

class Gitlab {
    static final String ENDPOINT = "https://gitlab.com/api/v4";
    private static final String API_V4 = "/api/v4";
    private final Tika tika = new Tika();
    private final JReleaserLogger logger;
    private final GitlabAPI api;
    private final String apiHost;
    private GlUser user;
    private GlProject project;

    Gitlab(JReleaserLogger logger, String endpoint, String token, int connectTimeout, int readTimeout) throws IOException {
        Objects.requireNonNull(logger, "'logger' must not be null");
        StringUtils.requireNonBlank((String)token, (String)"'token' must not be blank");
        if (StringUtils.isBlank((String)endpoint)) {
            endpoint = ENDPOINT;
        }
        if (!endpoint.endsWith(API_V4)) {
            if (endpoint.endsWith("/")) {
                endpoint = endpoint.substring(0, endpoint.length() - 1);
            }
            endpoint = endpoint + API_V4;
        }
        this.apiHost = endpoint.substring(0, endpoint.length() - API_V4.length());
        ObjectMapper objectMapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.INDENT_OUTPUT, true);
        this.logger = logger;
        this.api = (GitlabAPI)ClientUtils.builder((JReleaserLogger)logger, (int)connectTimeout, (int)readTimeout).encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder(objectMapper))).decoder((Decoder)new PaginatingDecoder((Decoder)new JacksonDecoder(objectMapper))).requestInterceptor(template -> template.header("Authorization", new String[]{String.format("Bearer %s", token)})).target(GitlabAPI.class, endpoint);
    }

    GlProject findProject(String projectName, String projectIdentifier) throws RestAPIException {
        return this.getProject(projectName, projectIdentifier);
    }

    List<Release> listReleases(String owner, String repoName, String projectIdentifier) throws IOException {
        this.logger.debug(RB.$((String)"git.list.releases", (Object[])new Object[0]), new Object[]{owner, repoName});
        ArrayList<Release> releases = new ArrayList<Release>();
        if (StringUtils.isBlank((String)projectIdentifier)) {
            GlProject project = this.getProject(repoName, projectIdentifier);
            projectIdentifier = project.getId().toString();
        }
        Page<List<GlRelease>> page = this.api.listReleases0(projectIdentifier);
        page.getContent().stream().map(r -> new Release(r.getName(), r.getTagName(), this.apiHost + r.getTagPath(), r.getReleasedAt())).forEach(releases::add);
        if (page.hasLinks() && page.getLinks().hasNext()) {
            try {
                this.collectReleases(page, releases);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        return releases;
    }

    private void collectReleases(Page<List<GlRelease>> page, List<Release> releases) throws URISyntaxException {
        URI next = new URI(page.getLinks().next());
        this.logger.debug(next.toString());
        page = this.api.listReleases1(next);
        page.getContent().stream().map(r -> new Release(r.getName(), r.getTagName(), this.apiHost + r.getTagPath(), r.getReleasedAt())).forEach(releases::add);
        if (page.hasLinks() && page.getLinks().hasNext()) {
            this.collectReleases(page, releases);
        }
    }

    List<String> listBranches(String owner, String repoName, String projectIdentifier) throws IOException {
        this.logger.debug(RB.$((String)"git.list.branches", (Object[])new Object[0]), new Object[]{owner, repoName});
        ArrayList<String> branches = new ArrayList<String>();
        if (StringUtils.isBlank((String)projectIdentifier)) {
            GlProject project = this.getProject(repoName, projectIdentifier);
            projectIdentifier = project.getId().toString();
        }
        Page<List<GlBranch>> page = this.api.listBranches0(projectIdentifier);
        page.getContent().stream().map(GlBranch::getName).forEach(branches::add);
        if (page.hasLinks() && page.getLinks().hasNext()) {
            try {
                this.collectBranches(page, branches);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        return branches;
    }

    private void collectBranches(Page<List<GlBranch>> page, List<String> branches) throws URISyntaxException {
        URI next = new URI(page.getLinks().next());
        this.logger.debug(next.toString());
        page = this.api.listBranches1(next);
        page.getContent().stream().map(GlBranch::getName).forEach(branches::add);
        if (page.hasLinks() && page.getLinks().hasNext()) {
            this.collectBranches(page, branches);
        }
    }

    Optional<GlMilestone> findMilestoneByName(String owner, String repo, String projectIdentifier, String milestoneName) throws IOException {
        this.logger.debug(RB.$((String)"git.milestone.lookup", (Object[])new Object[0]), new Object[]{milestoneName, owner, repo});
        GlProject project = this.getProject(repo, projectIdentifier);
        try {
            List<GlMilestone> milestones = this.api.findMilestoneByTitle(project.getId(), (Map<String, Object>)CollectionUtils.map().e((Object)"title", (Object)milestoneName));
            if (milestones == null || milestones.isEmpty()) {
                return Optional.empty();
            }
            GlMilestone milestone = milestones.get(0);
            return "active".equals(milestone.getState()) ? Optional.of(milestone) : Optional.empty();
        }
        catch (RestAPIException e) {
            if (e.isNotFound() || e.isForbidden()) {
                return Optional.empty();
            }
            throw e;
        }
    }

    void closeMilestone(String owner, String repo, String projectIdentifier, GlMilestone milestone) throws IOException {
        this.logger.debug(RB.$((String)"git.milestone.close", (Object[])new Object[0]), new Object[]{milestone.getTitle(), owner, repo});
        GlProject project = this.getProject(repo, projectIdentifier);
        this.api.updateMilestone((Map<String, Object>)CollectionUtils.map().e((Object)"state_event", (Object)"close"), project.getId(), milestone.getId());
    }

    GlProject createProject(String owner, String repo) throws IOException {
        this.logger.debug(RB.$((String)"git.project.create", (Object[])new Object[0]), new Object[]{owner, repo});
        return this.api.createProject(repo, "public");
    }

    GlUser getCurrentUser() throws RestAPIException {
        if (null == this.user) {
            this.logger.debug(RB.$((String)"git.fetch.current.user", (Object[])new Object[0]));
            this.user = this.api.getCurrentUser();
        }
        return this.user;
    }

    GlProject getProject(String projectName, String projectIdentifier) throws RestAPIException {
        if (null == this.project) {
            if (StringUtils.isNotBlank((String)projectIdentifier)) {
                this.logger.debug(RB.$((String)"git.fetch.gitlab.project_by_id", (Object[])new Object[0]), new Object[]{projectIdentifier});
                this.project = this.api.getProject(projectIdentifier.trim());
            } else {
                GlUser u = this.getCurrentUser();
                this.logger.debug(RB.$((String)"git.fetch.gitlab.project.by.user", (Object[])new Object[0]), new Object[]{projectName, u.getUsername(), u.getId()});
                List<GlProject> projects = this.api.getProject(u.getId(), (Map<String, Object>)CollectionUtils.map().e((Object)"search", (Object)projectName));
                if (projects == null || projects.isEmpty()) {
                    throw new RestAPIException(404, RB.$((String)"ERROR_project_not_exist", (Object[])new Object[]{projectName}));
                }
                this.project = projects.get(0);
            }
            this.logger.debug(RB.$((String)"git.gitlab.project.found", (Object[])new Object[0]), new Object[]{this.project.getNameWithNamespace(), this.project.getId()});
        }
        return this.project;
    }

    GlRelease findReleaseByTag(String owner, String repoName, String projectIdentifier, String tagName) throws RestAPIException {
        this.logger.debug(RB.$((String)"git.fetch.release.by.tag", (Object[])new Object[0]), new Object[]{owner, repoName, tagName});
        GlProject project = this.getProject(repoName, projectIdentifier);
        try {
            return this.api.getRelease(project.getId(), UrlEncoder.urlEncode(tagName));
        }
        catch (RestAPIException e) {
            if (e.isNotFound() || e.isForbidden()) {
                return null;
            }
            throw e;
        }
    }

    void deleteTag(String owner, String repoName, String projectIdentifier, String tagName) throws RestAPIException {
        this.logger.debug(RB.$((String)"git.delete.tag.from", (Object[])new Object[0]), new Object[]{tagName, owner, repoName});
        GlProject project = this.getProject(repoName, projectIdentifier);
        this.api.deleteTag(project.getId(), UrlEncoder.urlEncode(tagName));
    }

    void deleteRelease(String owner, String repoName, String projectIdentifier, String tagName) throws RestAPIException {
        this.logger.debug(RB.$((String)"git.delete.release.from", (Object[])new Object[0]), new Object[]{tagName, owner, repoName});
        GlProject project = this.getProject(repoName, projectIdentifier);
        this.api.deleteRelease(project.getId(), UrlEncoder.urlEncode(tagName));
    }

    void createRelease(String owner, String repoName, String projectIdentifier, GlRelease release) throws RestAPIException {
        this.logger.debug(RB.$((String)"git.create.release", (Object[])new Object[0]), new Object[]{owner, repoName, release.getTagName()});
        GlProject project = this.getProject(repoName, projectIdentifier);
        this.api.createRelease(release, project.getId());
    }

    void updateRelease(String owner, String repoName, String projectIdentifier, GlRelease release) throws RestAPIException {
        this.logger.debug(RB.$((String)"git.update.release", (Object[])new Object[0]), new Object[]{owner, repoName, release.getTagName()});
        GlProject project = this.getProject(repoName, projectIdentifier);
        this.api.updateRelease(release, project.getId());
    }

    Collection<GlFileUpload> uploadAssets(String owner, String repoName, String projectIdentifier, List<Asset> assets) throws IOException, RestAPIException {
        this.logger.debug(RB.$((String)"git.upload.assets", (Object[])new Object[0]), new Object[]{owner, repoName});
        ArrayList<GlFileUpload> uploads = new ArrayList<GlFileUpload>();
        GlProject project = this.getProject(repoName, projectIdentifier);
        for (Asset asset : assets) {
            if (0L == Files.size(asset.getPath()) || !Files.exists(asset.getPath(), new LinkOption[0])) continue;
            this.logger.info(" " + RB.$((String)"git.upload.asset", (Object[])new Object[0]), new Object[]{asset.getFilename()});
            try {
                GlFileUpload upload = this.api.uploadFile(project.getId(), this.toFormData(asset.getPath()));
                upload.setName(asset.getFilename());
                uploads.add(upload);
            }
            catch (IOException | RestAPIException e) {
                this.logger.error(" " + RB.$((String)"git.upload.asset.failure", (Object[])new Object[0]), new Object[]{asset.getFilename()});
                throw e;
            }
        }
        return uploads;
    }

    void linkReleaseAssets(String owner, String repoName, GlRelease release, String projectIdentifier, Collection<GlFileUpload> uploads) throws IOException, RestAPIException {
        this.logger.debug(RB.$((String)"git.upload.asset.links", (Object[])new Object[0]), new Object[]{owner, repoName, release.getTagName()});
        GlProject project = this.getProject(repoName, projectIdentifier);
        for (GlFileUpload upload : uploads) {
            this.logger.debug(" " + RB.$((String)"git.upload.asset.link", (Object[])new Object[0]), new Object[]{upload.getName()});
            try {
                this.api.linkAsset(upload.toLinkRequest(this.apiHost), project.getId(), release.getTagName());
            }
            catch (RestAPIException e) {
                this.logger.error(" " + RB.$((String)"git.upload.asset.link.failure", (Object[])new Object[0]), new Object[]{upload.getName()});
                throw e;
            }
        }
    }

    void linkAssets(String owner, String repoName, GlRelease release, String projectIdentifier, Collection<GlLinkRequest> links) throws IOException, RestAPIException {
        this.logger.debug(RB.$((String)"git.upload.asset.links", (Object[])new Object[0]), new Object[]{owner, repoName, release.getTagName()});
        GlProject project = this.getProject(repoName, projectIdentifier);
        for (GlLinkRequest link : links) {
            this.logger.info(" " + RB.$((String)"git.upload.asset.link", (Object[])new Object[0]), new Object[]{link.getName()});
            try {
                this.api.linkAsset(link, project.getId(), release.getTagName());
            }
            catch (RestAPIException e) {
                this.logger.error(" " + RB.$((String)"git.upload.asset.link.failure", (Object[])new Object[0]), new Object[]{link.getName()});
                throw e;
            }
        }
    }

    Optional<User> findUser(String email, String name) throws RestAPIException {
        GlUser user;
        this.logger.debug(RB.$((String)"git.user.lookup", (Object[])new Object[0]), new Object[]{name, email});
        List<GlUser> users = this.api.searchUser(CollectionUtils.mapOf((Object[])new Object[]{"scope", "users", "search", email}));
        if (users != null && !users.isEmpty()) {
            GlUser user2 = users.get(0);
            return Optional.of(new User(user2.getUsername(), email, user2.getWebUrl()));
        }
        users = this.api.searchUser(CollectionUtils.mapOf((Object[])new Object[]{"scope", "users", "search", name}));
        if (users != null && !users.isEmpty() && name.equals((user = users.get(0)).getName())) {
            return Optional.of(new User(user.getUsername(), email, user.getWebUrl()));
        }
        return Optional.empty();
    }

    private FormData toFormData(Path asset) throws IOException {
        return FormData.builder().fileName(asset.getFileName().toString()).contentType(MediaType.parse((String)this.tika.detect(asset)).toString()).data(Files.readAllBytes(asset)).build();
    }
}

