/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.distribution;

import java.util.List;
import java.util.Locale;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.distribution.DistributionProcessor;
import org.jreleaser.engine.distribution.PackagerProcessingFunction;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.packager.spi.PackagerProcessingException;
import org.jreleaser.util.JReleaserException;

public class Distributions {
    public static void process(JReleaserContext context, String action, PackagerProcessingFunction function) {
        List activeDistributions = context.getModel().getActiveDistributions();
        if (activeDistributions.isEmpty()) {
            context.getLogger().debug(RB.$((String)"distributions.not.enabled", (Object[])new Object[0]), new Object[]{action.toLowerCase(Locale.ENGLISH)});
            return;
        }
        if (!context.getIncludedDistributions().isEmpty()) {
            for (String distributionName : context.getIncludedDistributions()) {
                Distribution distribution = activeDistributions.stream().filter(d -> distributionName.equals(d.getName())).findFirst().orElse(null);
                if (null == distribution) {
                    context.getLogger().error(RB.$((String)"distributions.no.match", (Object[])new Object[0]), new Object[]{distributionName});
                    return;
                }
                if (!context.getIncludedPackagers().isEmpty()) {
                    for (String packagerName : context.getIncludedPackagers()) {
                        if (!Distribution.supportedPackagers().contains(packagerName)) {
                            context.getLogger().warn(RB.$((String)"ERROR_unsupported_packager", (Object[])new Object[]{packagerName}));
                            continue;
                        }
                        context.getLogger().info(RB.$((String)"distributions.apply.action", (Object[])new Object[0]), new Object[]{action});
                        Distributions.processDistribution(context, action, distribution, packagerName, function);
                    }
                    continue;
                }
                Distributions.processDistribution(context, action, distribution, function);
            }
        } else if (!context.getIncludedPackagers().isEmpty()) {
            for (String packagerName : context.getIncludedPackagers()) {
                if (!Distribution.supportedPackagers().contains(packagerName)) {
                    context.getLogger().warn(RB.$((String)"ERROR_unsupported_packager", (Object[])new Object[]{packagerName}));
                    continue;
                }
                context.getLogger().info(RB.$((String)"distributions.apply.action", (Object[])new Object[0]), new Object[]{action});
                for (Distribution distribution : activeDistributions) {
                    Distributions.processDistribution(context, action, distribution, packagerName, function);
                }
            }
        } else {
            context.getLogger().info(RB.$((String)"distributions.apply.action", (Object[])new Object[0]), new Object[]{action});
            for (Distribution distribution : activeDistributions) {
                if (context.getExcludedDistributions().contains(distribution.getName())) {
                    context.getLogger().info(RB.$((String)"distributions.distribution.excluded", (Object[])new Object[0]), new Object[]{distribution.getName()});
                    continue;
                }
                Distributions.processDistribution(context, action, distribution, function);
            }
        }
    }

    private static void processDistribution(JReleaserContext context, String action, Distribution distribution, PackagerProcessingFunction function) {
        context.getLogger().increaseIndent();
        context.getLogger().info(RB.$((String)"distributions.apply.action.to", (Object[])new Object[0]), new Object[]{action, distribution.getName()});
        for (String packagerName : Distribution.supportedPackagers()) {
            if (context.getExcludedPackagers().contains(packagerName)) {
                context.getLogger().info(RB.$((String)"packagers.packager.excluded", (Object[])new Object[0]), new Object[]{packagerName});
                continue;
            }
            Distributions.processPackager(context, distribution, packagerName, function);
        }
        context.getLogger().decreaseIndent();
    }

    private static void processDistribution(JReleaserContext context, String action, Distribution distribution, String packagerName, PackagerProcessingFunction function) {
        context.getLogger().increaseIndent();
        context.getLogger().info(RB.$((String)"distributions.apply.action.to", (Object[])new Object[0]), new Object[]{action, distribution.getName()});
        Distributions.processPackager(context, distribution, packagerName, function);
        context.getLogger().decreaseIndent();
    }

    private static void processPackager(JReleaserContext context, Distribution distribution, String packagerName, PackagerProcessingFunction function) {
        context.getLogger().increaseIndent();
        context.getLogger().setPrefix(packagerName);
        try {
            DistributionProcessor processor = Distributions.createDistributionProcessor(context, distribution, packagerName);
            function.consume(processor);
        }
        catch (PackagerProcessingException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
        context.getLogger().restorePrefix();
        context.getLogger().decreaseIndent();
    }

    private static DistributionProcessor createDistributionProcessor(JReleaserContext context, Distribution distribution, String packagerName) {
        return DistributionProcessor.builder().context(context).distributionName(distribution.getName()).packagerName(packagerName).build();
    }
}

