/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.util;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.github.mustachejava.TemplateFunction;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.jreleaser.bundle.RB;
import org.jreleaser.util.Algorithm;
import org.jreleaser.util.ChecksumUtils;
import org.jreleaser.util.StringUtils;

public final class MustacheUtils {
    private MustacheUtils() {
    }

    private static Map<String, String> envVars() {
        LinkedHashMap<String, String> vars = new LinkedHashMap<String, String>();
        System.getenv().forEach((k, v) -> {
            if (!k.startsWith("JRELEASER_")) {
                vars.put("Env." + k, (String)v);
            }
        });
        return vars;
    }

    public static String applyTemplate(Reader reader, Map<String, Object> context, String templateName) {
        StringWriter input = new StringWriter();
        MyMustacheFactory mf = new MyMustacheFactory();
        Mustache mustache = mf.compile(reader, templateName);
        context.putAll(MustacheUtils.envVars());
        mustache.execute((Writer)input, MustacheUtils.decorate(context));
        input.flush();
        return input.toString();
    }

    private static Map<String, Object> decorate(Map<String, Object> context) {
        for (Map.Entry entry : new LinkedHashSet<Map.Entry<String, Object>>(context.entrySet())) {
            String val;
            Object value = entry.getValue();
            if (!(value instanceof CharSequence) || !(val = String.valueOf(value)).contains("{{")) continue;
            context.put((String)entry.getKey(), new TemplateFunction(){

                public String apply(String s) {
                    return val;
                }
            });
        }
        return context;
    }

    public static String applyTemplate(Reader reader, Map<String, Object> context) {
        return MustacheUtils.applyTemplate(reader, context, UUID.randomUUID().toString()).trim();
    }

    public static String applyTemplate(String template, Map<String, Object> context, String templateName) {
        return MustacheUtils.applyTemplate(new StringReader(template), context, templateName);
    }

    public static String applyTemplate(String template, Map<String, Object> context) {
        return MustacheUtils.applyTemplate(new StringReader(template), context, UUID.randomUUID().toString()).trim();
    }

    public static void applyTemplates(Map<String, Object> props, Map<String, Object> templates) {
        for (Map.Entry entry : new LinkedHashSet<Map.Entry<String, Object>>(templates.entrySet())) {
            String val;
            Object value = entry.getValue();
            if (value instanceof CharSequence && (val = String.valueOf(value)).contains("{{") && val.contains("}}")) {
                value = MustacheUtils.applyTemplate(val, props);
            }
            props.put((String)entry.getKey(), value);
        }
    }

    public static String passThrough(String str) {
        return StringUtils.isNotBlank(str) ? "!!" + str + "!!" : str;
    }

    public static void applyFunctions(Map<String, Object> props) {
        ZonedDateTime now = (ZonedDateTime)props.get("__ZonedDateTime_now__");
        if (null == now) {
            now = ZonedDateTime.now();
        }
        props.put("f_now", new TimeFormatFunction(now));
        props.put("f_trim", new TrimFunction());
        props.put("f_underscore", new UnderscoreFunction());
        props.put("f_dash", new DashFunction());
        props.put("f_slash", new SlashFunction());
        props.put("f_upper", new UpperFunction());
        props.put("f_lower", new LowerFunction());
        props.put("f_capitalize", new CapitalizeFunction());
        props.put("f_uncapitalize", new UncapitalizeFunction());
        props.put("f_md2html", new MarkdownToHtmlFunction());
        props.put("f_file_read", new FileReadFunction());
        props.put("f_file_size", new FileSizeFunction());
        EnumSet.allOf(Algorithm.class).forEach(algorithm -> props.put("f_checksum_" + algorithm.formatted(), new FileChecksumFunction((Algorithm)((Object)algorithm))));
    }

    public static class FileChecksumFunction
    implements Function<Object, String> {
        private final Algorithm algorithm;

        public FileChecksumFunction(Algorithm algorithm) {
            this.algorithm = algorithm;
        }

        @Override
        public String apply(Object input) {
            try {
                if (input instanceof Path) {
                    return ChecksumUtils.checksum(this.algorithm, Files.readAllBytes((Path)input));
                }
                if (input instanceof File) {
                    return ChecksumUtils.checksum(this.algorithm, Files.readAllBytes(((File)input).toPath()));
                }
                if (input instanceof CharSequence) {
                    return ChecksumUtils.checksum(this.algorithm, Files.readAllBytes(Paths.get(String.valueOf(input).trim(), new String[0])));
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(RB.$("ERROR_unexpected_file_read", input), e);
            }
            throw new IllegalStateException(RB.$("ERROR_invalid_file_input", input));
        }
    }

    public static class FileSizeFunction
    implements Function<Object, Long> {
        @Override
        public Long apply(Object input) {
            try {
                if (input instanceof Path) {
                    return Files.size((Path)input);
                }
                if (input instanceof File) {
                    return Files.size(((File)input).toPath());
                }
                if (input instanceof CharSequence) {
                    return Files.size(Paths.get(String.valueOf(input).trim(), new String[0]));
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(RB.$("ERROR_unexpected_file_read", input), e);
            }
            throw new IllegalStateException(RB.$("ERROR_invalid_file_input", input));
        }
    }

    public static class FileReadFunction
    implements Function<Object, String> {
        @Override
        public String apply(Object input) {
            try {
                if (input instanceof Path) {
                    return new String(Files.readAllBytes((Path)input));
                }
                if (input instanceof File) {
                    return new String(Files.readAllBytes(((File)input).toPath()));
                }
                if (input instanceof CharSequence) {
                    return new String(Files.readAllBytes(Paths.get(String.valueOf(input).trim(), new String[0])));
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(RB.$("ERROR_unexpected_file_read", input), e);
            }
            throw new IllegalStateException(RB.$("ERROR_invalid_file_input", input));
        }
    }

    public static class MarkdownToHtmlFunction
    implements Function<String, String> {
        @Override
        public String apply(String input) {
            Parser parser = Parser.builder().build();
            Node document = parser.parse(input);
            HtmlRenderer renderer = HtmlRenderer.builder().build();
            return renderer.render(document).trim();
        }
    }

    public static class UncapitalizeFunction
    implements Function<String, String> {
        @Override
        public String apply(String input) {
            return StringUtils.uncapitalize(input);
        }
    }

    public static class CapitalizeFunction
    implements Function<String, String> {
        @Override
        public String apply(String input) {
            return StringUtils.capitalize(input);
        }
    }

    public static class LowerFunction
    implements Function<String, String> {
        @Override
        public String apply(String input) {
            return input.toLowerCase(Locale.ENGLISH);
        }
    }

    public static class UpperFunction
    implements Function<String, String> {
        @Override
        public String apply(String input) {
            return input.toUpperCase(Locale.ENGLISH);
        }
    }

    public static class SlashFunction
    implements Function<String, String> {
        @Override
        public String apply(String input) {
            return input.replace(".", "/").replace("-", "/").replace("+", "/");
        }
    }

    public static class DashFunction
    implements Function<String, String> {
        @Override
        public String apply(String input) {
            return input.replace(".", "-").replace("_", "-").replace("+", "-");
        }
    }

    public static class UnderscoreFunction
    implements Function<String, String> {
        @Override
        public String apply(String input) {
            return input.replace(".", "_").replace("-", "_").replace("+", "_");
        }
    }

    public static class TrimFunction
    implements Function<String, String> {
        @Override
        public String apply(String input) {
            return input.trim();
        }
    }

    public static class TimeFormatFunction
    implements Function<String, String> {
        private final ZonedDateTime now;

        private TimeFormatFunction(ZonedDateTime now) {
            this.now = now;
        }

        @Override
        public String apply(String input) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(input);
            return this.now.format(formatter);
        }
    }

    private static class MyMustacheFactory
    extends DefaultMustacheFactory {
        private MyMustacheFactory() {
        }

        public void encode(String value, Writer writer) {
            if (value.startsWith("!!") && value.endsWith("!!")) {
                try {
                    writer.write(value.substring(2, value.length() - 2));
                }
                catch (IOException e) {
                    throw new MustacheException(RB.$("ERROR_mustache_write_value", value), (Throwable)e);
                }
            } else {
                super.encode(value, writer);
            }
        }
    }
}

