/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.packagers;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Sdkman;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.JReleaserModel;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.SdkmanPackager;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.validation.common.ExtraPropertiesValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.distributions.DistributionsValidator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class SdkmanPackagerValidator {
    private SdkmanPackagerValidator() {
    }

    public static void validateSdkman(JReleaserContext context, Distribution distribution, SdkmanPackager packager, Errors errors) {
        context.getLogger().debug("distribution.{}." + packager.getType(), new Object[]{distribution.getName()});
        JReleaserModel model = context.getModel();
        SdkmanPackager parentPackager = model.getPackagers().getSdkman();
        boolean packagerSet = packager.isActiveSet();
        boolean parentPackagerSet = parentPackager.isActiveSet();
        packager.getExtraProperties().put("__MAGIC_SET__", packagerSet || parentPackagerSet);
        Validator.resolveActivatable(context, (Activatable)packager, "distributions." + distribution.getName() + "." + packager.getType(), parentPackager);
        if (!packager.resolveEnabled(context.getModel().getProject(), distribution)) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        BaseReleaser<?, ?> service = model.getRelease().getReleaser();
        if (!service.isReleaseSupported()) {
            context.getLogger().debug(RB.$((String)"validation.disabled.release", (Object[])new Object[0]));
            packager.disable();
            return;
        }
        List<Artifact> candidateArtifacts = packager.resolveCandidateArtifacts(context, distribution);
        if (candidateArtifacts.isEmpty()) {
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            errors.warning(RB.$((String)"WARNING.validation.packager.no.artifacts", (Object[])new Object[]{distribution.getName(), packager.getType(), packager.getSupportedFileExtensions(distribution.getType())}));
            packager.disable();
            return;
        }
        ExtraPropertiesValidator.mergeExtraProperties(packager, parentPackager);
        Validator.validateContinueOnError(packager, parentPackager);
        if (StringUtils.isBlank((String)packager.getDownloadUrl())) {
            packager.setDownloadUrl(parentPackager.getDownloadUrl());
        }
        if (null == packager.getCommand()) {
            packager.setCommand(parentPackager.getCommand());
            if (null == packager.getCommand()) {
                packager.setCommand(Sdkman.Command.MAJOR);
            }
        }
        if (StringUtils.isBlank((String)packager.getCandidate())) {
            packager.setCandidate(parentPackager.getCandidate());
            if (StringUtils.isBlank((String)packager.getCandidate())) {
                packager.setCandidate(distribution.getName());
            }
        }
        if (StringUtils.isBlank((String)packager.getReleaseNotesUrl())) {
            packager.setReleaseNotesUrl(parentPackager.getReleaseNotesUrl());
            if (StringUtils.isBlank((String)packager.getReleaseNotesUrl())) {
                packager.setReleaseNotesUrl(service.getReleaseNotesUrl());
            }
        }
        if (StringUtils.isBlank((String)packager.getConsumerKey())) {
            packager.setConsumerKey(parentPackager.getConsumerKey());
        }
        if (StringUtils.isBlank((String)packager.getConsumerToken())) {
            packager.setConsumerToken(parentPackager.getConsumerToken());
        }
        String baseKey = "distributions." + distribution.getName();
        packager.setConsumerKey(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{baseKey + ".sdkman.consumer.key", "SDKMAN_CONSUMER_KEY"}), baseKey + ".sdkman.consumerKey", packager.getConsumerKey(), errors, context.isDryrun()));
        packager.setConsumerToken(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{baseKey + ".sdkman.consumer.token", "SDKMAN_CONSUMER_TOKEN"}), baseKey + ".sdkman.consumerToken", packager.getConsumerToken(), errors, context.isDryrun()));
        Validator.validateTimeout(packager);
        DistributionsValidator.validateArtifactPlatforms(distribution, packager, candidateArtifacts, errors);
        if (errors.hasErrors()) {
            packager.disable();
        }
    }

    public static void postValidateSdkman(JReleaserContext context, Errors errors) {
        Map<String, List<Distribution>> map = context.getModel().getActiveDistributions().stream().peek(distribution -> {
            boolean set;
            if (distribution.getSdkman().getExtraProperties().containsKey("__MAGIC_SET__") && (set = ((Boolean)distribution.getSdkman().getExtraProperties().remove("__MAGIC_SET__")).booleanValue())) {
                context.getModel().getAnnounce().getSdkman().getExtraProperties().put("__MAGIC_SET__", set);
            }
        }).filter(d -> d.getSdkman().isEnabled()).collect(Collectors.groupingBy(d -> d.getSdkman().getCandidate()));
        map.forEach((candidate, distributions) -> {
            if (distributions.size() > 1) {
                errors.configuration(RB.$((String)"validation_sdkman_multiple_definition", (Object[])new Object[]{candidate, distributions.stream().map(Distribution::getName).collect(Collectors.joining(", "))}));
            }
        });
    }
}

