/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.upload;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.Map;
import org.jreleaser.model.Active;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.upload.AbstractGitPackageUploader;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;

public final class GitlabUploader
extends AbstractGitPackageUploader<org.jreleaser.model.api.upload.GitlabUploader, GitlabUploader> {
    private static final String DOWNLOAD_URL = "https://{{host}}/api/v4/projects/{{projectIdentifier}}/packages/generic/{{packageName}}/{{packageVersion}}/{{artifactFile}}";
    private static final long serialVersionUID = 5043963981384840431L;
    private String projectIdentifier;
    @JsonIgnore
    private final org.jreleaser.model.api.upload.GitlabUploader immutable = new org.jreleaser.model.api.upload.GitlabUploader(){
        private static final long serialVersionUID = -7870246763484590832L;

        public String getHost() {
            return GitlabUploader.this.getHost();
        }

        public String getToken() {
            return GitlabUploader.this.getToken();
        }

        public String getPackageName() {
            return GitlabUploader.this.getPackageName();
        }

        public String getPackageVersion() {
            return GitlabUploader.this.getPackageVersion();
        }

        public String getProjectIdentifier() {
            return GitlabUploader.this.projectIdentifier;
        }

        public String getType() {
            return GitlabUploader.this.getType();
        }

        public String getName() {
            return GitlabUploader.this.getName();
        }

        public boolean isSnapshotSupported() {
            return GitlabUploader.this.isSnapshotSupported();
        }

        public boolean isArtifacts() {
            return GitlabUploader.this.isArtifacts();
        }

        public boolean isFiles() {
            return GitlabUploader.this.isFiles();
        }

        public boolean isSignatures() {
            return GitlabUploader.this.isSignatures();
        }

        public boolean isChecksums() {
            return GitlabUploader.this.isChecksums();
        }

        public boolean isCatalogs() {
            return GitlabUploader.this.isCatalogs();
        }

        public Active getActive() {
            return GitlabUploader.this.getActive();
        }

        public boolean isEnabled() {
            return GitlabUploader.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(GitlabUploader.this.asMap(full));
        }

        public String getPrefix() {
            return GitlabUploader.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(GitlabUploader.this.getExtraProperties());
        }

        public Integer getConnectTimeout() {
            return GitlabUploader.this.getConnectTimeout();
        }

        public Integer getReadTimeout() {
            return GitlabUploader.this.getReadTimeout();
        }
    };

    public GitlabUploader() {
        super("gitlab");
        this.setHost("gitlab.com");
    }

    @Override
    public org.jreleaser.model.api.upload.GitlabUploader asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(GitlabUploader source) {
        super.merge(source);
        this.projectIdentifier = this.merge(this.projectIdentifier, source.projectIdentifier);
    }

    public String getProjectIdentifier() {
        return this.projectIdentifier;
    }

    public void setProjectIdentifier(String projectIdentifier) {
        this.projectIdentifier = projectIdentifier;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("projectIdentifier", this.projectIdentifier);
    }

    @Override
    public String getResolvedDownloadUrl(TemplateContext props, Artifact artifact) {
        TemplateContext p = new TemplateContext(this.artifactProps(props, artifact));
        p.setAll(this.resolvedExtraProperties());
        p.set("host", (Object)this.getHost());
        p.set("packageName", (Object)this.getPackageName());
        p.set("packageVersion", (Object)this.getPackageVersion());
        p.set("projectIdentifier", (Object)this.getProjectIdentifier());
        return Templates.resolveTemplate((String)DOWNLOAD_URL, (TemplateContext)p);
    }
}

