/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.util;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.SdkmanAnnouncer;
import org.jreleaser.model.internal.assemble.Assembler;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.ExtraProperties;
import org.jreleaser.model.internal.common.FileSet;
import org.jreleaser.model.internal.common.Glob;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.upload.Upload;
import org.jreleaser.model.internal.upload.Uploader;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.FileType;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.StringUtils;

public final class Artifacts {
    private static final String DOWNLOAD_URL_SUFFIX = "DownloadUrl";
    private static final String DOWNLOAD_URL_KEY = "downloadUrl";
    private static final String DOWNLOAD_URL_FROM_KEY = "downloadUrlFrom";

    private Artifacts() {
    }

    public static String resolveForArtifact(String input, JReleaserContext context) {
        return Templates.resolveTemplate((String)input, (TemplateContext)context.fullProps());
    }

    public static String resolveForArtifact(String input, JReleaserContext context, Artifact artifact) {
        return Templates.resolveTemplate((String)input, (TemplateContext)Artifacts.artifactProps(artifact, context.fullProps()));
    }

    public static String resolveForGlob(String input, JReleaserContext context, Glob glob) {
        return Templates.resolveTemplate((String)input, (TemplateContext)Artifacts.globProps(glob, context.fullProps()));
    }

    public static String resolveForFileSet(String input, JReleaserContext context, FileSet fileSet) {
        return Templates.resolveTemplate((String)input, (TemplateContext)Artifacts.fileSetProps(fileSet, context.fullProps()));
    }

    public static String resolveForArtifact(String input, JReleaserContext context, Artifact artifact, Distribution distribution) {
        TemplateContext props = context.fullProps();
        props.setAll(distribution.props());
        Artifacts.artifactProps(artifact, props);
        return Templates.resolveTemplate((String)input, (TemplateContext)props);
    }

    public static String resolveForArtifact(String input, JReleaserContext context, Artifact artifact, Assembler<?> assembler) {
        TemplateContext props = context.fullProps();
        props.setAll(assembler.props());
        Artifacts.artifactProps(artifact, props);
        return Templates.resolveTemplate((String)input, (TemplateContext)props);
    }

    public static TemplateContext artifactProps(Artifact artifact, TemplateContext props) {
        if (null != artifact.getEffectivePath()) {
            return Artifacts.resolvedArtifactProps(artifact, props);
        }
        return Artifacts.unresolvedArtifactProps(artifact, props);
    }

    public static TemplateContext artifactProps(Artifact artifact, Distribution distribution, TemplateContext props) {
        if (null != artifact.getEffectivePath()) {
            return Artifacts.resolvedArtifactProps(artifact, distribution, props);
        }
        return Artifacts.unresolvedArtifactProps(artifact, props);
    }

    public static TemplateContext unresolvedArtifactProps(Artifact artifact, TemplateContext props) {
        props.setAll(artifact.getExtraProperties());
        props.setAll(artifact.resolvedExtraProperties());
        props.set("platform", (Object)artifact.getPlatform());
        props.set("artifactPlatform", (Object)artifact.getPlatform());
        return props;
    }

    public static TemplateContext resolvedArtifactProps(Artifact artifact, TemplateContext props) {
        props.setAll(artifact.getExtraProperties());
        props.setAll(artifact.resolvedExtraProperties());
        String artifactFile = artifact.getEffectivePath().getFileName().toString();
        String artifactFileName = StringUtils.getFilename((String)artifactFile, (Collection)FileType.getSupportedExtensions());
        props.set("artifactFile", (Object)artifactFile);
        props.set("artifactFileName", (Object)artifactFileName);
        props.set("artifactRootEntryName", (Object)FileUtils.resolveRootEntryName((Path)artifact.getEffectivePath()));
        if (!artifactFile.equals(artifactFileName)) {
            String artifactExtension = artifactFile.substring(artifactFileName.length());
            String artifactFileFormat = artifactExtension.substring(1);
            props.set("artifactFileExtension", (Object)artifactExtension);
            props.set("artifactFileFormat", (Object)artifactFileFormat);
        }
        String artifactName = "";
        String projectVersion = (String)props.get("projectEffectiveVersion");
        if (StringUtils.isNotBlank((String)projectVersion) && artifactFileName.contains(projectVersion)) {
            artifactName = artifactFileName.substring(0, artifactFileName.indexOf(projectVersion));
            if (artifactName.endsWith("-")) {
                artifactName = artifactName.substring(0, artifactName.length() - 1);
            }
            props.set("artifactVersion", (Object)projectVersion);
        }
        projectVersion = (String)props.get("projectVersion");
        if (StringUtils.isBlank((String)artifactName) && StringUtils.isNotBlank((String)projectVersion) && artifactFileName.contains(projectVersion)) {
            artifactName = artifactFileName.substring(0, artifactFileName.indexOf(projectVersion));
            if (artifactName.endsWith("-")) {
                artifactName = artifactName.substring(0, artifactName.length() - 1);
            }
            props.set("artifactVersion", (Object)projectVersion);
        }
        props.set("artifactName", (Object)artifactName);
        String platform = artifact.getPlatform();
        if (StringUtils.isNotBlank((String)platform)) {
            props.set("platform", (Object)platform);
            props.set("artifactPlatform", (Object)platform);
            if (platform.contains("-")) {
                String[] parts = platform.split("-");
                props.set("artifactOs", (Object)parts[0]);
                props.set("artifactArch", (Object)parts[1]);
            }
        }
        return props;
    }

    public static TemplateContext resolvedArtifactProps(Artifact artifact, Distribution distribution, TemplateContext props) {
        Artifacts.resolvedArtifactProps(artifact, props);
        String artifactFile = (String)props.get("artifactFile");
        String artifactFileName = (String)props.get("artifactFileName");
        if (!artifactFile.equals(artifactFileName)) {
            String artifactExtension = (String)props.get("artifactFileExtension");
            String artifactFileFormat = (String)props.get("artifactFileFormat");
            props.set("distributionArtifactFileExtension", (Object)artifactExtension);
            props.set("distributionArtifactFileFormat", (Object)artifactFileFormat);
            props.set("distributionArtifactArchiveFormat", (Object)artifactFileFormat);
        }
        String platform = artifact.getPlatform();
        String platformReplaced = distribution.getPlatform().applyReplacements(platform);
        if (StringUtils.isNotBlank((String)platformReplaced)) {
            props.set("artifactPlatformReplaced", (Object)platformReplaced);
        }
        if (StringUtils.isNotBlank((String)platform)) {
            props.set("distributionArtifactPlatform", (Object)platform);
        }
        if (StringUtils.isNotBlank((String)platformReplaced)) {
            props.set("distributionArtifactPlatformReplaced", (Object)platformReplaced);
        }
        return props;
    }

    public static TemplateContext globProps(Glob glob, TemplateContext props) {
        props.setAll(glob.getExtraProperties());
        props.setAll(glob.resolvedExtraProperties());
        return props;
    }

    public static TemplateContext fileSetProps(FileSet fileSet, TemplateContext props) {
        props.setAll(fileSet.getExtraProperties());
        props.setAll(fileSet.resolvedExtraProperties());
        return props;
    }

    public static String resolveDownloadUrl(JReleaserContext context, String packagerName, Distribution distribution, Artifact artifact) {
        List<String> keys = Collections.singletonList("skip" + StringUtils.capitalize((String)packagerName));
        if (Artifacts.isSkip(artifact, keys)) {
            return "";
        }
        String downloadUrl = artifact.getExtraProperty(packagerName + DOWNLOAD_URL_SUFFIX);
        if (StringUtils.isBlank((String)downloadUrl)) {
            downloadUrl = artifact.getExtraProperty(DOWNLOAD_URL_KEY);
        }
        Object packager = distribution.findPackager(packagerName);
        if (StringUtils.isBlank((String)downloadUrl)) {
            downloadUrl = packager.getDownloadUrl();
        }
        if (StringUtils.isBlank((String)downloadUrl)) {
            downloadUrl = distribution.getExtraProperty(packagerName + DOWNLOAD_URL_SUFFIX);
        }
        if (StringUtils.isBlank((String)downloadUrl)) {
            downloadUrl = distribution.getExtraProperty(DOWNLOAD_URL_KEY);
        }
        BaseReleaser<?, ?> service = context.getModel().getRelease().getReleaser();
        if (StringUtils.isBlank((String)downloadUrl) && !service.isSkipRelease() && service.isArtifacts() && service.resolveUploadAssetsEnabled(context.getModel().getProject())) {
            downloadUrl = service.getDownloadUrl();
        }
        if (StringUtils.isBlank((String)downloadUrl)) {
            downloadUrl = Artifacts.resolveDownloadUrlFromUploader(context, artifact, artifact);
        }
        if (StringUtils.isBlank((String)downloadUrl)) {
            downloadUrl = Artifacts.resolveDownloadUrlFromUploader(context, packager, artifact);
        }
        if (StringUtils.isBlank((String)downloadUrl)) {
            downloadUrl = Artifacts.resolveDownloadUrlFromUploader(context, distribution, artifact);
        }
        if (StringUtils.isBlank((String)downloadUrl)) {
            context.getLogger().warn(RB.$((String)"ERROR_artifacts_download_url_missing", (Object[])new Object[]{artifact.getEffectivePath(context, distribution).getFileName().toString(), service.getServiceName()}));
            downloadUrl = service.getDownloadUrl();
        }
        TemplateContext props = context.fullProps();
        props.setAll(packager.resolvedExtraProperties());
        props.setAll(distribution.props());
        Artifacts.artifactProps(artifact, distribution, props);
        return Templates.resolveTemplate((String)downloadUrl, (TemplateContext)props);
    }

    public static String resolveDownloadUrl(JReleaserContext context, SdkmanAnnouncer announcer, Distribution distribution, Artifact artifact) {
        String packager = "sdkman";
        List<String> keys = Collections.singletonList("skip" + StringUtils.capitalize((String)packager));
        if (Artifacts.isSkip(artifact, keys)) {
            return "";
        }
        String downloadUrl = artifact.getExtraProperty(packager + DOWNLOAD_URL_SUFFIX);
        if (StringUtils.isBlank((String)downloadUrl)) {
            downloadUrl = artifact.getExtraProperty(DOWNLOAD_URL_KEY);
        }
        if (StringUtils.isBlank((String)downloadUrl)) {
            downloadUrl = announcer.getDownloadUrl();
        }
        if (StringUtils.isBlank((String)downloadUrl)) {
            downloadUrl = distribution.getExtraProperty(packager + DOWNLOAD_URL_SUFFIX);
        }
        if (StringUtils.isBlank((String)downloadUrl)) {
            downloadUrl = distribution.getExtraProperty(DOWNLOAD_URL_KEY);
        }
        BaseReleaser<?, ?> service = context.getModel().getRelease().getReleaser();
        if (StringUtils.isBlank((String)downloadUrl) && !service.isSkipRelease() && service.isArtifacts() && service.resolveUploadAssetsEnabled(context.getModel().getProject())) {
            downloadUrl = service.getDownloadUrl();
        }
        if (StringUtils.isBlank((String)downloadUrl)) {
            downloadUrl = Artifacts.resolveDownloadUrlFromUploader(context, artifact, artifact);
        }
        if (StringUtils.isBlank((String)downloadUrl)) {
            downloadUrl = Artifacts.resolveDownloadUrlFromUploader(context, announcer, artifact);
        }
        if (StringUtils.isBlank((String)downloadUrl)) {
            downloadUrl = Artifacts.resolveDownloadUrlFromUploader(context, distribution, artifact);
        }
        if (StringUtils.isBlank((String)downloadUrl)) {
            context.getLogger().warn(RB.$((String)"ERROR_artifacts_download_url_missing", (Object[])new Object[]{artifact.getEffectivePath(context, distribution).getFileName().toString()}), new Object[]{service.getServiceName()});
            downloadUrl = service.getDownloadUrl();
        }
        TemplateContext props = context.fullProps();
        props.setAll(announcer.resolvedExtraProperties());
        props.setAll(distribution.props());
        Artifacts.artifactProps(artifact, distribution, props);
        return Templates.resolveTemplate((String)downloadUrl, (TemplateContext)props);
    }

    private static String resolveDownloadUrlFromUploader(JReleaserContext context, ExtraProperties props, Artifact artifact) {
        Upload upload = context.getModel().getUpload();
        String coords = props.getExtraProperty(DOWNLOAD_URL_FROM_KEY);
        if (StringUtils.isBlank((String)coords)) {
            for (Uploader up : upload.findAllActiveUploaders()) {
                List<String> keys = up.resolveSkipKeys();
                String key = up.getType() + StringUtils.capitalize((String)up.getName()) + "Path";
                if (!artifact.getExtraProperties().containsKey(key) || Artifacts.isSkip(props, keys)) continue;
                return up.getResolvedDownloadUrl(context, artifact);
            }
            return null;
        }
        String[] parts = coords.split(":");
        if (parts.length != 2) {
            return null;
        }
        Optional<Uploader<?>> uploader = upload.getActiveUploader(parts[0], parts[1]);
        if (uploader.isPresent()) {
            List<String> keys = uploader.get().resolveSkipKeys();
            if (!Artifacts.isSkip(props, keys)) {
                return uploader.get().getResolvedDownloadUrl(context, artifact);
            }
        } else {
            for (Uploader up : upload.findAllActiveUploaders()) {
                List<String> keys = up.resolveSkipKeys();
                String key = up.getType() + StringUtils.capitalize((String)up.getName()) + "Path";
                if (!artifact.getExtraProperties().containsKey(key) || Artifacts.isSkip(props, keys)) continue;
                return up.getResolvedDownloadUrl(context, artifact);
            }
        }
        return null;
    }

    private static boolean isSkip(ExtraProperties props, List<String> keys) {
        for (String key : keys) {
            if (!props.extraPropertyIsTrue(key)) continue;
            return true;
        }
        return false;
    }

    public static Path checkAndCopyFile(JReleaserContext context, Path src, Path dest, boolean optional) throws JReleaserException {
        if (!Files.exists(src, new LinkOption[0]) && optional || null == dest) {
            return src;
        }
        if (!Files.exists(dest, new LinkOption[0])) {
            context.getLogger().debug(RB.$((String)"artifacts.not.exists", (Object[])new Object[0]), new Object[]{context.relativizeToBasedir(dest)});
            Artifacts.copyFile(context, src, dest);
        } else if (src.toFile().lastModified() > dest.toFile().lastModified()) {
            context.getLogger().debug(RB.$((String)"artifacts.newer", (Object[])new Object[0]), new Object[]{context.relativizeToBasedir(src), context.relativizeToBasedir(dest)});
            Artifacts.copyFile(context, src, dest);
        }
        return dest;
    }

    public static void copyFile(JReleaserContext context, Path src, Path dest) throws JReleaserException {
        try {
            Files.createDirectories(dest.getParent(), new FileAttribute[0]);
            Files.copy(src, dest, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_artifacts_unexpected_error_copying", (Object[])new Object[]{context.relativizeToBasedir(src), context.relativizeToBasedir(dest), e.toString()}));
        }
    }

    public static Set<Artifact> resolveFiles(JReleaserContext context) throws JReleaserException {
        org.jreleaser.model.internal.files.Files files = context.getModel().getFiles();
        LinkedHashSet<Artifact> paths = new LinkedHashSet<Artifact>();
        if (!files.isEnabled()) {
            return paths;
        }
        if (files.arePathsResolved()) {
            return files.getPaths();
        }
        for (Artifact artifact : files.getArtifacts()) {
            if (!artifact.resolveActiveAndSelected(context)) continue;
            Path effectivePath = artifact.getEffectivePath(context);
            if (null != effectivePath) {
                paths.add(artifact);
                continue;
            }
            artifact.deactivateAndUnselect();
        }
        for (Glob glob : files.getGlobs()) {
            if (!glob.resolveActiveAndSelected(context)) continue;
            paths.addAll(glob.getResolvedArtifacts(context));
        }
        files.setPaths(Artifact.sortArtifacts(paths));
        return files.getPaths();
    }

    public static Set<Artifact> resolveFiles(JReleaserLogger logger, Path basedir, Collection<String> globs) throws JReleaserException {
        if (null == globs || globs.isEmpty()) {
            return Collections.emptySet();
        }
        FileSystem fileSystem = FileSystems.getDefault();
        ArrayList<PathMatcher> matchers = new ArrayList<PathMatcher>();
        for (String glob : globs) {
            matchers.add(fileSystem.getPathMatcher(glob));
        }
        return Artifacts.resolveArtifacts(logger, basedir, matchers);
    }

    public static Set<Artifact> resolveFiles(JReleaserLogger logger, TemplateContext props, Path basedir, Collection<String> globs) throws JReleaserException {
        if (null == globs || globs.isEmpty()) {
            return Collections.emptySet();
        }
        FileSystem fileSystem = FileSystems.getDefault();
        ArrayList<PathMatcher> matchers = new ArrayList<PathMatcher>();
        for (String glob : globs) {
            matchers.add(fileSystem.getPathMatcher(Templates.resolveTemplate((String)glob, (TemplateContext)props)));
        }
        return Artifacts.resolveArtifacts(logger, basedir, matchers);
    }

    private static Set<Artifact> resolveArtifacts(JReleaserLogger logger, Path basedir, List<PathMatcher> matchers) {
        GlobResolver resolver = new GlobResolver(logger, basedir, matchers);
        try {
            Files.walkFileTree(basedir, resolver);
            if (resolver.failed) {
                throw new JReleaserException(RB.$((String)"ERROR_artifacts_glob_resolution", (Object[])new Object[0]));
            }
            return Artifact.sortArtifacts(resolver.artifacts);
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_artifacts_unexpected_error_globs", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public static Set<Artifact> resolveFiles(JReleaserContext context, Path directory, Collection<String> globs) throws JReleaserException {
        return Artifacts.resolveFiles(context.getLogger(), context.fullProps(), directory, globs);
    }

    private static class GlobResolver
    extends SimpleFileVisitor<Path> {
        private final JReleaserLogger logger;
        private final List<PathMatcher> matchers;
        private final Path basedir;
        private final Set<Artifact> artifacts = new LinkedHashSet<Artifact>();
        private boolean failed;

        private GlobResolver(JReleaserLogger logger, Path basedir, List<PathMatcher> matchers) {
            this.logger = logger;
            this.matchers = matchers;
            this.basedir = basedir;
        }

        private void match(Path path) {
            if (this.matchers.stream().anyMatch(matcher -> matcher.matches(path))) {
                this.artifacts.add(Artifact.of(path));
            }
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            this.match(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException e) throws IOException {
            this.failed = true;
            this.logger.error(RB.$((String)"ERROR_artifacts_unexpected_error_path", (Object[])new Object[0]), new Object[]{this.basedir.toAbsolutePath().relativize(file.toAbsolutePath()), e});
            return FileVisitResult.CONTINUE;
        }
    }
}

