/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.upload;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.upload.ScpUploader;
import org.jreleaser.model.internal.validation.common.SshValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class ScpUploaderValidator {
    private ScpUploaderValidator() {
    }

    public static void validateScpUploader(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, ScpUploader> scp = context.getModel().getUpload().getScp();
        if (!scp.isEmpty()) {
            context.getLogger().debug("upload.scp");
        }
        for (Map.Entry<String, ScpUploader> e : scp.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig()) continue;
            ScpUploaderValidator.validateScpUploader(context, e.getValue(), errors);
        }
    }

    private static void validateScpUploader(JReleaserContext context, ScpUploader uploader, Errors errors) {
        context.getLogger().debug("upload.scp.{}", new Object[]{uploader.getName()});
        Validator.resolveActivatable(context, (Activatable)uploader, CollectionUtils.listOf((Object[])new String[]{"upload.scp." + uploader.getName(), "upload.scp"}), "NEVER");
        if (!uploader.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (!(uploader.isArtifacts() || uploader.isFiles() || uploader.isSignatures())) {
            errors.warning(RB.$((String)"WARNING.validation.uploader.no.artifacts", (Object[])new Object[]{uploader.getType(), uploader.getName()}));
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            uploader.disable();
            return;
        }
        SshValidator.validateSsh(context, uploader, uploader.getType(), uploader.getName(), "upload.", errors);
        if (StringUtils.isBlank((String)uploader.getPath())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"upload.scp." + uploader.getName() + ".path"}));
        }
        Validator.validateTimeout(uploader);
    }
}

