/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.hooks;

import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.hooks.Hooks;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.hooks.CommandHooksValidator;
import org.jreleaser.model.internal.validation.hooks.ScriptHooksValidator;
import org.jreleaser.util.Errors;

public final class HooksValidator {
    private HooksValidator() {
    }

    public static void validateHooks(JReleaserContext context, Errors errors) {
        context.getLogger().debug("hooks");
        Hooks hooks = context.getModel().getHooks();
        CommandHooksValidator.validateCommandHooks(context, errors);
        ScriptHooksValidator.validateScriptHooks(context, errors);
        boolean activeSet = hooks.isActiveSet();
        Validator.resolveActivatable(context, (Activatable)hooks, "hooks", "ALWAYS");
        hooks.resolveEnabled(context.getModel().getProject());
        if (hooks.isEnabled()) {
            boolean enabled;
            boolean bl = enabled = hooks.getCommand().isEnabled() || hooks.getScript().isEnabled();
            if (!activeSet && !enabled) {
                context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
                hooks.disable();
            }
        }
    }
}

