/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;

public final class JvmOptions
extends AbstractModelObject<JvmOptions>
implements Domain {
    private final List<String> universal = new ArrayList<String>();
    private final List<String> unix = new ArrayList<String>();
    private final List<String> linux = new ArrayList<String>();
    private final List<String> osx = new ArrayList<String>();
    private final List<String> windows = new ArrayList<String>();
    @JsonIgnore
    private final org.jreleaser.model.api.common.JvmOptions immutable = new org.jreleaser.model.api.common.JvmOptions(){
        private static final long serialVersionUID = -7553541254718019915L;

        public List<String> getUniversal() {
            return Collections.unmodifiableList(JvmOptions.this.universal);
        }

        public List<String> getUnix() {
            return Collections.unmodifiableList(JvmOptions.this.unix);
        }

        public List<String> getLinux() {
            return Collections.unmodifiableList(JvmOptions.this.linux);
        }

        public List<String> getOsx() {
            return Collections.unmodifiableList(JvmOptions.this.osx);
        }

        public List<String> getWindows() {
            return Collections.unmodifiableList(JvmOptions.this.windows);
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(JvmOptions.this.asMap(full));
        }
    };

    public org.jreleaser.model.api.common.JvmOptions asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(JvmOptions source) {
        this.setUniversal(this.merge(this.universal, source.universal));
        this.setUnix(this.merge(this.unix, source.unix));
        this.setLinux(this.merge(this.linux, source.linux));
        this.setOsx(this.merge(this.osx, source.osx));
        this.setWindows(this.merge(this.windows, source.windows));
    }

    @Override
    public void merge(Set<String> source) {
        this.universal.addAll(source);
    }

    public List<String> getUniversal() {
        return this.universal;
    }

    public void setUniversal(List<String> universal) {
        this.universal.clear();
        this.universal.addAll(universal);
    }

    public List<String> getUnix() {
        return this.unix;
    }

    public void setUnix(List<String> unix) {
        this.unix.clear();
        this.unix.addAll(unix);
    }

    public List<String> getLinux() {
        return this.linux;
    }

    public void setLinux(List<String> linux) {
        this.linux.clear();
        this.linux.addAll(linux);
    }

    public List<String> getOsx() {
        return this.osx;
    }

    public void setOsx(List<String> osx) {
        this.osx.clear();
        this.osx.addAll(osx);
    }

    public List<String> getWindows() {
        return this.windows;
    }

    public void setWindows(List<String> windows) {
        this.windows.clear();
        this.windows.addAll(windows);
    }

    public boolean isSet() {
        return !this.universal.isEmpty() || !this.unix.isEmpty() || !this.linux.isEmpty() || !this.osx.isEmpty() || !this.windows.isEmpty();
    }

    public List<String> getResolvedUniversal(JReleaserContext context) {
        TemplateContext props = context.fullProps();
        return this.universal.stream().map(option -> Templates.resolveTemplate((String)option, (TemplateContext)props)).collect(Collectors.toList());
    }

    public List<String> getResolvedUnix(JReleaserContext context) {
        TemplateContext props = context.fullProps();
        return this.unix.stream().map(option -> Templates.resolveTemplate((String)option, (TemplateContext)props)).collect(Collectors.toList());
    }

    public List<String> getResolvedLinux(JReleaserContext context) {
        TemplateContext props = context.fullProps();
        return this.linux.stream().map(option -> Templates.resolveTemplate((String)option, (TemplateContext)props)).collect(Collectors.toList());
    }

    public List<String> getResolvedOsx(JReleaserContext context) {
        TemplateContext props = context.fullProps();
        return this.osx.stream().map(option -> Templates.resolveTemplate((String)option, (TemplateContext)props)).collect(Collectors.toList());
    }

    public List<String> getResolvedWindows(JReleaserContext context) {
        TemplateContext props = context.fullProps();
        return this.windows.stream().map(option -> Templates.resolveTemplate((String)option, (TemplateContext)props)).collect(Collectors.toList());
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("universal", this.universal);
        map.put("unix", this.unix);
        map.put("linux", this.linux);
        map.put("osx", this.osx);
        map.put("windows", this.windows);
        return map;
    }
}

