/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.bluesky.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.LocalDateTime;
import org.jreleaser.sdk.bluesky.api.CreateRecordResponse;
import org.jreleaser.util.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CreateTextRecordRequest {
    private static final String BLUESKY_POST_COLLECTION = "app.bsky.feed.post";
    private String repo;
    private String collection;
    private TextRecord record;

    public static CreateTextRecordRequest of(String repo, String text) {
        CreateTextRecordRequest request = new CreateTextRecordRequest();
        request.repo = StringUtils.requireNonBlank((String)repo, (String)"'repo' must not be blank").trim();
        request.collection = BLUESKY_POST_COLLECTION;
        TextRecord textRecord = new TextRecord();
        textRecord.text = StringUtils.requireNonBlank((String)text, (String)"'text' must not be blank").trim();
        textRecord.createdAt = LocalDateTime.now().toString();
        request.record = textRecord;
        return request;
    }

    public static CreateTextRecordRequest of(String repo, String text, CreateRecordResponse root, CreateRecordResponse parent) {
        CreateTextRecordRequest request = CreateTextRecordRequest.of(repo, text);
        ReplyReference reply = new ReplyReference();
        reply.root = root;
        reply.parent = parent;
        request.record.setReply(reply);
        return request;
    }

    public String getRepo() {
        return this.repo;
    }

    public void setRepo(String repo) {
        this.repo = repo;
    }

    public String getCollection() {
        return this.collection;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public TextRecord getRecord() {
        return this.record;
    }

    public void setRecord(TextRecord record) {
        this.record = record;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TextRecord {
        private String text;
        private String createdAt;
        private ReplyReference reply;
        @JsonProperty(value="$type")
        private String type;

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public ReplyReference getReply() {
            return this.reply;
        }

        public void setReply(ReplyReference reply) {
            this.reply = reply;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ReplyReference {
        private CreateRecordResponse root;
        private CreateRecordResponse parent;

        public CreateRecordResponse getRoot() {
            return this.root;
        }

        public void setRoot(CreateRecordResponse root) {
            this.root = root;
        }

        public CreateRecordResponse getParent() {
            return this.parent;
        }

        public void setParent(CreateRecordResponse parent) {
            this.parent = parent;
        }
    }
}

